/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDynamicThingGroupRequest extends IotRequest implements
        ToCopyableBuilder<UpdateDynamicThingGroupRequest.Builder, UpdateDynamicThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDynamicThingGroupRequest::thingGroupName)).setter(setter(Builder::thingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingGroupName").build()).build();

    private static final SdkField<ThingGroupProperties> THING_GROUP_PROPERTIES_FIELD = SdkField
            .<ThingGroupProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDynamicThingGroupRequest::thingGroupProperties)).setter(setter(Builder::thingGroupProperties))
            .constructor(ThingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupProperties").build())
            .build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateDynamicThingGroupRequest::expectedVersion)).setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDynamicThingGroupRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDynamicThingGroupRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDynamicThingGroupRequest::queryVersion)).setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD,
            THING_GROUP_PROPERTIES_FIELD, EXPECTED_VERSION_FIELD, INDEX_NAME_FIELD, QUERY_STRING_FIELD, QUERY_VERSION_FIELD));

    private final String thingGroupName;

    private final ThingGroupProperties thingGroupProperties;

    private final Long expectedVersion;

    private final String indexName;

    private final String queryString;

    private final String queryVersion;

    private UpdateDynamicThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupProperties = builder.thingGroupProperties;
        this.expectedVersion = builder.expectedVersion;
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.queryVersion = builder.queryVersion;
    }

    /**
     * <p>
     * The name of the dynamic thing group to update.
     * </p>
     * 
     * @return The name of the dynamic thing group to update.
     */
    public String thingGroupName() {
        return thingGroupName;
    }

    /**
     * <p>
     * The dynamic thing group properties to update.
     * </p>
     * 
     * @return The dynamic thing group properties to update.
     */
    public ThingGroupProperties thingGroupProperties() {
        return thingGroupProperties;
    }

    /**
     * <p>
     * The expected version of the dynamic thing group to update.
     * </p>
     * 
     * @return The expected version of the dynamic thing group to update.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    /**
     * <p>
     * The dynamic thing group index to update.
     * </p>
     * <note>
     * <p>
     * Currently one index is supported: 'AWS_Things'.
     * </p>
     * </note>
     * 
     * @return The dynamic thing group index to update.</p> <note>
     *         <p>
     *         Currently one index is supported: 'AWS_Things'.
     *         </p>
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The dynamic thing group search query string to update.
     * </p>
     * 
     * @return The dynamic thing group search query string to update.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The dynamic thing group query version to update.
     * </p>
     * <note>
     * <p>
     * Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this
     * value.
     * </p>
     * </note>
     * 
     * @return The dynamic thing group query version to update.</p> <note>
     *         <p>
     *         Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to
     *         this value.
     *         </p>
     */
    public String queryVersion() {
        return queryVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDynamicThingGroupRequest)) {
            return false;
        }
        UpdateDynamicThingGroupRequest other = (UpdateDynamicThingGroupRequest) obj;
        return Objects.equals(thingGroupName(), other.thingGroupName())
                && Objects.equals(thingGroupProperties(), other.thingGroupProperties())
                && Objects.equals(expectedVersion(), other.expectedVersion()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(queryVersion(), other.queryVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDynamicThingGroupRequest").add("ThingGroupName", thingGroupName())
                .add("ThingGroupProperties", thingGroupProperties()).add("ExpectedVersion", expectedVersion())
                .add("IndexName", indexName()).add("QueryString", queryString()).add("QueryVersion", queryVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupName":
            return Optional.ofNullable(clazz.cast(thingGroupName()));
        case "thingGroupProperties":
            return Optional.ofNullable(clazz.cast(thingGroupProperties()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDynamicThingGroupRequest, T> g) {
        return obj -> g.apply((UpdateDynamicThingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDynamicThingGroupRequest> {
        /**
         * <p>
         * The name of the dynamic thing group to update.
         * </p>
         * 
         * @param thingGroupName
         *        The name of the dynamic thing group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupName(String thingGroupName);

        /**
         * <p>
         * The dynamic thing group properties to update.
         * </p>
         * 
         * @param thingGroupProperties
         *        The dynamic thing group properties to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupProperties(ThingGroupProperties thingGroupProperties);

        /**
         * <p>
         * The dynamic thing group properties to update.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupProperties.Builder} avoiding the need
         * to create one manually via {@link ThingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingGroupProperties(ThingGroupProperties)}.
         * 
         * @param thingGroupProperties
         *        a consumer that will call methods on {@link ThingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupProperties(ThingGroupProperties)
         */
        default Builder thingGroupProperties(Consumer<ThingGroupProperties.Builder> thingGroupProperties) {
            return thingGroupProperties(ThingGroupProperties.builder().applyMutation(thingGroupProperties).build());
        }

        /**
         * <p>
         * The expected version of the dynamic thing group to update.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the dynamic thing group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        /**
         * <p>
         * The dynamic thing group index to update.
         * </p>
         * <note>
         * <p>
         * Currently one index is supported: 'AWS_Things'.
         * </p>
         * </note>
         * 
         * @param indexName
         *        The dynamic thing group index to update.</p> <note>
         *        <p>
         *        Currently one index is supported: 'AWS_Things'.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The dynamic thing group search query string to update.
         * </p>
         * 
         * @param queryString
         *        The dynamic thing group search query string to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The dynamic thing group query version to update.
         * </p>
         * <note>
         * <p>
         * Currently one query version is supported: "2017-09-30". If not specified, the query version defaults to this
         * value.
         * </p>
         * </note>
         * 
         * @param queryVersion
         *        The dynamic thing group query version to update.</p> <note>
         *        <p>
         *        Currently one query version is supported: "2017-09-30". If not specified, the query version defaults
         *        to this value.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingGroupName;

        private ThingGroupProperties thingGroupProperties;

        private Long expectedVersion;

        private String indexName;

        private String queryString;

        private String queryVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDynamicThingGroupRequest model) {
            super(model);
            thingGroupName(model.thingGroupName);
            thingGroupProperties(model.thingGroupProperties);
            expectedVersion(model.expectedVersion);
            indexName(model.indexName);
            queryString(model.queryString);
            queryVersion(model.queryVersion);
        }

        public final String getThingGroupName() {
            return thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final ThingGroupProperties.Builder getThingGroupProperties() {
            return thingGroupProperties != null ? thingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupProperties(ThingGroupProperties thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties;
            return this;
        }

        public final void setThingGroupProperties(ThingGroupProperties.BuilderImpl thingGroupProperties) {
            this.thingGroupProperties = thingGroupProperties != null ? thingGroupProperties.build() : null;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDynamicThingGroupRequest build() {
            return new UpdateDynamicThingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
