/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachedPoliciesRequest extends IotRequest implements
        ToCopyableBuilder<ListAttachedPoliciesRequest.Builder, ListAttachedPoliciesRequest> {
    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAttachedPoliciesRequest::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("target").build()).build();

    private static final SdkField<Boolean> RECURSIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ListAttachedPoliciesRequest::recursive)).setter(setter(Builder::recursive))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recursive").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAttachedPoliciesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAttachedPoliciesRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, RECURSIVE_FIELD,
            MARKER_FIELD, PAGE_SIZE_FIELD));

    private final String target;

    private final Boolean recursive;

    private final String marker;

    private final Integer pageSize;

    private ListAttachedPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.recursive = builder.recursive;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The group for which the policies will be listed.
     * </p>
     * 
     * @return The group for which the policies will be listed.
     */
    public String target() {
        return target;
    }

    /**
     * <p>
     * When true, recursively list attached policies.
     * </p>
     * 
     * @return When true, recursively list attached policies.
     */
    public Boolean recursive() {
        return recursive;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of results to be returned per request.
     * </p>
     * 
     * @return The maximum number of results to be returned per request.
     */
    public Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(recursive());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedPoliciesRequest)) {
            return false;
        }
        ListAttachedPoliciesRequest other = (ListAttachedPoliciesRequest) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(recursive(), other.recursive())
                && Objects.equals(marker(), other.marker()) && Objects.equals(pageSize(), other.pageSize());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAttachedPoliciesRequest").add("Target", target()).add("Recursive", recursive())
                .add("Marker", marker()).add("PageSize", pageSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "recursive":
            return Optional.ofNullable(clazz.cast(recursive()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "pageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedPoliciesRequest, T> g) {
        return obj -> g.apply((ListAttachedPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAttachedPoliciesRequest> {
        /**
         * <p>
         * The group for which the policies will be listed.
         * </p>
         * 
         * @param target
         *        The group for which the policies will be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * When true, recursively list attached policies.
         * </p>
         * 
         * @param recursive
         *        When true, recursively list attached policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param marker
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of results to be returned per request.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to be returned per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String target;

        private Boolean recursive;

        private String marker;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedPoliciesRequest model) {
            super(model);
            target(model.target);
            recursive(model.recursive);
            marker(model.marker);
            pageSize(model.pageSize);
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAttachedPoliciesRequest build() {
            return new ListAttachedPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
