/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data used to transfer a certificate to an AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransferData implements SdkPojo, Serializable, ToCopyableBuilder<TransferData.Builder, TransferData> {
    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransferData::transferMessage)).setter(setter(Builder::transferMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()).build();

    private static final SdkField<String> REJECT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransferData::rejectReason)).setter(setter(Builder::rejectReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectReason").build()).build();

    private static final SdkField<Instant> TRANSFER_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransferData::transferDate)).setter(setter(Builder::transferDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferDate").build()).build();

    private static final SdkField<Instant> ACCEPT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransferData::acceptDate)).setter(setter(Builder::acceptDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptDate").build()).build();

    private static final SdkField<Instant> REJECT_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransferData::rejectDate)).setter(setter(Builder::rejectDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFER_MESSAGE_FIELD,
            REJECT_REASON_FIELD, TRANSFER_DATE_FIELD, ACCEPT_DATE_FIELD, REJECT_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transferMessage;

    private final String rejectReason;

    private final Instant transferDate;

    private final Instant acceptDate;

    private final Instant rejectDate;

    private TransferData(BuilderImpl builder) {
        this.transferMessage = builder.transferMessage;
        this.rejectReason = builder.rejectReason;
        this.transferDate = builder.transferDate;
        this.acceptDate = builder.acceptDate;
        this.rejectDate = builder.rejectDate;
    }

    /**
     * <p>
     * The transfer message.
     * </p>
     * 
     * @return The transfer message.
     */
    public String transferMessage() {
        return transferMessage;
    }

    /**
     * <p>
     * The reason why the transfer was rejected.
     * </p>
     * 
     * @return The reason why the transfer was rejected.
     */
    public String rejectReason() {
        return rejectReason;
    }

    /**
     * <p>
     * The date the transfer took place.
     * </p>
     * 
     * @return The date the transfer took place.
     */
    public Instant transferDate() {
        return transferDate;
    }

    /**
     * <p>
     * The date the transfer was accepted.
     * </p>
     * 
     * @return The date the transfer was accepted.
     */
    public Instant acceptDate() {
        return acceptDate;
    }

    /**
     * <p>
     * The date the transfer was rejected.
     * </p>
     * 
     * @return The date the transfer was rejected.
     */
    public Instant rejectDate() {
        return rejectDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transferMessage());
        hashCode = 31 * hashCode + Objects.hashCode(rejectReason());
        hashCode = 31 * hashCode + Objects.hashCode(transferDate());
        hashCode = 31 * hashCode + Objects.hashCode(acceptDate());
        hashCode = 31 * hashCode + Objects.hashCode(rejectDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferData)) {
            return false;
        }
        TransferData other = (TransferData) obj;
        return Objects.equals(transferMessage(), other.transferMessage()) && Objects.equals(rejectReason(), other.rejectReason())
                && Objects.equals(transferDate(), other.transferDate()) && Objects.equals(acceptDate(), other.acceptDate())
                && Objects.equals(rejectDate(), other.rejectDate());
    }

    @Override
    public String toString() {
        return ToString.builder("TransferData").add("TransferMessage", transferMessage()).add("RejectReason", rejectReason())
                .add("TransferDate", transferDate()).add("AcceptDate", acceptDate()).add("RejectDate", rejectDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transferMessage":
            return Optional.ofNullable(clazz.cast(transferMessage()));
        case "rejectReason":
            return Optional.ofNullable(clazz.cast(rejectReason()));
        case "transferDate":
            return Optional.ofNullable(clazz.cast(transferDate()));
        case "acceptDate":
            return Optional.ofNullable(clazz.cast(acceptDate()));
        case "rejectDate":
            return Optional.ofNullable(clazz.cast(rejectDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferData, T> g) {
        return obj -> g.apply((TransferData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransferData> {
        /**
         * <p>
         * The transfer message.
         * </p>
         * 
         * @param transferMessage
         *        The transfer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferMessage(String transferMessage);

        /**
         * <p>
         * The reason why the transfer was rejected.
         * </p>
         * 
         * @param rejectReason
         *        The reason why the transfer was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectReason(String rejectReason);

        /**
         * <p>
         * The date the transfer took place.
         * </p>
         * 
         * @param transferDate
         *        The date the transfer took place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferDate(Instant transferDate);

        /**
         * <p>
         * The date the transfer was accepted.
         * </p>
         * 
         * @param acceptDate
         *        The date the transfer was accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptDate(Instant acceptDate);

        /**
         * <p>
         * The date the transfer was rejected.
         * </p>
         * 
         * @param rejectDate
         *        The date the transfer was rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectDate(Instant rejectDate);
    }

    static final class BuilderImpl implements Builder {
        private String transferMessage;

        private String rejectReason;

        private Instant transferDate;

        private Instant acceptDate;

        private Instant rejectDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferData model) {
            transferMessage(model.transferMessage);
            rejectReason(model.rejectReason);
            transferDate(model.transferDate);
            acceptDate(model.acceptDate);
            rejectDate(model.rejectDate);
        }

        public final String getTransferMessage() {
            return transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final String getRejectReason() {
            return rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        public final Instant getTransferDate() {
            return transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        public final Instant getAcceptDate() {
            return acceptDate;
        }

        @Override
        public final Builder acceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
            return this;
        }

        public final void setAcceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
        }

        public final Instant getRejectDate() {
            return rejectDate;
        }

        @Override
        public final Builder rejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
            return this;
        }

        public final void setRejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
        }

        @Override
        public TransferData build() {
            return new TransferData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
