/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListOutgoingCertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOutgoingCertificatesResponse extends IotResponse implements
        ToCopyableBuilder<ListOutgoingCertificatesResponse.Builder, ListOutgoingCertificatesResponse> {
    private static final SdkField<List<OutgoingCertificate>> OUTGOING_CERTIFICATES_FIELD = SdkField
            .<List<OutgoingCertificate>> builder(MarshallingType.LIST)
            .getter(getter(ListOutgoingCertificatesResponse::outgoingCertificates))
            .setter(setter(Builder::outgoingCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outgoingCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutgoingCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutgoingCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOutgoingCertificatesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTGOING_CERTIFICATES_FIELD,
            NEXT_MARKER_FIELD));

    private final List<OutgoingCertificate> outgoingCertificates;

    private final String nextMarker;

    private ListOutgoingCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.outgoingCertificates = builder.outgoingCertificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The certificates that are being transferred but not yet accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The certificates that are being transferred but not yet accepted.
     */
    public List<OutgoingCertificate> outgoingCertificates() {
        return outgoingCertificates;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outgoingCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutgoingCertificatesResponse)) {
            return false;
        }
        ListOutgoingCertificatesResponse other = (ListOutgoingCertificatesResponse) obj;
        return Objects.equals(outgoingCertificates(), other.outgoingCertificates())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListOutgoingCertificatesResponse").add("OutgoingCertificates", outgoingCertificates())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outgoingCertificates":
            return Optional.ofNullable(clazz.cast(outgoingCertificates()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutgoingCertificatesResponse, T> g) {
        return obj -> g.apply((ListOutgoingCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOutgoingCertificatesResponse> {
        /**
         * <p>
         * The certificates that are being transferred but not yet accepted.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transferred but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates);

        /**
         * <p>
         * The certificates that are being transferred but not yet accepted.
         * </p>
         * 
         * @param outgoingCertificates
         *        The certificates that are being transferred but not yet accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates);

        /**
         * <p>
         * The certificates that are being transferred but not yet accepted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutgoingCertificate>.Builder} avoiding the
         * need to create one manually via {@link List<OutgoingCertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutgoingCertificate>.Builder#build()} is called immediately
         * and its result is passed to {@link #outgoingCertificates(List<OutgoingCertificate>)}.
         * 
         * @param outgoingCertificates
         *        a consumer that will call methods on {@link List<OutgoingCertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingCertificates(List<OutgoingCertificate>)
         */
        Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder>... outgoingCertificates);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<OutgoingCertificate> outgoingCertificates = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutgoingCertificatesResponse model) {
            super(model);
            outgoingCertificates(model.outgoingCertificates);
            nextMarker(model.nextMarker);
        }

        public final Collection<OutgoingCertificate.Builder> getOutgoingCertificates() {
            return outgoingCertificates != null ? outgoingCertificates.stream().map(OutgoingCertificate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outgoingCertificates(Collection<OutgoingCertificate> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copy(outgoingCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(OutgoingCertificate... outgoingCertificates) {
            outgoingCertificates(Arrays.asList(outgoingCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outgoingCertificates(Consumer<OutgoingCertificate.Builder>... outgoingCertificates) {
            outgoingCertificates(Stream.of(outgoingCertificates).map(c -> OutgoingCertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutgoingCertificates(Collection<OutgoingCertificate.BuilderImpl> outgoingCertificates) {
            this.outgoingCertificates = OutgoingCertificatesCopier.copyFromBuilder(outgoingCertificates);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListOutgoingCertificatesResponse build() {
            return new ListOutgoingCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
