/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing group indexing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupIndexingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingGroupIndexingConfiguration.Builder, ThingGroupIndexingConfiguration> {
    private static final SdkField<String> THING_GROUP_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupIndexingConfiguration::thingGroupIndexingModeAsString))
            .setter(setter(Builder::thingGroupIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupIndexingMode").build())
            .build();

    private static final SdkField<List<Field>> MANAGED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .getter(getter(ThingGroupIndexingConfiguration::managedFields))
            .setter(setter(Builder::managedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Field>> CUSTOM_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .getter(getter(ThingGroupIndexingConfiguration::customFields))
            .setter(setter(Builder::customFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            THING_GROUP_INDEXING_MODE_FIELD, MANAGED_FIELDS_FIELD, CUSTOM_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingGroupIndexingMode;

    private final List<Field> managedFields;

    private final List<Field> customFields;

    private ThingGroupIndexingConfiguration(BuilderImpl builder) {
        this.thingGroupIndexingMode = builder.thingGroupIndexingMode;
        this.managedFields = builder.managedFields;
        this.customFields = builder.customFields;
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public ThingGroupIndexingMode thingGroupIndexingMode() {
        return ThingGroupIndexingMode.fromValue(thingGroupIndexingMode);
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public String thingGroupIndexingModeAsString() {
        return thingGroupIndexingMode;
    }

    /**
     * <p>
     * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
     */
    public List<Field> managedFields() {
        return managedFields;
    }

    /**
     * <p>
     * Contains custom field names and their data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains custom field names and their data type.
     */
    public List<Field> customFields() {
        return customFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedFields());
        hashCode = 31 * hashCode + Objects.hashCode(customFields());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupIndexingConfiguration)) {
            return false;
        }
        ThingGroupIndexingConfiguration other = (ThingGroupIndexingConfiguration) obj;
        return Objects.equals(thingGroupIndexingModeAsString(), other.thingGroupIndexingModeAsString())
                && Objects.equals(managedFields(), other.managedFields()) && Objects.equals(customFields(), other.customFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingGroupIndexingConfiguration")
                .add("ThingGroupIndexingMode", thingGroupIndexingModeAsString()).add("ManagedFields", managedFields())
                .add("CustomFields", customFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupIndexingMode":
            return Optional.ofNullable(clazz.cast(thingGroupIndexingModeAsString()));
        case "managedFields":
            return Optional.ofNullable(clazz.cast(managedFields()));
        case "customFields":
            return Optional.ofNullable(clazz.cast(customFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingGroupIndexingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingGroupIndexingConfiguration> {
        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(String thingGroupIndexingMode);

        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Collection<Field> managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Field... managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #managedFields(List<Field>)}.
         * 
         * @param managedFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedFields(List<Field>)
         */
        Builder managedFields(Consumer<Field.Builder>... managedFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Collection<Field> customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Field... customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Field>.Builder} avoiding the need to create
         * one manually via {@link List<Field>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Field>.Builder#build()} is called immediately and its result
         * is passed to {@link #customFields(List<Field>)}.
         * 
         * @param customFields
         *        a consumer that will call methods on {@link List<Field>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFields(List<Field>)
         */
        Builder customFields(Consumer<Field.Builder>... customFields);
    }

    static final class BuilderImpl implements Builder {
        private String thingGroupIndexingMode;

        private List<Field> managedFields = DefaultSdkAutoConstructList.getInstance();

        private List<Field> customFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupIndexingConfiguration model) {
            thingGroupIndexingMode(model.thingGroupIndexingMode);
            managedFields(model.managedFields);
            customFields(model.customFields);
        }

        public final String getThingGroupIndexingModeAsString() {
            return thingGroupIndexingMode;
        }

        @Override
        public final Builder thingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
            return this;
        }

        @Override
        public final Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode) {
            this.thingGroupIndexingMode(thingGroupIndexingMode == null ? null : thingGroupIndexingMode.toString());
            return this;
        }

        public final void setThingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
        }

        public final Collection<Field.Builder> getManagedFields() {
            return managedFields != null ? managedFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder managedFields(Collection<Field> managedFields) {
            this.managedFields = FieldsCopier.copy(managedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Field... managedFields) {
            managedFields(Arrays.asList(managedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Consumer<Field.Builder>... managedFields) {
            managedFields(Stream.of(managedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setManagedFields(Collection<Field.BuilderImpl> managedFields) {
            this.managedFields = FieldsCopier.copyFromBuilder(managedFields);
        }

        public final Collection<Field.Builder> getCustomFields() {
            return customFields != null ? customFields.stream().map(Field::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customFields(Collection<Field> customFields) {
            this.customFields = FieldsCopier.copy(customFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Field... customFields) {
            customFields(Arrays.asList(customFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Consumer<Field.Builder>... customFields) {
            customFields(Stream.of(customFields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomFields(Collection<Field.BuilderImpl> customFields) {
            this.customFields = FieldsCopier.copyFromBuilder(customFields);
        }

        @Override
        public ThingGroupIndexingConfiguration build() {
            return new ThingGroupIndexingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
