/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBillingGroupResponse extends IotResponse implements
        ToCopyableBuilder<DescribeBillingGroupResponse.Builder, DescribeBillingGroupResponse> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBillingGroupResponse::billingGroupName)).setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()).build();

    private static final SdkField<String> BILLING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBillingGroupResponse::billingGroupId)).setter(setter(Builder::billingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupId").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBillingGroupResponse::billingGroupArn)).setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupArn").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeBillingGroupResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField
            .<BillingGroupProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeBillingGroupResponse::billingGroupProperties)).setter(setter(Builder::billingGroupProperties))
            .constructor(BillingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build())
            .build();

    private static final SdkField<BillingGroupMetadata> BILLING_GROUP_METADATA_FIELD = SdkField
            .<BillingGroupMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeBillingGroupResponse::billingGroupMetadata)).setter(setter(Builder::billingGroupMetadata))
            .constructor(BillingGroupMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD,
            BILLING_GROUP_ID_FIELD, BILLING_GROUP_ARN_FIELD, VERSION_FIELD, BILLING_GROUP_PROPERTIES_FIELD,
            BILLING_GROUP_METADATA_FIELD));

    private final String billingGroupName;

    private final String billingGroupId;

    private final String billingGroupArn;

    private final Long version;

    private final BillingGroupProperties billingGroupProperties;

    private final BillingGroupMetadata billingGroupMetadata;

    private DescribeBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupId = builder.billingGroupId;
        this.billingGroupArn = builder.billingGroupArn;
        this.version = builder.version;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.billingGroupMetadata = builder.billingGroupMetadata;
    }

    /**
     * <p>
     * The name of the billing group.
     * </p>
     * 
     * @return The name of the billing group.
     */
    public String billingGroupName() {
        return billingGroupName;
    }

    /**
     * <p>
     * The ID of the billing group.
     * </p>
     * 
     * @return The ID of the billing group.
     */
    public String billingGroupId() {
        return billingGroupId;
    }

    /**
     * <p>
     * The ARN of the billing group.
     * </p>
     * 
     * @return The ARN of the billing group.
     */
    public String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The version of the billing group.
     * </p>
     * 
     * @return The version of the billing group.
     */
    public Long version() {
        return version;
    }

    /**
     * <p>
     * The properties of the billing group.
     * </p>
     * 
     * @return The properties of the billing group.
     */
    public BillingGroupProperties billingGroupProperties() {
        return billingGroupProperties;
    }

    /**
     * <p>
     * Additional information about the billing group.
     * </p>
     * 
     * @return Additional information about the billing group.
     */
    public BillingGroupMetadata billingGroupMetadata() {
        return billingGroupMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBillingGroupResponse)) {
            return false;
        }
        DescribeBillingGroupResponse other = (DescribeBillingGroupResponse) obj;
        return Objects.equals(billingGroupName(), other.billingGroupName())
                && Objects.equals(billingGroupId(), other.billingGroupId())
                && Objects.equals(billingGroupArn(), other.billingGroupArn()) && Objects.equals(version(), other.version())
                && Objects.equals(billingGroupProperties(), other.billingGroupProperties())
                && Objects.equals(billingGroupMetadata(), other.billingGroupMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBillingGroupResponse").add("BillingGroupName", billingGroupName())
                .add("BillingGroupId", billingGroupId()).add("BillingGroupArn", billingGroupArn()).add("Version", version())
                .add("BillingGroupProperties", billingGroupProperties()).add("BillingGroupMetadata", billingGroupMetadata())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        case "billingGroupId":
            return Optional.ofNullable(clazz.cast(billingGroupId()));
        case "billingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "billingGroupProperties":
            return Optional.ofNullable(clazz.cast(billingGroupProperties()));
        case "billingGroupMetadata":
            return Optional.ofNullable(clazz.cast(billingGroupMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBillingGroupResponse, T> g) {
        return obj -> g.apply((DescribeBillingGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBillingGroupResponse> {
        /**
         * <p>
         * The name of the billing group.
         * </p>
         * 
         * @param billingGroupName
         *        The name of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        /**
         * <p>
         * The ID of the billing group.
         * </p>
         * 
         * @param billingGroupId
         *        The ID of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupId(String billingGroupId);

        /**
         * <p>
         * The ARN of the billing group.
         * </p>
         * 
         * @param billingGroupArn
         *        The ARN of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The version of the billing group.
         * </p>
         * 
         * @param version
         *        The version of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * 
         * @param billingGroupProperties
         *        The properties of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupProperties(BillingGroupProperties billingGroupProperties);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingGroupProperties.Builder} avoiding the
         * need to create one manually via {@link BillingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #billingGroupProperties(BillingGroupProperties)}.
         * 
         * @param billingGroupProperties
         *        a consumer that will call methods on {@link BillingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroupProperties(BillingGroupProperties)
         */
        default Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return billingGroupProperties(BillingGroupProperties.builder().applyMutation(billingGroupProperties).build());
        }

        /**
         * <p>
         * Additional information about the billing group.
         * </p>
         * 
         * @param billingGroupMetadata
         *        Additional information about the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupMetadata(BillingGroupMetadata billingGroupMetadata);

        /**
         * <p>
         * Additional information about the billing group.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingGroupMetadata.Builder} avoiding the need
         * to create one manually via {@link BillingGroupMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingGroupMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #billingGroupMetadata(BillingGroupMetadata)}.
         * 
         * @param billingGroupMetadata
         *        a consumer that will call methods on {@link BillingGroupMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroupMetadata(BillingGroupMetadata)
         */
        default Builder billingGroupMetadata(Consumer<BillingGroupMetadata.Builder> billingGroupMetadata) {
            return billingGroupMetadata(BillingGroupMetadata.builder().applyMutation(billingGroupMetadata).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String billingGroupName;

        private String billingGroupId;

        private String billingGroupArn;

        private Long version;

        private BillingGroupProperties billingGroupProperties;

        private BillingGroupMetadata billingGroupMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBillingGroupResponse model) {
            super(model);
            billingGroupName(model.billingGroupName);
            billingGroupId(model.billingGroupId);
            billingGroupArn(model.billingGroupArn);
            version(model.version);
            billingGroupProperties(model.billingGroupProperties);
            billingGroupMetadata(model.billingGroupMetadata);
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        public final String getBillingGroupId() {
            return billingGroupId;
        }

        @Override
        public final Builder billingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
            return this;
        }

        public final void setBillingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        public final Long getVersion() {
            return version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return billingGroupProperties != null ? billingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        public final BillingGroupMetadata.Builder getBillingGroupMetadata() {
            return billingGroupMetadata != null ? billingGroupMetadata.toBuilder() : null;
        }

        @Override
        public final Builder billingGroupMetadata(BillingGroupMetadata billingGroupMetadata) {
            this.billingGroupMetadata = billingGroupMetadata;
            return this;
        }

        public final void setBillingGroupMetadata(BillingGroupMetadata.BuilderImpl billingGroupMetadata) {
            this.billingGroupMetadata = billingGroupMetadata != null ? billingGroupMetadata.build() : null;
        }

        @Override
        public DescribeBillingGroupResponse build() {
            return new DescribeBillingGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
