/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Thing group indexing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingGroupIndexingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingGroupIndexingConfiguration.Builder, ThingGroupIndexingConfiguration> {
    private static final SdkField<String> THING_GROUP_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingGroupIndexingConfiguration::thingGroupIndexingModeAsString))
            .setter(setter(Builder::thingGroupIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupIndexingMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(THING_GROUP_INDEXING_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingGroupIndexingMode;

    private ThingGroupIndexingConfiguration(BuilderImpl builder) {
        this.thingGroupIndexingMode = builder.thingGroupIndexingMode;
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public ThingGroupIndexingMode thingGroupIndexingMode() {
        return ThingGroupIndexingMode.fromValue(thingGroupIndexingMode);
    }

    /**
     * <p>
     * Thing group indexing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingGroupIndexingMode} will return {@link ThingGroupIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #thingGroupIndexingModeAsString}.
     * </p>
     * 
     * @return Thing group indexing mode.
     * @see ThingGroupIndexingMode
     */
    public String thingGroupIndexingModeAsString() {
        return thingGroupIndexingMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupIndexingModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingGroupIndexingConfiguration)) {
            return false;
        }
        ThingGroupIndexingConfiguration other = (ThingGroupIndexingConfiguration) obj;
        return Objects.equals(thingGroupIndexingModeAsString(), other.thingGroupIndexingModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingGroupIndexingConfiguration")
                .add("ThingGroupIndexingMode", thingGroupIndexingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingGroupIndexingMode":
            return Optional.ofNullable(clazz.cast(thingGroupIndexingModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingGroupIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingGroupIndexingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingGroupIndexingConfiguration> {
        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(String thingGroupIndexingMode);

        /**
         * <p>
         * Thing group indexing mode.
         * </p>
         * 
         * @param thingGroupIndexingMode
         *        Thing group indexing mode.
         * @see ThingGroupIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingGroupIndexingMode
         */
        Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode);
    }

    static final class BuilderImpl implements Builder {
        private String thingGroupIndexingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingGroupIndexingConfiguration model) {
            thingGroupIndexingMode(model.thingGroupIndexingMode);
        }

        public final String getThingGroupIndexingModeAsString() {
            return thingGroupIndexingMode;
        }

        @Override
        public final Builder thingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
            return this;
        }

        @Override
        public final Builder thingGroupIndexingMode(ThingGroupIndexingMode thingGroupIndexingMode) {
            this.thingGroupIndexingMode(thingGroupIndexingMode == null ? null : thingGroupIndexingMode.toString());
            return this;
        }

        public final void setThingGroupIndexingMode(String thingGroupIndexingMode) {
            this.thingGroupIndexingMode = thingGroupIndexingMode;
        }

        @Override
        public ThingGroupIndexingConfiguration build() {
            return new ThingGroupIndexingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
