/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOtaUpdatesResponse extends IotResponse implements
        ToCopyableBuilder<ListOtaUpdatesResponse.Builder, ListOtaUpdatesResponse> {
    private static final SdkField<List<OTAUpdateSummary>> OTA_UPDATES_FIELD = SdkField
            .<List<OTAUpdateSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListOtaUpdatesResponse::otaUpdates))
            .setter(setter(Builder::otaUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OTAUpdateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OTAUpdateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListOtaUpdatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<OTAUpdateSummary> otaUpdates;

    private final String nextToken;

    private ListOtaUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.otaUpdates = builder.otaUpdates;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the OtaUpdates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOtaUpdates() {
        return otaUpdates != null && !(otaUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of OTA update jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOtaUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of OTA update jobs.
     */
    public List<OTAUpdateSummary> otaUpdates() {
        return otaUpdates;
    }

    /**
     * <p>
     * A token to use to get the next set of results.
     * </p>
     * 
     * @return A token to use to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOtaUpdatesResponse)) {
            return false;
        }
        ListOtaUpdatesResponse other = (ListOtaUpdatesResponse) obj;
        return Objects.equals(otaUpdates(), other.otaUpdates()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListOtaUpdatesResponse").add("OtaUpdates", otaUpdates()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdates":
            return Optional.ofNullable(clazz.cast(otaUpdates()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOtaUpdatesResponse, T> g) {
        return obj -> g.apply((ListOtaUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListOtaUpdatesResponse> {
        /**
         * <p>
         * A list of OTA update jobs.
         * </p>
         * 
         * @param otaUpdates
         *        A list of OTA update jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdates(Collection<OTAUpdateSummary> otaUpdates);

        /**
         * <p>
         * A list of OTA update jobs.
         * </p>
         * 
         * @param otaUpdates
         *        A list of OTA update jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdates(OTAUpdateSummary... otaUpdates);

        /**
         * <p>
         * A list of OTA update jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OTAUpdateSummary>.Builder} avoiding the
         * need to create one manually via {@link List<OTAUpdateSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OTAUpdateSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #otaUpdates(List<OTAUpdateSummary>)}.
         * 
         * @param otaUpdates
         *        a consumer that will call methods on {@link List<OTAUpdateSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaUpdates(List<OTAUpdateSummary>)
         */
        Builder otaUpdates(Consumer<OTAUpdateSummary.Builder>... otaUpdates);

        /**
         * <p>
         * A token to use to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to use to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<OTAUpdateSummary> otaUpdates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOtaUpdatesResponse model) {
            super(model);
            otaUpdates(model.otaUpdates);
            nextToken(model.nextToken);
        }

        public final Collection<OTAUpdateSummary.Builder> getOtaUpdates() {
            return otaUpdates != null ? otaUpdates.stream().map(OTAUpdateSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder otaUpdates(Collection<OTAUpdateSummary> otaUpdates) {
            this.otaUpdates = OTAUpdatesSummaryCopier.copy(otaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdates(OTAUpdateSummary... otaUpdates) {
            otaUpdates(Arrays.asList(otaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdates(Consumer<OTAUpdateSummary.Builder>... otaUpdates) {
            otaUpdates(Stream.of(otaUpdates).map(c -> OTAUpdateSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOtaUpdates(Collection<OTAUpdateSummary.BuilderImpl> otaUpdates) {
            this.otaUpdates = OTAUpdatesSummaryCopier.copyFromBuilder(otaUpdates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOtaUpdatesResponse build() {
            return new ListOtaUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
