/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProvisioningTemplateResponse extends IotResponse implements
        ToCopyableBuilder<DescribeProvisioningTemplateResponse.Builder, DescribeProvisioningTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningTemplateResponse::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningTemplateResponse::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningTemplateResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProvisioningTemplateResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProvisioningTemplateResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Integer> DEFAULT_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeProvisioningTemplateResponse::defaultVersionId)).setter(setter(Builder::defaultVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersionId").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningTemplateResponse::templateBody)).setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeProvisioningTemplateResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProvisioningTemplateResponse::provisioningRoleArn))
            .setter(setter(Builder::provisioningRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, DEFAULT_VERSION_ID_FIELD,
            TEMPLATE_BODY_FIELD, ENABLED_FIELD, PROVISIONING_ROLE_ARN_FIELD));

    private final String templateArn;

    private final String templateName;

    private final String description;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final Integer defaultVersionId;

    private final String templateBody;

    private final Boolean enabled;

    private final String provisioningRoleArn;

    private DescribeProvisioningTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.defaultVersionId = builder.defaultVersionId;
        this.templateBody = builder.templateBody;
        this.enabled = builder.enabled;
        this.provisioningRoleArn = builder.provisioningRoleArn;
    }

    /**
     * <p>
     * The ARN of the fleet provisioning template.
     * </p>
     * 
     * @return The ARN of the fleet provisioning template.
     */
    public String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The name of the fleet provisioning template.
     * </p>
     * 
     * @return The name of the fleet provisioning template.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The description of the fleet provisioning template.
     * </p>
     * 
     * @return The description of the fleet provisioning template.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date when the fleet provisioning template was created.
     * </p>
     * 
     * @return The date when the fleet provisioning template was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the fleet provisioning template was last modified.
     * </p>
     * 
     * @return The date when the fleet provisioning template was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The default fleet template version ID.
     * </p>
     * 
     * @return The default fleet template version ID.
     */
    public Integer defaultVersionId() {
        return defaultVersionId;
    }

    /**
     * <p>
     * The JSON formatted contents of the fleet provisioning template.
     * </p>
     * 
     * @return The JSON formatted contents of the fleet provisioning template.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * True if the fleet provisioning template is enabled, otherwise false.
     * </p>
     * 
     * @return True if the fleet provisioning template is enabled, otherwise false.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a
     * device.
     * </p>
     * 
     * @return The ARN of the role associated with the provisioning template. This IoT role grants permission to
     *         provision a device.
     */
    public String provisioningRoleArn() {
        return provisioningRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisioningTemplateResponse)) {
            return false;
        }
        DescribeProvisioningTemplateResponse other = (DescribeProvisioningTemplateResponse) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(description(), other.description()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(defaultVersionId(), other.defaultVersionId())
                && Objects.equals(templateBody(), other.templateBody()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(provisioningRoleArn(), other.provisioningRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProvisioningTemplateResponse").add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("Description", description()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).add("DefaultVersionId", defaultVersionId())
                .add("TemplateBody", templateBody()).add("Enabled", enabled()).add("ProvisioningRoleArn", provisioningRoleArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "defaultVersionId":
            return Optional.ofNullable(clazz.cast(defaultVersionId()));
        case "templateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "provisioningRoleArn":
            return Optional.ofNullable(clazz.cast(provisioningRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProvisioningTemplateResponse, T> g) {
        return obj -> g.apply((DescribeProvisioningTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProvisioningTemplateResponse> {
        /**
         * <p>
         * The ARN of the fleet provisioning template.
         * </p>
         * 
         * @param templateArn
         *        The ARN of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The name of the fleet provisioning template.
         * </p>
         * 
         * @param templateName
         *        The name of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The description of the fleet provisioning template.
         * </p>
         * 
         * @param description
         *        The description of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date when the fleet provisioning template was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the fleet provisioning template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the fleet provisioning template was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the fleet provisioning template was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The default fleet template version ID.
         * </p>
         * 
         * @param defaultVersionId
         *        The default fleet template version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(Integer defaultVersionId);

        /**
         * <p>
         * The JSON formatted contents of the fleet provisioning template.
         * </p>
         * 
         * @param templateBody
         *        The JSON formatted contents of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * True if the fleet provisioning template is enabled, otherwise false.
         * </p>
         * 
         * @param enabled
         *        True if the fleet provisioning template is enabled, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The ARN of the role associated with the provisioning template. This IoT role grants permission to provision a
         * device.
         * </p>
         * 
         * @param provisioningRoleArn
         *        The ARN of the role associated with the provisioning template. This IoT role grants permission to
         *        provision a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRoleArn(String provisioningRoleArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String templateArn;

        private String templateName;

        private String description;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private Integer defaultVersionId;

        private String templateBody;

        private Boolean enabled;

        private String provisioningRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisioningTemplateResponse model) {
            super(model);
            templateArn(model.templateArn);
            templateName(model.templateName);
            description(model.description);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            defaultVersionId(model.defaultVersionId);
            templateBody(model.templateBody);
            enabled(model.enabled);
            provisioningRoleArn(model.provisioningRoleArn);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(Integer defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getProvisioningRoleArn() {
            return provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public DescribeProvisioningTemplateResponse build() {
            return new DescribeProvisioningTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
