/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRoleAliasResponse extends IotResponse implements
        ToCopyableBuilder<DescribeRoleAliasResponse.Builder, DescribeRoleAliasResponse> {
    private static final SdkField<RoleAliasDescription> ROLE_ALIAS_DESCRIPTION_FIELD = SdkField
            .<RoleAliasDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeRoleAliasResponse::roleAliasDescription)).setter(setter(Builder::roleAliasDescription))
            .constructor(RoleAliasDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_DESCRIPTION_FIELD));

    private final RoleAliasDescription roleAliasDescription;

    private DescribeRoleAliasResponse(BuilderImpl builder) {
        super(builder);
        this.roleAliasDescription = builder.roleAliasDescription;
    }

    /**
     * <p>
     * The role alias description.
     * </p>
     * 
     * @return The role alias description.
     */
    public RoleAliasDescription roleAliasDescription() {
        return roleAliasDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRoleAliasResponse)) {
            return false;
        }
        DescribeRoleAliasResponse other = (DescribeRoleAliasResponse) obj;
        return Objects.equals(roleAliasDescription(), other.roleAliasDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRoleAliasResponse").add("RoleAliasDescription", roleAliasDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAliasDescription":
            return Optional.ofNullable(clazz.cast(roleAliasDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRoleAliasResponse, T> g) {
        return obj -> g.apply((DescribeRoleAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRoleAliasResponse> {
        /**
         * <p>
         * The role alias description.
         * </p>
         * 
         * @param roleAliasDescription
         *        The role alias description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasDescription(RoleAliasDescription roleAliasDescription);

        /**
         * <p>
         * The role alias description.
         * </p>
         * This is a convenience that creates an instance of the {@link RoleAliasDescription.Builder} avoiding the need
         * to create one manually via {@link RoleAliasDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoleAliasDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #roleAliasDescription(RoleAliasDescription)}.
         * 
         * @param roleAliasDescription
         *        a consumer that will call methods on {@link RoleAliasDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleAliasDescription(RoleAliasDescription)
         */
        default Builder roleAliasDescription(Consumer<RoleAliasDescription.Builder> roleAliasDescription) {
            return roleAliasDescription(RoleAliasDescription.builder().applyMutation(roleAliasDescription).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private RoleAliasDescription roleAliasDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRoleAliasResponse model) {
            super(model);
            roleAliasDescription(model.roleAliasDescription);
        }

        public final RoleAliasDescription.Builder getRoleAliasDescription() {
            return roleAliasDescription != null ? roleAliasDescription.toBuilder() : null;
        }

        @Override
        public final Builder roleAliasDescription(RoleAliasDescription roleAliasDescription) {
            this.roleAliasDescription = roleAliasDescription;
            return this;
        }

        public final void setRoleAliasDescription(RoleAliasDescription.BuilderImpl roleAliasDescription) {
            this.roleAliasDescription = roleAliasDescription != null ? roleAliasDescription.build() : null;
        }

        @Override
        public DescribeRoleAliasResponse build() {
            return new DescribeRoleAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
