/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a file to be associated with an OTA update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OTAUpdateFile implements SdkPojo, Serializable, ToCopyableBuilder<OTAUpdateFile.Builder, OTAUpdateFile> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateFile::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> FILE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateFile::fileVersion)).setter(setter(Builder::fileVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileVersion").build()).build();

    private static final SdkField<FileLocation> FILE_LOCATION_FIELD = SdkField.<FileLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(OTAUpdateFile::fileLocation)).setter(setter(Builder::fileLocation)).constructor(FileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLocation").build()).build();

    private static final SdkField<CodeSigning> CODE_SIGNING_FIELD = SdkField.<CodeSigning> builder(MarshallingType.SDK_POJO)
            .getter(getter(OTAUpdateFile::codeSigning)).setter(setter(Builder::codeSigning)).constructor(CodeSigning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSigning").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(OTAUpdateFile::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD,
            FILE_VERSION_FIELD, FILE_LOCATION_FIELD, CODE_SIGNING_FIELD, ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileName;

    private final String fileVersion;

    private final FileLocation fileLocation;

    private final CodeSigning codeSigning;

    private final Map<String, String> attributes;

    private OTAUpdateFile(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.fileVersion = builder.fileVersion;
        this.fileLocation = builder.fileLocation;
        this.codeSigning = builder.codeSigning;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The name of the file.
     * </p>
     * 
     * @return The name of the file.
     */
    public String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The file version.
     * </p>
     * 
     * @return The file version.
     */
    public String fileVersion() {
        return fileVersion;
    }

    /**
     * <p>
     * The location of the updated firmware.
     * </p>
     * 
     * @return The location of the updated firmware.
     */
    public FileLocation fileLocation() {
        return fileLocation;
    }

    /**
     * <p>
     * The code signing method of the file.
     * </p>
     * 
     * @return The code signing method of the file.
     */
    public CodeSigning codeSigning() {
        return codeSigning;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of name/attribute pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of name/attribute pairs.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(fileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(fileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(codeSigning());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateFile)) {
            return false;
        }
        OTAUpdateFile other = (OTAUpdateFile) obj;
        return Objects.equals(fileName(), other.fileName()) && Objects.equals(fileVersion(), other.fileVersion())
                && Objects.equals(fileLocation(), other.fileLocation()) && Objects.equals(codeSigning(), other.codeSigning())
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OTAUpdateFile").add("FileName", fileName()).add("FileVersion", fileVersion())
                .add("FileLocation", fileLocation()).add("CodeSigning", codeSigning()).add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "fileVersion":
            return Optional.ofNullable(clazz.cast(fileVersion()));
        case "fileLocation":
            return Optional.ofNullable(clazz.cast(fileLocation()));
        case "codeSigning":
            return Optional.ofNullable(clazz.cast(codeSigning()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OTAUpdateFile, T> g) {
        return obj -> g.apply((OTAUpdateFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OTAUpdateFile> {
        /**
         * <p>
         * The name of the file.
         * </p>
         * 
         * @param fileName
         *        The name of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The file version.
         * </p>
         * 
         * @param fileVersion
         *        The file version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileVersion(String fileVersion);

        /**
         * <p>
         * The location of the updated firmware.
         * </p>
         * 
         * @param fileLocation
         *        The location of the updated firmware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLocation(FileLocation fileLocation);

        /**
         * <p>
         * The location of the updated firmware.
         * </p>
         * This is a convenience that creates an instance of the {@link FileLocation.Builder} avoiding the need to
         * create one manually via {@link FileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #fileLocation(FileLocation)}.
         * 
         * @param fileLocation
         *        a consumer that will call methods on {@link FileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileLocation(FileLocation)
         */
        default Builder fileLocation(Consumer<FileLocation.Builder> fileLocation) {
            return fileLocation(FileLocation.builder().applyMutation(fileLocation).build());
        }

        /**
         * <p>
         * The code signing method of the file.
         * </p>
         * 
         * @param codeSigning
         *        The code signing method of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigning(CodeSigning codeSigning);

        /**
         * <p>
         * The code signing method of the file.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSigning.Builder} avoiding the need to create
         * one manually via {@link CodeSigning#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigning.Builder#build()} is called immediately and its result
         * is passed to {@link #codeSigning(CodeSigning)}.
         * 
         * @param codeSigning
         *        a consumer that will call methods on {@link CodeSigning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSigning(CodeSigning)
         */
        default Builder codeSigning(Consumer<CodeSigning.Builder> codeSigning) {
            return codeSigning(CodeSigning.builder().applyMutation(codeSigning).build());
        }

        /**
         * <p>
         * A list of name/attribute pairs.
         * </p>
         * 
         * @param attributes
         *        A list of name/attribute pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private String fileVersion;

        private FileLocation fileLocation;

        private CodeSigning codeSigning;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateFile model) {
            fileName(model.fileName);
            fileVersion(model.fileVersion);
            fileLocation(model.fileLocation);
            codeSigning(model.codeSigning);
            attributes(model.attributes);
        }

        public final String getFileName() {
            return fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final String getFileVersion() {
            return fileVersion;
        }

        @Override
        public final Builder fileVersion(String fileVersion) {
            this.fileVersion = fileVersion;
            return this;
        }

        public final void setFileVersion(String fileVersion) {
            this.fileVersion = fileVersion;
        }

        public final FileLocation.Builder getFileLocation() {
            return fileLocation != null ? fileLocation.toBuilder() : null;
        }

        @Override
        public final Builder fileLocation(FileLocation fileLocation) {
            this.fileLocation = fileLocation;
            return this;
        }

        public final void setFileLocation(FileLocation.BuilderImpl fileLocation) {
            this.fileLocation = fileLocation != null ? fileLocation.build() : null;
        }

        public final CodeSigning.Builder getCodeSigning() {
            return codeSigning != null ? codeSigning.toBuilder() : null;
        }

        @Override
        public final Builder codeSigning(CodeSigning codeSigning) {
            this.codeSigning = codeSigning;
            return this;
        }

        public final void setCodeSigning(CodeSigning.BuilderImpl codeSigning) {
            this.codeSigning = codeSigning != null ? codeSigning.build() : null;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesMapCopier.copy(attributes);
        }

        @Override
        public OTAUpdateFile build() {
            return new OTAUpdateFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
