/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing search index document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingDocument implements SdkPojo, Serializable, ToCopyableBuilder<ThingDocument.Builder, ThingDocument> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingDocument::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingDocument::thingId)).setter(setter(Builder::thingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()).build();

    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingDocument::thingTypeName)).setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ThingDocument::thingGroupNames))
            .setter(setter(Builder::thingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ThingDocument::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SHADOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThingDocument::shadow)).setter(setter(Builder::shadow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadow").build()).build();

    private static final SdkField<ThingConnectivity> CONNECTIVITY_FIELD = SdkField
            .<ThingConnectivity> builder(MarshallingType.SDK_POJO).getter(getter(ThingDocument::connectivity))
            .setter(setter(Builder::connectivity)).constructor(ThingConnectivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_ID_FIELD, THING_TYPE_NAME_FIELD, THING_GROUP_NAMES_FIELD, ATTRIBUTES_FIELD, SHADOW_FIELD, CONNECTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final String thingId;

    private final String thingTypeName;

    private final List<String> thingGroupNames;

    private final Map<String, String> attributes;

    private final String shadow;

    private final ThingConnectivity connectivity;

    private ThingDocument(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingTypeName = builder.thingTypeName;
        this.thingGroupNames = builder.thingGroupNames;
        this.attributes = builder.attributes;
        this.shadow = builder.shadow;
        this.connectivity = builder.connectivity;
    }

    /**
     * <p>
     * The thing name.
     * </p>
     * 
     * @return The thing name.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The thing ID.
     * </p>
     * 
     * @return The thing ID.
     */
    public String thingId() {
        return thingId;
    }

    /**
     * <p>
     * The thing type name.
     * </p>
     * 
     * @return The thing type name.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * Returns true if the ThingGroupNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasThingGroupNames() {
        return thingGroupNames != null && !(thingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Thing group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThingGroupNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Thing group names.
     */
    public List<String> thingGroupNames() {
        return thingGroupNames;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The shadow.
     * </p>
     * 
     * @return The shadow.
     */
    public String shadow() {
        return shadow;
    }

    /**
     * <p>
     * Indicates whether the thing is connected to the AWS IoT service.
     * </p>
     * 
     * @return Indicates whether the thing is connected to the AWS IoT service.
     */
    public ThingConnectivity connectivity() {
        return connectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingId());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(shadow());
        hashCode = 31 * hashCode + Objects.hashCode(connectivity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingId(), other.thingId())
                && Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingGroupNames(), other.thingGroupNames()) && Objects.equals(attributes(), other.attributes())
                && Objects.equals(shadow(), other.shadow()) && Objects.equals(connectivity(), other.connectivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThingDocument").add("ThingName", thingName()).add("ThingId", thingId())
                .add("ThingTypeName", thingTypeName()).add("ThingGroupNames", thingGroupNames()).add("Attributes", attributes())
                .add("Shadow", shadow()).add("Connectivity", connectivity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingId":
            return Optional.ofNullable(clazz.cast(thingId()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingGroupNames":
            return Optional.ofNullable(clazz.cast(thingGroupNames()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "shadow":
            return Optional.ofNullable(clazz.cast(shadow()));
        case "connectivity":
            return Optional.ofNullable(clazz.cast(connectivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingDocument, T> g) {
        return obj -> g.apply((ThingDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingDocument> {
        /**
         * <p>
         * The thing name.
         * </p>
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The thing ID.
         * </p>
         * 
         * @param thingId
         *        The thing ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingId(String thingId);

        /**
         * <p>
         * The thing type name.
         * </p>
         * 
         * @param thingTypeName
         *        The thing type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * Thing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(Collection<String> thingGroupNames);

        /**
         * <p>
         * Thing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(String... thingGroupNames);

        /**
         * <p>
         * The attributes.
         * </p>
         * 
         * @param attributes
         *        The attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The shadow.
         * </p>
         * 
         * @param shadow
         *        The shadow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadow(String shadow);

        /**
         * <p>
         * Indicates whether the thing is connected to the AWS IoT service.
         * </p>
         * 
         * @param connectivity
         *        Indicates whether the thing is connected to the AWS IoT service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivity(ThingConnectivity connectivity);

        /**
         * <p>
         * Indicates whether the thing is connected to the AWS IoT service.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingConnectivity.Builder} avoiding the need to
         * create one manually via {@link ThingConnectivity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingConnectivity.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivity(ThingConnectivity)}.
         * 
         * @param connectivity
         *        a consumer that will call methods on {@link ThingConnectivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivity(ThingConnectivity)
         */
        default Builder connectivity(Consumer<ThingConnectivity.Builder> connectivity) {
            return connectivity(ThingConnectivity.builder().applyMutation(connectivity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingId;

        private String thingTypeName;

        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String shadow;

        private ThingConnectivity connectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingDocument model) {
            thingName(model.thingName);
            thingId(model.thingId);
            thingTypeName(model.thingTypeName);
            thingGroupNames(model.thingGroupNames);
            attributes(model.attributes);
            shadow(model.shadow);
            connectivity(model.connectivity);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingId() {
            return thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Collection<String> getThingGroupNames() {
            return thingGroupNames;
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String... thingGroupNames) {
            thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final String getShadow() {
            return shadow;
        }

        @Override
        public final Builder shadow(String shadow) {
            this.shadow = shadow;
            return this;
        }

        public final void setShadow(String shadow) {
            this.shadow = shadow;
        }

        public final ThingConnectivity.Builder getConnectivity() {
            return connectivity != null ? connectivity.toBuilder() : null;
        }

        @Override
        public final Builder connectivity(ThingConnectivity connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        public final void setConnectivity(ThingConnectivity.BuilderImpl connectivity) {
            this.connectivity = connectivity != null ? connectivity.build() : null;
        }

        @Override
        public ThingDocument build() {
            return new ThingDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
