/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTopicRuleDestinationResponse extends IotResponse implements
        ToCopyableBuilder<CreateTopicRuleDestinationResponse.Builder, CreateTopicRuleDestinationResponse> {
    private static final SdkField<TopicRuleDestination> TOPIC_RULE_DESTINATION_FIELD = SdkField
            .<TopicRuleDestination> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTopicRuleDestinationResponse::topicRuleDestination))
            .setter(setter(Builder::topicRuleDestination)).constructor(TopicRuleDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicRuleDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_RULE_DESTINATION_FIELD));

    private final TopicRuleDestination topicRuleDestination;

    private CreateTopicRuleDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.topicRuleDestination = builder.topicRuleDestination;
    }

    /**
     * <p>
     * The topic rule destination.
     * </p>
     * 
     * @return The topic rule destination.
     */
    public TopicRuleDestination topicRuleDestination() {
        return topicRuleDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicRuleDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleDestinationResponse)) {
            return false;
        }
        CreateTopicRuleDestinationResponse other = (CreateTopicRuleDestinationResponse) obj;
        return Objects.equals(topicRuleDestination(), other.topicRuleDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTopicRuleDestinationResponse").add("TopicRuleDestination", topicRuleDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicRuleDestination":
            return Optional.ofNullable(clazz.cast(topicRuleDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTopicRuleDestinationResponse, T> g) {
        return obj -> g.apply((CreateTopicRuleDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTopicRuleDestinationResponse> {
        /**
         * <p>
         * The topic rule destination.
         * </p>
         * 
         * @param topicRuleDestination
         *        The topic rule destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicRuleDestination(TopicRuleDestination topicRuleDestination);

        /**
         * <p>
         * The topic rule destination.
         * </p>
         * This is a convenience that creates an instance of the {@link TopicRuleDestination.Builder} avoiding the need
         * to create one manually via {@link TopicRuleDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link TopicRuleDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #topicRuleDestination(TopicRuleDestination)}.
         * 
         * @param topicRuleDestination
         *        a consumer that will call methods on {@link TopicRuleDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicRuleDestination(TopicRuleDestination)
         */
        default Builder topicRuleDestination(Consumer<TopicRuleDestination.Builder> topicRuleDestination) {
            return topicRuleDestination(TopicRuleDestination.builder().applyMutation(topicRuleDestination).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private TopicRuleDestination topicRuleDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleDestinationResponse model) {
            super(model);
            topicRuleDestination(model.topicRuleDestination);
        }

        public final TopicRuleDestination.Builder getTopicRuleDestination() {
            return topicRuleDestination != null ? topicRuleDestination.toBuilder() : null;
        }

        @Override
        public final Builder topicRuleDestination(TopicRuleDestination topicRuleDestination) {
            this.topicRuleDestination = topicRuleDestination;
            return this;
        }

        public final void setTopicRuleDestination(TopicRuleDestination.BuilderImpl topicRuleDestination) {
            this.topicRuleDestination = topicRuleDestination != null ? topicRuleDestination.build() : null;
        }

        @Override
        public CreateTopicRuleDestinationResponse build() {
            return new CreateTopicRuleDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
