/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that identifies a mitigation action. This information is returned by ListMitigationActions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MitigationActionIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<MitigationActionIdentifier.Builder, MitigationActionIdentifier> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MitigationActionIdentifier::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MitigationActionIdentifier::actionArn)).setter(setter(Builder::actionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MitigationActionIdentifier::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ACTION_ARN_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionName;

    private final String actionArn;

    private final Instant creationDate;

    private MitigationActionIdentifier(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.actionArn = builder.actionArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The friendly name of the mitigation action.
     * </p>
     * 
     * @return The friendly name of the mitigation action.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The IAM role ARN used to apply this mitigation action.
     * </p>
     * 
     * @return The IAM role ARN used to apply this mitigation action.
     */
    public String actionArn() {
        return actionArn;
    }

    /**
     * <p>
     * The date when this mitigation action was created.
     * </p>
     * 
     * @return The date when this mitigation action was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MitigationActionIdentifier)) {
            return false;
        }
        MitigationActionIdentifier other = (MitigationActionIdentifier) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(actionArn(), other.actionArn())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MitigationActionIdentifier").add("ActionName", actionName()).add("ActionArn", actionArn())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionArn":
            return Optional.ofNullable(clazz.cast(actionArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MitigationActionIdentifier, T> g) {
        return obj -> g.apply((MitigationActionIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MitigationActionIdentifier> {
        /**
         * <p>
         * The friendly name of the mitigation action.
         * </p>
         * 
         * @param actionName
         *        The friendly name of the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The IAM role ARN used to apply this mitigation action.
         * </p>
         * 
         * @param actionArn
         *        The IAM role ARN used to apply this mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionArn(String actionArn);

        /**
         * <p>
         * The date when this mitigation action was created.
         * </p>
         * 
         * @param creationDate
         *        The date when this mitigation action was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String actionName;

        private String actionArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(MitigationActionIdentifier model) {
            actionName(model.actionName);
            actionArn(model.actionArn);
            creationDate(model.creationDate);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getActionArn() {
            return actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public MitigationActionIdentifier build() {
            return new MitigationActionIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
