/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Sends an input to an AWS IoT Events detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IotEventsAction implements SdkPojo, Serializable, ToCopyableBuilder<IotEventsAction.Builder, IotEventsAction> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotEventsAction::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotEventsAction::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IotEventsAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            MESSAGE_ID_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final String messageId;

    private final String roleArn;

    private IotEventsAction(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.messageId = builder.messageId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the AWS IoT Events input.
     * </p>
     * 
     * @return The name of the AWS IoT Events input.
     */
    public String inputName() {
        return inputName;
    }

    /**
     * <p>
     * [Optional] Use this to ensure that only one input (message) with a given messageId will be processed by an AWS
     * IoT Events detector.
     * </p>
     * 
     * @return [Optional] Use this to ensure that only one input (message) with a given messageId will be processed by
     *         an AWS IoT Events detector.
     */
    public String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector.
     * ("Action":"iotevents:BatchPutMessage").
     * </p>
     * 
     * @return The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector.
     *         ("Action":"iotevents:BatchPutMessage").
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotEventsAction)) {
            return false;
        }
        IotEventsAction other = (IotEventsAction) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IotEventsAction").add("InputName", inputName()).add("MessageId", messageId())
                .add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotEventsAction, T> g) {
        return obj -> g.apply((IotEventsAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IotEventsAction> {
        /**
         * <p>
         * The name of the AWS IoT Events input.
         * </p>
         * 
         * @param inputName
         *        The name of the AWS IoT Events input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * [Optional] Use this to ensure that only one input (message) with a given messageId will be processed by an
         * AWS IoT Events detector.
         * </p>
         * 
         * @param messageId
         *        [Optional] Use this to ensure that only one input (message) with a given messageId will be processed
         *        by an AWS IoT Events detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector.
         * ("Action":"iotevents:BatchPutMessage").
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector.
         *        ("Action":"iotevents:BatchPutMessage").
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private String messageId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotEventsAction model) {
            inputName(model.inputName);
            messageId(model.messageId);
            roleArn(model.roleArn);
        }

        public final String getInputName() {
            return inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public IotEventsAction build() {
            return new IotEventsAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
