/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An asset property value entry containing the following information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAssetPropertyValueEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<PutAssetPropertyValueEntry.Builder, PutAssetPropertyValueEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAssetPropertyValueEntry::entryId)).setter(setter(Builder::entryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAssetPropertyValueEntry::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAssetPropertyValueEntry::propertyId)).setter(setter(Builder::propertyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()).build();

    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAssetPropertyValueEntry::propertyAlias)).setter(setter(Builder::propertyAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()).build();

    private static final SdkField<List<AssetPropertyValue>> PROPERTY_VALUES_FIELD = SdkField
            .<List<AssetPropertyValue>> builder(MarshallingType.LIST)
            .getter(getter(PutAssetPropertyValueEntry::propertyValues))
            .setter(setter(Builder::propertyValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetPropertyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetPropertyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD,
            ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryId;

    private final String assetId;

    private final String propertyId;

    private final String propertyAlias;

    private final List<AssetPropertyValue> propertyValues;

    private PutAssetPropertyValueEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyValues = builder.propertyValues;
    }

    /**
     * <p>
     * Optional. A unique identifier for this entry that you can define to better track which message caused an error in
     * case of failure. Accepts substitution templates. Defaults to a new UUID.
     * </p>
     * 
     * @return Optional. A unique identifier for this entry that you can define to better track which message caused an
     *         error in case of failure. Accepts substitution templates. Defaults to a new UUID.
     */
    public String entryId() {
        return entryId;
    }

    /**
     * <p>
     * The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an
     * <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
     * </p>
     * 
     * @return The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an
     *         <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
     */
    public String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The ID of the asset's property. You must specify either a <code>propertyAlias</code> or both an
     * <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
     * </p>
     * 
     * @return The ID of the asset's property. You must specify either a <code>propertyAlias</code> or both an
     *         <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
     */
    public String propertyId() {
        return propertyId;
    }

    /**
     * <p>
     * The name of the property alias associated with your asset property. You must specify either a
     * <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution
     * templates.
     * </p>
     * 
     * @return The name of the property alias associated with your asset property. You must specify either a
     *         <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts
     *         substitution templates.
     */
    public String propertyAlias() {
        return propertyAlias;
    }

    /**
     * Returns true if the PropertyValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPropertyValues() {
        return propertyValues != null && !(propertyValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPropertyValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
     */
    public List<AssetPropertyValue> propertyValues() {
        return propertyValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryId());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(propertyValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAssetPropertyValueEntry)) {
            return false;
        }
        PutAssetPropertyValueEntry other = (PutAssetPropertyValueEntry) obj;
        return Objects.equals(entryId(), other.entryId()) && Objects.equals(assetId(), other.assetId())
                && Objects.equals(propertyId(), other.propertyId()) && Objects.equals(propertyAlias(), other.propertyAlias())
                && Objects.equals(propertyValues(), other.propertyValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutAssetPropertyValueEntry").add("EntryId", entryId()).add("AssetId", assetId())
                .add("PropertyId", propertyId()).add("PropertyAlias", propertyAlias()).add("PropertyValues", propertyValues())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryId":
            return Optional.ofNullable(clazz.cast(entryId()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "propertyId":
            return Optional.ofNullable(clazz.cast(propertyId()));
        case "propertyAlias":
            return Optional.ofNullable(clazz.cast(propertyAlias()));
        case "propertyValues":
            return Optional.ofNullable(clazz.cast(propertyValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAssetPropertyValueEntry, T> g) {
        return obj -> g.apply((PutAssetPropertyValueEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PutAssetPropertyValueEntry> {
        /**
         * <p>
         * Optional. A unique identifier for this entry that you can define to better track which message caused an
         * error in case of failure. Accepts substitution templates. Defaults to a new UUID.
         * </p>
         * 
         * @param entryId
         *        Optional. A unique identifier for this entry that you can define to better track which message caused
         *        an error in case of failure. Accepts substitution templates. Defaults to a new UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryId(String entryId);

        /**
         * <p>
         * The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an
         * <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
         * </p>
         * 
         * @param assetId
         *        The ID of the AWS IoT SiteWise asset. You must specify either a <code>propertyAlias</code> or both an
         *        <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The ID of the asset's property. You must specify either a <code>propertyAlias</code> or both an
         * <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
         * </p>
         * 
         * @param propertyId
         *        The ID of the asset's property. You must specify either a <code>propertyAlias</code> or both an
         *        <code>aliasId</code> and a <code>propertyId</code>. Accepts substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyId(String propertyId);

        /**
         * <p>
         * The name of the property alias associated with your asset property. You must specify either a
         * <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts
         * substitution templates.
         * </p>
         * 
         * @param propertyAlias
         *        The name of the property alias associated with your asset property. You must specify either a
         *        <code>propertyAlias</code> or both an <code>aliasId</code> and a <code>propertyId</code>. Accepts
         *        substitution templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyAlias(String propertyAlias);

        /**
         * <p>
         * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * </p>
         * 
         * @param propertyValues
         *        A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValues(Collection<AssetPropertyValue> propertyValues);

        /**
         * <p>
         * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * </p>
         * 
         * @param propertyValues
         *        A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyValues(AssetPropertyValue... propertyValues);

        /**
         * <p>
         * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssetPropertyValue>.Builder} avoiding the
         * need to create one manually via {@link List<AssetPropertyValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssetPropertyValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #propertyValues(List<AssetPropertyValue>)}.
         * 
         * @param propertyValues
         *        a consumer that will call methods on {@link List<AssetPropertyValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyValues(List<AssetPropertyValue>)
         */
        Builder propertyValues(Consumer<AssetPropertyValue.Builder>... propertyValues);
    }

    static final class BuilderImpl implements Builder {
        private String entryId;

        private String assetId;

        private String propertyId;

        private String propertyAlias;

        private List<AssetPropertyValue> propertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAssetPropertyValueEntry model) {
            entryId(model.entryId);
            assetId(model.assetId);
            propertyId(model.propertyId);
            propertyAlias(model.propertyAlias);
            propertyValues(model.propertyValues);
        }

        public final String getEntryId() {
            return entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        public final String getAssetId() {
            return assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final Collection<AssetPropertyValue.Builder> getPropertyValues() {
            return propertyValues != null ? propertyValues.stream().map(AssetPropertyValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propertyValues(Collection<AssetPropertyValue> propertyValues) {
            this.propertyValues = AssetPropertyValueListCopier.copy(propertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(AssetPropertyValue... propertyValues) {
            propertyValues(Arrays.asList(propertyValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(Consumer<AssetPropertyValue.Builder>... propertyValues) {
            propertyValues(Stream.of(propertyValues).map(c -> AssetPropertyValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyValues(Collection<AssetPropertyValue.BuilderImpl> propertyValues) {
            this.propertyValues = AssetPropertyValueListCopier.copyFromBuilder(propertyValues);
        }

        @Override
        public PutAssetPropertyValueEntry build() {
            return new PutAssetPropertyValueEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
