/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DescribeEndpoint operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointRequest extends IotRequest implements
        ToCopyableBuilder<DescribeEndpointRequest.Builder, DescribeEndpointRequest> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEndpointRequest::endpointType)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endpointType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD));

    private final String endpointType;

    private DescribeEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointType = builder.endpointType;
    }

    /**
     * <p>
     * The endpoint type. Valid endpoint types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>iot:Data</code> - Returns a VeriSign signed data endpoint.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.
     * </p>
     * </li>
     * </ul>
     * <ul>
     * <li>
     * <p>
     * <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The endpoint type. Valid endpoint types include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>iot:Data</code> - Returns a VeriSign signed data endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.
     *         </p>
     *         </li>
     *         </ul>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.
     *         </p>
     *         </li>
     */
    public String endpointType() {
        return endpointType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointRequest)) {
            return false;
        }
        DescribeEndpointRequest other = (DescribeEndpointRequest) obj;
        return Objects.equals(endpointType(), other.endpointType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEndpointRequest").add("EndpointType", endpointType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointRequest, T> g) {
        return obj -> g.apply((DescribeEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointRequest> {
        /**
         * <p>
         * The endpoint type. Valid endpoint types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>iot:Data</code> - Returns a VeriSign signed data endpoint.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.
         * </p>
         * </li>
         * </ul>
         * <ul>
         * <li>
         * <p>
         * <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endpointType
         *        The endpoint type. Valid endpoint types include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>iot:Data</code> - Returns a VeriSign signed data endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>iot:Data-ATS</code> - Returns an ATS signed data endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>iot:CredentialProvider</code> - Returns an AWS IoT credentials provider API endpoint.
         *        </p>
         *        </li>
         *        </ul>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>iot:Jobs</code> - Returns an AWS IoT device management Jobs API endpoint.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String endpointType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointRequest model) {
            super(model);
            endpointType(model.endpointType);
        }

        public final String getEndpointType() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEndpointRequest build() {
            return new DescribeEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
