/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the DescribeCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCertificateResponse extends IotResponse implements
        ToCopyableBuilder<DescribeCertificateResponse.Builder, DescribeCertificateResponse> {
    private static final SdkField<CertificateDescription> CERTIFICATE_DESCRIPTION_FIELD = SdkField
            .<CertificateDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeCertificateResponse::certificateDescription)).setter(setter(Builder::certificateDescription))
            .constructor(CertificateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CERTIFICATE_DESCRIPTION_FIELD));

    private final CertificateDescription certificateDescription;

    private DescribeCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificateDescription = builder.certificateDescription;
    }

    /**
     * <p>
     * The description of the certificate.
     * </p>
     * 
     * @return The description of the certificate.
     */
    public CertificateDescription certificateDescription() {
        return certificateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateResponse)) {
            return false;
        }
        DescribeCertificateResponse other = (DescribeCertificateResponse) obj;
        return Objects.equals(certificateDescription(), other.certificateDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCertificateResponse").add("CertificateDescription", certificateDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateDescription":
            return Optional.ofNullable(clazz.cast(certificateDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCertificateResponse, T> g) {
        return obj -> g.apply((DescribeCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCertificateResponse> {
        /**
         * <p>
         * The description of the certificate.
         * </p>
         * 
         * @param certificateDescription
         *        The description of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDescription(CertificateDescription certificateDescription);

        /**
         * <p>
         * The description of the certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateDescription.Builder} avoiding the
         * need to create one manually via {@link CertificateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateDescription(CertificateDescription)}.
         * 
         * @param certificateDescription
         *        a consumer that will call methods on {@link CertificateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateDescription(CertificateDescription)
         */
        default Builder certificateDescription(Consumer<CertificateDescription.Builder> certificateDescription) {
            return certificateDescription(CertificateDescription.builder().applyMutation(certificateDescription).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private CertificateDescription certificateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateResponse model) {
            super(model);
            certificateDescription(model.certificateDescription);
        }

        public final CertificateDescription.Builder getCertificateDescription() {
            return certificateDescription != null ? certificateDescription.toBuilder() : null;
        }

        @Override
        public final Builder certificateDescription(CertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final void setCertificateDescription(CertificateDescription.BuilderImpl certificateDescription) {
            this.certificateDescription = certificateDescription != null ? certificateDescription.build() : null;
        }

        @Override
        public DescribeCertificateResponse build() {
            return new DescribeCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
