/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamResponse extends IotResponse implements
        ToCopyableBuilder<DescribeStreamResponse.Builder, DescribeStreamResponse> {
    private static final SdkField<StreamInfo> STREAM_INFO_FIELD = SdkField.<StreamInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeStreamResponse::streamInfo)).setter(setter(Builder::streamInfo))
            .constructor(StreamInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_INFO_FIELD));

    private final StreamInfo streamInfo;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamInfo = builder.streamInfo;
    }

    /**
     * <p>
     * Information about the stream.
     * </p>
     * 
     * @return Information about the stream.
     */
    public StreamInfo streamInfo() {
        return streamInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse) obj;
        return Objects.equals(streamInfo(), other.streamInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStreamResponse").add("StreamInfo", streamInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamInfo":
            return Optional.ofNullable(clazz.cast(streamInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamResponse, T> g) {
        return obj -> g.apply((DescribeStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamResponse> {
        /**
         * <p>
         * Information about the stream.
         * </p>
         * 
         * @param streamInfo
         *        Information about the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamInfo(StreamInfo streamInfo);

        /**
         * <p>
         * Information about the stream.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamInfo.Builder} avoiding the need to create
         * one manually via {@link StreamInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #streamInfo(StreamInfo)}.
         * 
         * @param streamInfo
         *        a consumer that will call methods on {@link StreamInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamInfo(StreamInfo)
         */
        default Builder streamInfo(Consumer<StreamInfo.Builder> streamInfo) {
            return streamInfo(StreamInfo.builder().applyMutation(streamInfo).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private StreamInfo streamInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            super(model);
            streamInfo(model.streamInfo);
        }

        public final StreamInfo.Builder getStreamInfo() {
            return streamInfo != null ? streamInfo.toBuilder() : null;
        }

        @Override
        public final Builder streamInfo(StreamInfo streamInfo) {
            this.streamInfo = streamInfo;
            return this;
        }

        public final void setStreamInfo(StreamInfo.BuilderImpl streamInfo) {
            this.streamInfo = streamInfo != null ? streamInfo.build() : null;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
