/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A topic rule destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRuleDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRuleDestination.Builder, TopicRuleDestination> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestination::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestination::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestination::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<HttpUrlDestinationProperties> HTTP_URL_PROPERTIES_FIELD = SdkField
            .<HttpUrlDestinationProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(TopicRuleDestination::httpUrlProperties)).setter(setter(Builder::httpUrlProperties))
            .constructor(HttpUrlDestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, HTTP_URL_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final String statusReason;

    private final HttpUrlDestinationProperties httpUrlProperties;

    private TopicRuleDestination(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.httpUrlProperties = builder.httpUrlProperties;
    }

    /**
     * <p>
     * The topic rule destination URL.
     * </p>
     * 
     * @return The topic rule destination URL.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional details or reason why the topic rule destination is in the current status.
     * </p>
     * 
     * @return Additional details or reason why the topic rule destination is in the current status.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Properties of the HTTP URL.
     * </p>
     * 
     * @return Properties of the HTTP URL.
     */
    public HttpUrlDestinationProperties httpUrlProperties() {
        return httpUrlProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(httpUrlProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestination)) {
            return false;
        }
        TopicRuleDestination other = (TopicRuleDestination) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(httpUrlProperties(), other.httpUrlProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TopicRuleDestination").add("Arn", arn()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("HttpUrlProperties", httpUrlProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "httpUrlProperties":
            return Optional.ofNullable(clazz.cast(httpUrlProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestination, T> g) {
        return obj -> g.apply((TopicRuleDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRuleDestination> {
        /**
         * <p>
         * The topic rule destination URL.
         * </p>
         * 
         * @param arn
         *        The topic rule destination URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(TopicRuleDestinationStatus status);

        /**
         * <p>
         * Additional details or reason why the topic rule destination is in the current status.
         * </p>
         * 
         * @param statusReason
         *        Additional details or reason why the topic rule destination is in the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Properties of the HTTP URL.
         * </p>
         * 
         * @param httpUrlProperties
         *        Properties of the HTTP URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpUrlProperties(HttpUrlDestinationProperties httpUrlProperties);

        /**
         * <p>
         * Properties of the HTTP URL.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpUrlDestinationProperties.Builder} avoiding
         * the need to create one manually via {@link HttpUrlDestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpUrlDestinationProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #httpUrlProperties(HttpUrlDestinationProperties)}.
         * 
         * @param httpUrlProperties
         *        a consumer that will call methods on {@link HttpUrlDestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpUrlProperties(HttpUrlDestinationProperties)
         */
        default Builder httpUrlProperties(Consumer<HttpUrlDestinationProperties.Builder> httpUrlProperties) {
            return httpUrlProperties(HttpUrlDestinationProperties.builder().applyMutation(httpUrlProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private String statusReason;

        private HttpUrlDestinationProperties httpUrlProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestination model) {
            arn(model.arn);
            status(model.status);
            statusReason(model.statusReason);
            httpUrlProperties(model.httpUrlProperties);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final HttpUrlDestinationProperties.Builder getHttpUrlProperties() {
            return httpUrlProperties != null ? httpUrlProperties.toBuilder() : null;
        }

        @Override
        public final Builder httpUrlProperties(HttpUrlDestinationProperties httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties;
            return this;
        }

        public final void setHttpUrlProperties(HttpUrlDestinationProperties.BuilderImpl httpUrlProperties) {
            this.httpUrlProperties = httpUrlProperties != null ? httpUrlProperties.build() : null;
        }

        @Override
        public TopicRuleDestination build() {
            return new TopicRuleDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
