/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingAttribute> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingAttribute.getter(ThingAttribute::thingName)).setter(ThingAttribute.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingAttribute.getter(ThingAttribute::thingTypeName)).setter(ThingAttribute.setter(Builder::thingTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()}).build();
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingAttribute.getter(ThingAttribute::thingArn)).setter(ThingAttribute.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ThingAttribute.getter(ThingAttribute::attributes)).setter(ThingAttribute.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ThingAttribute.getter(ThingAttribute::version)).setter(ThingAttribute.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, THING_TYPE_NAME_FIELD, THING_ARN_FIELD, ATTRIBUTES_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingName;
    private final String thingTypeName;
    private final String thingArn;
    private final Map<String, String> attributes;
    private final Long version;

    private ThingAttribute(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.thingArn = builder.thingArn;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public String thingArn() {
        return this.thingArn;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Long version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingAttribute)) {
            return false;
        }
        ThingAttribute other = (ThingAttribute)obj;
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"ThingAttribute").add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("ThingArn", (Object)this.thingArn()).add("Attributes", this.attributes()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.ofNullable(clazz.cast(this.thingTypeName()));
            }
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingAttribute, T> g) {
        return obj -> g.apply((ThingAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private String thingArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingAttribute model) {
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.thingArn(model.thingArn);
            this.attributes(model.attributes);
            this.version(model.version);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public ThingAttribute build() {
            return new ThingAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingAttribute> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder thingArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder version(Long var1);
    }
}

