/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupResponse;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse;
import software.amazon.awssdk.services.iot.model.AttachPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.CancelJobRequest;
import software.amazon.awssdk.services.iot.model.CancelJobResponse;
import software.amazon.awssdk.services.iot.model.CertificateConflictException;
import software.amazon.awssdk.services.iot.model.CertificateStateException;
import software.amazon.awssdk.services.iot.model.CertificateValidationException;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ConflictingResourceUpdateException;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.services.iot.model.CreateJobResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.services.iot.model.CreateStreamResponse;
import software.amazon.awssdk.services.iot.model.CreateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteConflictException;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobResponse;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DeleteStreamRequest;
import software.amazon.awssdk.services.iot.model.DeleteStreamResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.DescribeIndexRequest;
import software.amazon.awssdk.services.iot.model.DescribeIndexResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobResponse;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DescribeStreamRequest;
import software.amazon.awssdk.services.iot.model.DescribeStreamResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetCardinalityRequest;
import software.amazon.awssdk.services.iot.model.GetCardinalityResponse;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetJobDocumentRequest;
import software.amazon.awssdk.services.iot.model.GetJobDocumentResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.GetPercentilesRequest;
import software.amazon.awssdk.services.iot.model.GetPercentilesResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetStatisticsRequest;
import software.amazon.awssdk.services.iot.model.GetStatisticsResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.IndexNotReadyException;
import software.amazon.awssdk.services.iot.model.InternalException;
import software.amazon.awssdk.services.iot.model.InternalFailureException;
import software.amazon.awssdk.services.iot.model.InvalidAggregationException;
import software.amazon.awssdk.services.iot.model.InvalidQueryException;
import software.amazon.awssdk.services.iot.model.InvalidRequestException;
import software.amazon.awssdk.services.iot.model.InvalidResponseException;
import software.amazon.awssdk.services.iot.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iot.model.IotException;
import software.amazon.awssdk.services.iot.model.LimitExceededException;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListJobsRequest;
import software.amazon.awssdk.services.iot.model.ListJobsResponse;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.MalformedPolicyException;
import software.amazon.awssdk.services.iot.model.NotConfiguredException;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterThingRequest;
import software.amazon.awssdk.services.iot.model.RegisterThingResponse;
import software.amazon.awssdk.services.iot.model.RegistrationCodeValidationException;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot.model.ResourceRegistrationFailureException;
import software.amazon.awssdk.services.iot.model.SearchIndexRequest;
import software.amazon.awssdk.services.iot.model.SearchIndexResponse;
import software.amazon.awssdk.services.iot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SqlParseException;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.TagResourceRequest;
import software.amazon.awssdk.services.iot.model.TagResourceResponse;
import software.amazon.awssdk.services.iot.model.TaskAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.services.iot.model.TestAuthorizationResponse;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ThrottlingException;
import software.amazon.awssdk.services.iot.model.TransferAlreadyCompletedException;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.TransferConflictException;
import software.amazon.awssdk.services.iot.model.UnauthorizedException;
import software.amazon.awssdk.services.iot.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateCACertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateJobRequest;
import software.amazon.awssdk.services.iot.model.UpdateJobResponse;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.UpdateStreamRequest;
import software.amazon.awssdk.services.iot.model.UpdateStreamResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse;
import software.amazon.awssdk.services.iot.model.VersionConflictException;
import software.amazon.awssdk.services.iot.model.VersionsLimitExceededException;
import software.amazon.awssdk.services.iot.transform.AcceptCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AssociateTargetsWithJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ClearDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ConfirmTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateFromCsrRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateKeysAndCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningClaimRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeprecateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditFindingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DisableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.EnableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetCardinalityRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetEffectivePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetJobDocumentRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPercentilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListActiveViolationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAttachedPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditFindingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCaCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesByCaRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDomainConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListMitigationActionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOtaUpdatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOutgoingCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListRoleAliasesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListScheduledAuditsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesForTargetRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTaskReportsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingTypesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRuleDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRulesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListV2LoggingLevelsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListViolationEventsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RejectCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ReplaceTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SearchIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartOnDemandAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StopThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TransferCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ValidateSecurityProfileBehaviorsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IotAsyncClient}.
 *
 * @see IotAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotAsyncClient implements IotAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIotAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return A Java Future containing the result of the AcceptCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AcceptCertificateTransfer
     */
    @Override
    public CompletableFuture<AcceptCertificateTransferResponse> acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptCertificateTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptCertificateTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptCertificateTransferRequest, AcceptCertificateTransferResponse>()
                            .withOperationName("AcceptCertificateTransfer")
                            .withMarshaller(new AcceptCertificateTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(acceptCertificateTransferRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     *
     * @param addThingToBillingGroupRequest
     * @return A Java Future containing the result of the AddThingToBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToBillingGroup
     */
    @Override
    public CompletableFuture<AddThingToBillingGroupResponse> addThingToBillingGroup(
            AddThingToBillingGroupRequest addThingToBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddThingToBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddThingToBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddThingToBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddThingToBillingGroupRequest, AddThingToBillingGroupResponse>()
                            .withOperationName("AddThingToBillingGroup")
                            .withMarshaller(new AddThingToBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(addThingToBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     *
     * @param addThingToThingGroupRequest
     * @return A Java Future containing the result of the AddThingToThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToThingGroup
     */
    @Override
    public CompletableFuture<AddThingToThingGroupResponse> addThingToThingGroup(
            AddThingToThingGroupRequest addThingToThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddThingToThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddThingToThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddThingToThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddThingToThingGroupRequest, AddThingToThingGroupResponse>()
                            .withOperationName("AddThingToThingGroup")
                            .withMarshaller(new AddThingToThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(addThingToThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateTargetsWithJobRequest
     * @return A Java Future containing the result of the AssociateTargetsWithJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AssociateTargetsWithJob
     */
    @Override
    public CompletableFuture<AssociateTargetsWithJobResponse> associateTargetsWithJob(
            AssociateTargetsWithJobRequest associateTargetsWithJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTargetsWithJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateTargetsWithJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateTargetsWithJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTargetsWithJobRequest, AssociateTargetsWithJobResponse>()
                            .withOperationName("AssociateTargetsWithJob")
                            .withMarshaller(new AssociateTargetsWithJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateTargetsWithJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a policy to the specified target.
     * </p>
     *
     * @param attachPolicyRequest
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachPolicy
     */
    @Override
    public CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachPolicyRequest, AttachPolicyResponse>()
                            .withOperationName("AttachPolicy").withMarshaller(new AttachPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachPolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     *
     * @param attachSecurityProfileRequest
     * @return A Java Future containing the result of the AttachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachSecurityProfile
     */
    @Override
    public CompletableFuture<AttachSecurityProfileResponse> attachSecurityProfile(
            AttachSecurityProfileRequest attachSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachSecurityProfileRequest, AttachSecurityProfileResponse>()
                            .withOperationName("AttachSecurityProfile")
                            .withMarshaller(new AttachSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return A Java Future containing the result of the AttachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachThingPrincipal
     */
    @Override
    public CompletableFuture<AttachThingPrincipalResponse> attachThingPrincipal(
            AttachThingPrincipalRequest attachThingPrincipalRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachThingPrincipalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachThingPrincipalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachThingPrincipalRequest, AttachThingPrincipalResponse>()
                            .withOperationName("AttachThingPrincipal")
                            .withMarshaller(new AttachThingPrincipalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(attachThingPrincipalRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the CancelAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditMitigationActionsTask
     */
    @Override
    public CompletableFuture<CancelAuditMitigationActionsTaskResponse> cancelAuditMitigationActionsTask(
            CancelAuditMitigationActionsTaskRequest cancelAuditMitigationActionsTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelAuditMitigationActionsTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CancelAuditMitigationActionsTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelAuditMitigationActionsTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelAuditMitigationActionsTaskRequest, CancelAuditMitigationActionsTaskResponse>()
                            .withOperationName("CancelAuditMitigationActionsTask")
                            .withMarshaller(new CancelAuditMitigationActionsTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelAuditMitigationActionsTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on-demand. If the audit is not in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     *
     * @param cancelAuditTaskRequest
     * @return A Java Future containing the result of the CancelAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditTask
     */
    @Override
    public CompletableFuture<CancelAuditTaskResponse> cancelAuditTask(CancelAuditTaskRequest cancelAuditTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelAuditTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelAuditTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelAuditTaskRequest, CancelAuditTaskResponse>()
                            .withOperationName("CancelAuditTask")
                            .withMarshaller(new CancelAuditTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelAuditTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return A Java Future containing the result of the CancelCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelCertificateTransfer
     */
    @Override
    public CompletableFuture<CancelCertificateTransferResponse> cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelCertificateTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelCertificateTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelCertificateTransferRequest, CancelCertificateTransferResponse>()
                            .withOperationName("CancelCertificateTransfer")
                            .withMarshaller(new CancelCertificateTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelCertificateTransferRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     *
     * @param cancelJobRequest
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJob
     */
    @Override
    public CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CancelJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelJobRequest, CancelJobResponse>().withOperationName("CancelJob")
                            .withMarshaller(new CancelJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     *
     * @param cancelJobExecutionRequest
     * @return A Java Future containing the result of the CancelJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJobExecution
     */
    @Override
    public CompletableFuture<CancelJobExecutionResponse> cancelJobExecution(CancelJobExecutionRequest cancelJobExecutionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelJobExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelJobExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelJobExecutionRequest, CancelJobExecutionResponse>()
                            .withOperationName("CancelJobExecution")
                            .withMarshaller(new CancelJobExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(cancelJobExecutionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     * @return A Java Future containing the result of the ClearDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ClearDefaultAuthorizer
     */
    @Override
    public CompletableFuture<ClearDefaultAuthorizerResponse> clearDefaultAuthorizer(
            ClearDefaultAuthorizerRequest clearDefaultAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClearDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ClearDefaultAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ClearDefaultAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClearDefaultAuthorizerRequest, ClearDefaultAuthorizerResponse>()
                            .withOperationName("ClearDefaultAuthorizer")
                            .withMarshaller(new ClearDefaultAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(clearDefaultAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, AWS IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     * @return A Java Future containing the result of the ConfirmTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ConfirmTopicRuleDestination
     */
    @Override
    public CompletableFuture<ConfirmTopicRuleDestinationResponse> confirmTopicRuleDestination(
            ConfirmTopicRuleDestinationRequest confirmTopicRuleDestinationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConfirmTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConfirmTopicRuleDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ConfirmTopicRuleDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConfirmTopicRuleDestinationRequest, ConfirmTopicRuleDestinationResponse>()
                            .withOperationName("ConfirmTopicRuleDestination")
                            .withMarshaller(new ConfirmTopicRuleDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(confirmTopicRuleDestinationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     *
     * @param createAuthorizerRequest
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateAuthorizer
     */
    @Override
    public CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                            .withOperationName("CreateAuthorizer")
                            .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateBillingGroup
     */
    @Override
    public CompletableFuture<CreateBillingGroupResponse> createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBillingGroupRequest, CreateBillingGroupResponse>()
                            .withOperationName("CreateBillingGroup")
                            .withMarshaller(new CreateBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or
     * an ECC key from NIST P-256 or NIST P-384 curves.
     * </p>
     * <p>
     * <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that
     * directory, and then specifying that directory on the command line. The following commands show how to create a
     * batch of certificates given a batch of CSRs.
     * </p>
     * <p>
     * Assuming a set of CSRs are located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot
     * create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.
     * </p>
     * <p>
     * The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the
     * certificate creation process:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/&#36_}
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; forfiles /p my-csr-directory /c
     * "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return A Java Future containing the result of the CreateCertificateFromCsr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateCertificateFromCsr
     */
    @Override
    public CompletableFuture<CreateCertificateFromCsrResponse> createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCertificateFromCsrResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCertificateFromCsrResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCertificateFromCsrResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResponse>()
                            .withOperationName("CreateCertificateFromCsr")
                            .withMarshaller(new CreateCertificateFromCsrRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createCertificateFromCsrRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param createDomainConfigurationRequest
     * @return A Java Future containing the result of the CreateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDomainConfiguration
     */
    @Override
    public CompletableFuture<CreateDomainConfigurationResponse> createDomainConfiguration(
            CreateDomainConfigurationRequest createDomainConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDomainConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainConfigurationRequest, CreateDomainConfigurationResponse>()
                            .withOperationName("CreateDomainConfiguration")
                            .withMarshaller(new CreateDomainConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDomainConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     *
     * @param createDynamicThingGroupRequest
     * @return A Java Future containing the result of the CreateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDynamicThingGroup
     */
    @Override
    public CompletableFuture<CreateDynamicThingGroupResponse> createDynamicThingGroup(
            CreateDynamicThingGroupRequest createDynamicThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDynamicThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDynamicThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDynamicThingGroupRequest, CreateDynamicThingGroupResponse>()
                            .withOperationName("CreateDynamicThingGroup")
                            .withMarshaller(new CreateDynamicThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createDynamicThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateJob
     */
    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>().withOperationName("CreateJob")
                            .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateKeysAndCertificate
     */
    @Override
    public CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateKeysAndCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateKeysAndCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateKeysAndCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResponse>()
                            .withOperationName("CreateKeysAndCertificate")
                            .withMarshaller(new CreateKeysAndCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createKeysAndCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Each mitigation
     * action can apply only one type of change.
     * </p>
     *
     * @param createMitigationActionRequest
     * @return A Java Future containing the result of the CreateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateMitigationAction
     */
    @Override
    public CompletableFuture<CreateMitigationActionResponse> createMitigationAction(
            CreateMitigationActionRequest createMitigationActionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMitigationActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMitigationActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMitigationActionRequest, CreateMitigationActionResponse>()
                            .withOperationName("CreateMitigationAction")
                            .withMarshaller(new CreateMitigationActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createMitigationActionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AWS IoT OTAUpdate on a target group of things or groups.
     * </p>
     *
     * @param createOtaUpdateRequest
     * @return A Java Future containing the result of the CreateOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateOTAUpdate
     */
    @Override
    public CompletableFuture<CreateOtaUpdateResponse> createOTAUpdate(CreateOtaUpdateRequest createOtaUpdateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOtaUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOtaUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOtaUpdateRequest, CreateOtaUpdateResponse>()
                            .withOperationName("CreateOTAUpdate")
                            .withMarshaller(new CreateOtaUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createOtaUpdateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AWS IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     *
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicy
     */
    @Override
    public CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                            .withOperationName("CreatePolicy").withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createPolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     *
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicyVersion
     */
    @Override
    public CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            CreatePolicyVersionRequest createPolicyVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                            .withOperationName("CreatePolicyVersion")
                            .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createPolicyVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     *
     * @param createProvisioningClaimRequest
     * @return A Java Future containing the result of the CreateProvisioningClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningClaim
     */
    @Override
    public CompletableFuture<CreateProvisioningClaimResponse> createProvisioningClaim(
            CreateProvisioningClaimRequest createProvisioningClaimRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProvisioningClaimResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProvisioningClaimResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProvisioningClaimResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningClaimRequest, CreateProvisioningClaimResponse>()
                            .withOperationName("CreateProvisioningClaim")
                            .withMarshaller(new CreateProvisioningClaimRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createProvisioningClaimRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a fleet provisioning template.
     * </p>
     *
     * @param createProvisioningTemplateRequest
     * @return A Java Future containing the result of the CreateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplate
     */
    @Override
    public CompletableFuture<CreateProvisioningTemplateResponse> createProvisioningTemplate(
            CreateProvisioningTemplateRequest createProvisioningTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateProvisioningTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProvisioningTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateRequest, CreateProvisioningTemplateResponse>()
                            .withOperationName("CreateProvisioningTemplate")
                            .withMarshaller(new CreateProvisioningTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createProvisioningTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of a fleet provisioning template.
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the CreateProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplateVersion
     */
    @Override
    public CompletableFuture<CreateProvisioningTemplateVersionResponse> createProvisioningTemplateVersion(
            CreateProvisioningTemplateVersionRequest createProvisioningTemplateVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProvisioningTemplateVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateProvisioningTemplateVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProvisioningTemplateVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateVersionRequest, CreateProvisioningTemplateVersionResponse>()
                            .withOperationName("CreateProvisioningTemplateVersion")
                            .withMarshaller(new CreateProvisioningTemplateVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createProvisioningTemplateVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     *
     * @param createRoleAliasRequest
     * @return A Java Future containing the result of the CreateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateRoleAlias
     */
    @Override
    public CompletableFuture<CreateRoleAliasResponse> createRoleAlias(CreateRoleAliasRequest createRoleAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRoleAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRoleAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRoleAliasRequest, CreateRoleAliasResponse>()
                            .withOperationName("CreateRoleAlias")
                            .withMarshaller(new CreateRoleAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRoleAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     *
     * @param createScheduledAuditRequest
     * @return A Java Future containing the result of the CreateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateScheduledAudit
     */
    @Override
    public CompletableFuture<CreateScheduledAuditResponse> createScheduledAudit(
            CreateScheduledAuditRequest createScheduledAuditRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateScheduledAuditResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateScheduledAuditResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateScheduledAuditRequest, CreateScheduledAuditResponse>()
                            .withOperationName("CreateScheduledAudit")
                            .withMarshaller(new CreateScheduledAuditRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createScheduledAuditRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return A Java Future containing the result of the CreateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateSecurityProfile
     */
    @Override
    public CompletableFuture<CreateSecurityProfileResponse> createSecurityProfile(
            CreateSecurityProfileRequest createSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSecurityProfileRequest, CreateSecurityProfileResponse>()
                            .withOperationName("CreateSecurityProfile")
                            .withMarshaller(new CreateSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     *
     * @param createStreamRequest
     * @return A Java Future containing the result of the CreateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateStream
     */
    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamRequest, CreateStreamResponse>()
                            .withOperationName("CreateStream").withMarshaller(new CreateStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createStreamRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     *
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return A Java Future containing the result of the CreateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThing
     */
    @Override
    public CompletableFuture<CreateThingResponse> createThing(CreateThingRequest createThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThingRequest, CreateThingResponse>()
                            .withOperationName("CreateThing").withMarshaller(new CreateThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     *
     * @param createThingGroupRequest
     * @return A Java Future containing the result of the CreateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingGroup
     */
    @Override
    public CompletableFuture<CreateThingGroupResponse> createThingGroup(CreateThingGroupRequest createThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThingGroupRequest, CreateThingGroupResponse>()
                            .withOperationName("CreateThingGroup")
                            .withMarshaller(new CreateThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     *
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return A Java Future containing the result of the CreateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingType
     */
    @Override
    public CompletableFuture<CreateThingTypeResponse> createThingType(CreateThingTypeRequest createThingTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThingTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThingTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThingTypeRequest, CreateThingTypeResponse>()
                            .withOperationName("CreateThingType")
                            .withMarshaller(new CreateThingTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createThingTypeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     *
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return A Java Future containing the result of the CreateTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRule
     */
    @Override
    public CompletableFuture<CreateTopicRuleResponse> createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRuleRequest, CreateTopicRuleResponse>()
                            .withOperationName("CreateTopicRule")
                            .withMarshaller(new CreateTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     * @return A Java Future containing the result of the CreateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRuleDestination
     */
    @Override
    public CompletableFuture<CreateTopicRuleDestinationResponse> createTopicRuleDestination(
            CreateTopicRuleDestinationRequest createTopicRuleDestinationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTopicRuleDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTopicRuleDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRuleDestinationRequest, CreateTopicRuleDestinationResponse>()
                            .withOperationName("CreateTopicRuleDestination")
                            .withMarshaller(new CreateTopicRuleDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTopicRuleDestinationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the DeleteAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAccountAuditConfiguration
     */
    @Override
    public CompletableFuture<DeleteAccountAuditConfigurationResponse> deleteAccountAuditConfiguration(
            DeleteAccountAuditConfigurationRequest deleteAccountAuditConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountAuditConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccountAuditConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAuditConfigurationRequest, DeleteAccountAuditConfigurationResponse>()
                            .withOperationName("DeleteAccountAuditConfiguration")
                            .withMarshaller(new DeleteAccountAuditConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAccountAuditConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAuthorizer
     */
    @Override
    public CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                            .withOperationName("DeleteAuthorizer")
                            .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteBillingGroup
     */
    @Override
    public CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBillingGroupRequest, DeleteBillingGroupResponse>()
                            .withOperationName("DeleteBillingGroup")
                            .withMarshaller(new DeleteBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return A Java Future containing the result of the DeleteCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCACertificate
     */
    @Override
    public CompletableFuture<DeleteCaCertificateResponse> deleteCACertificate(
            DeleteCaCertificateRequest deleteCaCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCaCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCaCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCaCertificateRequest, DeleteCaCertificateResponse>()
                            .withOperationName("DeleteCACertificate")
                            .withMarshaller(new DeleteCaCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteCaCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the
     * <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.
     * </p>
     *
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCertificate
     */
    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                            .withOperationName("DeleteCertificate")
                            .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param deleteDomainConfigurationRequest
     * @return A Java Future containing the result of the DeleteDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDomainConfiguration
     */
    @Override
    public CompletableFuture<DeleteDomainConfigurationResponse> deleteDomainConfiguration(
            DeleteDomainConfigurationRequest deleteDomainConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDomainConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainConfigurationRequest, DeleteDomainConfigurationResponse>()
                            .withOperationName("DeleteDomainConfiguration")
                            .withMarshaller(new DeleteDomainConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDomainConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     * @return A Java Future containing the result of the DeleteDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDynamicThingGroup
     */
    @Override
    public CompletableFuture<DeleteDynamicThingGroupResponse> deleteDynamicThingGroup(
            DeleteDynamicThingGroupRequest deleteDynamicThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDynamicThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDynamicThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDynamicThingGroupRequest, DeleteDynamicThingGroupResponse>()
                            .withOperationName("DeleteDynamicThingGroup")
                            .withMarshaller(new DeleteDynamicThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDynamicThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     *
     * @param deleteJobRequest
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJob
     */
    @Override
    public CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteJobRequest, DeleteJobResponse>().withOperationName("DeleteJob")
                            .withMarshaller(new DeleteJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     *
     * @param deleteJobExecutionRequest
     * @return A Java Future containing the result of the DeleteJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJobExecution
     */
    @Override
    public CompletableFuture<DeleteJobExecutionResponse> deleteJobExecution(DeleteJobExecutionRequest deleteJobExecutionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteJobExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteJobExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteJobExecutionRequest, DeleteJobExecutionResponse>()
                            .withOperationName("DeleteJobExecution")
                            .withMarshaller(new DeleteJobExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteJobExecutionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your AWS account.
     * </p>
     *
     * @param deleteMitigationActionRequest
     * @return A Java Future containing the result of the DeleteMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteMitigationAction
     */
    @Override
    public CompletableFuture<DeleteMitigationActionResponse> deleteMitigationAction(
            DeleteMitigationActionRequest deleteMitigationActionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMitigationActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMitigationActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMitigationActionRequest, DeleteMitigationActionResponse>()
                            .withOperationName("DeleteMitigationAction")
                            .withMarshaller(new DeleteMitigationActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteMitigationActionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     *
     * @param deleteOtaUpdateRequest
     * @return A Java Future containing the result of the DeleteOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteOTAUpdate
     */
    @Override
    public CompletableFuture<DeleteOtaUpdateResponse> deleteOTAUpdate(DeleteOtaUpdateRequest deleteOtaUpdateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOtaUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOtaUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOtaUpdateRequest, DeleteOtaUpdateResponse>()
                            .withOperationName("DeleteOTAUpdate")
                            .withMarshaller(new DeleteOtaUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteOtaUpdateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the
     * DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete
     * the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     *
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicy
     */
    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                            .withOperationName("DeletePolicy").withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deletePolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicyVersion
     */
    @Override
    public CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            DeletePolicyVersionRequest deletePolicyVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                            .withOperationName("DeletePolicyVersion")
                            .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deletePolicyVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet provisioning template.
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     * @return A Java Future containing the result of the DeleteProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplate
     */
    @Override
    public CompletableFuture<DeleteProvisioningTemplateResponse> deleteProvisioningTemplate(
            DeleteProvisioningTemplateRequest deleteProvisioningTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteProvisioningTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProvisioningTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningTemplateRequest, DeleteProvisioningTemplateResponse>()
                            .withOperationName("DeleteProvisioningTemplate")
                            .withMarshaller(new DeleteProvisioningTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteProvisioningTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a fleet provisioning template version.
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the DeleteProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplateVersion
     */
    @Override
    public CompletableFuture<DeleteProvisioningTemplateVersionResponse> deleteProvisioningTemplateVersion(
            DeleteProvisioningTemplateVersionRequest deleteProvisioningTemplateVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProvisioningTemplateVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteProvisioningTemplateVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProvisioningTemplateVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningTemplateVersionRequest, DeleteProvisioningTemplateVersionResponse>()
                            .withOperationName("DeleteProvisioningTemplateVersion")
                            .withMarshaller(new DeleteProvisioningTemplateVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteProvisioningTemplateVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRegistrationCode
     */
    @Override
    public CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode(
            DeleteRegistrationCodeRequest deleteRegistrationCodeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRegistrationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRegistrationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRegistrationCodeRequest, DeleteRegistrationCodeResponse>()
                            .withOperationName("DeleteRegistrationCode")
                            .withMarshaller(new DeleteRegistrationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRegistrationCodeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     *
     * @param deleteRoleAliasRequest
     * @return A Java Future containing the result of the DeleteRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRoleAlias
     */
    @Override
    public CompletableFuture<DeleteRoleAliasResponse> deleteRoleAlias(DeleteRoleAliasRequest deleteRoleAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRoleAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRoleAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleAliasRequest, DeleteRoleAliasResponse>()
                            .withOperationName("DeleteRoleAlias")
                            .withMarshaller(new DeleteRoleAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRoleAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     *
     * @param deleteScheduledAuditRequest
     * @return A Java Future containing the result of the DeleteScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteScheduledAudit
     */
    @Override
    public CompletableFuture<DeleteScheduledAuditResponse> deleteScheduledAudit(
            DeleteScheduledAuditRequest deleteScheduledAuditRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteScheduledAuditResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteScheduledAuditResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScheduledAuditRequest, DeleteScheduledAuditResponse>()
                            .withOperationName("DeleteScheduledAudit")
                            .withMarshaller(new DeleteScheduledAuditRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteScheduledAuditRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return A Java Future containing the result of the DeleteSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteSecurityProfile
     */
    @Override
    public CompletableFuture<DeleteSecurityProfileResponse> deleteSecurityProfile(
            DeleteSecurityProfileRequest deleteSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSecurityProfileRequest, DeleteSecurityProfileResponse>()
                            .withOperationName("DeleteSecurityProfile")
                            .withMarshaller(new DeleteSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     *
     * @param deleteStreamRequest
     * @return A Java Future containing the result of the DeleteStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteStream
     */
    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamRequest, DeleteStreamResponse>()
                            .withOperationName("DeleteStream").withMarshaller(new DeleteStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteStreamRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     *
     * @param deleteThingRequest
     *        The input for the DeleteThing operation.
     * @return A Java Future containing the result of the DeleteThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThing
     */
    @Override
    public CompletableFuture<DeleteThingResponse> deleteThing(DeleteThingRequest deleteThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThingRequest, DeleteThingResponse>()
                            .withOperationName("DeleteThing").withMarshaller(new DeleteThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     *
     * @param deleteThingGroupRequest
     * @return A Java Future containing the result of the DeleteThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingGroup
     */
    @Override
    public CompletableFuture<DeleteThingGroupResponse> deleteThingGroup(DeleteThingGroupRequest deleteThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThingGroupRequest, DeleteThingGroupResponse>()
                            .withOperationName("DeleteThingGroup")
                            .withMarshaller(new DeleteThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     *
     * @param deleteThingTypeRequest
     *        The input for the DeleteThingType operation.
     * @return A Java Future containing the result of the DeleteThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingType
     */
    @Override
    public CompletableFuture<DeleteThingTypeResponse> deleteThingType(DeleteThingTypeRequest deleteThingTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThingTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThingTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThingTypeRequest, DeleteThingTypeResponse>()
                            .withOperationName("DeleteThingType")
                            .withMarshaller(new DeleteThingTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteThingTypeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        The input for the DeleteTopicRule operation.
     * @return A Java Future containing the result of the DeleteTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRule
     */
    @Override
    public CompletableFuture<DeleteTopicRuleResponse> deleteTopicRule(DeleteTopicRuleRequest deleteTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRuleRequest, DeleteTopicRuleResponse>()
                            .withOperationName("DeleteTopicRule")
                            .withMarshaller(new DeleteTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     * @return A Java Future containing the result of the DeleteTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRuleDestination
     */
    @Override
    public CompletableFuture<DeleteTopicRuleDestinationResponse> deleteTopicRuleDestination(
            DeleteTopicRuleDestinationRequest deleteTopicRuleDestinationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTopicRuleDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTopicRuleDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRuleDestinationRequest, DeleteTopicRuleDestinationResponse>()
                            .withOperationName("DeleteTopicRuleDestination")
                            .withMarshaller(new DeleteTopicRuleDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTopicRuleDestinationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     * @return A Java Future containing the result of the DeleteV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteV2LoggingLevel
     */
    @Override
    public CompletableFuture<DeleteV2LoggingLevelResponse> deleteV2LoggingLevel(
            DeleteV2LoggingLevelRequest deleteV2LoggingLevelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteV2LoggingLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteV2LoggingLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteV2LoggingLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteV2LoggingLevelRequest, DeleteV2LoggingLevelResponse>()
                            .withOperationName("DeleteV2LoggingLevel")
                            .withMarshaller(new DeleteV2LoggingLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteV2LoggingLevelRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        The input for the DeprecateThingType operation.
     * @return A Java Future containing the result of the DeprecateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeprecateThingType
     */
    @Override
    public CompletableFuture<DeprecateThingTypeResponse> deprecateThingType(DeprecateThingTypeRequest deprecateThingTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeprecateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeprecateThingTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeprecateThingTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeprecateThingTypeRequest, DeprecateThingTypeResponse>()
                            .withOperationName("DeprecateThingType")
                            .withMarshaller(new DeprecateThingTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deprecateThingTypeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAccountAuditConfiguration
     */
    @Override
    public CompletableFuture<DescribeAccountAuditConfigurationResponse> describeAccountAuditConfiguration(
            DescribeAccountAuditConfigurationRequest describeAccountAuditConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountAuditConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAccountAuditConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountAuditConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAuditConfigurationRequest, DescribeAccountAuditConfigurationResponse>()
                            .withOperationName("DescribeAccountAuditConfiguration")
                            .withMarshaller(new DescribeAccountAuditConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAccountAuditConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and when the audit that returned the finding was started.
     * </p>
     *
     * @param describeAuditFindingRequest
     * @return A Java Future containing the result of the DescribeAuditFinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditFinding
     */
    @Override
    public CompletableFuture<DescribeAuditFindingResponse> describeAuditFinding(
            DescribeAuditFindingRequest describeAuditFindingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAuditFindingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAuditFindingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAuditFindingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAuditFindingRequest, DescribeAuditFindingResponse>()
                            .withOperationName("DescribeAuditFinding")
                            .withMarshaller(new DescribeAuditFindingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAuditFindingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the DescribeAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditMitigationActionsTask
     */
    @Override
    public CompletableFuture<DescribeAuditMitigationActionsTaskResponse> describeAuditMitigationActionsTask(
            DescribeAuditMitigationActionsTaskRequest describeAuditMitigationActionsTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAuditMitigationActionsTaskResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAuditMitigationActionsTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAuditMitigationActionsTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAuditMitigationActionsTaskRequest, DescribeAuditMitigationActionsTaskResponse>()
                            .withOperationName("DescribeAuditMitigationActionsTask")
                            .withMarshaller(new DescribeAuditMitigationActionsTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAuditMitigationActionsTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     *
     * @param describeAuditTaskRequest
     * @return A Java Future containing the result of the DescribeAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditTask
     */
    @Override
    public CompletableFuture<DescribeAuditTaskResponse> describeAuditTask(DescribeAuditTaskRequest describeAuditTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAuditTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAuditTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAuditTaskRequest, DescribeAuditTaskResponse>()
                            .withOperationName("DescribeAuditTask")
                            .withMarshaller(new DescribeAuditTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAuditTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     *
     * @param describeAuthorizerRequest
     * @return A Java Future containing the result of the DescribeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuthorizer
     */
    @Override
    public CompletableFuture<DescribeAuthorizerResponse> describeAuthorizer(DescribeAuthorizerRequest describeAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAuthorizerRequest, DescribeAuthorizerResponse>()
                            .withOperationName("DescribeAuthorizer")
                            .withMarshaller(new DescribeAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     *
     * @param describeBillingGroupRequest
     * @return A Java Future containing the result of the DescribeBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeBillingGroup
     */
    @Override
    public CompletableFuture<DescribeBillingGroupResponse> describeBillingGroup(
            DescribeBillingGroupRequest describeBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBillingGroupRequest, DescribeBillingGroupResponse>()
                            .withOperationName("DescribeBillingGroup")
                            .withMarshaller(new DescribeBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     *
     * @param describeCaCertificateRequest
     *        The input for the DescribeCACertificate operation.
     * @return A Java Future containing the result of the DescribeCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCACertificate
     */
    @Override
    public CompletableFuture<DescribeCaCertificateResponse> describeCACertificate(
            DescribeCaCertificateRequest describeCaCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCaCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCaCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCaCertificateRequest, DescribeCaCertificateResponse>()
                            .withOperationName("DescribeCACertificate")
                            .withMarshaller(new DescribeCaCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCaCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     *
     * @param describeCertificateRequest
     *        The input for the DescribeCertificate operation.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCertificate
     */
    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                            .withOperationName("DescribeCertificate")
                            .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     * @return A Java Future containing the result of the DescribeDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDefaultAuthorizer
     */
    @Override
    public CompletableFuture<DescribeDefaultAuthorizerResponse> describeDefaultAuthorizer(
            DescribeDefaultAuthorizerRequest describeDefaultAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDefaultAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDefaultAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDefaultAuthorizerRequest, DescribeDefaultAuthorizerResponse>()
                            .withOperationName("DescribeDefaultAuthorizer")
                            .withMarshaller(new DescribeDefaultAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDefaultAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param describeDomainConfigurationRequest
     * @return A Java Future containing the result of the DescribeDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDomainConfiguration
     */
    @Override
    public CompletableFuture<DescribeDomainConfigurationResponse> describeDomainConfiguration(
            DescribeDomainConfigurationRequest describeDomainConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainConfigurationRequest, DescribeDomainConfigurationResponse>()
                            .withOperationName("DescribeDomainConfiguration")
                            .withMarshaller(new DescribeDomainConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeDomainConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     *
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEndpoint
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                            .withOperationName("DescribeEndpoint")
                            .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEndpointRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     *
     * @param describeEventConfigurationsRequest
     * @return A Java Future containing the result of the DescribeEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEventConfigurations
     */
    @Override
    public CompletableFuture<DescribeEventConfigurationsResponse> describeEventConfigurations(
            DescribeEventConfigurationsRequest describeEventConfigurationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEventConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventConfigurationsRequest, DescribeEventConfigurationsResponse>()
                            .withOperationName("DescribeEventConfigurations")
                            .withMarshaller(new DescribeEventConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEventConfigurationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     *
     * @param describeIndexRequest
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeIndex
     */
    @Override
    public CompletableFuture<DescribeIndexResponse> describeIndex(DescribeIndexRequest describeIndexRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIndexRequest, DescribeIndexResponse>()
                            .withOperationName("DescribeIndex")
                            .withMarshaller(new DescribeIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeIndexRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     *
     * @param describeJobRequest
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJob
     */
    @Override
    public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeJobRequest, DescribeJobResponse>()
                            .withOperationName("DescribeJob").withMarshaller(new DescribeJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return A Java Future containing the result of the DescribeJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJobExecution
     */
    @Override
    public CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(
            DescribeJobExecutionRequest describeJobExecutionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeJobExecutionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeJobExecutionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeJobExecutionRequest, DescribeJobExecutionResponse>()
                            .withOperationName("DescribeJobExecution")
                            .withMarshaller(new DescribeJobExecutionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeJobExecutionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     *
     * @param describeMitigationActionRequest
     * @return A Java Future containing the result of the DescribeMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeMitigationAction
     */
    @Override
    public CompletableFuture<DescribeMitigationActionResponse> describeMitigationAction(
            DescribeMitigationActionRequest describeMitigationActionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMitigationActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMitigationActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMitigationActionRequest, DescribeMitigationActionResponse>()
                            .withOperationName("DescribeMitigationAction")
                            .withMarshaller(new DescribeMitigationActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMitigationActionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template.
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     * @return A Java Future containing the result of the DescribeProvisioningTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplate
     */
    @Override
    public CompletableFuture<DescribeProvisioningTemplateResponse> describeProvisioningTemplate(
            DescribeProvisioningTemplateRequest describeProvisioningTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProvisioningTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisioningTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningTemplateRequest, DescribeProvisioningTemplateResponse>()
                            .withOperationName("DescribeProvisioningTemplate")
                            .withMarshaller(new DescribeProvisioningTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeProvisioningTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template version.
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the DescribeProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplateVersion
     */
    @Override
    public CompletableFuture<DescribeProvisioningTemplateVersionResponse> describeProvisioningTemplateVersion(
            DescribeProvisioningTemplateVersionRequest describeProvisioningTemplateVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProvisioningTemplateVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeProvisioningTemplateVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProvisioningTemplateVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningTemplateVersionRequest, DescribeProvisioningTemplateVersionResponse>()
                            .withOperationName("DescribeProvisioningTemplateVersion")
                            .withMarshaller(new DescribeProvisioningTemplateVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeProvisioningTemplateVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     *
     * @param describeRoleAliasRequest
     * @return A Java Future containing the result of the DescribeRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeRoleAlias
     */
    @Override
    public CompletableFuture<DescribeRoleAliasResponse> describeRoleAlias(DescribeRoleAliasRequest describeRoleAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRoleAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRoleAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRoleAliasRequest, DescribeRoleAliasResponse>()
                            .withOperationName("DescribeRoleAlias")
                            .withMarshaller(new DescribeRoleAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeRoleAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     *
     * @param describeScheduledAuditRequest
     * @return A Java Future containing the result of the DescribeScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeScheduledAudit
     */
    @Override
    public CompletableFuture<DescribeScheduledAuditResponse> describeScheduledAudit(
            DescribeScheduledAuditRequest describeScheduledAuditRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeScheduledAuditResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeScheduledAuditResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledAuditRequest, DescribeScheduledAuditResponse>()
                            .withOperationName("DescribeScheduledAudit")
                            .withMarshaller(new DescribeScheduledAuditRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeScheduledAuditRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return A Java Future containing the result of the DescribeSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeSecurityProfile
     */
    @Override
    public CompletableFuture<DescribeSecurityProfileResponse> describeSecurityProfile(
            DescribeSecurityProfileRequest describeSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSecurityProfileRequest, DescribeSecurityProfileResponse>()
                            .withOperationName("DescribeSecurityProfile")
                            .withMarshaller(new DescribeSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     *
     * @param describeStreamRequest
     * @return A Java Future containing the result of the DescribeStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeStream
     */
    @Override
    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStreamRequest, DescribeStreamResponse>()
                            .withOperationName("DescribeStream")
                            .withMarshaller(new DescribeStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeStreamRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     *
     * @param describeThingRequest
     *        The input for the DescribeThing operation.
     * @return A Java Future containing the result of the DescribeThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThing
     */
    @Override
    public CompletableFuture<DescribeThingResponse> describeThing(DescribeThingRequest describeThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThingRequest, DescribeThingResponse>()
                            .withOperationName("DescribeThing")
                            .withMarshaller(new DescribeThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     *
     * @param describeThingGroupRequest
     * @return A Java Future containing the result of the DescribeThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingGroup
     */
    @Override
    public CompletableFuture<DescribeThingGroupResponse> describeThingGroup(DescribeThingGroupRequest describeThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThingGroupRequest, DescribeThingGroupResponse>()
                            .withOperationName("DescribeThingGroup")
                            .withMarshaller(new DescribeThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     * @return A Java Future containing the result of the DescribeThingRegistrationTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingRegistrationTask
     */
    @Override
    public CompletableFuture<DescribeThingRegistrationTaskResponse> describeThingRegistrationTask(
            DescribeThingRegistrationTaskRequest describeThingRegistrationTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThingRegistrationTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThingRegistrationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThingRegistrationTaskRequest, DescribeThingRegistrationTaskResponse>()
                            .withOperationName("DescribeThingRegistrationTask")
                            .withMarshaller(new DescribeThingRegistrationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeThingRegistrationTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     *
     * @param describeThingTypeRequest
     *        The input for the DescribeThingType operation.
     * @return A Java Future containing the result of the DescribeThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingType
     */
    @Override
    public CompletableFuture<DescribeThingTypeResponse> describeThingType(DescribeThingTypeRequest describeThingTypeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThingTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThingTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThingTypeRequest, DescribeThingTypeResponse>()
                            .withOperationName("DescribeThingType")
                            .withMarshaller(new DescribeThingTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeThingTypeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     *
     * @param detachPolicyRequest
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachPolicy
     */
    @Override
    public CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachPolicyRequest, DetachPolicyResponse>()
                            .withOperationName("DetachPolicy").withMarshaller(new DetachPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachPolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     *
     * @param detachSecurityProfileRequest
     * @return A Java Future containing the result of the DetachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachSecurityProfile
     */
    @Override
    public CompletableFuture<DetachSecurityProfileResponse> detachSecurityProfile(
            DetachSecurityProfileRequest detachSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachSecurityProfileRequest, DetachSecurityProfileResponse>()
                            .withOperationName("DetachSecurityProfile")
                            .withMarshaller(new DetachSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     *
     * @param detachThingPrincipalRequest
     *        The input for the DetachThingPrincipal operation.
     * @return A Java Future containing the result of the DetachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachThingPrincipal
     */
    @Override
    public CompletableFuture<DetachThingPrincipalResponse> detachThingPrincipal(
            DetachThingPrincipalRequest detachThingPrincipalRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachThingPrincipalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachThingPrincipalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachThingPrincipalRequest, DetachThingPrincipalResponse>()
                            .withOperationName("DetachThingPrincipal")
                            .withMarshaller(new DetachThingPrincipalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(detachThingPrincipalRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     *
     * @param disableTopicRuleRequest
     *        The input for the DisableTopicRuleRequest operation.
     * @return A Java Future containing the result of the DisableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DisableTopicRule
     */
    @Override
    public CompletableFuture<DisableTopicRuleResponse> disableTopicRule(DisableTopicRuleRequest disableTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableTopicRuleRequest, DisableTopicRuleResponse>()
                            .withOperationName("DisableTopicRule")
                            .withMarshaller(new DisableTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disableTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     *
     * @param enableTopicRuleRequest
     *        The input for the EnableTopicRuleRequest operation.
     * @return A Java Future containing the result of the EnableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.EnableTopicRule
     */
    @Override
    public CompletableFuture<EnableTopicRuleResponse> enableTopicRule(EnableTopicRuleRequest enableTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableTopicRuleRequest, EnableTopicRuleResponse>()
                            .withOperationName("EnableTopicRule")
                            .withMarshaller(new EnableTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(enableTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     *
     * @param getCardinalityRequest
     * @return A Java Future containing the result of the GetCardinality operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetCardinality
     */
    @Override
    public CompletableFuture<GetCardinalityResponse> getCardinality(GetCardinalityRequest getCardinalityRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCardinalityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCardinalityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCardinalityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCardinalityRequest, GetCardinalityResponse>()
                            .withOperationName("GetCardinality")
                            .withMarshaller(new GetCardinalityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getCardinalityRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the AWS IoT device gateway.
     * </p>
     *
     * @param getEffectivePoliciesRequest
     * @return A Java Future containing the result of the GetEffectivePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetEffectivePolicies
     */
    @Override
    public CompletableFuture<GetEffectivePoliciesResponse> getEffectivePolicies(
            GetEffectivePoliciesRequest getEffectivePoliciesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEffectivePoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEffectivePoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEffectivePoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEffectivePoliciesRequest, GetEffectivePoliciesResponse>()
                            .withOperationName("GetEffectivePolicies")
                            .withMarshaller(new GetEffectivePoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getEffectivePoliciesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     *
     * @param getIndexingConfigurationRequest
     * @return A Java Future containing the result of the GetIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetIndexingConfiguration
     */
    @Override
    public CompletableFuture<GetIndexingConfigurationResponse> getIndexingConfiguration(
            GetIndexingConfigurationRequest getIndexingConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIndexingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIndexingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIndexingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIndexingConfigurationRequest, GetIndexingConfigurationResponse>()
                            .withOperationName("GetIndexingConfiguration")
                            .withMarshaller(new GetIndexingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getIndexingConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     *
     * @param getJobDocumentRequest
     * @return A Java Future containing the result of the GetJobDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetJobDocument
     */
    @Override
    public CompletableFuture<GetJobDocumentResponse> getJobDocument(GetJobDocumentRequest getJobDocumentRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetJobDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetJobDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetJobDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetJobDocumentRequest, GetJobDocumentResponse>()
                            .withOperationName("GetJobDocument")
                            .withMarshaller(new GetJobDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getJobDocumentRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetLoggingOptions
     */
    @Override
    public CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoggingOptionsRequest, GetLoggingOptionsResponse>()
                            .withOperationName("GetLoggingOptions")
                            .withMarshaller(new GetLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getLoggingOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     *
     * @param getOtaUpdateRequest
     * @return A Java Future containing the result of the GetOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetOTAUpdate
     */
    @Override
    public CompletableFuture<GetOtaUpdateResponse> getOTAUpdate(GetOtaUpdateRequest getOtaUpdateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOtaUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOtaUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOtaUpdateRequest, GetOtaUpdateResponse>()
                            .withOperationName("GetOTAUpdate").withMarshaller(new GetOtaUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOtaUpdateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     *
     * @param getPercentilesRequest
     * @return A Java Future containing the result of the GetPercentiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPercentiles
     */
    @Override
    public CompletableFuture<GetPercentilesResponse> getPercentiles(GetPercentilesRequest getPercentilesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPercentilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPercentilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPercentilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPercentilesRequest, GetPercentilesResponse>()
                            .withOperationName("GetPercentiles")
                            .withMarshaller(new GetPercentilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getPercentilesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     *
     * @param getPolicyRequest
     *        The input for the GetPolicy operation.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicy
     */
    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>().withOperationName("GetPolicy")
                            .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     *
     * @param getPolicyVersionRequest
     *        The input for the GetPolicyVersion operation.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicyVersion
     */
    @Override
    public CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPolicyVersionRequest, GetPolicyVersionResponse>()
                            .withOperationName("GetPolicyVersion")
                            .withMarshaller(new GetPolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getPolicyVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetRegistrationCode
     */
    @Override
    public CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode(
            GetRegistrationCodeRequest getRegistrationCodeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRegistrationCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRegistrationCodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRegistrationCodeRequest, GetRegistrationCodeResponse>()
                            .withOperationName("GetRegistrationCode")
                            .withMarshaller(new GetRegistrationCodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRegistrationCodeRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     *
     * @param getStatisticsRequest
     * @return A Java Future containing the result of the GetStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetStatistics
     */
    @Override
    public CompletableFuture<GetStatisticsResponse> getStatistics(GetStatisticsRequest getStatisticsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStatisticsRequest, GetStatisticsResponse>()
                            .withOperationName("GetStatistics")
                            .withMarshaller(new GetStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getStatisticsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     *
     * @param getTopicRuleRequest
     *        The input for the GetTopicRule operation.
     * @return A Java Future containing the result of the GetTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRule
     */
    @Override
    public CompletableFuture<GetTopicRuleResponse> getTopicRule(GetTopicRuleRequest getTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTopicRuleRequest, GetTopicRuleResponse>()
                            .withOperationName("GetTopicRule").withMarshaller(new GetTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     * @return A Java Future containing the result of the GetTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRuleDestination
     */
    @Override
    public CompletableFuture<GetTopicRuleDestinationResponse> getTopicRuleDestination(
            GetTopicRuleDestinationRequest getTopicRuleDestinationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTopicRuleDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTopicRuleDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTopicRuleDestinationRequest, GetTopicRuleDestinationResponse>()
                            .withOperationName("GetTopicRuleDestination")
                            .withMarshaller(new GetTopicRuleDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getTopicRuleDestinationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     * @return A Java Future containing the result of the GetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetV2LoggingOptions
     */
    @Override
    public CompletableFuture<GetV2LoggingOptionsResponse> getV2LoggingOptions(
            GetV2LoggingOptionsRequest getV2LoggingOptionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetV2LoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetV2LoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetV2LoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetV2LoggingOptionsRequest, GetV2LoggingOptionsResponse>()
                            .withOperationName("GetV2LoggingOptions")
                            .withMarshaller(new GetV2LoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getV2LoggingOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     *
     * @param listActiveViolationsRequest
     * @return A Java Future containing the result of the ListActiveViolations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListActiveViolations
     */
    @Override
    public CompletableFuture<ListActiveViolationsResponse> listActiveViolations(
            ListActiveViolationsRequest listActiveViolationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListActiveViolationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListActiveViolationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListActiveViolationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListActiveViolationsRequest, ListActiveViolationsResponse>()
                            .withOperationName("ListActiveViolations")
                            .withMarshaller(new ListActiveViolationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listActiveViolationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     *
     * @param listAttachedPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAttachedPolicies
     */
    @Override
    public CompletableFuture<ListAttachedPoliciesResponse> listAttachedPolicies(
            ListAttachedPoliciesRequest listAttachedPoliciesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAttachedPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAttachedPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAttachedPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAttachedPoliciesRequest, ListAttachedPoliciesResponse>()
                            .withOperationName("ListAttachedPolicies")
                            .withMarshaller(new ListAttachedPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAttachedPoliciesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 180 days.)
     * </p>
     *
     * @param listAuditFindingsRequest
     * @return A Java Future containing the result of the ListAuditFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditFindings
     */
    @Override
    public CompletableFuture<ListAuditFindingsResponse> listAuditFindings(ListAuditFindingsRequest listAuditFindingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAuditFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAuditFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAuditFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAuditFindingsRequest, ListAuditFindingsResponse>()
                            .withOperationName("ListAuditFindings")
                            .withMarshaller(new ListAuditFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAuditFindingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     * @return A Java Future containing the result of the ListAuditMitigationActionsExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsExecutions
     */
    @Override
    public CompletableFuture<ListAuditMitigationActionsExecutionsResponse> listAuditMitigationActionsExecutions(
            ListAuditMitigationActionsExecutionsRequest listAuditMitigationActionsExecutionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAuditMitigationActionsExecutionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListAuditMitigationActionsExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAuditMitigationActionsExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAuditMitigationActionsExecutionsRequest, ListAuditMitigationActionsExecutionsResponse>()
                            .withOperationName("ListAuditMitigationActionsExecutions")
                            .withMarshaller(new ListAuditMitigationActionsExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAuditMitigationActionsExecutionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     * @return A Java Future containing the result of the ListAuditMitigationActionsTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsTasks
     */
    @Override
    public CompletableFuture<ListAuditMitigationActionsTasksResponse> listAuditMitigationActionsTasks(
            ListAuditMitigationActionsTasksRequest listAuditMitigationActionsTasksRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAuditMitigationActionsTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAuditMitigationActionsTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAuditMitigationActionsTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAuditMitigationActionsTasksRequest, ListAuditMitigationActionsTasksResponse>()
                            .withOperationName("ListAuditMitigationActionsTasks")
                            .withMarshaller(new ListAuditMitigationActionsTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAuditMitigationActionsTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     *
     * @param listAuditTasksRequest
     * @return A Java Future containing the result of the ListAuditTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditTasks
     */
    @Override
    public CompletableFuture<ListAuditTasksResponse> listAuditTasks(ListAuditTasksRequest listAuditTasksRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAuditTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAuditTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAuditTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAuditTasksRequest, ListAuditTasksResponse>()
                            .withOperationName("ListAuditTasks")
                            .withMarshaller(new ListAuditTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAuditTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     *
     * @param listAuthorizersRequest
     * @return A Java Future containing the result of the ListAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuthorizers
     */
    @Override
    public CompletableFuture<ListAuthorizersResponse> listAuthorizers(ListAuthorizersRequest listAuthorizersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAuthorizersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAuthorizersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAuthorizersRequest, ListAuthorizersResponse>()
                            .withOperationName("ListAuthorizers")
                            .withMarshaller(new ListAuthorizersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAuthorizersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListBillingGroups
     */
    @Override
    public CompletableFuture<ListBillingGroupsResponse> listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBillingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBillingGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBillingGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBillingGroupsRequest, ListBillingGroupsResponse>()
                            .withOperationName("ListBillingGroups")
                            .withMarshaller(new ListBillingGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBillingGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @param listCaCertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCACertificates
     */
    @Override
    public CompletableFuture<ListCaCertificatesResponse> listCACertificates(ListCaCertificatesRequest listCaCertificatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCaCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCaCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCaCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCaCertificatesRequest, ListCaCertificatesResponse>()
                            .withOperationName("ListCACertificates")
                            .withMarshaller(new ListCaCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCaCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificates
     */
    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                            .withOperationName("ListCertificates")
                            .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        The input to the ListCertificatesByCA operation.
     * @return A Java Future containing the result of the ListCertificatesByCA operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificatesByCA
     */
    @Override
    public CompletableFuture<ListCertificatesByCaResponse> listCertificatesByCA(
            ListCertificatesByCaRequest listCertificatesByCaRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCertificatesByCaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCertificatesByCaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCertificatesByCaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCertificatesByCaRequest, ListCertificatesByCaResponse>()
                            .withOperationName("ListCertificatesByCA")
                            .withMarshaller(new ListCertificatesByCaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCertificatesByCaRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param listDomainConfigurationsRequest
     * @return A Java Future containing the result of the ListDomainConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListDomainConfigurations
     */
    @Override
    public CompletableFuture<ListDomainConfigurationsResponse> listDomainConfigurations(
            ListDomainConfigurationsRequest listDomainConfigurationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDomainConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainConfigurationsRequest, ListDomainConfigurationsResponse>()
                            .withOperationName("ListDomainConfigurations")
                            .withMarshaller(new ListDomainConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listDomainConfigurationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListIndices
     */
    @Override
    public CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIndicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIndicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIndicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIndicesRequest, ListIndicesResponse>()
                            .withOperationName("ListIndices").withMarshaller(new ListIndicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listIndicesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     * @return A Java Future containing the result of the ListJobExecutionsForJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForJob
     */
    @Override
    public CompletableFuture<ListJobExecutionsForJobResponse> listJobExecutionsForJob(
            ListJobExecutionsForJobRequest listJobExecutionsForJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJobExecutionsForJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListJobExecutionsForJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListJobExecutionsForJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobExecutionsForJobRequest, ListJobExecutionsForJobResponse>()
                            .withOperationName("ListJobExecutionsForJob")
                            .withMarshaller(new ListJobExecutionsForJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listJobExecutionsForJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the job executions for the specified thing.
     * </p>
     *
     * @param listJobExecutionsForThingRequest
     * @return A Java Future containing the result of the ListJobExecutionsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForThing
     */
    @Override
    public CompletableFuture<ListJobExecutionsForThingResponse> listJobExecutionsForThing(
            ListJobExecutionsForThingRequest listJobExecutionsForThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJobExecutionsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListJobExecutionsForThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListJobExecutionsForThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobExecutionsForThingRequest, ListJobExecutionsForThingResponse>()
                            .withOperationName("ListJobExecutionsForThing")
                            .withMarshaller(new ListJobExecutionsForThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listJobExecutionsForThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobs
     */
    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>().withOperationName("ListJobs")
                            .withMarshaller(new ListJobsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listJobsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * </p>
     *
     * @param listMitigationActionsRequest
     * @return A Java Future containing the result of the ListMitigationActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListMitigationActions
     */
    @Override
    public CompletableFuture<ListMitigationActionsResponse> listMitigationActions(
            ListMitigationActionsRequest listMitigationActionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMitigationActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMitigationActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMitigationActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMitigationActionsRequest, ListMitigationActionsResponse>()
                            .withOperationName("ListMitigationActions")
                            .withMarshaller(new ListMitigationActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listMitigationActionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists OTA updates.
     * </p>
     *
     * @param listOtaUpdatesRequest
     * @return A Java Future containing the result of the ListOTAUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOTAUpdates
     */
    @Override
    public CompletableFuture<ListOtaUpdatesResponse> listOTAUpdates(ListOtaUpdatesRequest listOtaUpdatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOtaUpdatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOtaUpdatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOtaUpdatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOtaUpdatesRequest, ListOtaUpdatesResponse>()
                            .withOperationName("ListOTAUpdates")
                            .withMarshaller(new ListOtaUpdatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listOtaUpdatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists certificates that are being transferred but not yet accepted.
     * </p>
     *
     * @param listOutgoingCertificatesRequest
     *        The input to the ListOutgoingCertificates operation.
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOutgoingCertificates
     */
    @Override
    public CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates(
            ListOutgoingCertificatesRequest listOutgoingCertificatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOutgoingCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOutgoingCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOutgoingCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOutgoingCertificatesRequest, ListOutgoingCertificatesResponse>()
                            .withOperationName("ListOutgoingCertificates")
                            .withMarshaller(new ListOutgoingCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listOutgoingCertificatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     *
     * @param listPoliciesRequest
     *        The input for the ListPolicies operation.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicies
     */
    @Override
    public CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListPoliciesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPoliciesRequest, ListPoliciesResponse>()
                            .withOperationName("ListPolicies").withMarshaller(new ListPoliciesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPoliciesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the versions of the specified policy and identifies the default version.
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        The input for the ListPolicyVersions operation.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicyVersions
     */
    @Override
    public CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPolicyVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPolicyVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPolicyVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPolicyVersionsRequest, ListPolicyVersionsResponse>()
                            .withOperationName("ListPolicyVersions")
                            .withMarshaller(new ListPolicyVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPolicyVersionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param listPrincipalThingsRequest
     *        The input for the ListPrincipalThings operation.
     * @return A Java Future containing the result of the ListPrincipalThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPrincipalThings
     */
    @Override
    public CompletableFuture<ListPrincipalThingsResponse> listPrincipalThings(
            ListPrincipalThingsRequest listPrincipalThingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPrincipalThingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPrincipalThingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPrincipalThingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPrincipalThingsRequest, ListPrincipalThingsResponse>()
                            .withOperationName("ListPrincipalThings")
                            .withMarshaller(new ListPrincipalThingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPrincipalThingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A list of fleet provisioning template versions.
     * </p>
     *
     * @param listProvisioningTemplateVersionsRequest
     * @return A Java Future containing the result of the ListProvisioningTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplateVersions
     */
    @Override
    public CompletableFuture<ListProvisioningTemplateVersionsResponse> listProvisioningTemplateVersions(
            ListProvisioningTemplateVersionsRequest listProvisioningTemplateVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProvisioningTemplateVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListProvisioningTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProvisioningTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningTemplateVersionsRequest, ListProvisioningTemplateVersionsResponse>()
                            .withOperationName("ListProvisioningTemplateVersions")
                            .withMarshaller(new ListProvisioningTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listProvisioningTemplateVersionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the fleet provisioning templates in your AWS account.
     * </p>
     *
     * @param listProvisioningTemplatesRequest
     * @return A Java Future containing the result of the ListProvisioningTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplates
     */
    @Override
    public CompletableFuture<ListProvisioningTemplatesResponse> listProvisioningTemplates(
            ListProvisioningTemplatesRequest listProvisioningTemplatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProvisioningTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProvisioningTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProvisioningTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningTemplatesRequest, ListProvisioningTemplatesResponse>()
                            .withOperationName("ListProvisioningTemplates")
                            .withMarshaller(new ListProvisioningTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listProvisioningTemplatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the role aliases registered in your account.
     * </p>
     *
     * @param listRoleAliasesRequest
     * @return A Java Future containing the result of the ListRoleAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListRoleAliases
     */
    @Override
    public CompletableFuture<ListRoleAliasesResponse> listRoleAliases(ListRoleAliasesRequest listRoleAliasesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRoleAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRoleAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRoleAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRoleAliasesRequest, ListRoleAliasesResponse>()
                            .withOperationName("ListRoleAliases")
                            .withMarshaller(new ListRoleAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listRoleAliasesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of your scheduled audits.
     * </p>
     *
     * @param listScheduledAuditsRequest
     * @return A Java Future containing the result of the ListScheduledAudits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListScheduledAudits
     */
    @Override
    public CompletableFuture<ListScheduledAuditsResponse> listScheduledAudits(
            ListScheduledAuditsRequest listScheduledAuditsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListScheduledAuditsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListScheduledAuditsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListScheduledAuditsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListScheduledAuditsRequest, ListScheduledAuditsResponse>()
                            .withOperationName("ListScheduledAudits")
                            .withMarshaller(new ListScheduledAuditsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listScheduledAuditsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profiles you have created. You can use filters to list only those security
     * profiles associated with a thing group or only those associated with your account.
     * </p>
     *
     * @param listSecurityProfilesRequest
     * @return A Java Future containing the result of the ListSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfiles
     */
    @Override
    public CompletableFuture<ListSecurityProfilesResponse> listSecurityProfiles(
            ListSecurityProfilesRequest listSecurityProfilesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSecurityProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSecurityProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSecurityProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSecurityProfilesRequest, ListSecurityProfilesResponse>()
                            .withOperationName("ListSecurityProfiles")
                            .withMarshaller(new ListSecurityProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSecurityProfilesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profiles attached to a target (thing group).
     * </p>
     *
     * @param listSecurityProfilesForTargetRequest
     * @return A Java Future containing the result of the ListSecurityProfilesForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfilesForTarget
     */
    @Override
    public CompletableFuture<ListSecurityProfilesForTargetResponse> listSecurityProfilesForTarget(
            ListSecurityProfilesForTargetRequest listSecurityProfilesForTargetRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSecurityProfilesForTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSecurityProfilesForTargetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSecurityProfilesForTargetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSecurityProfilesForTargetRequest, ListSecurityProfilesForTargetResponse>()
                            .withOperationName("ListSecurityProfilesForTarget")
                            .withMarshaller(new ListSecurityProfilesForTargetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSecurityProfilesForTargetRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the streams in your AWS account.
     * </p>
     *
     * @param listStreamsRequest
     * @return A Java Future containing the result of the ListStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListStreams
     */
    @Override
    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListStreamsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListStreamsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListStreamsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStreamsRequest, ListStreamsResponse>()
                            .withOperationName("ListStreams").withMarshaller(new ListStreamsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listStreamsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTagsForResource
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTagsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List targets for the specified policy.
     * </p>
     *
     * @param listTargetsForPolicyRequest
     * @return A Java Future containing the result of the ListTargetsForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForPolicy
     */
    @Override
    public CompletableFuture<ListTargetsForPolicyResponse> listTargetsForPolicy(
            ListTargetsForPolicyRequest listTargetsForPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTargetsForPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTargetsForPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTargetsForPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTargetsForPolicyRequest, ListTargetsForPolicyResponse>()
                            .withOperationName("ListTargetsForPolicy")
                            .withMarshaller(new ListTargetsForPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTargetsForPolicyRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * </p>
     *
     * @param listTargetsForSecurityProfileRequest
     * @return A Java Future containing the result of the ListTargetsForSecurityProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForSecurityProfile
     */
    @Override
    public CompletableFuture<ListTargetsForSecurityProfileResponse> listTargetsForSecurityProfile(
            ListTargetsForSecurityProfileRequest listTargetsForSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTargetsForSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTargetsForSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTargetsForSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTargetsForSecurityProfileRequest, ListTargetsForSecurityProfileResponse>()
                            .withOperationName("ListTargetsForSecurityProfile")
                            .withMarshaller(new ListTargetsForSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTargetsForSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the thing groups in your account.
     * </p>
     *
     * @param listThingGroupsRequest
     * @return A Java Future containing the result of the ListThingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroups
     */
    @Override
    public CompletableFuture<ListThingGroupsResponse> listThingGroups(ListThingGroupsRequest listThingGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingGroupsRequest, ListThingGroupsResponse>()
                            .withOperationName("ListThingGroups")
                            .withMarshaller(new ListThingGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the thing groups to which the specified thing belongs.
     * </p>
     *
     * @param listThingGroupsForThingRequest
     * @return A Java Future containing the result of the ListThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroupsForThing
     */
    @Override
    public CompletableFuture<ListThingGroupsForThingResponse> listThingGroupsForThing(
            ListThingGroupsForThingRequest listThingGroupsForThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingGroupsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingGroupsForThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingGroupsForThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingGroupsForThingRequest, ListThingGroupsForThingResponse>()
                            .withOperationName("ListThingGroupsForThing")
                            .withMarshaller(new ListThingGroupsForThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingGroupsForThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param listThingPrincipalsRequest
     *        The input for the ListThingPrincipal operation.
     * @return A Java Future containing the result of the ListThingPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingPrincipals
     */
    @Override
    public CompletableFuture<ListThingPrincipalsResponse> listThingPrincipals(
            ListThingPrincipalsRequest listThingPrincipalsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingPrincipalsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingPrincipalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingPrincipalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingPrincipalsRequest, ListThingPrincipalsResponse>()
                            .withOperationName("ListThingPrincipals")
                            .withMarshaller(new ListThingPrincipalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingPrincipalsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Information about the thing registration tasks.
     * </p>
     *
     * @param listThingRegistrationTaskReportsRequest
     * @return A Java Future containing the result of the ListThingRegistrationTaskReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTaskReports
     */
    @Override
    public CompletableFuture<ListThingRegistrationTaskReportsResponse> listThingRegistrationTaskReports(
            ListThingRegistrationTaskReportsRequest listThingRegistrationTaskReportsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingRegistrationTaskReportsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListThingRegistrationTaskReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingRegistrationTaskReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingRegistrationTaskReportsRequest, ListThingRegistrationTaskReportsResponse>()
                            .withOperationName("ListThingRegistrationTaskReports")
                            .withMarshaller(new ListThingRegistrationTaskReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingRegistrationTaskReportsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List bulk thing provisioning tasks.
     * </p>
     *
     * @param listThingRegistrationTasksRequest
     * @return A Java Future containing the result of the ListThingRegistrationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTasks
     */
    @Override
    public CompletableFuture<ListThingRegistrationTasksResponse> listThingRegistrationTasks(
            ListThingRegistrationTasksRequest listThingRegistrationTasksRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingRegistrationTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingRegistrationTasksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingRegistrationTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingRegistrationTasksRequest, ListThingRegistrationTasksResponse>()
                            .withOperationName("ListThingRegistrationTasks")
                            .withMarshaller(new ListThingRegistrationTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingRegistrationTasksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     *
     * @param listThingTypesRequest
     *        The input for the ListThingTypes operation.
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingTypes
     */
    @Override
    public CompletableFuture<ListThingTypesResponse> listThingTypes(ListThingTypesRequest listThingTypesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingTypesRequest, ListThingTypesResponse>()
                            .withOperationName("ListThingTypes")
                            .withMarshaller(new ListThingTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingTypesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     *
     * @param listThingsRequest
     *        The input for the ListThings operation.
     * @return A Java Future containing the result of the ListThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThings
     */
    @Override
    public CompletableFuture<ListThingsResponse> listThings(ListThingsRequest listThingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListThingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingsRequest, ListThingsResponse>().withOperationName("ListThings")
                            .withMarshaller(new ListThingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the things you have added to the given billing group.
     * </p>
     *
     * @param listThingsInBillingGroupRequest
     * @return A Java Future containing the result of the ListThingsInBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInBillingGroup
     */
    @Override
    public CompletableFuture<ListThingsInBillingGroupResponse> listThingsInBillingGroup(
            ListThingsInBillingGroupRequest listThingsInBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingsInBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingsInBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingsInBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingsInBillingGroupRequest, ListThingsInBillingGroupResponse>()
                            .withOperationName("ListThingsInBillingGroup")
                            .withMarshaller(new ListThingsInBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingsInBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the things in the specified group.
     * </p>
     *
     * @param listThingsInThingGroupRequest
     * @return A Java Future containing the result of the ListThingsInThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInThingGroup
     */
    @Override
    public CompletableFuture<ListThingsInThingGroupResponse> listThingsInThingGroup(
            ListThingsInThingGroupRequest listThingsInThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThingsInThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThingsInThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThingsInThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThingsInThingGroupRequest, ListThingsInThingGroupResponse>()
                            .withOperationName("ListThingsInThingGroup")
                            .withMarshaller(new ListThingsInThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThingsInThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the topic rule destinations in your AWS account.
     * </p>
     *
     * @param listTopicRuleDestinationsRequest
     * @return A Java Future containing the result of the ListTopicRuleDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRuleDestinations
     */
    @Override
    public CompletableFuture<ListTopicRuleDestinationsResponse> listTopicRuleDestinations(
            ListTopicRuleDestinationsRequest listTopicRuleDestinationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTopicRuleDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTopicRuleDestinationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTopicRuleDestinationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTopicRuleDestinationsRequest, ListTopicRuleDestinationsResponse>()
                            .withOperationName("ListTopicRuleDestinations")
                            .withMarshaller(new ListTopicRuleDestinationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTopicRuleDestinationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     *
     * @param listTopicRulesRequest
     *        The input for the ListTopicRules operation.
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRules
     */
    @Override
    public CompletableFuture<ListTopicRulesResponse> listTopicRules(ListTopicRulesRequest listTopicRulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTopicRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTopicRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTopicRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTopicRulesRequest, ListTopicRulesResponse>()
                            .withOperationName("ListTopicRules")
                            .withMarshaller(new ListTopicRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTopicRulesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists logging levels.
     * </p>
     *
     * @param listV2LoggingLevelsRequest
     * @return A Java Future containing the result of the ListV2LoggingLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListV2LoggingLevels
     */
    @Override
    public CompletableFuture<ListV2LoggingLevelsResponse> listV2LoggingLevels(
            ListV2LoggingLevelsRequest listV2LoggingLevelsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListV2LoggingLevelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListV2LoggingLevelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListV2LoggingLevelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListV2LoggingLevelsRequest, ListV2LoggingLevelsResponse>()
                            .withOperationName("ListV2LoggingLevels")
                            .withMarshaller(new ListV2LoggingLevelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listV2LoggingLevelsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profile violations discovered during the given time period. You can use
     * filters to limit the results to those alerts issued for a particular security profile, behavior, or thing
     * (device).
     * </p>
     *
     * @param listViolationEventsRequest
     * @return A Java Future containing the result of the ListViolationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListViolationEvents
     */
    @Override
    public CompletableFuture<ListViolationEventsResponse> listViolationEvents(
            ListViolationEventsRequest listViolationEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListViolationEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListViolationEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListViolationEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListViolationEventsRequest, ListViolationEventsResponse>()
                            .withOperationName("ListViolationEvents")
                            .withMarshaller(new ListViolationEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listViolationEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which
     * can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same
     * subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you
     * have more than one CA certificate registered, make sure you pass the CA certificate when you register your device
     * certificates with the RegisterCertificate API.
     * </p>
     *
     * @param registerCaCertificateRequest
     *        The input to the RegisterCACertificate operation.
     * @return A Java Future containing the result of the RegisterCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>RegistrationCodeValidationException The registration code is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCACertificate
     */
    @Override
    public CompletableFuture<RegisterCaCertificateResponse> registerCACertificate(
            RegisterCaCertificateRequest registerCaCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterCaCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterCaCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterCaCertificateRequest, RegisterCaCertificateResponse>()
                            .withOperationName("RegisterCACertificate")
                            .withMarshaller(new RegisterCaCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerCaCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject
     * field, you must specify the CA certificate that was used to sign the device certificate being registered.
     * </p>
     *
     * @param registerCertificateRequest
     *        The input to the RegisterCertificate operation.
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateConflictException Unable to verify the CA certificate used to sign the device certificate
     *         you are attempting to register. This is happens when you have registered more than one CA certificate
     *         that has the same subject field and public key.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCertificate
     */
    @Override
    public CompletableFuture<RegisterCertificateResponse> registerCertificate(
            RegisterCertificateRequest registerCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterCertificateRequest, RegisterCertificateResponse>()
                            .withOperationName("RegisterCertificate")
                            .withMarshaller(new RegisterCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provisions a thing in the device registry. RegisterThing calls other AWS IoT control plane APIs. These calls
     * might exceed your account level <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> AWS IoT Throttling
     * Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">AWS
     * Customer Support</a> to raise your throttling limits if necessary.
     * </p>
     *
     * @param registerThingRequest
     * @return A Java Future containing the result of the RegisterThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>ResourceRegistrationFailureException The resource registration failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterThing
     */
    @Override
    public CompletableFuture<RegisterThingResponse> registerThing(RegisterThingRequest registerThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RegisterThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterThingRequest, RegisterThingResponse>()
                            .withOperationName("RegisterThing")
                            .withMarshaller(new RegisterThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status
     * changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * This operation can only be called by the transfer destination. After it is called, the certificate will be
     * returned to the source's account in the INACTIVE state.
     * </p>
     *
     * @param rejectCertificateTransferRequest
     *        The input for the RejectCertificateTransfer operation.
     * @return A Java Future containing the result of the RejectCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RejectCertificateTransfer
     */
    @Override
    public CompletableFuture<RejectCertificateTransferResponse> rejectCertificateTransfer(
            RejectCertificateTransferRequest rejectCertificateTransferRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RejectCertificateTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectCertificateTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectCertificateTransferRequest, RejectCertificateTransferResponse>()
                            .withOperationName("RejectCertificateTransfer")
                            .withMarshaller(new RejectCertificateTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(rejectCertificateTransferRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the given thing from the billing group.
     * </p>
     *
     * @param removeThingFromBillingGroupRequest
     * @return A Java Future containing the result of the RemoveThingFromBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromBillingGroup
     */
    @Override
    public CompletableFuture<RemoveThingFromBillingGroupResponse> removeThingFromBillingGroup(
            RemoveThingFromBillingGroupRequest removeThingFromBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveThingFromBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveThingFromBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveThingFromBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveThingFromBillingGroupRequest, RemoveThingFromBillingGroupResponse>()
                            .withOperationName("RemoveThingFromBillingGroup")
                            .withMarshaller(new RemoveThingFromBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeThingFromBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove the specified thing from the specified group.
     * </p>
     *
     * @param removeThingFromThingGroupRequest
     * @return A Java Future containing the result of the RemoveThingFromThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromThingGroup
     */
    @Override
    public CompletableFuture<RemoveThingFromThingGroupResponse> removeThingFromThingGroup(
            RemoveThingFromThingGroupRequest removeThingFromThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveThingFromThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveThingFromThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveThingFromThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveThingFromThingGroupRequest, RemoveThingFromThingGroupResponse>()
                            .withOperationName("RemoveThingFromThingGroup")
                            .withMarshaller(new RemoveThingFromThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeThingFromThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level
     * action. Any user who has permission to create rules will be able to access data processed by the rule.
     * </p>
     *
     * @param replaceTopicRuleRequest
     *        The input for the ReplaceTopicRule operation.
     * @return A Java Future containing the result of the ReplaceTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ReplaceTopicRule
     */
    @Override
    public CompletableFuture<ReplaceTopicRuleResponse> replaceTopicRule(ReplaceTopicRuleRequest replaceTopicRuleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ReplaceTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ReplaceTopicRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReplaceTopicRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ReplaceTopicRuleRequest, ReplaceTopicRuleResponse>()
                            .withOperationName("ReplaceTopicRule")
                            .withMarshaller(new ReplaceTopicRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(replaceTopicRuleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The query search index.
     * </p>
     *
     * @param searchIndexRequest
     * @return A Java Future containing the result of the SearchIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SearchIndex
     */
    @Override
    public CompletableFuture<SearchIndexResponse> searchIndex(SearchIndexRequest searchIndexRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchIndexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchIndexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchIndexRequest, SearchIndexResponse>()
                            .withOperationName("SearchIndex").withMarshaller(new SearchIndexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchIndexRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an
     * authorizer.
     * </p>
     *
     * @param setDefaultAuthorizerRequest
     * @return A Java Future containing the result of the SetDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultAuthorizer
     */
    @Override
    public CompletableFuture<SetDefaultAuthorizerResponse> setDefaultAuthorizer(
            SetDefaultAuthorizerRequest setDefaultAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetDefaultAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetDefaultAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetDefaultAuthorizerRequest, SetDefaultAuthorizerResponse>()
                            .withOperationName("SetDefaultAuthorizer")
                            .withMarshaller(new SetDefaultAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setDefaultAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action
     * affects all certificates to which the policy is attached. To list the principals the policy is attached to, use
     * the ListPrincipalPolicy API.
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     *        The input for the SetDefaultPolicyVersion operation.
     * @return A Java Future containing the result of the SetDefaultPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultPolicyVersion
     */
    @Override
    public CompletableFuture<SetDefaultPolicyVersionResponse> setDefaultPolicyVersion(
            SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetDefaultPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetDefaultPolicyVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetDefaultPolicyVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse>()
                            .withOperationName("SetDefaultPolicyVersion")
                            .withMarshaller(new SetDefaultPolicyVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setDefaultPolicyVersionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>SetV2LoggingOptions</code> instead.
     * </p>
     *
     * @param setLoggingOptionsRequest
     *        The input for the SetLoggingOptions operation.
     * @return A Java Future containing the result of the SetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetLoggingOptions
     */
    @Override
    public CompletableFuture<SetLoggingOptionsResponse> setLoggingOptions(SetLoggingOptionsRequest setLoggingOptionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetLoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetLoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetLoggingOptionsRequest, SetLoggingOptionsResponse>()
                            .withOperationName("SetLoggingOptions")
                            .withMarshaller(new SetLoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setLoggingOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the logging level.
     * </p>
     *
     * @param setV2LoggingLevelRequest
     * @return A Java Future containing the result of the SetV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingLevel
     */
    @Override
    public CompletableFuture<SetV2LoggingLevelResponse> setV2LoggingLevel(SetV2LoggingLevelRequest setV2LoggingLevelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetV2LoggingLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetV2LoggingLevelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetV2LoggingLevelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetV2LoggingLevelRequest, SetV2LoggingLevelResponse>()
                            .withOperationName("SetV2LoggingLevel")
                            .withMarshaller(new SetV2LoggingLevelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setV2LoggingLevelRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the logging options for the V2 logging service.
     * </p>
     *
     * @param setV2LoggingOptionsRequest
     * @return A Java Future containing the result of the SetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingOptions
     */
    @Override
    public CompletableFuture<SetV2LoggingOptionsResponse> setV2LoggingOptions(
            SetV2LoggingOptionsRequest setV2LoggingOptionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetV2LoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetV2LoggingOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetV2LoggingOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetV2LoggingOptionsRequest, SetV2LoggingOptionsResponse>()
                            .withOperationName("SetV2LoggingOptions")
                            .withMarshaller(new SetV2LoggingOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(setV2LoggingOptionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a task that applies a set of mitigation actions to the specified target.
     * </p>
     *
     * @param startAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the StartAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TaskAlreadyExistsException This exception occurs if you attempt to start a task with the same task-id
     *         as an existing task but with a different clientRequestToken.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartAuditMitigationActionsTask
     */
    @Override
    public CompletableFuture<StartAuditMitigationActionsTaskResponse> startAuditMitigationActionsTask(
            StartAuditMitigationActionsTaskRequest startAuditMitigationActionsTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAuditMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAuditMitigationActionsTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartAuditMitigationActionsTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAuditMitigationActionsTaskRequest, StartAuditMitigationActionsTaskResponse>()
                            .withOperationName("StartAuditMitigationActionsTask")
                            .withMarshaller(new StartAuditMitigationActionsTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startAuditMitigationActionsTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an on-demand Device Defender audit.
     * </p>
     *
     * @param startOnDemandAuditTaskRequest
     * @return A Java Future containing the result of the StartOnDemandAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartOnDemandAuditTask
     */
    @Override
    public CompletableFuture<StartOnDemandAuditTaskResponse> startOnDemandAuditTask(
            StartOnDemandAuditTaskRequest startOnDemandAuditTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartOnDemandAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartOnDemandAuditTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartOnDemandAuditTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartOnDemandAuditTaskRequest, StartOnDemandAuditTaskResponse>()
                            .withOperationName("StartOnDemandAuditTask")
                            .withMarshaller(new StartOnDemandAuditTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startOnDemandAuditTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a bulk thing provisioning task.
     * </p>
     *
     * @param startThingRegistrationTaskRequest
     * @return A Java Future containing the result of the StartThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartThingRegistrationTask
     */
    @Override
    public CompletableFuture<StartThingRegistrationTaskResponse> startThingRegistrationTask(
            StartThingRegistrationTaskRequest startThingRegistrationTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartThingRegistrationTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartThingRegistrationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartThingRegistrationTaskRequest, StartThingRegistrationTaskResponse>()
                            .withOperationName("StartThingRegistrationTask")
                            .withMarshaller(new StartThingRegistrationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startThingRegistrationTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a bulk thing provisioning task.
     * </p>
     *
     * @param stopThingRegistrationTaskRequest
     * @return A Java Future containing the result of the StopThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StopThingRegistrationTask
     */
    @Override
    public CompletableFuture<StopThingRegistrationTaskResponse> stopThingRegistrationTask(
            StopThingRegistrationTaskRequest stopThingRegistrationTaskRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopThingRegistrationTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopThingRegistrationTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopThingRegistrationTaskRequest, StopThingRegistrationTaskResponse>()
                            .withOperationName("StopThingRegistrationTask")
                            .withMarshaller(new StopThingRegistrationTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(stopThingRegistrationTaskRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TagResource
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests if a specified principal is authorized to perform an AWS IoT action on a specified resource. Use this to
     * test and debug the authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     *
     * @param testAuthorizationRequest
     * @return A Java Future containing the result of the TestAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestAuthorization
     */
    @Override
    public CompletableFuture<TestAuthorizationResponse> testAuthorization(TestAuthorizationRequest testAuthorizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestAuthorizationRequest, TestAuthorizationResponse>()
                            .withOperationName("TestAuthorization")
                            .withMarshaller(new TestAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(testAuthorizationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the
     * custom authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidResponseException The response is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestInvokeAuthorizer
     */
    @Override
    public CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestInvokeAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestInvokeAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                            .withOperationName("TestInvokeAuthorizer")
                            .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(testInvokeAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Transfers the specified certificate to the specified AWS account.
     * </p>
     * <p>
     * You can cancel the transfer until it is acknowledged by the recipient.
     * </p>
     * <p>
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer
     * target.
     * </p>
     * <p>
     * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to
     * deactivate it.
     * </p>
     * <p>
     * The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach
     * them.
     * </p>
     *
     * @param transferCertificateRequest
     *        The input for the TransferCertificate operation.
     * @return A Java Future containing the result of the TransferCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>TransferConflictException You can't transfer the certificate because authorization policies are still
     *         attached.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TransferCertificate
     */
    @Override
    public CompletableFuture<TransferCertificateResponse> transferCertificate(
            TransferCertificateRequest transferCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TransferCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TransferCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TransferCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TransferCertificateRequest, TransferCertificateResponse>()
                            .withOperationName("TransferCertificate")
                            .withMarshaller(new TransferCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(transferCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UntagResource
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     *
     * @param updateAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the UpdateAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAccountAuditConfiguration
     */
    @Override
    public CompletableFuture<UpdateAccountAuditConfigurationResponse> updateAccountAuditConfiguration(
            UpdateAccountAuditConfigurationRequest updateAccountAuditConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAccountAuditConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountAuditConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountAuditConfigurationRequest, UpdateAccountAuditConfigurationResponse>()
                            .withOperationName("UpdateAccountAuditConfiguration")
                            .withMarshaller(new UpdateAccountAuditConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateAccountAuditConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an authorizer.
     * </p>
     *
     * @param updateAuthorizerRequest
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAuthorizer
     */
    @Override
    public CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAuthorizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAuthorizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                            .withOperationName("UpdateAuthorizer")
                            .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateAuthorizerRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateBillingGroup
     */
    @Override
    public CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBillingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBillingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBillingGroupRequest, UpdateBillingGroupResponse>()
                            .withOperationName("UpdateBillingGroup")
                            .withMarshaller(new UpdateBillingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateBillingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a registered CA certificate.
     * </p>
     *
     * @param updateCaCertificateRequest
     *        The input to the UpdateCACertificate operation.
     * @return A Java Future containing the result of the UpdateCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCACertificate
     */
    @Override
    public CompletableFuture<UpdateCACertificateResponse> updateCACertificate(
            UpdateCaCertificateRequest updateCaCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCACertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCACertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCACertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCaCertificateRequest, UpdateCACertificateResponse>()
                            .withOperationName("UpdateCACertificate")
                            .withMarshaller(new UpdateCaCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateCaCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of the specified certificate. This operation is idempotent.
     * </p>
     * <p>
     * Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices,
     * but these devices will be unable to reconnect.
     * </p>
     * <p>
     * The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.
     * </p>
     *
     * @param updateCertificateRequest
     *        The input for the UpdateCertificate operation.
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCertificate
     */
    @Override
    public CompletableFuture<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest updateCertificateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCertificateRequest, UpdateCertificateResponse>()
                            .withOperationName("UpdateCertificate")
                            .withMarshaller(new UpdateCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateCertificateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param updateDomainConfigurationRequest
     * @return A Java Future containing the result of the UpdateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDomainConfiguration
     */
    @Override
    public CompletableFuture<UpdateDomainConfigurationResponse> updateDomainConfiguration(
            UpdateDomainConfigurationRequest updateDomainConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDomainConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDomainConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainConfigurationRequest, UpdateDomainConfigurationResponse>()
                            .withOperationName("UpdateDomainConfiguration")
                            .withMarshaller(new UpdateDomainConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDomainConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a dynamic thing group.
     * </p>
     *
     * @param updateDynamicThingGroupRequest
     * @return A Java Future containing the result of the UpdateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDynamicThingGroup
     */
    @Override
    public CompletableFuture<UpdateDynamicThingGroupResponse> updateDynamicThingGroup(
            UpdateDynamicThingGroupRequest updateDynamicThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDynamicThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDynamicThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDynamicThingGroupRequest, UpdateDynamicThingGroupResponse>()
                            .withOperationName("UpdateDynamicThingGroup")
                            .withMarshaller(new UpdateDynamicThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDynamicThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the event configurations.
     * </p>
     *
     * @param updateEventConfigurationsRequest
     * @return A Java Future containing the result of the UpdateEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateEventConfigurations
     */
    @Override
    public CompletableFuture<UpdateEventConfigurationsResponse> updateEventConfigurations(
            UpdateEventConfigurationsRequest updateEventConfigurationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventConfigurationsRequest, UpdateEventConfigurationsResponse>()
                            .withOperationName("UpdateEventConfigurations")
                            .withMarshaller(new UpdateEventConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateEventConfigurationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the search configuration.
     * </p>
     *
     * @param updateIndexingConfigurationRequest
     * @return A Java Future containing the result of the UpdateIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateIndexingConfiguration
     */
    @Override
    public CompletableFuture<UpdateIndexingConfigurationResponse> updateIndexingConfiguration(
            UpdateIndexingConfigurationRequest updateIndexingConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIndexingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIndexingConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIndexingConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIndexingConfigurationRequest, UpdateIndexingConfigurationResponse>()
                            .withOperationName("UpdateIndexingConfiguration")
                            .withMarshaller(new UpdateIndexingConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateIndexingConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates supported fields of the specified job.
     * </p>
     *
     * @param updateJobRequest
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateJob
     */
    @Override
    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateJobRequest, UpdateJobResponse>().withOperationName("UpdateJob")
                            .withMarshaller(new UpdateJobRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateJobRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the definition for the specified mitigation action.
     * </p>
     *
     * @param updateMitigationActionRequest
     * @return A Java Future containing the result of the UpdateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateMitigationAction
     */
    @Override
    public CompletableFuture<UpdateMitigationActionResponse> updateMitigationAction(
            UpdateMitigationActionRequest updateMitigationActionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMitigationActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMitigationActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMitigationActionRequest, UpdateMitigationActionResponse>()
                            .withOperationName("UpdateMitigationAction")
                            .withMarshaller(new UpdateMitigationActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMitigationActionRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a fleet provisioning template.
     * </p>
     *
     * @param updateProvisioningTemplateRequest
     * @return A Java Future containing the result of the UpdateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateProvisioningTemplate
     */
    @Override
    public CompletableFuture<UpdateProvisioningTemplateResponse> updateProvisioningTemplate(
            UpdateProvisioningTemplateRequest updateProvisioningTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateProvisioningTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProvisioningTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisioningTemplateRequest, UpdateProvisioningTemplateResponse>()
                            .withOperationName("UpdateProvisioningTemplate")
                            .withMarshaller(new UpdateProvisioningTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateProvisioningTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a role alias.
     * </p>
     *
     * @param updateRoleAliasRequest
     * @return A Java Future containing the result of the UpdateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateRoleAlias
     */
    @Override
    public CompletableFuture<UpdateRoleAliasResponse> updateRoleAlias(UpdateRoleAliasRequest updateRoleAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRoleAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRoleAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRoleAliasRequest, UpdateRoleAliasResponse>()
                            .withOperationName("UpdateRoleAlias")
                            .withMarshaller(new UpdateRoleAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRoleAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
     * </p>
     *
     * @param updateScheduledAuditRequest
     * @return A Java Future containing the result of the UpdateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateScheduledAudit
     */
    @Override
    public CompletableFuture<UpdateScheduledAuditResponse> updateScheduledAudit(
            UpdateScheduledAuditRequest updateScheduledAuditRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateScheduledAuditResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateScheduledAuditResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateScheduledAuditRequest, UpdateScheduledAuditResponse>()
                            .withOperationName("UpdateScheduledAudit")
                            .withMarshaller(new UpdateScheduledAuditRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateScheduledAuditRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a Device Defender security profile.
     * </p>
     *
     * @param updateSecurityProfileRequest
     * @return A Java Future containing the result of the UpdateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateSecurityProfile
     */
    @Override
    public CompletableFuture<UpdateSecurityProfileResponse> updateSecurityProfile(
            UpdateSecurityProfileRequest updateSecurityProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSecurityProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSecurityProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSecurityProfileRequest, UpdateSecurityProfileResponse>()
                            .withOperationName("UpdateSecurityProfile")
                            .withMarshaller(new UpdateSecurityProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateSecurityProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing stream. The stream version will be incremented by one.
     * </p>
     *
     * @param updateStreamRequest
     * @return A Java Future containing the result of the UpdateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateStream
     */
    @Override
    public CompletableFuture<UpdateStreamResponse> updateStream(UpdateStreamRequest updateStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateStreamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateStreamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStreamRequest, UpdateStreamResponse>()
                            .withOperationName("UpdateStream").withMarshaller(new UpdateStreamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateStreamRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the data for a thing.
     * </p>
     *
     * @param updateThingRequest
     *        The input for the UpdateThing operation.
     * @return A Java Future containing the result of the UpdateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThing
     */
    @Override
    public CompletableFuture<UpdateThingResponse> updateThing(UpdateThingRequest updateThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThingRequest, UpdateThingResponse>()
                            .withOperationName("UpdateThing").withMarshaller(new UpdateThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a thing group.
     * </p>
     *
     * @param updateThingGroupRequest
     * @return A Java Future containing the result of the UpdateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroup
     */
    @Override
    public CompletableFuture<UpdateThingGroupResponse> updateThingGroup(UpdateThingGroupRequest updateThingGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThingGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThingGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThingGroupRequest, UpdateThingGroupResponse>()
                            .withOperationName("UpdateThingGroup")
                            .withMarshaller(new UpdateThingGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateThingGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the groups to which the thing belongs.
     * </p>
     *
     * @param updateThingGroupsForThingRequest
     * @return A Java Future containing the result of the UpdateThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroupsForThing
     */
    @Override
    public CompletableFuture<UpdateThingGroupsForThingResponse> updateThingGroupsForThing(
            UpdateThingGroupsForThingRequest updateThingGroupsForThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThingGroupsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThingGroupsForThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThingGroupsForThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThingGroupsForThingRequest, UpdateThingGroupsForThingResponse>()
                            .withOperationName("UpdateThingGroupsForThing")
                            .withMarshaller(new UpdateThingGroupsForThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateThingGroupsForThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the
     * destination.
     * </p>
     *
     * @param updateTopicRuleDestinationRequest
     * @return A Java Future containing the result of the UpdateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateTopicRuleDestination
     */
    @Override
    public CompletableFuture<UpdateTopicRuleDestinationResponse> updateTopicRuleDestination(
            UpdateTopicRuleDestinationRequest updateTopicRuleDestinationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTopicRuleDestinationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTopicRuleDestinationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTopicRuleDestinationRequest, UpdateTopicRuleDestinationResponse>()
                            .withOperationName("UpdateTopicRuleDestination")
                            .withMarshaller(new UpdateTopicRuleDestinationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateTopicRuleDestinationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Validates a Device Defender security profile behaviors specification.
     * </p>
     *
     * @param validateSecurityProfileBehaviorsRequest
     * @return A Java Future containing the result of the ValidateSecurityProfileBehaviors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ValidateSecurityProfileBehaviors
     */
    @Override
    public CompletableFuture<ValidateSecurityProfileBehaviorsResponse> validateSecurityProfileBehaviors(
            ValidateSecurityProfileBehaviorsRequest validateSecurityProfileBehaviorsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ValidateSecurityProfileBehaviorsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ValidateSecurityProfileBehaviorsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ValidateSecurityProfileBehaviorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ValidateSecurityProfileBehaviorsRequest, ValidateSecurityProfileBehaviorsResponse>()
                            .withOperationName("ValidateSecurityProfileBehaviors")
                            .withMarshaller(new ValidateSecurityProfileBehaviorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(validateSecurityProfileBehaviorsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IotException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TransferAlreadyCompletedException")
                                .exceptionBuilderSupplier(TransferAlreadyCompletedException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotConfiguredException")
                                .exceptionBuilderSupplier(NotConfiguredException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedPolicyException")
                                .exceptionBuilderSupplier(MalformedPolicyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryException")
                                .exceptionBuilderSupplier(InvalidQueryException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidStateTransitionException")
                                .exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceRegistrationFailureException")
                                .exceptionBuilderSupplier(ResourceRegistrationFailureException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteConflictException")
                                .exceptionBuilderSupplier(DeleteConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateConflictException")
                                .exceptionBuilderSupplier(CertificateConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RegistrationCodeValidationException")
                                .exceptionBuilderSupplier(RegistrationCodeValidationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResponseException")
                                .exceptionBuilderSupplier(InvalidResponseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAggregationException")
                                .exceptionBuilderSupplier(InvalidAggregationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SqlParseException")
                                .exceptionBuilderSupplier(SqlParseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictingResourceUpdateException")
                                .exceptionBuilderSupplier(ConflictingResourceUpdateException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalException")
                                .exceptionBuilderSupplier(InternalException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VersionsLimitExceededException")
                                .exceptionBuilderSupplier(VersionsLimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TransferConflictException")
                                .exceptionBuilderSupplier(TransferConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IndexNotReadyException")
                                .exceptionBuilderSupplier(IndexNotReadyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateStateException")
                                .exceptionBuilderSupplier(CertificateStateException::builder).httpStatusCode(406).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("VersionConflictException")
                                .exceptionBuilderSupplier(VersionConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TaskAlreadyExistsException")
                                .exceptionBuilderSupplier(TaskAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateValidationException")
                                .exceptionBuilderSupplier(CertificateValidationException::builder).httpStatusCode(400).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
