/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMitigationActionResponse extends IotResponse implements
        ToCopyableBuilder<DescribeMitigationActionResponse.Builder, DescribeMitigationActionResponse> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMitigationActionResponse::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMitigationActionResponse::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMitigationActionResponse::actionArn)).setter(setter(Builder::actionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionArn").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMitigationActionResponse::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMitigationActionResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<MitigationActionParams> ACTION_PARAMS_FIELD = SdkField
            .<MitigationActionParams> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeMitigationActionResponse::actionParams)).setter(setter(Builder::actionParams))
            .constructor(MitigationActionParams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionParams").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeMitigationActionResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeMitigationActionResponse::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ACTION_TYPE_FIELD, ACTION_ARN_FIELD, ACTION_ID_FIELD, ROLE_ARN_FIELD, ACTION_PARAMS_FIELD, CREATION_DATE_FIELD,
            LAST_MODIFIED_DATE_FIELD));

    private final String actionName;

    private final String actionType;

    private final String actionArn;

    private final String actionId;

    private final String roleArn;

    private final MitigationActionParams actionParams;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private DescribeMitigationActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.actionType = builder.actionType;
        this.actionArn = builder.actionArn;
        this.actionId = builder.actionId;
        this.roleArn = builder.roleArn;
        this.actionParams = builder.actionParams;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The friendly name that uniquely identifies the mitigation action.
     * </p>
     * 
     * @return The friendly name that uniquely identifies the mitigation action.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The type of mitigation action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link MitigationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of mitigation action.
     * @see MitigationActionType
     */
    public MitigationActionType actionType() {
        return MitigationActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of mitigation action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link MitigationActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of mitigation action.
     * @see MitigationActionType
     */
    public String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The ARN that identifies this migration action.
     * </p>
     * 
     * @return The ARN that identifies this migration action.
     */
    public String actionArn() {
        return actionArn;
    }

    /**
     * <p>
     * A unique identifier for this action.
     * </p>
     * 
     * @return A unique identifier for this action.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The ARN of the IAM role used to apply this action.
     * </p>
     * 
     * @return The ARN of the IAM role used to apply this action.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Parameters that control how the mitigation action is applied, specific to the type of mitigation action.
     * </p>
     * 
     * @return Parameters that control how the mitigation action is applied, specific to the type of mitigation action.
     */
    public MitigationActionParams actionParams() {
        return actionParams;
    }

    /**
     * <p>
     * The date and time when the mitigation action was added to your AWS account.
     * </p>
     * 
     * @return The date and time when the mitigation action was added to your AWS account.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time when the mitigation action was last changed.
     * </p>
     * 
     * @return The date and time when the mitigation action was last changed.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionParams());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMitigationActionResponse)) {
            return false;
        }
        DescribeMitigationActionResponse other = (DescribeMitigationActionResponse) obj;
        return Objects.equals(actionName(), other.actionName())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(actionArn(), other.actionArn()) && Objects.equals(actionId(), other.actionId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(actionParams(), other.actionParams())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMitigationActionResponse").add("ActionName", actionName())
                .add("ActionType", actionTypeAsString()).add("ActionArn", actionArn()).add("ActionId", actionId())
                .add("RoleArn", roleArn()).add("ActionParams", actionParams()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "actionArn":
            return Optional.ofNullable(clazz.cast(actionArn()));
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "actionParams":
            return Optional.ofNullable(clazz.cast(actionParams()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMitigationActionResponse, T> g) {
        return obj -> g.apply((DescribeMitigationActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMitigationActionResponse> {
        /**
         * <p>
         * The friendly name that uniquely identifies the mitigation action.
         * </p>
         * 
         * @param actionName
         *        The friendly name that uniquely identifies the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The type of mitigation action.
         * </p>
         * 
         * @param actionType
         *        The type of mitigation action.
         * @see MitigationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MitigationActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of mitigation action.
         * </p>
         * 
         * @param actionType
         *        The type of mitigation action.
         * @see MitigationActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MitigationActionType
         */
        Builder actionType(MitigationActionType actionType);

        /**
         * <p>
         * The ARN that identifies this migration action.
         * </p>
         * 
         * @param actionArn
         *        The ARN that identifies this migration action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionArn(String actionArn);

        /**
         * <p>
         * A unique identifier for this action.
         * </p>
         * 
         * @param actionId
         *        A unique identifier for this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The ARN of the IAM role used to apply this action.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role used to apply this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Parameters that control how the mitigation action is applied, specific to the type of mitigation action.
         * </p>
         * 
         * @param actionParams
         *        Parameters that control how the mitigation action is applied, specific to the type of mitigation
         *        action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionParams(MitigationActionParams actionParams);

        /**
         * <p>
         * Parameters that control how the mitigation action is applied, specific to the type of mitigation action.
         * </p>
         * This is a convenience that creates an instance of the {@link MitigationActionParams.Builder} avoiding the
         * need to create one manually via {@link MitigationActionParams#builder()}.
         *
         * When the {@link Consumer} completes, {@link MitigationActionParams.Builder#build()} is called immediately and
         * its result is passed to {@link #actionParams(MitigationActionParams)}.
         * 
         * @param actionParams
         *        a consumer that will call methods on {@link MitigationActionParams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionParams(MitigationActionParams)
         */
        default Builder actionParams(Consumer<MitigationActionParams.Builder> actionParams) {
            return actionParams(MitigationActionParams.builder().applyMutation(actionParams).build());
        }

        /**
         * <p>
         * The date and time when the mitigation action was added to your AWS account.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the mitigation action was added to your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time when the mitigation action was last changed.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the mitigation action was last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String actionName;

        private String actionType;

        private String actionArn;

        private String actionId;

        private String roleArn;

        private MitigationActionParams actionParams;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMitigationActionResponse model) {
            super(model);
            actionName(model.actionName);
            actionType(model.actionType);
            actionArn(model.actionArn);
            actionId(model.actionId);
            roleArn(model.roleArn);
            actionParams(model.actionParams);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getActionTypeAsString() {
            return actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(MitigationActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getActionArn() {
            return actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final MitigationActionParams.Builder getActionParams() {
            return actionParams != null ? actionParams.toBuilder() : null;
        }

        @Override
        public final Builder actionParams(MitigationActionParams actionParams) {
            this.actionParams = actionParams;
            return this;
        }

        public final void setActionParams(MitigationActionParams.BuilderImpl actionParams) {
            this.actionParams = actionParams != null ? actionParams.build() : null;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public DescribeMitigationActionResponse build() {
            return new DescribeMitigationActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
