/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the rollout of OTA updates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsJobExecutionsRolloutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsJobExecutionsRolloutConfig.Builder, AwsJobExecutionsRolloutConfig> {
    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AwsJobExecutionsRolloutConfig::maximumPerMinute)).setter(setter(Builder::maximumPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_PER_MINUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumPerMinute;

    private AwsJobExecutionsRolloutConfig(BuilderImpl builder) {
        this.maximumPerMinute = builder.maximumPerMinute;
    }

    /**
     * <p>
     * The maximum number of OTA update job executions started per minute.
     * </p>
     * 
     * @return The maximum number of OTA update job executions started per minute.
     */
    public Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsJobExecutionsRolloutConfig)) {
            return false;
        }
        AwsJobExecutionsRolloutConfig other = (AwsJobExecutionsRolloutConfig) obj;
        return Objects.equals(maximumPerMinute(), other.maximumPerMinute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsJobExecutionsRolloutConfig").add("MaximumPerMinute", maximumPerMinute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsJobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((AwsJobExecutionsRolloutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsJobExecutionsRolloutConfig> {
        /**
         * <p>
         * The maximum number of OTA update job executions started per minute.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of OTA update job executions started per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsJobExecutionsRolloutConfig model) {
            maximumPerMinute(model.maximumPerMinute);
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public AwsJobExecutionsRolloutConfig build() {
            return new AwsJobExecutionsRolloutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
