/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAccountAuditConfigurationRequest extends IotRequest implements
        ToCopyableBuilder<DeleteAccountAuditConfigurationRequest.Builder, DeleteAccountAuditConfigurationRequest> {
    private static final SdkField<Boolean> DELETE_SCHEDULED_AUDITS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteAccountAuditConfigurationRequest::deleteScheduledAudits))
            .setter(setter(Builder::deleteScheduledAudits))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deleteScheduledAudits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DELETE_SCHEDULED_AUDITS_FIELD));

    private final Boolean deleteScheduledAudits;

    private DeleteAccountAuditConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.deleteScheduledAudits = builder.deleteScheduledAudits;
    }

    /**
     * <p>
     * If true, all scheduled audits are deleted.
     * </p>
     * 
     * @return If true, all scheduled audits are deleted.
     */
    public Boolean deleteScheduledAudits() {
        return deleteScheduledAudits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deleteScheduledAudits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountAuditConfigurationRequest)) {
            return false;
        }
        DeleteAccountAuditConfigurationRequest other = (DeleteAccountAuditConfigurationRequest) obj;
        return Objects.equals(deleteScheduledAudits(), other.deleteScheduledAudits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAccountAuditConfigurationRequest").add("DeleteScheduledAudits", deleteScheduledAudits())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleteScheduledAudits":
            return Optional.ofNullable(clazz.cast(deleteScheduledAudits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountAuditConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteAccountAuditConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAccountAuditConfigurationRequest> {
        /**
         * <p>
         * If true, all scheduled audits are deleted.
         * </p>
         * 
         * @param deleteScheduledAudits
         *        If true, all scheduled audits are deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteScheduledAudits(Boolean deleteScheduledAudits);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Boolean deleteScheduledAudits;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountAuditConfigurationRequest model) {
            super(model);
            deleteScheduledAudits(model.deleteScheduledAudits);
        }

        public final Boolean getDeleteScheduledAudits() {
            return deleteScheduledAudits;
        }

        @Override
        public final Builder deleteScheduledAudits(Boolean deleteScheduledAudits) {
            this.deleteScheduledAudits = deleteScheduledAudits;
            return this;
        }

        public final void setDeleteScheduledAudits(Boolean deleteScheduledAudits) {
            this.deleteScheduledAudits = deleteScheduledAudits;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccountAuditConfigurationRequest build() {
            return new DeleteAccountAuditConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
