/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainConfigurationResponse extends IotResponse implements
        ToCopyableBuilder<DescribeDomainConfigurationResponse.Builder, DescribeDomainConfigurationResponse> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::domainConfigurationName))
            .setter(setter(Builder::domainConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build())
            .build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::domainConfigurationArn))
            .setter(setter(Builder::domainConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build())
            .build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<List<ServerCertificateSummary>> SERVER_CERTIFICATES_FIELD = SdkField
            .<List<ServerCertificateSummary>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDomainConfigurationResponse::serverCertificates))
            .setter(setter(Builder::serverCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerCertificateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerCertificateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField
            .<AuthorizerConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDomainConfigurationResponse::authorizerConfig)).setter(setter(Builder::authorizerConfig))
            .constructor(AuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()).build();

    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::domainConfigurationStatusAsString))
            .setter(setter(Builder::domainConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build())
            .build();

    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::serviceTypeAsString)).setter(setter(Builder::serviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()).build();

    private static final SdkField<String> DOMAIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDomainConfigurationResponse::domainTypeAsString)).setter(setter(Builder::domainType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD, DOMAIN_NAME_FIELD, SERVER_CERTIFICATES_FIELD,
            AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD, SERVICE_TYPE_FIELD, DOMAIN_TYPE_FIELD));

    private final String domainConfigurationName;

    private final String domainConfigurationArn;

    private final String domainName;

    private final List<ServerCertificateSummary> serverCertificates;

    private final AuthorizerConfig authorizerConfig;

    private final String domainConfigurationStatus;

    private final String serviceType;

    private final String domainType;

    private DescribeDomainConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
        this.domainName = builder.domainName;
        this.serverCertificates = builder.serverCertificates;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.serviceType = builder.serviceType;
        this.domainType = builder.domainType;
    }

    /**
     * <p>
     * The name of the domain configuration.
     * </p>
     * 
     * @return The name of the domain configuration.
     */
    public String domainConfigurationName() {
        return domainConfigurationName;
    }

    /**
     * <p>
     * The ARN of the domain configuration.
     * </p>
     * 
     * @return The ARN of the domain configuration.
     */
    public String domainConfigurationArn() {
        return domainConfigurationArn;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * Returns true if the ServerCertificates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasServerCertificates() {
        return serverCertificates != null && !(serverCertificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing summary information about the server certificate included in the domain configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerCertificates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing summary information about the server certificate included in the domain configuration.
     */
    public List<ServerCertificateSummary> serverCertificates() {
        return serverCertificates;
    }

    /**
     * <p>
     * An object that specifies the authorization service for a domain.
     * </p>
     * 
     * @return An object that specifies the authorization service for a domain.
     */
    public AuthorizerConfig authorizerConfig() {
        return authorizerConfig;
    }

    /**
     * <p>
     * A Boolean value that specifies the current state of the domain configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value that specifies the current state of the domain configuration.
     * @see DomainConfigurationStatus
     */
    public DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(domainConfigurationStatus);
    }

    /**
     * <p>
     * A Boolean value that specifies the current state of the domain configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #domainConfigurationStatus} will return {@link DomainConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #domainConfigurationStatusAsString}.
     * </p>
     * 
     * @return A Boolean value that specifies the current state of the domain configuration.
     * @see DomainConfigurationStatus
     */
    public String domainConfigurationStatusAsString() {
        return domainConfigurationStatus;
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public ServiceType serviceType() {
        return ServiceType.fromValue(serviceType);
    }

    /**
     * <p>
     * The type of service delivered by the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceType} will
     * return {@link ServiceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #serviceTypeAsString}.
     * </p>
     * 
     * @return The type of service delivered by the endpoint.
     * @see ServiceType
     */
    public String serviceTypeAsString() {
        return serviceType;
    }

    /**
     * <p>
     * The type of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainType} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainTypeAsString}.
     * </p>
     * 
     * @return The type of the domain.
     * @see DomainType
     */
    public DomainType domainType() {
        return DomainType.fromValue(domainType);
    }

    /**
     * <p>
     * The type of the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainType} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainTypeAsString}.
     * </p>
     * 
     * @return The type of the domain.
     * @see DomainType
     */
    public String domainTypeAsString() {
        return domainType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificates());
        hashCode = 31 * hashCode + Objects.hashCode(authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainConfigurationResponse)) {
            return false;
        }
        DescribeDomainConfigurationResponse other = (DescribeDomainConfigurationResponse) obj;
        return Objects.equals(domainConfigurationName(), other.domainConfigurationName())
                && Objects.equals(domainConfigurationArn(), other.domainConfigurationArn())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(serverCertificates(), other.serverCertificates())
                && Objects.equals(authorizerConfig(), other.authorizerConfig())
                && Objects.equals(domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString())
                && Objects.equals(serviceTypeAsString(), other.serviceTypeAsString())
                && Objects.equals(domainTypeAsString(), other.domainTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDomainConfigurationResponse").add("DomainConfigurationName", domainConfigurationName())
                .add("DomainConfigurationArn", domainConfigurationArn()).add("DomainName", domainName())
                .add("ServerCertificates", serverCertificates()).add("AuthorizerConfig", authorizerConfig())
                .add("DomainConfigurationStatus", domainConfigurationStatusAsString()).add("ServiceType", serviceTypeAsString())
                .add("DomainType", domainTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainConfigurationName":
            return Optional.ofNullable(clazz.cast(domainConfigurationName()));
        case "domainConfigurationArn":
            return Optional.ofNullable(clazz.cast(domainConfigurationArn()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "serverCertificates":
            return Optional.ofNullable(clazz.cast(serverCertificates()));
        case "authorizerConfig":
            return Optional.ofNullable(clazz.cast(authorizerConfig()));
        case "domainConfigurationStatus":
            return Optional.ofNullable(clazz.cast(domainConfigurationStatusAsString()));
        case "serviceType":
            return Optional.ofNullable(clazz.cast(serviceTypeAsString()));
        case "domainType":
            return Optional.ofNullable(clazz.cast(domainTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDomainConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainConfigurationResponse> {
        /**
         * <p>
         * The name of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationName
         *        The name of the domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationName(String domainConfigurationName);

        /**
         * <p>
         * The ARN of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationArn
         *        The ARN of the domain configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainConfigurationArn(String domainConfigurationArn);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * 
         * @param serverCertificates
         *        A list containing summary information about the server certificate included in the domain
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(Collection<ServerCertificateSummary> serverCertificates);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * 
         * @param serverCertificates
         *        A list containing summary information about the server certificate included in the domain
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificates(ServerCertificateSummary... serverCertificates);

        /**
         * <p>
         * A list containing summary information about the server certificate included in the domain configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerCertificateSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ServerCertificateSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerCertificateSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #serverCertificates(List<ServerCertificateSummary>)}.
         * 
         * @param serverCertificates
         *        a consumer that will call methods on {@link List<ServerCertificateSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificates(List<ServerCertificateSummary>)
         */
        Builder serverCertificates(Consumer<ServerCertificateSummary.Builder>... serverCertificates);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * 
         * @param authorizerConfig
         *        An object that specifies the authorization service for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerConfig(AuthorizerConfig authorizerConfig);

        /**
         * <p>
         * An object that specifies the authorization service for a domain.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthorizerConfig.Builder} avoiding the need to
         * create one manually via {@link AuthorizerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthorizerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #authorizerConfig(AuthorizerConfig)}.
         * 
         * @param authorizerConfig
         *        a consumer that will call methods on {@link AuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerConfig(AuthorizerConfig)
         */
        default Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return authorizerConfig(AuthorizerConfig.builder().applyMutation(authorizerConfig).build());
        }

        /**
         * <p>
         * A Boolean value that specifies the current state of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        A Boolean value that specifies the current state of the domain configuration.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(String domainConfigurationStatus);

        /**
         * <p>
         * A Boolean value that specifies the current state of the domain configuration.
         * </p>
         * 
         * @param domainConfigurationStatus
         *        A Boolean value that specifies the current state of the domain configuration.
         * @see DomainConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainConfigurationStatus
         */
        Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(String serviceType);

        /**
         * <p>
         * The type of service delivered by the endpoint.
         * </p>
         * 
         * @param serviceType
         *        The type of service delivered by the endpoint.
         * @see ServiceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceType
         */
        Builder serviceType(ServiceType serviceType);

        /**
         * <p>
         * The type of the domain.
         * </p>
         * 
         * @param domainType
         *        The type of the domain.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domainType(String domainType);

        /**
         * <p>
         * The type of the domain.
         * </p>
         * 
         * @param domainType
         *        The type of the domain.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domainType(DomainType domainType);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String domainConfigurationName;

        private String domainConfigurationArn;

        private String domainName;

        private List<ServerCertificateSummary> serverCertificates = DefaultSdkAutoConstructList.getInstance();

        private AuthorizerConfig authorizerConfig;

        private String domainConfigurationStatus;

        private String serviceType;

        private String domainType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainConfigurationResponse model) {
            super(model);
            domainConfigurationName(model.domainConfigurationName);
            domainConfigurationArn(model.domainConfigurationArn);
            domainName(model.domainName);
            serverCertificates(model.serverCertificates);
            authorizerConfig(model.authorizerConfig);
            domainConfigurationStatus(model.domainConfigurationStatus);
            serviceType(model.serviceType);
            domainType(model.domainType);
        }

        public final String getDomainConfigurationName() {
            return domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        public final String getDomainConfigurationArn() {
            return domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<ServerCertificateSummary.Builder> getServerCertificates() {
            return serverCertificates != null ? serverCertificates.stream().map(ServerCertificateSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverCertificates(Collection<ServerCertificateSummary> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copy(serverCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(ServerCertificateSummary... serverCertificates) {
            serverCertificates(Arrays.asList(serverCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(Consumer<ServerCertificateSummary.Builder>... serverCertificates) {
            serverCertificates(Stream.of(serverCertificates)
                    .map(c -> ServerCertificateSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerCertificates(Collection<ServerCertificateSummary.BuilderImpl> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copyFromBuilder(serverCertificates);
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return authorizerConfig != null ? authorizerConfig.toBuilder() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        public final String getDomainConfigurationStatusAsString() {
            return domainConfigurationStatus;
        }

        @Override
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        public final String getServiceTypeAsString() {
            return serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getDomainTypeAsString() {
            return domainType;
        }

        @Override
        public final Builder domainType(String domainType) {
            this.domainType = domainType;
            return this;
        }

        @Override
        public final Builder domainType(DomainType domainType) {
            this.domainType(domainType == null ? null : domainType.toString());
            return this;
        }

        public final void setDomainType(String domainType) {
            this.domainType = domainType;
        }

        @Override
        public DescribeDomainConfigurationResponse build() {
            return new DescribeDomainConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
