/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditTasksRequest extends IotRequest implements
        ToCopyableBuilder<ListAuditTasksRequest.Builder, ListAuditTasksRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListAuditTasksRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListAuditTasksRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditTasksRequest::taskTypeAsString)).setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskType").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditTasksRequest::taskStatusAsString)).setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskStatus").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAuditTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TASK_TYPE_FIELD, TASK_STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final Instant startTime;

    private final Instant endTime;

    private final String taskType;

    private final String taskStatus;

    private final String nextToken;

    private final Integer maxResults;

    private ListAuditTasksRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.taskType = builder.taskType;
        this.taskStatus = builder.taskStatus;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The beginning of the time period. Audit information is retained for a limited time (180 days). Requesting a start
     * time prior to what is retained results in an "InvalidRequestException".
     * </p>
     * 
     * @return The beginning of the time period. Audit information is retained for a limited time (180 days). Requesting
     *         a start time prior to what is retained results in an "InvalidRequestException".
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period.
     * </p>
     * 
     * @return The end of the time period.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
     * "SCHEDULED__AUDIT_TASK".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link AuditTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
     *         "SCHEDULED__AUDIT_TASK".
     * @see AuditTaskType
     */
    public AuditTaskType taskType() {
        return AuditTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
     * "SCHEDULED__AUDIT_TASK".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link AuditTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
     *         "SCHEDULED__AUDIT_TASK".
     * @see AuditTaskType
     */
    public String taskTypeAsString() {
        return taskType;
    }

    /**
     * <p>
     * A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
     * "COMPLETED", "FAILED", or "CANCELED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
     *         "COMPLETED", "FAILED", or "CANCELED".
     * @see AuditTaskStatus
     */
    public AuditTaskStatus taskStatus() {
        return AuditTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
     * "COMPLETED", "FAILED", or "CANCELED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskStatusAsString}.
     * </p>
     * 
     * @return A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
     *         "COMPLETED", "FAILED", or "CANCELED".
     * @see AuditTaskStatus
     */
    public String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditTasksRequest)) {
            return false;
        }
        ListAuditTasksRequest other = (ListAuditTasksRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(taskTypeAsString(), other.taskTypeAsString())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuditTasksRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("TaskType", taskTypeAsString()).add("TaskStatus", taskStatusAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "taskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditTasksRequest, T> g) {
        return obj -> g.apply((ListAuditTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAuditTasksRequest> {
        /**
         * <p>
         * The beginning of the time period. Audit information is retained for a limited time (180 days). Requesting a
         * start time prior to what is retained results in an "InvalidRequestException".
         * </p>
         * 
         * @param startTime
         *        The beginning of the time period. Audit information is retained for a limited time (180 days).
         *        Requesting a start time prior to what is retained results in an "InvalidRequestException".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period.
         * </p>
         * 
         * @param endTime
         *        The end of the time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
         * "SCHEDULED__AUDIT_TASK".
         * </p>
         * 
         * @param taskType
         *        A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
         *        "SCHEDULED__AUDIT_TASK".
         * @see AuditTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
         * "SCHEDULED__AUDIT_TASK".
         * </p>
         * 
         * @param taskType
         *        A filter to limit the output to the specified type of audit: can be one of "ON_DEMAND_AUDIT_TASK" or
         *        "SCHEDULED__AUDIT_TASK".
         * @see AuditTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskType
         */
        Builder taskType(AuditTaskType taskType);

        /**
         * <p>
         * A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
         * "COMPLETED", "FAILED", or "CANCELED".
         * </p>
         * 
         * @param taskStatus
         *        A filter to limit the output to audits with the specified completion status: can be one of
         *        "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * @see AuditTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * A filter to limit the output to audits with the specified completion status: can be one of "IN_PROGRESS",
         * "COMPLETED", "FAILED", or "CANCELED".
         * </p>
         * 
         * @param taskStatus
         *        A filter to limit the output to audits with the specified completion status: can be one of
         *        "IN_PROGRESS", "COMPLETED", "FAILED", or "CANCELED".
         * @see AuditTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditTaskStatus
         */
        Builder taskStatus(AuditTaskStatus taskStatus);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private String taskType;

        private String taskStatus;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditTasksRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            taskType(model.taskType);
            taskStatus(model.taskStatus);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getTaskTypeAsString() {
            return taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(AuditTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final String getTaskStatusAsString() {
            return taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditTasksRequest build() {
            return new ListAuditTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
