/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the MQTT context to use for the test authorizer request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MqttContext implements SdkPojo, Serializable, ToCopyableBuilder<MqttContext.Builder, MqttContext> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MqttContext::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final SdkField<SdkBytes> PASSWORD_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(MqttContext::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MqttContext::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, CLIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final SdkBytes password;

    private final String clientId;

    private MqttContext(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.clientId = builder.clientId;
    }

    /**
     * <p>
     * The value of the <code>username</code> key in an MQTT authorization request.
     * </p>
     * 
     * @return The value of the <code>username</code> key in an MQTT authorization request.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The value of the <code>password</code> key in an MQTT authorization request.
     * </p>
     * 
     * @return The value of the <code>password</code> key in an MQTT authorization request.
     */
    public SdkBytes password() {
        return password;
    }

    /**
     * <p>
     * The value of the <code>clientId</code> key in an MQTT authorization request.
     * </p>
     * 
     * @return The value of the <code>clientId</code> key in an MQTT authorization request.
     */
    public String clientId() {
        return clientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MqttContext)) {
            return false;
        }
        MqttContext other = (MqttContext) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(clientId(), other.clientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MqttContext").add("Username", username()).add("Password", password())
                .add("ClientId", clientId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "username":
            return Optional.ofNullable(clazz.cast(username()));
        case "password":
            return Optional.ofNullable(clazz.cast(password()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MqttContext, T> g) {
        return obj -> g.apply((MqttContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MqttContext> {
        /**
         * <p>
         * The value of the <code>username</code> key in an MQTT authorization request.
         * </p>
         * 
         * @param username
         *        The value of the <code>username</code> key in an MQTT authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The value of the <code>password</code> key in an MQTT authorization request.
         * </p>
         * 
         * @param password
         *        The value of the <code>password</code> key in an MQTT authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(SdkBytes password);

        /**
         * <p>
         * The value of the <code>clientId</code> key in an MQTT authorization request.
         * </p>
         * 
         * @param clientId
         *        The value of the <code>clientId</code> key in an MQTT authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private SdkBytes password;

        private String clientId;

        private BuilderImpl() {
        }

        private BuilderImpl(MqttContext model) {
            username(model.username);
            password(model.password);
            clientId(model.clientId);
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final ByteBuffer getPassword() {
            return password == null ? null : password.asByteBuffer();
        }

        @Override
        public final Builder password(SdkBytes password) {
            this.password = StandardMemberCopier.copy(password);
            return this;
        }

        public final void setPassword(ByteBuffer password) {
            password(password == null ? null : SdkBytes.fromByteBuffer(password));
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public MqttContext build() {
            return new MqttContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
