/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a fleet provision template version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisioningTemplateVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisioningTemplateVersionSummary.Builder, ProvisioningTemplateVersionSummary> {
    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ProvisioningTemplateVersionSummary::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProvisioningTemplateVersionSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ProvisioningTemplateVersionSummary::isDefaultVersion)).setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_ID_FIELD,
            CREATION_DATE_FIELD, IS_DEFAULT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer versionId;

    private final Instant creationDate;

    private final Boolean isDefaultVersion;

    private ProvisioningTemplateVersionSummary(BuilderImpl builder) {
        this.versionId = builder.versionId;
        this.creationDate = builder.creationDate;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The ID of the fleet privisioning template version.
     * </p>
     * 
     * @return The ID of the fleet privisioning template version.
     */
    public Integer versionId() {
        return versionId;
    }

    /**
     * <p>
     * The date when the fleet provisioning template version was created
     * </p>
     * 
     * @return The date when the fleet provisioning template version was created
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * True if the fleet provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @return True if the fleet provisioning template version is the default version, otherwise false.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningTemplateVersionSummary)) {
            return false;
        }
        ProvisioningTemplateVersionSummary other = (ProvisioningTemplateVersionSummary) obj;
        return Objects.equals(versionId(), other.versionId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisioningTemplateVersionSummary").add("VersionId", versionId())
                .add("CreationDate", creationDate()).add("IsDefaultVersion", isDefaultVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "isDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningTemplateVersionSummary, T> g) {
        return obj -> g.apply((ProvisioningTemplateVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisioningTemplateVersionSummary> {
        /**
         * <p>
         * The ID of the fleet privisioning template version.
         * </p>
         * 
         * @param versionId
         *        The ID of the fleet privisioning template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(Integer versionId);

        /**
         * <p>
         * The date when the fleet provisioning template version was created
         * </p>
         * 
         * @param creationDate
         *        The date when the fleet provisioning template version was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * True if the fleet provisioning template version is the default version, otherwise false.
         * </p>
         * 
         * @param isDefaultVersion
         *        True if the fleet provisioning template version is the default version, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl implements Builder {
        private Integer versionId;

        private Instant creationDate;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningTemplateVersionSummary model) {
            versionId(model.versionId);
            creationDate(model.creationDate);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final Integer getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public ProvisioningTemplateVersionSummary build() {
            return new ProvisioningTemplateVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
