/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the topic rule destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicRuleDestinationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicRuleDestinationSummary.Builder, TopicRuleDestinationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestinationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestinationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TopicRuleDestinationSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<HttpUrlDestinationSummary> HTTP_URL_SUMMARY_FIELD = SdkField
            .<HttpUrlDestinationSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(TopicRuleDestinationSummary::httpUrlSummary)).setter(setter(Builder::httpUrlSummary))
            .constructor(HttpUrlDestinationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpUrlSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, HTTP_URL_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String status;

    private final String statusReason;

    private final HttpUrlDestinationSummary httpUrlSummary;

    private TopicRuleDestinationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.httpUrlSummary = builder.httpUrlSummary;
    }

    /**
     * <p>
     * The topic rule destination ARN.
     * </p>
     * 
     * @return The topic rule destination ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public TopicRuleDestinationStatus status() {
        return TopicRuleDestinationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the topic rule destination. Valid values are:
     * </p>
     * <dl>
     * <dt>IN_PROGRESS</dt>
     * <dd>
     * <p>
     * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * <dt>ENABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
     * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>DISABLED</dt>
     * <dd>
     * <p>
     * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code> to
     * <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     * </p>
     * </dd>
     * <dt>ERROR</dt>
     * <dd>
     * <p>
     * Confirmation could not be completed, for example if the confirmation timed out. You can call
     * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
     * endpoint.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicRuleDestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the topic rule destination. Valid values are:</p>
     *         <dl>
     *         <dt>IN_PROGRESS</dt>
     *         <dd>
     *         <p>
     *         A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     *         <dt>ENABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code>
     *         to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>DISABLED</dt>
     *         <dd>
     *         <p>
     *         Confirmation was completed, and traffic to this destination is not allowed. You can set
     *         <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
     *         </p>
     *         </dd>
     *         <dt>ERROR</dt>
     *         <dd>
     *         <p>
     *         Confirmation could not be completed, for example if the confirmation timed out. You can call
     *         <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
     *         <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
     *         <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
     *         confirmation endpoint.
     *         </p>
     *         </dd>
     * @see TopicRuleDestinationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason the topic rule destination is in the current status.
     * </p>
     * 
     * @return The reason the topic rule destination is in the current status.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Information about the HTTP URL.
     * </p>
     * 
     * @return Information about the HTTP URL.
     */
    public HttpUrlDestinationSummary httpUrlSummary() {
        return httpUrlSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(httpUrlSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRuleDestinationSummary)) {
            return false;
        }
        TopicRuleDestinationSummary other = (TopicRuleDestinationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(httpUrlSummary(), other.httpUrlSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TopicRuleDestinationSummary").add("Arn", arn()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("HttpUrlSummary", httpUrlSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "httpUrlSummary":
            return Optional.ofNullable(clazz.cast(httpUrlSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicRuleDestinationSummary, T> g) {
        return obj -> g.apply((TopicRuleDestinationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicRuleDestinationSummary> {
        /**
         * <p>
         * The topic rule destination ARN.
         * </p>
         * 
         * @param arn
         *        The topic rule destination ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the topic rule destination. Valid values are:
         * </p>
         * <dl>
         * <dt>IN_PROGRESS</dt>
         * <dd>
         * <p>
         * A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * <dt>ENABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is allowed. You can set <code>status</code> to
         * <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>DISABLED</dt>
         * <dd>
         * <p>
         * Confirmation was completed, and traffic to this destination is not allowed. You can set <code>status</code>
         * to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         * </p>
         * </dd>
         * <dt>ERROR</dt>
         * <dd>
         * <p>
         * Confirmation could not be completed, for example if the confirmation timed out. You can call
         * <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         * <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         * <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your confirmation
         * endpoint.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the topic rule destination. Valid values are:</p>
         *        <dl>
         *        <dt>IN_PROGRESS</dt>
         *        <dd>
         *        <p>
         *        A topic rule destination was created but has not been confirmed. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         *        <dt>ENABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is allowed. You can set
         *        <code>status</code> to <code>DISABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>DISABLED</dt>
         *        <dd>
         *        <p>
         *        Confirmation was completed, and traffic to this destination is not allowed. You can set
         *        <code>status</code> to <code>ENABLED</code> by calling <code>UpdateTopicRuleDestination</code>.
         *        </p>
         *        </dd>
         *        <dt>ERROR</dt>
         *        <dd>
         *        <p>
         *        Confirmation could not be completed, for example if the confirmation timed out. You can call
         *        <code>GetTopicRuleDestination</code> for details about the error. You can set <code>status</code> to
         *        <code>IN_PROGRESS</code> by calling <code>UpdateTopicRuleDestination</code>. Calling
         *        <code>UpdateTopicRuleDestination</code> causes a new confirmation challenge to be sent to your
         *        confirmation endpoint.
         *        </p>
         *        </dd>
         * @see TopicRuleDestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicRuleDestinationStatus
         */
        Builder status(TopicRuleDestinationStatus status);

        /**
         * <p>
         * The reason the topic rule destination is in the current status.
         * </p>
         * 
         * @param statusReason
         *        The reason the topic rule destination is in the current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Information about the HTTP URL.
         * </p>
         * 
         * @param httpUrlSummary
         *        Information about the HTTP URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary);

        /**
         * <p>
         * Information about the HTTP URL.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpUrlDestinationSummary.Builder} avoiding the
         * need to create one manually via {@link HttpUrlDestinationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpUrlDestinationSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #httpUrlSummary(HttpUrlDestinationSummary)}.
         * 
         * @param httpUrlSummary
         *        a consumer that will call methods on {@link HttpUrlDestinationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpUrlSummary(HttpUrlDestinationSummary)
         */
        default Builder httpUrlSummary(Consumer<HttpUrlDestinationSummary.Builder> httpUrlSummary) {
            return httpUrlSummary(HttpUrlDestinationSummary.builder().applyMutation(httpUrlSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String status;

        private String statusReason;

        private HttpUrlDestinationSummary httpUrlSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRuleDestinationSummary model) {
            arn(model.arn);
            status(model.status);
            statusReason(model.statusReason);
            httpUrlSummary(model.httpUrlSummary);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicRuleDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final HttpUrlDestinationSummary.Builder getHttpUrlSummary() {
            return httpUrlSummary != null ? httpUrlSummary.toBuilder() : null;
        }

        @Override
        public final Builder httpUrlSummary(HttpUrlDestinationSummary httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary;
            return this;
        }

        public final void setHttpUrlSummary(HttpUrlDestinationSummary.BuilderImpl httpUrlSummary) {
            this.httpUrlSummary = httpUrlSummary != null ? httpUrlSummary.build() : null;
        }

        @Override
        public TopicRuleDestinationSummary build() {
            return new TopicRuleDestinationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
