/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input to the UpdateCACertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCaCertificateRequest extends IotRequest implements
        ToCopyableBuilder<UpdateCaCertificateRequest.Builder, UpdateCaCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCaCertificateRequest::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caCertificateId").build()).build();

    private static final SdkField<String> NEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCaCertificateRequest::newStatusAsString)).setter(setter(Builder::newStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("newStatus").build()).build();

    private static final SdkField<String> NEW_AUTO_REGISTRATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCaCertificateRequest::newAutoRegistrationStatusAsString))
            .setter(setter(Builder::newAutoRegistrationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("newAutoRegistrationStatus")
                    .build()).build();

    private static final SdkField<RegistrationConfig> REGISTRATION_CONFIG_FIELD = SdkField
            .<RegistrationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateCaCertificateRequest::registrationConfig)).setter(setter(Builder::registrationConfig))
            .constructor(RegistrationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationConfig").build())
            .build();

    private static final SdkField<Boolean> REMOVE_AUTO_REGISTRATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateCaCertificateRequest::removeAutoRegistration)).setter(setter(Builder::removeAutoRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAutoRegistration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            NEW_STATUS_FIELD, NEW_AUTO_REGISTRATION_STATUS_FIELD, REGISTRATION_CONFIG_FIELD, REMOVE_AUTO_REGISTRATION_FIELD));

    private final String certificateId;

    private final String newStatus;

    private final String newAutoRegistrationStatus;

    private final RegistrationConfig registrationConfig;

    private final Boolean removeAutoRegistration;

    private UpdateCaCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.newStatus = builder.newStatus;
        this.newAutoRegistrationStatus = builder.newAutoRegistrationStatus;
        this.registrationConfig = builder.registrationConfig;
        this.removeAutoRegistration = builder.removeAutoRegistration;
    }

    /**
     * <p>
     * The CA certificate identifier.
     * </p>
     * 
     * @return The CA certificate identifier.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The updated status of the CA certificate.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newStatus} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #newStatusAsString}.
     * </p>
     * 
     * @return The updated status of the CA certificate.</p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CACertificateStatus
     */
    public CACertificateStatus newStatus() {
        return CACertificateStatus.fromValue(newStatus);
    }

    /**
     * <p>
     * The updated status of the CA certificate.
     * </p>
     * <p>
     * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #newStatus} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #newStatusAsString}.
     * </p>
     * 
     * @return The updated status of the CA certificate.</p>
     *         <p>
     *         <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
     * @see CACertificateStatus
     */
    public String newStatusAsString() {
        return newStatus;
    }

    /**
     * <p>
     * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newAutoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newAutoRegistrationStatusAsString}.
     * </p>
     * 
     * @return The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * @see AutoRegistrationStatus
     */
    public AutoRegistrationStatus newAutoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(newAutoRegistrationStatus);
    }

    /**
     * <p>
     * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newAutoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newAutoRegistrationStatusAsString}.
     * </p>
     * 
     * @return The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
     * @see AutoRegistrationStatus
     */
    public String newAutoRegistrationStatusAsString() {
        return newAutoRegistrationStatus;
    }

    /**
     * <p>
     * Information about the registration configuration.
     * </p>
     * 
     * @return Information about the registration configuration.
     */
    public RegistrationConfig registrationConfig() {
        return registrationConfig;
    }

    /**
     * <p>
     * If true, removes auto registration.
     * </p>
     * 
     * @return If true, removes auto registration.
     */
    public Boolean removeAutoRegistration() {
        return removeAutoRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(newStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(newAutoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(registrationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(removeAutoRegistration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaCertificateRequest)) {
            return false;
        }
        UpdateCaCertificateRequest other = (UpdateCaCertificateRequest) obj;
        return Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(newStatusAsString(), other.newStatusAsString())
                && Objects.equals(newAutoRegistrationStatusAsString(), other.newAutoRegistrationStatusAsString())
                && Objects.equals(registrationConfig(), other.registrationConfig())
                && Objects.equals(removeAutoRegistration(), other.removeAutoRegistration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCaCertificateRequest").add("CertificateId", certificateId())
                .add("NewStatus", newStatusAsString()).add("NewAutoRegistrationStatus", newAutoRegistrationStatusAsString())
                .add("RegistrationConfig", registrationConfig()).add("RemoveAutoRegistration", removeAutoRegistration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "newStatus":
            return Optional.ofNullable(clazz.cast(newStatusAsString()));
        case "newAutoRegistrationStatus":
            return Optional.ofNullable(clazz.cast(newAutoRegistrationStatusAsString()));
        case "registrationConfig":
            return Optional.ofNullable(clazz.cast(registrationConfig()));
        case "removeAutoRegistration":
            return Optional.ofNullable(clazz.cast(removeAutoRegistration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaCertificateRequest, T> g) {
        return obj -> g.apply((UpdateCaCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCaCertificateRequest> {
        /**
         * <p>
         * The CA certificate identifier.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The updated status of the CA certificate.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The updated status of the CA certificate.</p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder newStatus(String newStatus);

        /**
         * <p>
         * The updated status of the CA certificate.
         * </p>
         * <p>
         * <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * </p>
         * 
         * @param newStatus
         *        The updated status of the CA certificate.</p>
         *        <p>
         *        <b>Note:</b> The status value REGISTER_INACTIVE is deprecated and should not be used.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder newStatus(CACertificateStatus newStatus);

        /**
         * <p>
         * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * </p>
         * 
         * @param newAutoRegistrationStatus
         *        The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder newAutoRegistrationStatus(String newAutoRegistrationStatus);

        /**
         * <p>
         * The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * </p>
         * 
         * @param newAutoRegistrationStatus
         *        The new value for the auto registration status. Valid values are: "ENABLE" or "DISABLE".
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus);

        /**
         * <p>
         * Information about the registration configuration.
         * </p>
         * 
         * @param registrationConfig
         *        Information about the registration configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationConfig(RegistrationConfig registrationConfig);

        /**
         * <p>
         * Information about the registration configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link RegistrationConfig.Builder} avoiding the need to
         * create one manually via {@link RegistrationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistrationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #registrationConfig(RegistrationConfig)}.
         * 
         * @param registrationConfig
         *        a consumer that will call methods on {@link RegistrationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationConfig(RegistrationConfig)
         */
        default Builder registrationConfig(Consumer<RegistrationConfig.Builder> registrationConfig) {
            return registrationConfig(RegistrationConfig.builder().applyMutation(registrationConfig).build());
        }

        /**
         * <p>
         * If true, removes auto registration.
         * </p>
         * 
         * @param removeAutoRegistration
         *        If true, removes auto registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAutoRegistration(Boolean removeAutoRegistration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateId;

        private String newStatus;

        private String newAutoRegistrationStatus;

        private RegistrationConfig registrationConfig;

        private Boolean removeAutoRegistration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaCertificateRequest model) {
            super(model);
            certificateId(model.certificateId);
            newStatus(model.newStatus);
            newAutoRegistrationStatus(model.newAutoRegistrationStatus);
            registrationConfig(model.registrationConfig);
            removeAutoRegistration(model.removeAutoRegistration);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getNewStatusAsString() {
            return newStatus;
        }

        @Override
        public final Builder newStatus(String newStatus) {
            this.newStatus = newStatus;
            return this;
        }

        @Override
        public final Builder newStatus(CACertificateStatus newStatus) {
            this.newStatus(newStatus == null ? null : newStatus.toString());
            return this;
        }

        public final void setNewStatus(String newStatus) {
            this.newStatus = newStatus;
        }

        public final String getNewAutoRegistrationStatusAsString() {
            return newAutoRegistrationStatus;
        }

        @Override
        public final Builder newAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder newAutoRegistrationStatus(AutoRegistrationStatus newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus(newAutoRegistrationStatus == null ? null : newAutoRegistrationStatus.toString());
            return this;
        }

        public final void setNewAutoRegistrationStatus(String newAutoRegistrationStatus) {
            this.newAutoRegistrationStatus = newAutoRegistrationStatus;
        }

        public final RegistrationConfig.Builder getRegistrationConfig() {
            return registrationConfig != null ? registrationConfig.toBuilder() : null;
        }

        @Override
        public final Builder registrationConfig(RegistrationConfig registrationConfig) {
            this.registrationConfig = registrationConfig;
            return this;
        }

        public final void setRegistrationConfig(RegistrationConfig.BuilderImpl registrationConfig) {
            this.registrationConfig = registrationConfig != null ? registrationConfig.build() : null;
        }

        public final Boolean getRemoveAutoRegistration() {
            return removeAutoRegistration;
        }

        @Override
        public final Builder removeAutoRegistration(Boolean removeAutoRegistration) {
            this.removeAutoRegistration = removeAutoRegistration;
            return this;
        }

        public final void setRemoveAutoRegistration(Boolean removeAutoRegistration) {
            this.removeAutoRegistration = removeAutoRegistration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCaCertificateRequest build() {
            return new UpdateCaCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
