/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventConfigurationsRequest extends IotRequest implements
        ToCopyableBuilder<UpdateEventConfigurationsRequest.Builder, UpdateEventConfigurationsRequest> {
    private static final SdkField<Map<String, Configuration>> EVENT_CONFIGURATIONS_FIELD = SdkField
            .<Map<String, Configuration>> builder(MarshallingType.MAP)
            .getter(getter(UpdateEventConfigurationsRequest::eventConfigurationsAsStrings))
            .setter(setter(Builder::eventConfigurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONFIGURATIONS_FIELD));

    private final Map<String, Configuration> eventConfigurations;

    private UpdateEventConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.eventConfigurations = builder.eventConfigurations;
    }

    /**
     * <p>
     * The new event configuration values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new event configuration values.
     */
    public Map<EventType, Configuration> eventConfigurations() {
        return EventConfigurationsCopier.copyStringToEnum(eventConfigurations);
    }

    /**
     * Returns true if the EventConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventConfigurations() {
        return eventConfigurations != null && !(eventConfigurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The new event configuration values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new event configuration values.
     */
    public Map<String, Configuration> eventConfigurationsAsStrings() {
        return eventConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventConfigurationsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventConfigurationsRequest)) {
            return false;
        }
        UpdateEventConfigurationsRequest other = (UpdateEventConfigurationsRequest) obj;
        return Objects.equals(eventConfigurationsAsStrings(), other.eventConfigurationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEventConfigurationsRequest").add("EventConfigurations", eventConfigurationsAsStrings())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventConfigurations":
            return Optional.ofNullable(clazz.cast(eventConfigurationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventConfigurationsRequest, T> g) {
        return obj -> g.apply((UpdateEventConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventConfigurationsRequest> {
        /**
         * <p>
         * The new event configuration values.
         * </p>
         * 
         * @param eventConfigurations
         *        The new event configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations);

        /**
         * <p>
         * The new event configuration values.
         * </p>
         * 
         * @param eventConfigurations
         *        The new event configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Map<String, Configuration> eventConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventConfigurationsRequest model) {
            super(model);
            eventConfigurationsWithStrings(model.eventConfigurations);
        }

        public final Map<String, Configuration.Builder> getEventConfigurationsAsStrings() {
            return eventConfigurations != null ? CollectionUtils.mapValues(eventConfigurations, Configuration::toBuilder) : null;
        }

        @Override
        public final Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        public final Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyEnumToString(eventConfigurations);
            return this;
        }

        public final void setEventConfigurationsWithStrings(Map<String, Configuration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventConfigurationsRequest build() {
            return new UpdateEventConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
