/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SigV4Authorization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SigV4Authorization> {
    private static final SdkField<String> SIGNING_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigV4Authorization.getter(SigV4Authorization::signingRegion)).setter(SigV4Authorization.setter(Builder::signingRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingRegion").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigV4Authorization.getter(SigV4Authorization::serviceName)).setter(SigV4Authorization.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SigV4Authorization.getter(SigV4Authorization::roleArn)).setter(SigV4Authorization.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_REGION_FIELD, SERVICE_NAME_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String signingRegion;
    private final String serviceName;
    private final String roleArn;

    private SigV4Authorization(BuilderImpl builder) {
        this.signingRegion = builder.signingRegion;
        this.serviceName = builder.serviceName;
        this.roleArn = builder.roleArn;
    }

    public String signingRegion() {
        return this.signingRegion;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigV4Authorization)) {
            return false;
        }
        SigV4Authorization other = (SigV4Authorization)obj;
        return Objects.equals(this.signingRegion(), other.signingRegion()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"SigV4Authorization").add("SigningRegion", (Object)this.signingRegion()).add("ServiceName", (Object)this.serviceName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signingRegion": {
                return Optional.ofNullable(clazz.cast(this.signingRegion()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigV4Authorization, T> g) {
        return obj -> g.apply((SigV4Authorization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String signingRegion;
        private String serviceName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SigV4Authorization model) {
            this.signingRegion(model.signingRegion);
            this.serviceName(model.serviceName);
            this.roleArn(model.roleArn);
        }

        public final String getSigningRegion() {
            return this.signingRegion;
        }

        @Override
        public final Builder signingRegion(String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        public final void setSigningRegion(String signingRegion) {
            this.signingRegion = signingRegion;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public SigV4Authorization build() {
            return new SigV4Authorization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SigV4Authorization> {
        public Builder signingRegion(String var1);

        public Builder serviceName(String var1);

        public Builder roleArn(String var1);
    }
}

