/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListV2LoggingLevelsResponse extends IotResponse implements
        ToCopyableBuilder<ListV2LoggingLevelsResponse.Builder, ListV2LoggingLevelsResponse> {
    private static final SdkField<List<LogTargetConfiguration>> LOG_TARGET_CONFIGURATIONS_FIELD = SdkField
            .<List<LogTargetConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ListV2LoggingLevelsResponse::logTargetConfigurations))
            .setter(setter(Builder::logTargetConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTargetConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogTargetConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogTargetConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListV2LoggingLevelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOG_TARGET_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<LogTargetConfiguration> logTargetConfigurations;

    private final String nextToken;

    private ListV2LoggingLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.logTargetConfigurations = builder.logTargetConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LogTargetConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLogTargetConfigurations() {
        return logTargetConfigurations != null && !(logTargetConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logging configuration for a target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogTargetConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The logging configuration for a target.
     */
    public List<LogTargetConfiguration> logTargetConfigurations() {
        return logTargetConfigurations;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logTargetConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListV2LoggingLevelsResponse)) {
            return false;
        }
        ListV2LoggingLevelsResponse other = (ListV2LoggingLevelsResponse) obj;
        return Objects.equals(logTargetConfigurations(), other.logTargetConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListV2LoggingLevelsResponse").add("LogTargetConfigurations", logTargetConfigurations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logTargetConfigurations":
            return Optional.ofNullable(clazz.cast(logTargetConfigurations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListV2LoggingLevelsResponse, T> g) {
        return obj -> g.apply((ListV2LoggingLevelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListV2LoggingLevelsResponse> {
        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * 
         * @param logTargetConfigurations
         *        The logging configuration for a target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations);

        /**
         * <p>
         * The logging configuration for a target.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LogTargetConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<LogTargetConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LogTargetConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #logTargetConfigurations(List<LogTargetConfiguration>)}.
         * 
         * @param logTargetConfigurations
         *        a consumer that will call methods on {@link List<LogTargetConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logTargetConfigurations(List<LogTargetConfiguration>)
         */
        Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<LogTargetConfiguration> logTargetConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListV2LoggingLevelsResponse model) {
            super(model);
            logTargetConfigurations(model.logTargetConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<LogTargetConfiguration.Builder> getLogTargetConfigurations() {
            return logTargetConfigurations != null ? logTargetConfigurations.stream().map(LogTargetConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logTargetConfigurations(Collection<LogTargetConfiguration> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copy(logTargetConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(LogTargetConfiguration... logTargetConfigurations) {
            logTargetConfigurations(Arrays.asList(logTargetConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTargetConfigurations(Consumer<LogTargetConfiguration.Builder>... logTargetConfigurations) {
            logTargetConfigurations(Stream.of(logTargetConfigurations)
                    .map(c -> LogTargetConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogTargetConfigurations(Collection<LogTargetConfiguration.BuilderImpl> logTargetConfigurations) {
            this.logTargetConfigurations = LogTargetConfigurationsCopier.copyFromBuilder(logTargetConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListV2LoggingLevelsResponse build() {
            return new ListV2LoggingLevelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
