/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that identifies the noncompliant resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIdentifier.Builder, ResourceIdentifier> {
    private static final SdkField<String> DEVICE_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::deviceCertificateId)).setter(setter(Builder::deviceCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCertificateId").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::caCertificateId)).setter(setter(Builder::caCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateId").build()).build();

    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::cognitoIdentityPoolId)).setter(setter(Builder::cognitoIdentityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<PolicyVersionIdentifier> POLICY_VERSION_IDENTIFIER_FIELD = SdkField
            .<PolicyVersionIdentifier> builder(MarshallingType.SDK_POJO)
            .getter(getter(ResourceIdentifier::policyVersionIdentifier)).setter(setter(Builder::policyVersionIdentifier))
            .constructor(PolicyVersionIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionIdentifier").build())
            .build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> ROLE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceIdentifier::roleAliasArn)).setter(setter(Builder::roleAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CERTIFICATE_ID_FIELD,
            CA_CERTIFICATE_ID_FIELD, COGNITO_IDENTITY_POOL_ID_FIELD, CLIENT_ID_FIELD, POLICY_VERSION_IDENTIFIER_FIELD,
            ACCOUNT_FIELD, IAM_ROLE_ARN_FIELD, ROLE_ALIAS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceCertificateId;

    private final String caCertificateId;

    private final String cognitoIdentityPoolId;

    private final String clientId;

    private final PolicyVersionIdentifier policyVersionIdentifier;

    private final String account;

    private final String iamRoleArn;

    private final String roleAliasArn;

    private ResourceIdentifier(BuilderImpl builder) {
        this.deviceCertificateId = builder.deviceCertificateId;
        this.caCertificateId = builder.caCertificateId;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.clientId = builder.clientId;
        this.policyVersionIdentifier = builder.policyVersionIdentifier;
        this.account = builder.account;
        this.iamRoleArn = builder.iamRoleArn;
        this.roleAliasArn = builder.roleAliasArn;
    }

    /**
     * <p>
     * The ID of the certificate attached to the resource.
     * </p>
     * 
     * @return The ID of the certificate attached to the resource.
     */
    public String deviceCertificateId() {
        return deviceCertificateId;
    }

    /**
     * <p>
     * The ID of the CA certificate used to authorize the certificate.
     * </p>
     * 
     * @return The ID of the CA certificate used to authorize the certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito identity pool.
     * </p>
     * 
     * @return The ID of the Amazon Cognito identity pool.
     */
    public String cognitoIdentityPoolId() {
        return cognitoIdentityPoolId;
    }

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @return The client ID.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The version of the policy associated with the resource.
     * </p>
     * 
     * @return The version of the policy associated with the resource.
     */
    public PolicyVersionIdentifier policyVersionIdentifier() {
        return policyVersionIdentifier;
    }

    /**
     * <p>
     * The account with which the resource is associated.
     * </p>
     * 
     * @return The account with which the resource is associated.
     */
    public String account() {
        return account;
    }

    /**
     * <p>
     * The ARN of the IAM role that has overly permissive actions.
     * </p>
     * 
     * @return The ARN of the IAM role that has overly permissive actions.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ARN of the role alias that has overly permissive actions.
     * </p>
     * 
     * @return The ARN of the role alias that has overly permissive actions.
     */
    public String roleAliasArn() {
        return roleAliasArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier) obj;
        return Objects.equals(deviceCertificateId(), other.deviceCertificateId())
                && Objects.equals(caCertificateId(), other.caCertificateId())
                && Objects.equals(cognitoIdentityPoolId(), other.cognitoIdentityPoolId())
                && Objects.equals(clientId(), other.clientId())
                && Objects.equals(policyVersionIdentifier(), other.policyVersionIdentifier())
                && Objects.equals(account(), other.account()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(roleAliasArn(), other.roleAliasArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceIdentifier").add("DeviceCertificateId", deviceCertificateId())
                .add("CaCertificateId", caCertificateId()).add("CognitoIdentityPoolId", cognitoIdentityPoolId())
                .add("ClientId", clientId()).add("PolicyVersionIdentifier", policyVersionIdentifier()).add("Account", account())
                .add("IamRoleArn", iamRoleArn()).add("RoleAliasArn", roleAliasArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceCertificateId":
            return Optional.ofNullable(clazz.cast(deviceCertificateId()));
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "cognitoIdentityPoolId":
            return Optional.ofNullable(clazz.cast(cognitoIdentityPoolId()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "policyVersionIdentifier":
            return Optional.ofNullable(clazz.cast(policyVersionIdentifier()));
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIdentifier> {
        /**
         * <p>
         * The ID of the certificate attached to the resource.
         * </p>
         * 
         * @param deviceCertificateId
         *        The ID of the certificate attached to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificateId(String deviceCertificateId);

        /**
         * <p>
         * The ID of the CA certificate used to authorize the certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The ID of the CA certificate used to authorize the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The ID of the Amazon Cognito identity pool.
         * </p>
         * 
         * @param cognitoIdentityPoolId
         *        The ID of the Amazon Cognito identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityPoolId(String cognitoIdentityPoolId);

        /**
         * <p>
         * The client ID.
         * </p>
         * 
         * @param clientId
         *        The client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * 
         * @param policyVersionIdentifier
         *        The version of the policy associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyVersionIdentifier.Builder} avoiding the
         * need to create one manually via {@link PolicyVersionIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyVersionIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #policyVersionIdentifier(PolicyVersionIdentifier)}.
         * 
         * @param policyVersionIdentifier
         *        a consumer that will call methods on {@link PolicyVersionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersionIdentifier(PolicyVersionIdentifier)
         */
        default Builder policyVersionIdentifier(Consumer<PolicyVersionIdentifier.Builder> policyVersionIdentifier) {
            return policyVersionIdentifier(PolicyVersionIdentifier.builder().applyMutation(policyVersionIdentifier).build());
        }

        /**
         * <p>
         * The account with which the resource is associated.
         * </p>
         * 
         * @param account
         *        The account with which the resource is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The ARN of the IAM role that has overly permissive actions.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that has overly permissive actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ARN of the role alias that has overly permissive actions.
         * </p>
         * 
         * @param roleAliasArn
         *        The ARN of the role alias that has overly permissive actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);
    }

    static final class BuilderImpl implements Builder {
        private String deviceCertificateId;

        private String caCertificateId;

        private String cognitoIdentityPoolId;

        private String clientId;

        private PolicyVersionIdentifier policyVersionIdentifier;

        private String account;

        private String iamRoleArn;

        private String roleAliasArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            deviceCertificateId(model.deviceCertificateId);
            caCertificateId(model.caCertificateId);
            cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            clientId(model.clientId);
            policyVersionIdentifier(model.policyVersionIdentifier);
            account(model.account);
            iamRoleArn(model.iamRoleArn);
            roleAliasArn(model.roleAliasArn);
        }

        public final String getDeviceCertificateId() {
            return deviceCertificateId;
        }

        @Override
        public final Builder deviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
            return this;
        }

        public final void setDeviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getCognitoIdentityPoolId() {
            return cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final PolicyVersionIdentifier.Builder getPolicyVersionIdentifier() {
            return policyVersionIdentifier != null ? policyVersionIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier;
            return this;
        }

        public final void setPolicyVersionIdentifier(PolicyVersionIdentifier.BuilderImpl policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier != null ? policyVersionIdentifier.build() : null;
        }

        public final String getAccount() {
            return account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        @Override
        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
