/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditMitigationActionsTasksRequest extends IotRequest implements
        ToCopyableBuilder<ListAuditMitigationActionsTasksRequest.Builder, ListAuditMitigationActionsTasksRequest> {
    private static final SdkField<String> AUDIT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsTasksRequest::auditTaskId)).setter(setter(Builder::auditTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("auditTaskId").build()).build();

    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsTasksRequest::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("findingId").build()).build();

    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsTasksRequest::taskStatusAsString)).setter(setter(Builder::taskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAuditMitigationActionsTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditMitigationActionsTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListAuditMitigationActionsTasksRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListAuditMitigationActionsTasksRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_TASK_ID_FIELD,
            FINDING_ID_FIELD, TASK_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private final String auditTaskId;

    private final String findingId;

    private final String taskStatus;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant startTime;

    private final Instant endTime;

    private ListAuditMitigationActionsTasksRequest(BuilderImpl builder) {
        super(builder);
        this.auditTaskId = builder.auditTaskId;
        this.findingId = builder.findingId;
        this.taskStatus = builder.taskStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that were applied to results for a specific audit.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that were applied to results for a specific audit.
     */
    public String auditTaskId() {
        return auditTaskId;
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that were applied to a specific audit finding.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that were applied to a specific audit finding.
     */
    public String findingId() {
        return findingId;
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that are in a specific state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that are in a specific state.
     * @see AuditMitigationActionsTaskStatus
     */
    public AuditMitigationActionsTaskStatus taskStatus() {
        return AuditMitigationActionsTaskStatus.fromValue(taskStatus);
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that are in a specific state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskStatus} will
     * return {@link AuditMitigationActionsTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskStatusAsString}.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that are in a specific state.
     * @see AuditMitigationActionsTaskStatus
     */
    public String taskStatusAsString() {
        return taskStatus;
    }

    /**
     * <p>
     * The maximum number of results to return at one time. The default is 25.
     * </p>
     * 
     * @return The maximum number of results to return at one time. The default is 25.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that began on or after a specific date and time.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that began on or after a specific date and time.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Specify this filter to limit results to tasks that were completed or canceled on or before a specific date and
     * time.
     * </p>
     * 
     * @return Specify this filter to limit results to tasks that were completed or canceled on or before a specific
     *         date and time.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(auditTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsTasksRequest)) {
            return false;
        }
        ListAuditMitigationActionsTasksRequest other = (ListAuditMitigationActionsTasksRequest) obj;
        return Objects.equals(auditTaskId(), other.auditTaskId()) && Objects.equals(findingId(), other.findingId())
                && Objects.equals(taskStatusAsString(), other.taskStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuditMitigationActionsTasksRequest").add("AuditTaskId", auditTaskId())
                .add("FindingId", findingId()).add("TaskStatus", taskStatusAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "auditTaskId":
            return Optional.ofNullable(clazz.cast(auditTaskId()));
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "taskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsTasksRequest, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAuditMitigationActionsTasksRequest> {
        /**
         * <p>
         * Specify this filter to limit results to tasks that were applied to results for a specific audit.
         * </p>
         * 
         * @param auditTaskId
         *        Specify this filter to limit results to tasks that were applied to results for a specific audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditTaskId(String auditTaskId);

        /**
         * <p>
         * Specify this filter to limit results to tasks that were applied to a specific audit finding.
         * </p>
         * 
         * @param findingId
         *        Specify this filter to limit results to tasks that were applied to a specific audit finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * Specify this filter to limit results to tasks that are in a specific state.
         * </p>
         * 
         * @param taskStatus
         *        Specify this filter to limit results to tasks that are in a specific state.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(String taskStatus);

        /**
         * <p>
         * Specify this filter to limit results to tasks that are in a specific state.
         * </p>
         * 
         * @param taskStatus
         *        Specify this filter to limit results to tasks that are in a specific state.
         * @see AuditMitigationActionsTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsTaskStatus
         */
        Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus);

        /**
         * <p>
         * The maximum number of results to return at one time. The default is 25.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time. The default is 25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify this filter to limit results to tasks that began on or after a specific date and time.
         * </p>
         * 
         * @param startTime
         *        Specify this filter to limit results to tasks that began on or after a specific date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Specify this filter to limit results to tasks that were completed or canceled on or before a specific date
         * and time.
         * </p>
         * 
         * @param endTime
         *        Specify this filter to limit results to tasks that were completed or canceled on or before a specific
         *        date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String auditTaskId;

        private String findingId;

        private String taskStatus;

        private Integer maxResults;

        private String nextToken;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsTasksRequest model) {
            super(model);
            auditTaskId(model.auditTaskId);
            findingId(model.findingId);
            taskStatus(model.taskStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getAuditTaskId() {
            return auditTaskId;
        }

        @Override
        public final Builder auditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
            return this;
        }

        public final void setAuditTaskId(String auditTaskId) {
            this.auditTaskId = auditTaskId;
        }

        public final String getFindingId() {
            return findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        public final String getTaskStatus() {
            return taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuditMitigationActionsTasksRequest build() {
            return new ListAuditMitigationActionsTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
