/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPercentilesRequest extends IotRequest implements
        ToCopyableBuilder<GetPercentilesRequest.Builder, GetPercentilesRequest> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPercentilesRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPercentilesRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<String> AGGREGATION_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPercentilesRequest::aggregationField)).setter(setter(Builder::aggregationField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationField").build()).build();

    private static final SdkField<String> QUERY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPercentilesRequest::queryVersion)).setter(setter(Builder::queryVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryVersion").build()).build();

    private static final SdkField<List<Double>> PERCENTS_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .getter(getter(GetPercentilesRequest::percents))
            .setter(setter(Builder::percents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            QUERY_STRING_FIELD, AGGREGATION_FIELD_FIELD, QUERY_VERSION_FIELD, PERCENTS_FIELD));

    private final String indexName;

    private final String queryString;

    private final String aggregationField;

    private final String queryVersion;

    private final List<Double> percents;

    private GetPercentilesRequest(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.queryString = builder.queryString;
        this.aggregationField = builder.aggregationField;
        this.queryVersion = builder.queryVersion;
        this.percents = builder.percents;
    }

    /**
     * <p>
     * The name of the index to search.
     * </p>
     * 
     * @return The name of the index to search.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The query string.
     * </p>
     * 
     * @return The query string.
     */
    public String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The field to aggregate.
     * </p>
     * 
     * @return The field to aggregate.
     */
    public String aggregationField() {
        return aggregationField;
    }

    /**
     * <p>
     * The query version.
     * </p>
     * 
     * @return The query version.
     */
    public String queryVersion() {
        return queryVersion;
    }

    /**
     * Returns true if the Percents property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPercents() {
        return percents != null && !(percents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The percentile groups returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPercents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The percentile groups returned.
     */
    public List<Double> percents() {
        return percents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationField());
        hashCode = 31 * hashCode + Objects.hashCode(queryVersion());
        hashCode = 31 * hashCode + Objects.hashCode(percents());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPercentilesRequest)) {
            return false;
        }
        GetPercentilesRequest other = (GetPercentilesRequest) obj;
        return Objects.equals(indexName(), other.indexName()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(aggregationField(), other.aggregationField())
                && Objects.equals(queryVersion(), other.queryVersion()) && Objects.equals(percents(), other.percents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPercentilesRequest").add("IndexName", indexName()).add("QueryString", queryString())
                .add("AggregationField", aggregationField()).add("QueryVersion", queryVersion()).add("Percents", percents())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "aggregationField":
            return Optional.ofNullable(clazz.cast(aggregationField()));
        case "queryVersion":
            return Optional.ofNullable(clazz.cast(queryVersion()));
        case "percents":
            return Optional.ofNullable(clazz.cast(percents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPercentilesRequest, T> g) {
        return obj -> g.apply((GetPercentilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPercentilesRequest> {
        /**
         * <p>
         * The name of the index to search.
         * </p>
         * 
         * @param indexName
         *        The name of the index to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The query string.
         * </p>
         * 
         * @param queryString
         *        The query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The field to aggregate.
         * </p>
         * 
         * @param aggregationField
         *        The field to aggregate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationField(String aggregationField);

        /**
         * <p>
         * The query version.
         * </p>
         * 
         * @param queryVersion
         *        The query version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryVersion(String queryVersion);

        /**
         * <p>
         * The percentile groups returned.
         * </p>
         * 
         * @param percents
         *        The percentile groups returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percents(Collection<Double> percents);

        /**
         * <p>
         * The percentile groups returned.
         * </p>
         * 
         * @param percents
         *        The percentile groups returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percents(Double... percents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String indexName;

        private String queryString;

        private String aggregationField;

        private String queryVersion;

        private List<Double> percents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPercentilesRequest model) {
            super(model);
            indexName(model.indexName);
            queryString(model.queryString);
            aggregationField(model.aggregationField);
            queryVersion(model.queryVersion);
            percents(model.percents);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getAggregationField() {
            return aggregationField;
        }

        @Override
        public final Builder aggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
            return this;
        }

        public final void setAggregationField(String aggregationField) {
            this.aggregationField = aggregationField;
        }

        public final String getQueryVersion() {
            return queryVersion;
        }

        @Override
        public final Builder queryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
            return this;
        }

        public final void setQueryVersion(String queryVersion) {
            this.queryVersion = queryVersion;
        }

        public final Collection<Double> getPercents() {
            return percents;
        }

        @Override
        public final Builder percents(Collection<Double> percents) {
            this.percents = PercentListCopier.copy(percents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder percents(Double... percents) {
            percents(Arrays.asList(percents));
            return this;
        }

        public final void setPercents(Collection<Double> percents) {
            this.percents = PercentListCopier.copy(percents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPercentilesRequest build() {
            return new GetPercentilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
