/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned by ListAuditMitigationActionsTask, this object contains information that describes a mitigation action that
 * has been started.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditMitigationActionExecutionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditMitigationActionExecutionMetadata.Builder, AuditMitigationActionExecutionMetadata> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()).build();

    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AuditMitigationActionExecutionMetadata::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AuditMitigationActionExecutionMetadata::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditMitigationActionExecutionMetadata::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD,
            FINDING_ID_FIELD, ACTION_NAME_FIELD, ACTION_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            ERROR_CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskId;

    private final String findingId;

    private final String actionName;

    private final String actionId;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String errorCode;

    private final String message;

    private AuditMitigationActionExecutionMetadata(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.findingId = builder.findingId;
        this.actionName = builder.actionName;
        this.actionId = builder.actionId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The unique identifier for the task that applies the mitigation action.
     * </p>
     * 
     * @return The unique identifier for the task that applies the mitigation action.
     */
    public String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The unique identifier for the findings to which the task and associated mitigation action are applied.
     * </p>
     * 
     * @return The unique identifier for the findings to which the task and associated mitigation action are applied.
     */
    public String findingId() {
        return findingId;
    }

    /**
     * <p>
     * The friendly name of the mitigation action being applied by the task.
     * </p>
     * 
     * @return The friendly name of the mitigation action being applied by the task.
     */
    public String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The unique identifier for the mitigation action being applied by the task.
     * </p>
     * 
     * @return The unique identifier for the mitigation action being applied by the task.
     */
    public String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The current status of the task being executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuditMitigationActionsExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task being executed.
     * @see AuditMitigationActionsExecutionStatus
     */
    public AuditMitigationActionsExecutionStatus status() {
        return AuditMitigationActionsExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the task being executed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuditMitigationActionsExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the task being executed.
     * @see AuditMitigationActionsExecutionStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the task was started.
     * </p>
     * 
     * @return The date and time when the task was started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the task was completed or canceled. Blank if the task is still running.
     * </p>
     * 
     * @return The date and time when the task was completed or canceled. Blank if the task is still running.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If an error occurred, the code that indicates which type of error occurred.
     * </p>
     * 
     * @return If an error occurred, the code that indicates which type of error occurred.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * If an error occurred, a message that describes the error.
     * </p>
     * 
     * @return If an error occurred, a message that describes the error.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionExecutionMetadata)) {
            return false;
        }
        AuditMitigationActionExecutionMetadata other = (AuditMitigationActionExecutionMetadata) obj;
        return Objects.equals(taskId(), other.taskId()) && Objects.equals(findingId(), other.findingId())
                && Objects.equals(actionName(), other.actionName()) && Objects.equals(actionId(), other.actionId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuditMitigationActionExecutionMetadata").add("TaskId", taskId()).add("FindingId", findingId())
                .add("ActionName", actionName()).add("ActionId", actionId()).add("Status", statusAsString())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("ErrorCode", errorCode()).add("Message", message())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "actionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionExecutionMetadata, T> g) {
        return obj -> g.apply((AuditMitigationActionExecutionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditMitigationActionExecutionMetadata> {
        /**
         * <p>
         * The unique identifier for the task that applies the mitigation action.
         * </p>
         * 
         * @param taskId
         *        The unique identifier for the task that applies the mitigation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The unique identifier for the findings to which the task and associated mitigation action are applied.
         * </p>
         * 
         * @param findingId
         *        The unique identifier for the findings to which the task and associated mitigation action are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * The friendly name of the mitigation action being applied by the task.
         * </p>
         * 
         * @param actionName
         *        The friendly name of the mitigation action being applied by the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The unique identifier for the mitigation action being applied by the task.
         * </p>
         * 
         * @param actionId
         *        The unique identifier for the mitigation action being applied by the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The current status of the task being executed.
         * </p>
         * 
         * @param status
         *        The current status of the task being executed.
         * @see AuditMitigationActionsExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the task being executed.
         * </p>
         * 
         * @param status
         *        The current status of the task being executed.
         * @see AuditMitigationActionsExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditMitigationActionsExecutionStatus
         */
        Builder status(AuditMitigationActionsExecutionStatus status);

        /**
         * <p>
         * The date and time when the task was started.
         * </p>
         * 
         * @param startTime
         *        The date and time when the task was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the task was completed or canceled. Blank if the task is still running.
         * </p>
         * 
         * @param endTime
         *        The date and time when the task was completed or canceled. Blank if the task is still running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If an error occurred, the code that indicates which type of error occurred.
         * </p>
         * 
         * @param errorCode
         *        If an error occurred, the code that indicates which type of error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * If an error occurred, a message that describes the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, a message that describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String taskId;

        private String findingId;

        private String actionName;

        private String actionId;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionExecutionMetadata model) {
            taskId(model.taskId);
            findingId(model.findingId);
            actionName(model.actionName);
            actionId(model.actionId);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getTaskId() {
            return taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final String getFindingId() {
            return findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        public final String getActionName() {
            return actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final String getActionId() {
            return actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuditMitigationActionsExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public AuditMitigationActionExecutionMetadata build() {
            return new AuditMitigationActionExecutionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
