/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProvisioningTemplateVersionResponse extends IotResponse implements
        ToCopyableBuilder<CreateProvisioningTemplateVersionResponse.Builder, CreateProvisioningTemplateVersionResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProvisioningTemplateVersionResponse::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProvisioningTemplateVersionResponse::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateName").build()).build();

    private static final SdkField<Integer> VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateProvisioningTemplateVersionResponse::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateProvisioningTemplateVersionResponse::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDefaultVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD));

    private final String templateArn;

    private final String templateName;

    private final Integer versionId;

    private final Boolean isDefaultVersion;

    private CreateProvisioningTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.versionId = builder.versionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The ARN that identifies the provisioning template.
     * </p>
     * 
     * @return The ARN that identifies the provisioning template.
     */
    public String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The name of the fleet provisioning template.
     * </p>
     * 
     * @return The name of the fleet provisioning template.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The version of the fleet provisioning template.
     * </p>
     * 
     * @return The version of the fleet provisioning template.
     */
    public Integer versionId() {
        return versionId;
    }

    /**
     * <p>
     * True if the fleet provisioning template version is the default version, otherwise false.
     * </p>
     * 
     * @return True if the fleet provisioning template version is the default version, otherwise false.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningTemplateVersionResponse)) {
            return false;
        }
        CreateProvisioningTemplateVersionResponse other = (CreateProvisioningTemplateVersionResponse) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProvisioningTemplateVersionResponse").add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("VersionId", versionId()).add("IsDefaultVersion", isDefaultVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "templateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "versionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "isDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateProvisioningTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateProvisioningTemplateVersionResponse> {
        /**
         * <p>
         * The ARN that identifies the provisioning template.
         * </p>
         * 
         * @param templateArn
         *        The ARN that identifies the provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The name of the fleet provisioning template.
         * </p>
         * 
         * @param templateName
         *        The name of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The version of the fleet provisioning template.
         * </p>
         * 
         * @param versionId
         *        The version of the fleet provisioning template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(Integer versionId);

        /**
         * <p>
         * True if the fleet provisioning template version is the default version, otherwise false.
         * </p>
         * 
         * @param isDefaultVersion
         *        True if the fleet provisioning template version is the default version, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String templateArn;

        private String templateName;

        private Integer versionId;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningTemplateVersionResponse model) {
            super(model);
            templateArn(model.templateArn);
            templateName(model.templateName);
            versionId(model.versionId);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final Integer getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(Integer versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(Integer versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public CreateProvisioningTemplateVersionResponse build() {
            return new CreateProvisioningTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
