/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupResponse;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse;
import software.amazon.awssdk.services.iot.model.AttachPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.CancelJobRequest;
import software.amazon.awssdk.services.iot.model.CancelJobResponse;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateDimensionRequest;
import software.amazon.awssdk.services.iot.model.CreateDimensionResponse;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.services.iot.model.CreateJobResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.services.iot.model.CreateStreamResponse;
import software.amazon.awssdk.services.iot.model.CreateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteDimensionRequest;
import software.amazon.awssdk.services.iot.model.DeleteDimensionResponse;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobResponse;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DeleteStreamRequest;
import software.amazon.awssdk.services.iot.model.DeleteStreamResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeDimensionRequest;
import software.amazon.awssdk.services.iot.model.DescribeDimensionResponse;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.DescribeIndexRequest;
import software.amazon.awssdk.services.iot.model.DescribeIndexResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobResponse;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DescribeStreamRequest;
import software.amazon.awssdk.services.iot.model.DescribeStreamResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetCardinalityRequest;
import software.amazon.awssdk.services.iot.model.GetCardinalityResponse;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetJobDocumentRequest;
import software.amazon.awssdk.services.iot.model.GetJobDocumentResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.GetPercentilesRequest;
import software.amazon.awssdk.services.iot.model.GetPercentilesResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetStatisticsRequest;
import software.amazon.awssdk.services.iot.model.GetStatisticsResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListJobsRequest;
import software.amazon.awssdk.services.iot.model.ListJobsResponse;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse;
import software.amazon.awssdk.services.iot.model.RegisterThingRequest;
import software.amazon.awssdk.services.iot.model.RegisterThingResponse;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.SearchIndexRequest;
import software.amazon.awssdk.services.iot.model.SearchIndexResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.TagResourceRequest;
import software.amazon.awssdk.services.iot.model.TagResourceResponse;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.services.iot.model.TestAuthorizationResponse;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateCACertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateDimensionRequest;
import software.amazon.awssdk.services.iot.model.UpdateDimensionResponse;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateJobRequest;
import software.amazon.awssdk.services.iot.model.UpdateJobResponse;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.UpdateStreamRequest;
import software.amazon.awssdk.services.iot.model.UpdateStreamResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse;

/**
 * Service client for accessing AWS IoT asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS IoT</fullname>
 * <p>
 * AWS IoT provides secure, bi-directional communication between Internet-connected devices (such as sensors, actuators,
 * embedded devices, or smart appliances) and the AWS cloud. You can discover your custom IoT-Data endpoint to
 * communicate with, configure rules for data processing and integration with other services, organize resources
 * associated with each device (Registry), configure logging, and create and manage policies and credentials to
 * authenticate devices.
 * </p>
 * <p>
 * The service endpoints that expose this API are listed in <a
 * href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html">AWS IoT Core Endpoints and Quotas</a>. You must
 * use the endpoint for the region that has the resources you want to access.
 * </p>
 * <p>
 * The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">AWS
 * Signature Version 4</a> to sign the request is: <i>execute-api</i>.
 * </p>
 * <p>
 * For more information about how AWS IoT works, see the <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">Developer Guide</a>.
 * </p>
 * <p>
 * For information about how to use the credentials provider for AWS IoT, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html">Authorizing Direct Calls to
 * AWS Services</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface IotAsyncClient extends SdkClient {
    String SERVICE_NAME = "execute-api";

    /**
     * Create a {@link IotAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IotAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IotAsyncClient}.
     */
    static IotAsyncClientBuilder builder() {
        return new DefaultIotAsyncClientBuilder();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return A Java Future containing the result of the AcceptCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AcceptCertificateTransfer
     */
    default CompletableFuture<AcceptCertificateTransferResponse> acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptCertificateTransferRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptCertificateTransferRequest#builder()}
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        A {@link Consumer} that will call methods on {@link AcceptCertificateTransferRequest.Builder} to create a
     *        request. The input for the AcceptCertificateTransfer operation.
     * @return A Java Future containing the result of the AcceptCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AcceptCertificateTransfer
     */
    default CompletableFuture<AcceptCertificateTransferResponse> acceptCertificateTransfer(
            Consumer<AcceptCertificateTransferRequest.Builder> acceptCertificateTransferRequest) {
        return acceptCertificateTransfer(AcceptCertificateTransferRequest.builder()
                .applyMutation(acceptCertificateTransferRequest).build());
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     *
     * @param addThingToBillingGroupRequest
     * @return A Java Future containing the result of the AddThingToBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToBillingGroup
     */
    default CompletableFuture<AddThingToBillingGroupResponse> addThingToBillingGroup(
            AddThingToBillingGroupRequest addThingToBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddThingToBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AddThingToBillingGroupRequest#builder()}
     * </p>
     *
     * @param addThingToBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link AddThingToBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddThingToBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToBillingGroup
     */
    default CompletableFuture<AddThingToBillingGroupResponse> addThingToBillingGroup(
            Consumer<AddThingToBillingGroupRequest.Builder> addThingToBillingGroupRequest) {
        return addThingToBillingGroup(AddThingToBillingGroupRequest.builder().applyMutation(addThingToBillingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     *
     * @param addThingToThingGroupRequest
     * @return A Java Future containing the result of the AddThingToThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToThingGroup
     */
    default CompletableFuture<AddThingToThingGroupResponse> addThingToThingGroup(
            AddThingToThingGroupRequest addThingToThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddThingToThingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AddThingToThingGroupRequest#builder()}
     * </p>
     *
     * @param addThingToThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link AddThingToThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddThingToThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AddThingToThingGroup
     */
    default CompletableFuture<AddThingToThingGroupResponse> addThingToThingGroup(
            Consumer<AddThingToThingGroupRequest.Builder> addThingToThingGroupRequest) {
        return addThingToThingGroup(AddThingToThingGroupRequest.builder().applyMutation(addThingToThingGroupRequest).build());
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateTargetsWithJobRequest
     * @return A Java Future containing the result of the AssociateTargetsWithJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AssociateTargetsWithJob
     */
    default CompletableFuture<AssociateTargetsWithJobResponse> associateTargetsWithJob(
            AssociateTargetsWithJobRequest associateTargetsWithJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTargetsWithJobRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTargetsWithJobRequest#builder()}
     * </p>
     *
     * @param associateTargetsWithJobRequest
     *        A {@link Consumer} that will call methods on {@link AssociateTargetsWithJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateTargetsWithJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AssociateTargetsWithJob
     */
    default CompletableFuture<AssociateTargetsWithJobResponse> associateTargetsWithJob(
            Consumer<AssociateTargetsWithJobRequest.Builder> associateTargetsWithJobRequest) {
        return associateTargetsWithJob(AssociateTargetsWithJobRequest.builder().applyMutation(associateTargetsWithJobRequest)
                .build());
    }

    /**
     * <p>
     * Attaches a policy to the specified target.
     * </p>
     *
     * @param attachPolicyRequest
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachPolicy
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a policy to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link AttachPolicyRequest#builder()}
     * </p>
     *
     * @param attachPolicyRequest
     *        A {@link Consumer} that will call methods on {@link AttachPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AttachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachPolicy
     */
    default CompletableFuture<AttachPolicyResponse> attachPolicy(Consumer<AttachPolicyRequest.Builder> attachPolicyRequest) {
        return attachPolicy(AttachPolicyRequest.builder().applyMutation(attachPolicyRequest).build());
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     *
     * @param attachSecurityProfileRequest
     * @return A Java Future containing the result of the AttachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachSecurityProfile
     */
    default CompletableFuture<AttachSecurityProfileResponse> attachSecurityProfile(
            AttachSecurityProfileRequest attachSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link AttachSecurityProfileRequest#builder()}
     * </p>
     *
     * @param attachSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link AttachSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachSecurityProfile
     */
    default CompletableFuture<AttachSecurityProfileResponse> attachSecurityProfile(
            Consumer<AttachSecurityProfileRequest.Builder> attachSecurityProfileRequest) {
        return attachSecurityProfile(AttachSecurityProfileRequest.builder().applyMutation(attachSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return A Java Future containing the result of the AttachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachThingPrincipal
     */
    default CompletableFuture<AttachThingPrincipalResponse> attachThingPrincipal(
            AttachThingPrincipalRequest attachThingPrincipalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachThingPrincipalRequest.Builder} avoiding the
     * need to create one manually via {@link AttachThingPrincipalRequest#builder()}
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        A {@link Consumer} that will call methods on {@link AttachThingPrincipalRequest.Builder} to create a
     *        request. The input for the AttachThingPrincipal operation.
     * @return A Java Future containing the result of the AttachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.AttachThingPrincipal
     */
    default CompletableFuture<AttachThingPrincipalResponse> attachThingPrincipal(
            Consumer<AttachThingPrincipalRequest.Builder> attachThingPrincipalRequest) {
        return attachThingPrincipal(AttachThingPrincipalRequest.builder().applyMutation(attachThingPrincipalRequest).build());
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the CancelAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditMitigationActionsTask
     */
    default CompletableFuture<CancelAuditMitigationActionsTaskResponse> cancelAuditMitigationActionsTask(
            CancelAuditMitigationActionsTaskRequest cancelAuditMitigationActionsTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAuditMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link CancelAuditMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelAuditMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditMitigationActionsTask
     */
    default CompletableFuture<CancelAuditMitigationActionsTaskResponse> cancelAuditMitigationActionsTask(
            Consumer<CancelAuditMitigationActionsTaskRequest.Builder> cancelAuditMitigationActionsTaskRequest) {
        return cancelAuditMitigationActionsTask(CancelAuditMitigationActionsTaskRequest.builder()
                .applyMutation(cancelAuditMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on-demand. If the audit is not in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     *
     * @param cancelAuditTaskRequest
     * @return A Java Future containing the result of the CancelAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditTask
     */
    default CompletableFuture<CancelAuditTaskResponse> cancelAuditTask(CancelAuditTaskRequest cancelAuditTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on-demand. If the audit is not in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAuditTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelAuditTaskRequest#builder()}
     * </p>
     *
     * @param cancelAuditTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelAuditTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelAuditTask
     */
    default CompletableFuture<CancelAuditTaskResponse> cancelAuditTask(
            Consumer<CancelAuditTaskRequest.Builder> cancelAuditTaskRequest) {
        return cancelAuditTask(CancelAuditTaskRequest.builder().applyMutation(cancelAuditTaskRequest).build());
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return A Java Future containing the result of the CancelCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelCertificateTransfer
     */
    default CompletableFuture<CancelCertificateTransferResponse> cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, AWS IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCertificateTransferRequest.Builder} avoiding
     * the need to create one manually via {@link CancelCertificateTransferRequest#builder()}
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        A {@link Consumer} that will call methods on {@link CancelCertificateTransferRequest.Builder} to create a
     *        request. The input for the CancelCertificateTransfer operation.
     * @return A Java Future containing the result of the CancelCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelCertificateTransfer
     */
    default CompletableFuture<CancelCertificateTransferResponse> cancelCertificateTransfer(
            Consumer<CancelCertificateTransferRequest.Builder> cancelCertificateTransferRequest) {
        return cancelCertificateTransfer(CancelCertificateTransferRequest.builder()
                .applyMutation(cancelCertificateTransferRequest).build());
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     *
     * @param cancelJobRequest
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJob
     */
    default CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJob
     */
    default CompletableFuture<CancelJobResponse> cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     *
     * @param cancelJobExecutionRequest
     * @return A Java Future containing the result of the CancelJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJobExecution
     */
    default CompletableFuture<CancelJobExecutionResponse> cancelJobExecution(CancelJobExecutionRequest cancelJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelJobExecutionRequest#builder()}
     * </p>
     *
     * @param cancelJobExecutionRequest
     *        A {@link Consumer} that will call methods on {@link CancelJobExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CancelJobExecution
     */
    default CompletableFuture<CancelJobExecutionResponse> cancelJobExecution(
            Consumer<CancelJobExecutionRequest.Builder> cancelJobExecutionRequest) {
        return cancelJobExecution(CancelJobExecutionRequest.builder().applyMutation(cancelJobExecutionRequest).build());
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     * @return A Java Future containing the result of the ClearDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ClearDefaultAuthorizer
     */
    default CompletableFuture<ClearDefaultAuthorizerResponse> clearDefaultAuthorizer(
            ClearDefaultAuthorizerRequest clearDefaultAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClearDefaultAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link ClearDefaultAuthorizerRequest#builder()}
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link ClearDefaultAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ClearDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ClearDefaultAuthorizer
     */
    default CompletableFuture<ClearDefaultAuthorizerResponse> clearDefaultAuthorizer(
            Consumer<ClearDefaultAuthorizerRequest.Builder> clearDefaultAuthorizerRequest) {
        return clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.builder().applyMutation(clearDefaultAuthorizerRequest)
                .build());
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     *
     * @return A Java Future containing the result of the ClearDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ClearDefaultAuthorizer
     */
    default CompletableFuture<ClearDefaultAuthorizerResponse> clearDefaultAuthorizer() {
        return clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.builder().build());
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, AWS IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     * @return A Java Future containing the result of the ConfirmTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ConfirmTopicRuleDestination
     */
    default CompletableFuture<ConfirmTopicRuleDestinationResponse> confirmTopicRuleDestination(
            ConfirmTopicRuleDestinationRequest confirmTopicRuleDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, AWS IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmTopicRuleDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link ConfirmTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on {@link ConfirmTopicRuleDestinationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ConfirmTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ConfirmTopicRuleDestination
     */
    default CompletableFuture<ConfirmTopicRuleDestinationResponse> confirmTopicRuleDestination(
            Consumer<ConfirmTopicRuleDestinationRequest.Builder> confirmTopicRuleDestinationRequest) {
        return confirmTopicRuleDestination(ConfirmTopicRuleDestinationRequest.builder()
                .applyMutation(confirmTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     *
     * @param createAuthorizerRequest
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link CreateAuthorizerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateAuthorizer
     */
    default CompletableFuture<CreateAuthorizerResponse> createAuthorizer(
            Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest) {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateBillingGroup
     */
    default CompletableFuture<CreateBillingGroupResponse> createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillingGroupRequest#builder()}
     * </p>
     *
     * @param createBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateBillingGroup
     */
    default CompletableFuture<CreateBillingGroupResponse> createBillingGroup(
            Consumer<CreateBillingGroupRequest.Builder> createBillingGroupRequest) {
        return createBillingGroup(CreateBillingGroupRequest.builder().applyMutation(createBillingGroupRequest).build());
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or
     * an ECC key from NIST P-256 or NIST P-384 curves.
     * </p>
     * <p>
     * <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that
     * directory, and then specifying that directory on the command line. The following commands show how to create a
     * batch of certificates given a batch of CSRs.
     * </p>
     * <p>
     * Assuming a set of CSRs are located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot
     * create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.
     * </p>
     * <p>
     * The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the
     * certificate creation process:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/&#36_}
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; forfiles /p my-csr-directory /c
     * "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return A Java Future containing the result of the CreateCertificateFromCsr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateCertificateFromCsr
     */
    default CompletableFuture<CreateCertificateFromCsrResponse> createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * <b>Note:</b> The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or
     * an ECC key from NIST P-256 or NIST P-384 curves.
     * </p>
     * <p>
     * <b>Note:</b> Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple .csr files into that
     * directory, and then specifying that directory on the command line. The following commands show how to create a
     * batch of certificates given a batch of CSRs.
     * </p>
     * <p>
     * Assuming a set of CSRs are located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the aws iot
     * create-certificate-from-csr AWS CLI command to create a certificate for the corresponding CSR.
     * </p>
     * <p>
     * The aws iot create-certificate-from-csr part of the command can also be run in parallel to speed up the
     * certificate creation process:
     * </p>
     * <p>
     * &#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/{}
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request
     * file://my-csr-directory/&#36_}
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * &gt; forfiles /p my-csr-directory /c
     * "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path"
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCertificateFromCsrRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCertificateFromCsrRequest#builder()}
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        A {@link Consumer} that will call methods on {@link CreateCertificateFromCsrRequest.Builder} to create a
     *        request. The input for the CreateCertificateFromCsr operation.
     * @return A Java Future containing the result of the CreateCertificateFromCsr operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateCertificateFromCsr
     */
    default CompletableFuture<CreateCertificateFromCsrResponse> createCertificateFromCsr(
            Consumer<CreateCertificateFromCsrRequest.Builder> createCertificateFromCsrRequest) {
        return createCertificateFromCsr(CreateCertificateFromCsrRequest.builder().applyMutation(createCertificateFromCsrRequest)
                .build());
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for AWS IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     *
     * @param createDimensionRequest
     * @return A Java Future containing the result of the CreateDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDimension
     */
    default CompletableFuture<CreateDimensionResponse> createDimension(CreateDimensionRequest createDimensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for AWS IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDimensionRequest#builder()}
     * </p>
     *
     * @param createDimensionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDimensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDimension
     */
    default CompletableFuture<CreateDimensionResponse> createDimension(
            Consumer<CreateDimensionRequest.Builder> createDimensionRequest) {
        return createDimension(CreateDimensionRequest.builder().applyMutation(createDimensionRequest).build());
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param createDomainConfigurationRequest
     * @return A Java Future containing the result of the CreateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDomainConfiguration
     */
    default CompletableFuture<CreateDomainConfigurationResponse> createDomainConfiguration(
            CreateDomainConfigurationRequest createDomainConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param createDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDomainConfiguration
     */
    default CompletableFuture<CreateDomainConfigurationResponse> createDomainConfiguration(
            Consumer<CreateDomainConfigurationRequest.Builder> createDomainConfigurationRequest) {
        return createDomainConfiguration(CreateDomainConfigurationRequest.builder()
                .applyMutation(createDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     *
     * @param createDynamicThingGroupRequest
     * @return A Java Future containing the result of the CreateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDynamicThingGroup
     */
    default CompletableFuture<CreateDynamicThingGroupResponse> createDynamicThingGroup(
            CreateDynamicThingGroupRequest createDynamicThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDynamicThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDynamicThingGroupRequest#builder()}
     * </p>
     *
     * @param createDynamicThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDynamicThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateDynamicThingGroup
     */
    default CompletableFuture<CreateDynamicThingGroupResponse> createDynamicThingGroup(
            Consumer<CreateDynamicThingGroupRequest.Builder> createDynamicThingGroupRequest) {
        return createDynamicThingGroup(CreateDynamicThingGroupRequest.builder().applyMutation(createDynamicThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     *
     * @param createJobRequest
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateJob
     */
    default CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateJob
     */
    default CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateKeysAndCertificate
     */
    default CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeysAndCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateKeysAndCertificateRequest#builder()}
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeysAndCertificateRequest.Builder} to create a
     *        request. The input for the CreateKeysAndCertificate operation.
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateKeysAndCertificate
     */
    default CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate(
            Consumer<CreateKeysAndCertificateRequest.Builder> createKeysAndCertificateRequest) {
        return createKeysAndCertificate(CreateKeysAndCertificateRequest.builder().applyMutation(createKeysAndCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time AWS IoT issues the private key for this certificate, so it is important to keep
     * it in a secure location.
     * </p>
     *
     * @return A Java Future containing the result of the CreateKeysAndCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateKeysAndCertificate
     */
    default CompletableFuture<CreateKeysAndCertificateResponse> createKeysAndCertificate() {
        return createKeysAndCertificate(CreateKeysAndCertificateRequest.builder().build());
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Each mitigation
     * action can apply only one type of change.
     * </p>
     *
     * @param createMitigationActionRequest
     * @return A Java Future containing the result of the CreateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateMitigationAction
     */
    default CompletableFuture<CreateMitigationActionResponse> createMitigationAction(
            CreateMitigationActionRequest createMitigationActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Each mitigation
     * action can apply only one type of change.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMitigationActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMitigationActionRequest#builder()}
     * </p>
     *
     * @param createMitigationActionRequest
     *        A {@link Consumer} that will call methods on {@link CreateMitigationActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateMitigationAction
     */
    default CompletableFuture<CreateMitigationActionResponse> createMitigationAction(
            Consumer<CreateMitigationActionRequest.Builder> createMitigationActionRequest) {
        return createMitigationAction(CreateMitigationActionRequest.builder().applyMutation(createMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS IoT OTAUpdate on a target group of things or groups.
     * </p>
     *
     * @param createOtaUpdateRequest
     * @return A Java Future containing the result of the CreateOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateOTAUpdate
     */
    default CompletableFuture<CreateOtaUpdateResponse> createOTAUpdate(CreateOtaUpdateRequest createOtaUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS IoT OTAUpdate on a target group of things or groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaUpdateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOtaUpdateRequest#builder()}
     * </p>
     *
     * @param createOtaUpdateRequest
     *        A {@link Consumer} that will call methods on {@link CreateOTAUpdateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateOTAUpdate
     */
    default CompletableFuture<CreateOtaUpdateResponse> createOTAUpdate(
            Consumer<CreateOtaUpdateRequest.Builder> createOtaUpdateRequest) {
        return createOTAUpdate(CreateOtaUpdateRequest.builder().applyMutation(createOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Creates an AWS IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     *
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicy
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(CreatePolicyRequest createPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePolicyRequest#builder()}
     * </p>
     *
     * @param createPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreatePolicyRequest.Builder} to create a request. The
     *        input for the CreatePolicy operation.
     * @return A Java Future containing the result of the CreatePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicy
     */
    default CompletableFuture<CreatePolicyResponse> createPolicy(Consumer<CreatePolicyRequest.Builder> createPolicyRequest) {
        return createPolicy(CreatePolicyRequest.builder().applyMutation(createPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     *
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicyVersion
     */
    default CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            CreatePolicyVersionRequest createPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified AWS IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePolicyVersionRequest#builder()}
     * </p>
     *
     * @param createPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreatePolicyVersionRequest.Builder} to create a
     *        request. The input for the CreatePolicyVersion operation.
     * @return A Java Future containing the result of the CreatePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>MalformedPolicyException The policy documentation is not valid.</li>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreatePolicyVersion
     */
    default CompletableFuture<CreatePolicyVersionResponse> createPolicyVersion(
            Consumer<CreatePolicyVersionRequest.Builder> createPolicyVersionRequest) {
        return createPolicyVersion(CreatePolicyVersionRequest.builder().applyMutation(createPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     *
     * @param createProvisioningClaimRequest
     * @return A Java Future containing the result of the CreateProvisioningClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningClaim
     */
    default CompletableFuture<CreateProvisioningClaimResponse> createProvisioningClaim(
            CreateProvisioningClaimRequest createProvisioningClaimRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningClaimRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningClaimRequest#builder()}
     * </p>
     *
     * @param createProvisioningClaimRequest
     *        A {@link Consumer} that will call methods on {@link CreateProvisioningClaimRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProvisioningClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningClaim
     */
    default CompletableFuture<CreateProvisioningClaimResponse> createProvisioningClaim(
            Consumer<CreateProvisioningClaimRequest.Builder> createProvisioningClaimRequest) {
        return createProvisioningClaim(CreateProvisioningClaimRequest.builder().applyMutation(createProvisioningClaimRequest)
                .build());
    }

    /**
     * <p>
     * Creates a fleet provisioning template.
     * </p>
     *
     * @param createProvisioningTemplateRequest
     * @return A Java Future containing the result of the CreateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplate
     */
    default CompletableFuture<CreateProvisioningTemplateResponse> createProvisioningTemplate(
            CreateProvisioningTemplateRequest createProvisioningTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet provisioning template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param createProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplate
     */
    default CompletableFuture<CreateProvisioningTemplateResponse> createProvisioningTemplate(
            Consumer<CreateProvisioningTemplateRequest.Builder> createProvisioningTemplateRequest) {
        return createProvisioningTemplate(CreateProvisioningTemplateRequest.builder()
                .applyMutation(createProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new version of a fleet provisioning template.
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the CreateProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplateVersion
     */
    default CompletableFuture<CreateProvisioningTemplateVersionResponse> createProvisioningTemplateVersion(
            CreateProvisioningTemplateVersionRequest createProvisioningTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of a fleet provisioning template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>VersionsLimitExceededException The number of policy versions exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateProvisioningTemplateVersion
     */
    default CompletableFuture<CreateProvisioningTemplateVersionResponse> createProvisioningTemplateVersion(
            Consumer<CreateProvisioningTemplateVersionRequest.Builder> createProvisioningTemplateVersionRequest) {
        return createProvisioningTemplateVersion(CreateProvisioningTemplateVersionRequest.builder()
                .applyMutation(createProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     *
     * @param createRoleAliasRequest
     * @return A Java Future containing the result of the CreateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateRoleAlias
     */
    default CompletableFuture<CreateRoleAliasResponse> createRoleAlias(CreateRoleAliasRequest createRoleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRoleAliasRequest#builder()}
     * </p>
     *
     * @param createRoleAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoleAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateRoleAlias
     */
    default CompletableFuture<CreateRoleAliasResponse> createRoleAlias(
            Consumer<CreateRoleAliasRequest.Builder> createRoleAliasRequest) {
        return createRoleAlias(CreateRoleAliasRequest.builder().applyMutation(createRoleAliasRequest).build());
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     *
     * @param createScheduledAuditRequest
     * @return A Java Future containing the result of the CreateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateScheduledAudit
     */
    default CompletableFuture<CreateScheduledAuditResponse> createScheduledAudit(
            CreateScheduledAuditRequest createScheduledAuditRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link CreateScheduledAuditRequest#builder()}
     * </p>
     *
     * @param createScheduledAuditRequest
     *        A {@link Consumer} that will call methods on {@link CreateScheduledAuditRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateScheduledAudit
     */
    default CompletableFuture<CreateScheduledAuditResponse> createScheduledAudit(
            Consumer<CreateScheduledAuditRequest.Builder> createScheduledAuditRequest) {
        return createScheduledAudit(CreateScheduledAuditRequest.builder().applyMutation(createScheduledAuditRequest).build());
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return A Java Future containing the result of the CreateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateSecurityProfile
     */
    default CompletableFuture<CreateSecurityProfileResponse> createSecurityProfile(
            CreateSecurityProfileRequest createSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param createSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateSecurityProfile
     */
    default CompletableFuture<CreateSecurityProfileResponse> createSecurityProfile(
            Consumer<CreateSecurityProfileRequest.Builder> createSecurityProfileRequest) {
        return createSecurityProfile(CreateSecurityProfileRequest.builder().applyMutation(createSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     *
     * @param createStreamRequest
     * @return A Java Future containing the result of the CreateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateStream
     */
    default CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStreamRequest#builder()}
     * </p>
     *
     * @param createStreamRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateStream
     */
    default CompletableFuture<CreateStreamResponse> createStream(Consumer<CreateStreamRequest.Builder> createStreamRequest) {
        return createStream(CreateStreamRequest.builder().applyMutation(createStreamRequest).build());
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     *
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return A Java Future containing the result of the CreateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThing
     */
    default CompletableFuture<CreateThingResponse> createThing(CreateThingRequest createThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThingRequest#builder()}
     * </p>
     *
     * @param createThingRequest
     *        A {@link Consumer} that will call methods on {@link CreateThingRequest.Builder} to create a request. The
     *        input for the CreateThing operation.
     * @return A Java Future containing the result of the CreateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThing
     */
    default CompletableFuture<CreateThingResponse> createThing(Consumer<CreateThingRequest.Builder> createThingRequest) {
        return createThing(CreateThingRequest.builder().applyMutation(createThingRequest).build());
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     *
     * @param createThingGroupRequest
     * @return A Java Future containing the result of the CreateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingGroup
     */
    default CompletableFuture<CreateThingGroupResponse> createThingGroup(CreateThingGroupRequest createThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThingGroupRequest#builder()}
     * </p>
     *
     * @param createThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateThingGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingGroup
     */
    default CompletableFuture<CreateThingGroupResponse> createThingGroup(
            Consumer<CreateThingGroupRequest.Builder> createThingGroupRequest) {
        return createThingGroup(CreateThingGroupRequest.builder().applyMutation(createThingGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     *
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return A Java Future containing the result of the CreateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingType
     */
    default CompletableFuture<CreateThingTypeResponse> createThingType(CreateThingTypeRequest createThingTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThingTypeRequest#builder()}
     * </p>
     *
     * @param createThingTypeRequest
     *        A {@link Consumer} that will call methods on {@link CreateThingTypeRequest.Builder} to create a request.
     *        The input for the CreateThingType operation.
     * @return A Java Future containing the result of the CreateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateThingType
     */
    default CompletableFuture<CreateThingTypeResponse> createThingType(
            Consumer<CreateThingTypeRequest.Builder> createThingTypeRequest) {
        return createThingType(CreateThingTypeRequest.builder().applyMutation(createThingTypeRequest).build());
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     *
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return A Java Future containing the result of the CreateTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRule
     */
    default CompletableFuture<CreateTopicRuleResponse> createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTopicRuleRequest#builder()}
     * </p>
     *
     * @param createTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateTopicRuleRequest.Builder} to create a request.
     *        The input for the CreateTopicRule operation.
     * @return A Java Future containing the result of the CreateTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRule
     */
    default CompletableFuture<CreateTopicRuleResponse> createTopicRule(
            Consumer<CreateTopicRuleRequest.Builder> createTopicRuleRequest) {
        return createTopicRule(CreateTopicRuleRequest.builder().applyMutation(createTopicRuleRequest).build());
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     * @return A Java Future containing the result of the CreateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRuleDestination
     */
    default CompletableFuture<CreateTopicRuleDestinationResponse> createTopicRuleDestination(
            CreateTopicRuleDestinationRequest createTopicRuleDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.CreateTopicRuleDestination
     */
    default CompletableFuture<CreateTopicRuleDestinationResponse> createTopicRuleDestination(
            Consumer<CreateTopicRuleDestinationRequest.Builder> createTopicRuleDestinationRequest) {
        return createTopicRuleDestination(CreateTopicRuleDestinationRequest.builder()
                .applyMutation(createTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the DeleteAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAccountAuditConfiguration
     */
    default CompletableFuture<DeleteAccountAuditConfigurationResponse> deleteAccountAuditConfiguration(
            DeleteAccountAuditConfigurationRequest deleteAccountAuditConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAuditConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccountAuditConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccountAuditConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAccountAuditConfiguration
     */
    default CompletableFuture<DeleteAccountAuditConfigurationResponse> deleteAccountAuditConfiguration(
            Consumer<DeleteAccountAuditConfigurationRequest.Builder> deleteAccountAuditConfigurationRequest) {
        return deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.builder()
                .applyMutation(deleteAccountAuditConfigurationRequest).build());
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAccountAuditConfiguration
     */
    default CompletableFuture<DeleteAccountAuditConfigurationResponse> deleteAccountAuditConfiguration() {
        return deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAuthorizerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteAuthorizer
     */
    default CompletableFuture<DeleteAuthorizerResponse> deleteAuthorizer(
            Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest) {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteBillingGroup
     */
    default CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillingGroupRequest#builder()}
     * </p>
     *
     * @param deleteBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteBillingGroup
     */
    default CompletableFuture<DeleteBillingGroupResponse> deleteBillingGroup(
            Consumer<DeleteBillingGroupRequest.Builder> deleteBillingGroupRequest) {
        return deleteBillingGroup(DeleteBillingGroupRequest.builder().applyMutation(deleteBillingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return A Java Future containing the result of the DeleteCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCACertificate
     */
    default CompletableFuture<DeleteCaCertificateResponse> deleteCACertificate(
            DeleteCaCertificateRequest deleteCaCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCaCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCACertificateRequest.Builder} to create a
     *        request. Input for the DeleteCACertificate operation.
     * @return A Java Future containing the result of the DeleteCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCACertificate
     */
    default CompletableFuture<DeleteCaCertificateResponse> deleteCACertificate(
            Consumer<DeleteCaCertificateRequest.Builder> deleteCaCertificateRequest) {
        return deleteCACertificate(DeleteCaCertificateRequest.builder().applyMutation(deleteCaCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the
     * <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.
     * </p>
     *
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCertificate
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPrincipalPolicy</a> API to detach all policies. Next, use the
     * <a>UpdateCertificate</a> API to set the certificate to the INACTIVE status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCertificateRequest.Builder} to create a request.
     *        The input for the DeleteCertificate operation.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteCertificate
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(
            Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest) {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Removes the specified dimension from your AWS account.
     * </p>
     *
     * @param deleteDimensionRequest
     * @return A Java Future containing the result of the DeleteDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDimension
     */
    default CompletableFuture<DeleteDimensionResponse> deleteDimension(DeleteDimensionRequest deleteDimensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified dimension from your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDimensionRequest#builder()}
     * </p>
     *
     * @param deleteDimensionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDimensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDimension
     */
    default CompletableFuture<DeleteDimensionResponse> deleteDimension(
            Consumer<DeleteDimensionRequest.Builder> deleteDimensionRequest) {
        return deleteDimension(DeleteDimensionRequest.builder().applyMutation(deleteDimensionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param deleteDomainConfigurationRequest
     * @return A Java Future containing the result of the DeleteDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDomainConfiguration
     */
    default CompletableFuture<DeleteDomainConfigurationResponse> deleteDomainConfiguration(
            DeleteDomainConfigurationRequest deleteDomainConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDomainConfiguration
     */
    default CompletableFuture<DeleteDomainConfigurationResponse> deleteDomainConfiguration(
            Consumer<DeleteDomainConfigurationRequest.Builder> deleteDomainConfigurationRequest) {
        return deleteDomainConfiguration(DeleteDomainConfigurationRequest.builder()
                .applyMutation(deleteDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     * @return A Java Future containing the result of the DeleteDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDynamicThingGroup
     */
    default CompletableFuture<DeleteDynamicThingGroupResponse> deleteDynamicThingGroup(
            DeleteDynamicThingGroupRequest deleteDynamicThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDynamicThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDynamicThingGroupRequest#builder()}
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDynamicThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteDynamicThingGroup
     */
    default CompletableFuture<DeleteDynamicThingGroupResponse> deleteDynamicThingGroup(
            Consumer<DeleteDynamicThingGroupRequest.Builder> deleteDynamicThingGroupRequest) {
        return deleteDynamicThingGroup(DeleteDynamicThingGroupRequest.builder().applyMutation(deleteDynamicThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     *
     * @param deleteJobRequest
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJob
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJob
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     *
     * @param deleteJobExecutionRequest
     * @return A Java Future containing the result of the DeleteJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJobExecution
     */
    default CompletableFuture<DeleteJobExecutionResponse> deleteJobExecution(DeleteJobExecutionRequest deleteJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteJobExecutionRequest#builder()}
     * </p>
     *
     * @param deleteJobExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InvalidStateTransitionException An attempt was made to change to an invalid state, for example by
     *         deleting a job or a job execution which is "IN_PROGRESS" without setting the <code>force</code>
     *         parameter.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteJobExecution
     */
    default CompletableFuture<DeleteJobExecutionResponse> deleteJobExecution(
            Consumer<DeleteJobExecutionRequest.Builder> deleteJobExecutionRequest) {
        return deleteJobExecution(DeleteJobExecutionRequest.builder().applyMutation(deleteJobExecutionRequest).build());
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your AWS account.
     * </p>
     *
     * @param deleteMitigationActionRequest
     * @return A Java Future containing the result of the DeleteMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteMitigationAction
     */
    default CompletableFuture<DeleteMitigationActionResponse> deleteMitigationAction(
            DeleteMitigationActionRequest deleteMitigationActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMitigationActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMitigationActionRequest#builder()}
     * </p>
     *
     * @param deleteMitigationActionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMitigationActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteMitigationAction
     */
    default CompletableFuture<DeleteMitigationActionResponse> deleteMitigationAction(
            Consumer<DeleteMitigationActionRequest.Builder> deleteMitigationActionRequest) {
        return deleteMitigationAction(DeleteMitigationActionRequest.builder().applyMutation(deleteMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     *
     * @param deleteOtaUpdateRequest
     * @return A Java Future containing the result of the DeleteOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteOTAUpdate
     */
    default CompletableFuture<DeleteOtaUpdateResponse> deleteOTAUpdate(DeleteOtaUpdateRequest deleteOtaUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaUpdateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOtaUpdateRequest#builder()}
     * </p>
     *
     * @param deleteOtaUpdateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOTAUpdateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteOTAUpdate
     */
    default CompletableFuture<DeleteOtaUpdateResponse> deleteOTAUpdate(
            Consumer<DeleteOtaUpdateRequest.Builder> deleteOtaUpdateRequest) {
        return deleteOTAUpdate(DeleteOtaUpdateRequest.builder().applyMutation(deleteOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the
     * DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete
     * the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     *
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicy
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the DeletePolicyVersion API to delete all non-default versions of the policy; use the
     * DetachPrincipalPolicy API to detach the policy from any certificate; and then use the DeletePolicy API to delete
     * the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyRequest.Builder} to create a request. The
     *        input for the DeletePolicy operation.
     * @return A Java Future containing the result of the DeletePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicy
     */
    default CompletableFuture<DeletePolicyResponse> deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest) {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicyVersion
     */
    default CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            DeletePolicyVersionRequest deletePolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this API. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePolicyVersionRequest#builder()}
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyVersionRequest.Builder} to create a
     *        request. The input for the DeletePolicyVersion operation.
     * @return A Java Future containing the result of the DeletePolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeletePolicyVersion
     */
    default CompletableFuture<DeletePolicyVersionResponse> deletePolicyVersion(
            Consumer<DeletePolicyVersionRequest.Builder> deletePolicyVersionRequest) {
        return deletePolicyVersion(DeletePolicyVersionRequest.builder().applyMutation(deletePolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet provisioning template.
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     * @return A Java Future containing the result of the DeleteProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplate
     */
    default CompletableFuture<DeleteProvisioningTemplateResponse> deleteProvisioningTemplate(
            DeleteProvisioningTemplateRequest deleteProvisioningTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet provisioning template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplate
     */
    default CompletableFuture<DeleteProvisioningTemplateResponse> deleteProvisioningTemplate(
            Consumer<DeleteProvisioningTemplateRequest.Builder> deleteProvisioningTemplateRequest) {
        return deleteProvisioningTemplate(DeleteProvisioningTemplateRequest.builder()
                .applyMutation(deleteProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet provisioning template version.
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the DeleteProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplateVersion
     */
    default CompletableFuture<DeleteProvisioningTemplateVersionResponse> deleteProvisioningTemplateVersion(
            DeleteProvisioningTemplateVersionRequest deleteProvisioningTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet provisioning template version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteProvisioningTemplateVersion
     */
    default CompletableFuture<DeleteProvisioningTemplateVersionResponse> deleteProvisioningTemplateVersion(
            Consumer<DeleteProvisioningTemplateVersionRequest.Builder> deleteProvisioningTemplateVersionRequest) {
        return deleteProvisioningTemplateVersion(DeleteProvisioningTemplateVersionRequest.builder()
                .applyMutation(deleteProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRegistrationCode
     */
    default CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode(
            DeleteRegistrationCodeRequest deleteRegistrationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegistrationCodeRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRegistrationCodeRequest.Builder} to create a
     *        request. The input for the DeleteRegistrationCode operation.
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRegistrationCode
     */
    default CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode(
            Consumer<DeleteRegistrationCodeRequest.Builder> deleteRegistrationCodeRequest) {
        return deleteRegistrationCode(DeleteRegistrationCodeRequest.builder().applyMutation(deleteRegistrationCodeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     *
     * @return A Java Future containing the result of the DeleteRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRegistrationCode
     */
    default CompletableFuture<DeleteRegistrationCodeResponse> deleteRegistrationCode() {
        return deleteRegistrationCode(DeleteRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     *
     * @param deleteRoleAliasRequest
     * @return A Java Future containing the result of the DeleteRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRoleAlias
     */
    default CompletableFuture<DeleteRoleAliasResponse> deleteRoleAlias(DeleteRoleAliasRequest deleteRoleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRoleAliasRequest#builder()}
     * </p>
     *
     * @param deleteRoleAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoleAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteRoleAlias
     */
    default CompletableFuture<DeleteRoleAliasResponse> deleteRoleAlias(
            Consumer<DeleteRoleAliasRequest.Builder> deleteRoleAliasRequest) {
        return deleteRoleAlias(DeleteRoleAliasRequest.builder().applyMutation(deleteRoleAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     *
     * @param deleteScheduledAuditRequest
     * @return A Java Future containing the result of the DeleteScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteScheduledAudit
     */
    default CompletableFuture<DeleteScheduledAuditResponse> deleteScheduledAudit(
            DeleteScheduledAuditRequest deleteScheduledAuditRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledAuditRequest#builder()}
     * </p>
     *
     * @param deleteScheduledAuditRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduledAuditRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteScheduledAudit
     */
    default CompletableFuture<DeleteScheduledAuditResponse> deleteScheduledAudit(
            Consumer<DeleteScheduledAuditRequest.Builder> deleteScheduledAuditRequest) {
        return deleteScheduledAudit(DeleteScheduledAuditRequest.builder().applyMutation(deleteScheduledAuditRequest).build());
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return A Java Future containing the result of the DeleteSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteSecurityProfile
     */
    default CompletableFuture<DeleteSecurityProfileResponse> deleteSecurityProfile(
            DeleteSecurityProfileRequest deleteSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityProfileRequest#builder()}
     * </p>
     *
     * @param deleteSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteSecurityProfile
     */
    default CompletableFuture<DeleteSecurityProfileResponse> deleteSecurityProfile(
            Consumer<DeleteSecurityProfileRequest.Builder> deleteSecurityProfileRequest) {
        return deleteSecurityProfile(DeleteSecurityProfileRequest.builder().applyMutation(deleteSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     *
     * @param deleteStreamRequest
     * @return A Java Future containing the result of the DeleteStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteStream
     */
    default CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStreamRequest#builder()}
     * </p>
     *
     * @param deleteStreamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>DeleteConflictException You can't delete the resource because it is attached to one or more
     *         resources.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteStream
     */
    default CompletableFuture<DeleteStreamResponse> deleteStream(Consumer<DeleteStreamRequest.Builder> deleteStreamRequest) {
        return deleteStream(DeleteStreamRequest.builder().applyMutation(deleteStreamRequest).build());
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     *
     * @param deleteThingRequest
     *        The input for the DeleteThing operation.
     * @return A Java Future containing the result of the DeleteThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThing
     */
    default CompletableFuture<DeleteThingResponse> deleteThing(DeleteThingRequest deleteThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThingRequest#builder()}
     * </p>
     *
     * @param deleteThingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThingRequest.Builder} to create a request. The
     *        input for the DeleteThing operation.
     * @return A Java Future containing the result of the DeleteThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThing
     */
    default CompletableFuture<DeleteThingResponse> deleteThing(Consumer<DeleteThingRequest.Builder> deleteThingRequest) {
        return deleteThing(DeleteThingRequest.builder().applyMutation(deleteThingRequest).build());
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     *
     * @param deleteThingGroupRequest
     * @return A Java Future containing the result of the DeleteThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingGroup
     */
    default CompletableFuture<DeleteThingGroupResponse> deleteThingGroup(DeleteThingGroupRequest deleteThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThingGroupRequest#builder()}
     * </p>
     *
     * @param deleteThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThingGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingGroup
     */
    default CompletableFuture<DeleteThingGroupResponse> deleteThingGroup(
            Consumer<DeleteThingGroupRequest.Builder> deleteThingGroupRequest) {
        return deleteThingGroup(DeleteThingGroupRequest.builder().applyMutation(deleteThingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     *
     * @param deleteThingTypeRequest
     *        The input for the DeleteThingType operation.
     * @return A Java Future containing the result of the DeleteThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingType
     */
    default CompletableFuture<DeleteThingTypeResponse> deleteThingType(DeleteThingTypeRequest deleteThingTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThingTypeRequest#builder()}
     * </p>
     *
     * @param deleteThingTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteThingTypeRequest.Builder} to create a request.
     *        The input for the DeleteThingType operation.
     * @return A Java Future containing the result of the DeleteThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteThingType
     */
    default CompletableFuture<DeleteThingTypeResponse> deleteThingType(
            Consumer<DeleteThingTypeRequest.Builder> deleteThingTypeRequest) {
        return deleteThingType(DeleteThingTypeRequest.builder().applyMutation(deleteThingTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        The input for the DeleteTopicRule operation.
     * @return A Java Future containing the result of the DeleteTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRule
     */
    default CompletableFuture<DeleteTopicRuleResponse> deleteTopicRule(DeleteTopicRuleRequest deleteTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTopicRuleRequest#builder()}
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTopicRuleRequest.Builder} to create a request.
     *        The input for the DeleteTopicRule operation.
     * @return A Java Future containing the result of the DeleteTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRule
     */
    default CompletableFuture<DeleteTopicRuleResponse> deleteTopicRule(
            Consumer<DeleteTopicRuleRequest.Builder> deleteTopicRuleRequest) {
        return deleteTopicRule(DeleteTopicRuleRequest.builder().applyMutation(deleteTopicRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     * @return A Java Future containing the result of the DeleteTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRuleDestination
     */
    default CompletableFuture<DeleteTopicRuleDestinationResponse> deleteTopicRuleDestination(
            DeleteTopicRuleDestinationRequest deleteTopicRuleDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteTopicRuleDestination
     */
    default CompletableFuture<DeleteTopicRuleDestinationResponse> deleteTopicRuleDestination(
            Consumer<DeleteTopicRuleDestinationRequest.Builder> deleteTopicRuleDestinationRequest) {
        return deleteTopicRuleDestination(DeleteTopicRuleDestinationRequest.builder()
                .applyMutation(deleteTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     * @return A Java Future containing the result of the DeleteV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteV2LoggingLevel
     */
    default CompletableFuture<DeleteV2LoggingLevelResponse> deleteV2LoggingLevel(
            DeleteV2LoggingLevelRequest deleteV2LoggingLevelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteV2LoggingLevelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteV2LoggingLevelRequest#builder()}
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteV2LoggingLevelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeleteV2LoggingLevel
     */
    default CompletableFuture<DeleteV2LoggingLevelResponse> deleteV2LoggingLevel(
            Consumer<DeleteV2LoggingLevelRequest.Builder> deleteV2LoggingLevelRequest) {
        return deleteV2LoggingLevel(DeleteV2LoggingLevelRequest.builder().applyMutation(deleteV2LoggingLevelRequest).build());
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        The input for the DeprecateThingType operation.
     * @return A Java Future containing the result of the DeprecateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeprecateThingType
     */
    default CompletableFuture<DeprecateThingTypeResponse> deprecateThingType(DeprecateThingTypeRequest deprecateThingTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateThingTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateThingTypeRequest#builder()}
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateThingTypeRequest.Builder} to create a
     *        request. The input for the DeprecateThingType operation.
     * @return A Java Future containing the result of the DeprecateThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DeprecateThingType
     */
    default CompletableFuture<DeprecateThingTypeResponse> deprecateThingType(
            Consumer<DeprecateThingTypeRequest.Builder> deprecateThingTypeRequest) {
        return deprecateThingType(DeprecateThingTypeRequest.builder().applyMutation(deprecateThingTypeRequest).build());
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAccountAuditConfiguration
     */
    default CompletableFuture<DescribeAccountAuditConfigurationResponse> describeAccountAuditConfiguration(
            DescribeAccountAuditConfigurationRequest describeAccountAuditConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAuditConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountAuditConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAuditConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAccountAuditConfiguration
     */
    default CompletableFuture<DescribeAccountAuditConfigurationResponse> describeAccountAuditConfiguration(
            Consumer<DescribeAccountAuditConfigurationRequest.Builder> describeAccountAuditConfigurationRequest) {
        return describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.builder()
                .applyMutation(describeAccountAuditConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAccountAuditConfiguration
     */
    default CompletableFuture<DescribeAccountAuditConfigurationResponse> describeAccountAuditConfiguration() {
        return describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and when the audit that returned the finding was started.
     * </p>
     *
     * @param describeAuditFindingRequest
     * @return A Java Future containing the result of the DescribeAuditFinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditFinding
     */
    default CompletableFuture<DescribeAuditFindingResponse> describeAuditFinding(
            DescribeAuditFindingRequest describeAuditFindingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and when the audit that returned the finding was started.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditFindingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAuditFindingRequest#builder()}
     * </p>
     *
     * @param describeAuditFindingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuditFindingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAuditFinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditFinding
     */
    default CompletableFuture<DescribeAuditFindingResponse> describeAuditFinding(
            Consumer<DescribeAuditFindingRequest.Builder> describeAuditFindingRequest) {
        return describeAuditFinding(DescribeAuditFindingRequest.builder().applyMutation(describeAuditFindingRequest).build());
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the DescribeAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditMitigationActionsTask
     */
    default CompletableFuture<DescribeAuditMitigationActionsTaskResponse> describeAuditMitigationActionsTask(
            DescribeAuditMitigationActionsTaskRequest describeAuditMitigationActionsTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuditMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuditMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditMitigationActionsTask
     */
    default CompletableFuture<DescribeAuditMitigationActionsTaskResponse> describeAuditMitigationActionsTask(
            Consumer<DescribeAuditMitigationActionsTaskRequest.Builder> describeAuditMitigationActionsTaskRequest) {
        return describeAuditMitigationActionsTask(DescribeAuditMitigationActionsTaskRequest.builder()
                .applyMutation(describeAuditMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     *
     * @param describeAuditTaskRequest
     * @return A Java Future containing the result of the DescribeAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditTask
     */
    default CompletableFuture<DescribeAuditTaskResponse> describeAuditTask(DescribeAuditTaskRequest describeAuditTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditTaskRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAuditTaskRequest#builder()}
     * </p>
     *
     * @param describeAuditTaskRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuditTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuditTask
     */
    default CompletableFuture<DescribeAuditTaskResponse> describeAuditTask(
            Consumer<DescribeAuditTaskRequest.Builder> describeAuditTaskRequest) {
        return describeAuditTask(DescribeAuditTaskRequest.builder().applyMutation(describeAuditTaskRequest).build());
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     *
     * @param describeAuthorizerRequest
     * @return A Java Future containing the result of the DescribeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuthorizer
     */
    default CompletableFuture<DescribeAuthorizerResponse> describeAuthorizer(DescribeAuthorizerRequest describeAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAuthorizerRequest#builder()}
     * </p>
     *
     * @param describeAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeAuthorizer
     */
    default CompletableFuture<DescribeAuthorizerResponse> describeAuthorizer(
            Consumer<DescribeAuthorizerRequest.Builder> describeAuthorizerRequest) {
        return describeAuthorizer(DescribeAuthorizerRequest.builder().applyMutation(describeAuthorizerRequest).build());
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     *
     * @param describeBillingGroupRequest
     * @return A Java Future containing the result of the DescribeBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeBillingGroup
     */
    default CompletableFuture<DescribeBillingGroupResponse> describeBillingGroup(
            DescribeBillingGroupRequest describeBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBillingGroupRequest#builder()}
     * </p>
     *
     * @param describeBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeBillingGroup
     */
    default CompletableFuture<DescribeBillingGroupResponse> describeBillingGroup(
            Consumer<DescribeBillingGroupRequest.Builder> describeBillingGroupRequest) {
        return describeBillingGroup(DescribeBillingGroupRequest.builder().applyMutation(describeBillingGroupRequest).build());
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     *
     * @param describeCaCertificateRequest
     *        The input for the DescribeCACertificate operation.
     * @return A Java Future containing the result of the DescribeCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCACertificate
     */
    default CompletableFuture<DescribeCaCertificateResponse> describeCACertificate(
            DescribeCaCertificateRequest describeCaCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCaCertificateRequest#builder()}
     * </p>
     *
     * @param describeCaCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCACertificateRequest.Builder} to create a
     *        request. The input for the DescribeCACertificate operation.
     * @return A Java Future containing the result of the DescribeCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCACertificate
     */
    default CompletableFuture<DescribeCaCertificateResponse> describeCACertificate(
            Consumer<DescribeCaCertificateRequest.Builder> describeCaCertificateRequest) {
        return describeCACertificate(DescribeCaCertificateRequest.builder().applyMutation(describeCaCertificateRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     *
     * @param describeCertificateRequest
     *        The input for the DescribeCertificate operation.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCertificate
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificateRequest#builder()}
     * </p>
     *
     * @param describeCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificateRequest.Builder} to create a
     *        request. The input for the DescribeCertificate operation.
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeCertificate
     */
    default CompletableFuture<DescribeCertificateResponse> describeCertificate(
            Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) {
        return describeCertificate(DescribeCertificateRequest.builder().applyMutation(describeCertificateRequest).build());
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     * @return A Java Future containing the result of the DescribeDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDefaultAuthorizer
     */
    default CompletableFuture<DescribeDefaultAuthorizerResponse> describeDefaultAuthorizer(
            DescribeDefaultAuthorizerRequest describeDefaultAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultAuthorizerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDefaultAuthorizerRequest#builder()}
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDefaultAuthorizer
     */
    default CompletableFuture<DescribeDefaultAuthorizerResponse> describeDefaultAuthorizer(
            Consumer<DescribeDefaultAuthorizerRequest.Builder> describeDefaultAuthorizerRequest) {
        return describeDefaultAuthorizer(DescribeDefaultAuthorizerRequest.builder()
                .applyMutation(describeDefaultAuthorizerRequest).build());
    }

    /**
     * <p>
     * Provides details about a dimension that is defined in your AWS account.
     * </p>
     *
     * @param describeDimensionRequest
     * @return A Java Future containing the result of the DescribeDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDimension
     */
    default CompletableFuture<DescribeDimensionResponse> describeDimension(DescribeDimensionRequest describeDimensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about a dimension that is defined in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDimensionRequest#builder()}
     * </p>
     *
     * @param describeDimensionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDimensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDimension
     */
    default CompletableFuture<DescribeDimensionResponse> describeDimension(
            Consumer<DescribeDimensionRequest.Builder> describeDimensionRequest) {
        return describeDimension(DescribeDimensionRequest.builder().applyMutation(describeDimensionRequest).build());
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param describeDomainConfigurationRequest
     * @return A Java Future containing the result of the DescribeDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDomainConfiguration
     */
    default CompletableFuture<DescribeDomainConfigurationResponse> describeDomainConfiguration(
            DescribeDomainConfigurationRequest describeDomainConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDomainConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeDomainConfiguration
     */
    default CompletableFuture<DescribeDomainConfigurationResponse> describeDomainConfiguration(
            Consumer<DescribeDomainConfigurationRequest.Builder> describeDomainConfigurationRequest) {
        return describeDomainConfiguration(DescribeDomainConfigurationRequest.builder()
                .applyMutation(describeDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     *
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEndpoint
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointRequest.Builder} to create a request.
     *        The input for the DescribeEndpoint operation.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEndpoint
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(
            Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest) {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the AWS account making the call.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEndpoint
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint() {
        return describeEndpoint(DescribeEndpointRequest.builder().build());
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     *
     * @param describeEventConfigurationsRequest
     * @return A Java Future containing the result of the DescribeEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEventConfigurations
     */
    default CompletableFuture<DescribeEventConfigurationsResponse> describeEventConfigurations(
            DescribeEventConfigurationsRequest describeEventConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEventConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeEventConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventConfigurationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEventConfigurations
     */
    default CompletableFuture<DescribeEventConfigurationsResponse> describeEventConfigurations(
            Consumer<DescribeEventConfigurationsRequest.Builder> describeEventConfigurationsRequest) {
        return describeEventConfigurations(DescribeEventConfigurationsRequest.builder()
                .applyMutation(describeEventConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeEventConfigurations
     */
    default CompletableFuture<DescribeEventConfigurationsResponse> describeEventConfigurations() {
        return describeEventConfigurations(DescribeEventConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     *
     * @param describeIndexRequest
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeIndex
     */
    default CompletableFuture<DescribeIndexResponse> describeIndex(DescribeIndexRequest describeIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIndexRequest#builder()}
     * </p>
     *
     * @param describeIndexRequest
     *        A {@link Consumer} that will call methods on {@link DescribeIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeIndex
     */
    default CompletableFuture<DescribeIndexResponse> describeIndex(Consumer<DescribeIndexRequest.Builder> describeIndexRequest) {
        return describeIndex(DescribeIndexRequest.builder().applyMutation(describeIndexRequest).build());
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     *
     * @param describeJobRequest
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJob
     */
    default CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRequest#builder()}
     * </p>
     *
     * @param describeJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJob
     */
    default CompletableFuture<DescribeJobResponse> describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest) {
        return describeJob(DescribeJobRequest.builder().applyMutation(describeJobRequest).build());
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return A Java Future containing the result of the DescribeJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJobExecution
     */
    default CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(
            DescribeJobExecutionRequest describeJobExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobExecutionRequest#builder()}
     * </p>
     *
     * @param describeJobExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeJobExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeJobExecution
     */
    default CompletableFuture<DescribeJobExecutionResponse> describeJobExecution(
            Consumer<DescribeJobExecutionRequest.Builder> describeJobExecutionRequest) {
        return describeJobExecution(DescribeJobExecutionRequest.builder().applyMutation(describeJobExecutionRequest).build());
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     *
     * @param describeMitigationActionRequest
     * @return A Java Future containing the result of the DescribeMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeMitigationAction
     */
    default CompletableFuture<DescribeMitigationActionResponse> describeMitigationAction(
            DescribeMitigationActionRequest describeMitigationActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMitigationActionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMitigationActionRequest#builder()}
     * </p>
     *
     * @param describeMitigationActionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMitigationActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeMitigationAction
     */
    default CompletableFuture<DescribeMitigationActionResponse> describeMitigationAction(
            Consumer<DescribeMitigationActionRequest.Builder> describeMitigationActionRequest) {
        return describeMitigationAction(DescribeMitigationActionRequest.builder().applyMutation(describeMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template.
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     * @return A Java Future containing the result of the DescribeProvisioningTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplate
     */
    default CompletableFuture<DescribeProvisioningTemplateResponse> describeProvisioningTemplate(
            DescribeProvisioningTemplateRequest describeProvisioningTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisioningTemplateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeProvisioningTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplate
     */
    default CompletableFuture<DescribeProvisioningTemplateResponse> describeProvisioningTemplate(
            Consumer<DescribeProvisioningTemplateRequest.Builder> describeProvisioningTemplateRequest) {
        return describeProvisioningTemplate(DescribeProvisioningTemplateRequest.builder()
                .applyMutation(describeProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template version.
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     * @return A Java Future containing the result of the DescribeProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplateVersion
     */
    default CompletableFuture<DescribeProvisioningTemplateVersionResponse> describeProvisioningTemplateVersion(
            DescribeProvisioningTemplateVersionRequest describeProvisioningTemplateVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a fleet provisioning template version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeProvisioningTemplateVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeProvisioningTemplateVersion
     */
    default CompletableFuture<DescribeProvisioningTemplateVersionResponse> describeProvisioningTemplateVersion(
            Consumer<DescribeProvisioningTemplateVersionRequest.Builder> describeProvisioningTemplateVersionRequest) {
        return describeProvisioningTemplateVersion(DescribeProvisioningTemplateVersionRequest.builder()
                .applyMutation(describeProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     *
     * @param describeRoleAliasRequest
     * @return A Java Future containing the result of the DescribeRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeRoleAlias
     */
    default CompletableFuture<DescribeRoleAliasResponse> describeRoleAlias(DescribeRoleAliasRequest describeRoleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRoleAliasRequest#builder()}
     * </p>
     *
     * @param describeRoleAliasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRoleAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeRoleAlias
     */
    default CompletableFuture<DescribeRoleAliasResponse> describeRoleAlias(
            Consumer<DescribeRoleAliasRequest.Builder> describeRoleAliasRequest) {
        return describeRoleAlias(DescribeRoleAliasRequest.builder().applyMutation(describeRoleAliasRequest).build());
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     *
     * @param describeScheduledAuditRequest
     * @return A Java Future containing the result of the DescribeScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeScheduledAudit
     */
    default CompletableFuture<DescribeScheduledAuditResponse> describeScheduledAudit(
            DescribeScheduledAuditRequest describeScheduledAuditRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeScheduledAuditRequest#builder()}
     * </p>
     *
     * @param describeScheduledAuditRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduledAuditRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeScheduledAudit
     */
    default CompletableFuture<DescribeScheduledAuditResponse> describeScheduledAudit(
            Consumer<DescribeScheduledAuditRequest.Builder> describeScheduledAuditRequest) {
        return describeScheduledAudit(DescribeScheduledAuditRequest.builder().applyMutation(describeScheduledAuditRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return A Java Future containing the result of the DescribeSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeSecurityProfile
     */
    default CompletableFuture<DescribeSecurityProfileResponse> describeSecurityProfile(
            DescribeSecurityProfileRequest describeSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSecurityProfileRequest#builder()}
     * </p>
     *
     * @param describeSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeSecurityProfile
     */
    default CompletableFuture<DescribeSecurityProfileResponse> describeSecurityProfile(
            Consumer<DescribeSecurityProfileRequest.Builder> describeSecurityProfileRequest) {
        return describeSecurityProfile(DescribeSecurityProfileRequest.builder().applyMutation(describeSecurityProfileRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     *
     * @param describeStreamRequest
     * @return A Java Future containing the result of the DescribeStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeStream
     */
    default CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStreamRequest#builder()}
     * </p>
     *
     * @param describeStreamRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeStream
     */
    default CompletableFuture<DescribeStreamResponse> describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) {
        return describeStream(DescribeStreamRequest.builder().applyMutation(describeStreamRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     *
     * @param describeThingRequest
     *        The input for the DescribeThing operation.
     * @return A Java Future containing the result of the DescribeThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThing
     */
    default CompletableFuture<DescribeThingResponse> describeThing(DescribeThingRequest describeThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeThingRequest#builder()}
     * </p>
     *
     * @param describeThingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThingRequest.Builder} to create a request. The
     *        input for the DescribeThing operation.
     * @return A Java Future containing the result of the DescribeThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThing
     */
    default CompletableFuture<DescribeThingResponse> describeThing(Consumer<DescribeThingRequest.Builder> describeThingRequest) {
        return describeThing(DescribeThingRequest.builder().applyMutation(describeThingRequest).build());
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     *
     * @param describeThingGroupRequest
     * @return A Java Future containing the result of the DescribeThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingGroup
     */
    default CompletableFuture<DescribeThingGroupResponse> describeThingGroup(DescribeThingGroupRequest describeThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeThingGroupRequest#builder()}
     * </p>
     *
     * @param describeThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingGroup
     */
    default CompletableFuture<DescribeThingGroupResponse> describeThingGroup(
            Consumer<DescribeThingGroupRequest.Builder> describeThingGroupRequest) {
        return describeThingGroup(DescribeThingGroupRequest.builder().applyMutation(describeThingGroupRequest).build());
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     * @return A Java Future containing the result of the DescribeThingRegistrationTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingRegistrationTask
     */
    default CompletableFuture<DescribeThingRegistrationTaskResponse> describeThingRegistrationTask(
            DescribeThingRegistrationTaskRequest describeThingRegistrationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingRegistrationTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeThingRegistrationTaskRequest#builder()}
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThingRegistrationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeThingRegistrationTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingRegistrationTask
     */
    default CompletableFuture<DescribeThingRegistrationTaskResponse> describeThingRegistrationTask(
            Consumer<DescribeThingRegistrationTaskRequest.Builder> describeThingRegistrationTaskRequest) {
        return describeThingRegistrationTask(DescribeThingRegistrationTaskRequest.builder()
                .applyMutation(describeThingRegistrationTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     *
     * @param describeThingTypeRequest
     *        The input for the DescribeThingType operation.
     * @return A Java Future containing the result of the DescribeThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingType
     */
    default CompletableFuture<DescribeThingTypeResponse> describeThingType(DescribeThingTypeRequest describeThingTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeThingTypeRequest#builder()}
     * </p>
     *
     * @param describeThingTypeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeThingTypeRequest.Builder} to create a request.
     *        The input for the DescribeThingType operation.
     * @return A Java Future containing the result of the DescribeThingType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DescribeThingType
     */
    default CompletableFuture<DescribeThingTypeResponse> describeThingType(
            Consumer<DescribeThingTypeRequest.Builder> describeThingTypeRequest) {
        return describeThingType(DescribeThingTypeRequest.builder().applyMutation(describeThingTypeRequest).build());
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     *
     * @param detachPolicyRequest
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachPolicy
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DetachPolicyRequest#builder()}
     * </p>
     *
     * @param detachPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DetachPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DetachPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachPolicy
     */
    default CompletableFuture<DetachPolicyResponse> detachPolicy(Consumer<DetachPolicyRequest.Builder> detachPolicyRequest) {
        return detachPolicy(DetachPolicyRequest.builder().applyMutation(detachPolicyRequest).build());
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     *
     * @param detachSecurityProfileRequest
     * @return A Java Future containing the result of the DetachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachSecurityProfile
     */
    default CompletableFuture<DetachSecurityProfileResponse> detachSecurityProfile(
            DetachSecurityProfileRequest detachSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DetachSecurityProfileRequest#builder()}
     * </p>
     *
     * @param detachSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link DetachSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DetachSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachSecurityProfile
     */
    default CompletableFuture<DetachSecurityProfileResponse> detachSecurityProfile(
            Consumer<DetachSecurityProfileRequest.Builder> detachSecurityProfileRequest) {
        return detachSecurityProfile(DetachSecurityProfileRequest.builder().applyMutation(detachSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     *
     * @param detachThingPrincipalRequest
     *        The input for the DetachThingPrincipal operation.
     * @return A Java Future containing the result of the DetachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachThingPrincipal
     */
    default CompletableFuture<DetachThingPrincipalResponse> detachThingPrincipal(
            DetachThingPrincipalRequest detachThingPrincipalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachThingPrincipalRequest.Builder} avoiding the
     * need to create one manually via {@link DetachThingPrincipalRequest#builder()}
     * </p>
     *
     * @param detachThingPrincipalRequest
     *        A {@link Consumer} that will call methods on {@link DetachThingPrincipalRequest.Builder} to create a
     *        request. The input for the DetachThingPrincipal operation.
     * @return A Java Future containing the result of the DetachThingPrincipal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DetachThingPrincipal
     */
    default CompletableFuture<DetachThingPrincipalResponse> detachThingPrincipal(
            Consumer<DetachThingPrincipalRequest.Builder> detachThingPrincipalRequest) {
        return detachThingPrincipal(DetachThingPrincipalRequest.builder().applyMutation(detachThingPrincipalRequest).build());
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     *
     * @param disableTopicRuleRequest
     *        The input for the DisableTopicRuleRequest operation.
     * @return A Java Future containing the result of the DisableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DisableTopicRule
     */
    default CompletableFuture<DisableTopicRuleResponse> disableTopicRule(DisableTopicRuleRequest disableTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DisableTopicRuleRequest#builder()}
     * </p>
     *
     * @param disableTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link DisableTopicRuleRequest.Builder} to create a request.
     *        The input for the DisableTopicRuleRequest operation.
     * @return A Java Future containing the result of the DisableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.DisableTopicRule
     */
    default CompletableFuture<DisableTopicRuleResponse> disableTopicRule(
            Consumer<DisableTopicRuleRequest.Builder> disableTopicRuleRequest) {
        return disableTopicRule(DisableTopicRuleRequest.builder().applyMutation(disableTopicRuleRequest).build());
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     *
     * @param enableTopicRuleRequest
     *        The input for the EnableTopicRuleRequest operation.
     * @return A Java Future containing the result of the EnableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.EnableTopicRule
     */
    default CompletableFuture<EnableTopicRuleResponse> enableTopicRule(EnableTopicRuleRequest enableTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link EnableTopicRuleRequest#builder()}
     * </p>
     *
     * @param enableTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link EnableTopicRuleRequest.Builder} to create a request.
     *        The input for the EnableTopicRuleRequest operation.
     * @return A Java Future containing the result of the EnableTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.EnableTopicRule
     */
    default CompletableFuture<EnableTopicRuleResponse> enableTopicRule(
            Consumer<EnableTopicRuleRequest.Builder> enableTopicRuleRequest) {
        return enableTopicRule(EnableTopicRuleRequest.builder().applyMutation(enableTopicRuleRequest).build());
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     *
     * @param getCardinalityRequest
     * @return A Java Future containing the result of the GetCardinality operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetCardinality
     */
    default CompletableFuture<GetCardinalityResponse> getCardinality(GetCardinalityRequest getCardinalityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCardinalityRequest.Builder} avoiding the need to
     * create one manually via {@link GetCardinalityRequest#builder()}
     * </p>
     *
     * @param getCardinalityRequest
     *        A {@link Consumer} that will call methods on {@link GetCardinalityRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCardinality operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetCardinality
     */
    default CompletableFuture<GetCardinalityResponse> getCardinality(Consumer<GetCardinalityRequest.Builder> getCardinalityRequest) {
        return getCardinality(GetCardinalityRequest.builder().applyMutation(getCardinalityRequest).build());
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the AWS IoT device gateway.
     * </p>
     *
     * @param getEffectivePoliciesRequest
     * @return A Java Future containing the result of the GetEffectivePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetEffectivePolicies
     */
    default CompletableFuture<GetEffectivePoliciesResponse> getEffectivePolicies(
            GetEffectivePoliciesRequest getEffectivePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the AWS IoT device gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetEffectivePoliciesRequest#builder()}
     * </p>
     *
     * @param getEffectivePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetEffectivePoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEffectivePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetEffectivePolicies
     */
    default CompletableFuture<GetEffectivePoliciesResponse> getEffectivePolicies(
            Consumer<GetEffectivePoliciesRequest.Builder> getEffectivePoliciesRequest) {
        return getEffectivePolicies(GetEffectivePoliciesRequest.builder().applyMutation(getEffectivePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     *
     * @param getIndexingConfigurationRequest
     * @return A Java Future containing the result of the GetIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetIndexingConfiguration
     */
    default CompletableFuture<GetIndexingConfigurationResponse> getIndexingConfiguration(
            GetIndexingConfigurationRequest getIndexingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetIndexingConfigurationRequest#builder()}
     * </p>
     *
     * @param getIndexingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetIndexingConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetIndexingConfiguration
     */
    default CompletableFuture<GetIndexingConfigurationResponse> getIndexingConfiguration(
            Consumer<GetIndexingConfigurationRequest.Builder> getIndexingConfigurationRequest) {
        return getIndexingConfiguration(GetIndexingConfigurationRequest.builder().applyMutation(getIndexingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     *
     * @return A Java Future containing the result of the GetIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetIndexingConfiguration
     */
    default CompletableFuture<GetIndexingConfigurationResponse> getIndexingConfiguration() {
        return getIndexingConfiguration(GetIndexingConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     *
     * @param getJobDocumentRequest
     * @return A Java Future containing the result of the GetJobDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetJobDocument
     */
    default CompletableFuture<GetJobDocumentResponse> getJobDocument(GetJobDocumentRequest getJobDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobDocumentRequest#builder()}
     * </p>
     *
     * @param getJobDocumentRequest
     *        A {@link Consumer} that will call methods on {@link GetJobDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJobDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetJobDocument
     */
    default CompletableFuture<GetJobDocumentResponse> getJobDocument(Consumer<GetJobDocumentRequest.Builder> getJobDocumentRequest) {
        return getJobDocument(GetJobDocumentRequest.builder().applyMutation(getJobDocumentRequest).build());
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetLoggingOptions
     */
    default CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link GetLoggingOptionsRequest.Builder} to create a request.
     *        The input for the GetLoggingOptions operation.
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetLoggingOptions
     */
    default CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions(
            Consumer<GetLoggingOptionsRequest.Builder> getLoggingOptionsRequest) {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().applyMutation(getLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     *
     * @return A Java Future containing the result of the GetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetLoggingOptions
     */
    default CompletableFuture<GetLoggingOptionsResponse> getLoggingOptions() {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     *
     * @param getOtaUpdateRequest
     * @return A Java Future containing the result of the GetOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetOTAUpdate
     */
    default CompletableFuture<GetOtaUpdateResponse> getOTAUpdate(GetOtaUpdateRequest getOtaUpdateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaUpdateRequest.Builder} avoiding the need to
     * create one manually via {@link GetOtaUpdateRequest#builder()}
     * </p>
     *
     * @param getOtaUpdateRequest
     *        A {@link Consumer} that will call methods on {@link GetOTAUpdateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOTAUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetOTAUpdate
     */
    default CompletableFuture<GetOtaUpdateResponse> getOTAUpdate(Consumer<GetOtaUpdateRequest.Builder> getOtaUpdateRequest) {
        return getOTAUpdate(GetOtaUpdateRequest.builder().applyMutation(getOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     *
     * @param getPercentilesRequest
     * @return A Java Future containing the result of the GetPercentiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPercentiles
     */
    default CompletableFuture<GetPercentilesResponse> getPercentiles(GetPercentilesRequest getPercentilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPercentilesRequest.Builder} avoiding the need to
     * create one manually via {@link GetPercentilesRequest#builder()}
     * </p>
     *
     * @param getPercentilesRequest
     *        A {@link Consumer} that will call methods on {@link GetPercentilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPercentiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPercentiles
     */
    default CompletableFuture<GetPercentilesResponse> getPercentiles(Consumer<GetPercentilesRequest.Builder> getPercentilesRequest) {
        return getPercentiles(GetPercentilesRequest.builder().applyMutation(getPercentilesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     *
     * @param getPolicyRequest
     *        The input for the GetPolicy operation.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicy
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request. The
     *        input for the GetPolicy operation.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicy
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     *
     * @param getPolicyVersionRequest
     *        The input for the GetPolicyVersion operation.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicyVersion
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPolicyVersionRequest#builder()}
     * </p>
     *
     * @param getPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyVersionRequest.Builder} to create a request.
     *        The input for the GetPolicyVersion operation.
     * @return A Java Future containing the result of the GetPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetPolicyVersion
     */
    default CompletableFuture<GetPolicyVersionResponse> getPolicyVersion(
            Consumer<GetPolicyVersionRequest.Builder> getPolicyVersionRequest) {
        return getPolicyVersion(GetPolicyVersionRequest.builder().applyMutation(getPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetRegistrationCode
     */
    default CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode(
            GetRegistrationCodeRequest getRegistrationCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistrationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegistrationCodeRequest#builder()}
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        A {@link Consumer} that will call methods on {@link GetRegistrationCodeRequest.Builder} to create a
     *        request. The input to the GetRegistrationCode operation.
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetRegistrationCode
     */
    default CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode(
            Consumer<GetRegistrationCodeRequest.Builder> getRegistrationCodeRequest) {
        return getRegistrationCode(GetRegistrationCodeRequest.builder().applyMutation(getRegistrationCodeRequest).build());
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with AWS IoT.
     * </p>
     *
     * @return A Java Future containing the result of the GetRegistrationCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetRegistrationCode
     */
    default CompletableFuture<GetRegistrationCodeResponse> getRegistrationCode() {
        return getRegistrationCode(GetRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     *
     * @param getStatisticsRequest
     * @return A Java Future containing the result of the GetStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetStatistics
     */
    default CompletableFuture<GetStatisticsResponse> getStatistics(GetStatisticsRequest getStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatisticsRequest.Builder} avoiding the need to
     * create one manually via {@link GetStatisticsRequest#builder()}
     * </p>
     *
     * @param getStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link GetStatisticsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>InvalidAggregationException The aggregation is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetStatistics
     */
    default CompletableFuture<GetStatisticsResponse> getStatistics(Consumer<GetStatisticsRequest.Builder> getStatisticsRequest) {
        return getStatistics(GetStatisticsRequest.builder().applyMutation(getStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     *
     * @param getTopicRuleRequest
     *        The input for the GetTopicRule operation.
     * @return A Java Future containing the result of the GetTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRule
     */
    default CompletableFuture<GetTopicRuleResponse> getTopicRule(GetTopicRuleRequest getTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTopicRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetTopicRuleRequest#builder()}
     * </p>
     *
     * @param getTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetTopicRuleRequest.Builder} to create a request. The
     *        input for the GetTopicRule operation.
     * @return A Java Future containing the result of the GetTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRule
     */
    default CompletableFuture<GetTopicRuleResponse> getTopicRule(Consumer<GetTopicRuleRequest.Builder> getTopicRuleRequest) {
        return getTopicRule(GetTopicRuleRequest.builder().applyMutation(getTopicRuleRequest).build());
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     * @return A Java Future containing the result of the GetTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRuleDestination
     */
    default CompletableFuture<GetTopicRuleDestinationResponse> getTopicRuleDestination(
            GetTopicRuleDestinationRequest getTopicRuleDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on {@link GetTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetTopicRuleDestination
     */
    default CompletableFuture<GetTopicRuleDestinationResponse> getTopicRuleDestination(
            Consumer<GetTopicRuleDestinationRequest.Builder> getTopicRuleDestinationRequest) {
        return getTopicRuleDestination(GetTopicRuleDestinationRequest.builder().applyMutation(getTopicRuleDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     * @return A Java Future containing the result of the GetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetV2LoggingOptions
     */
    default CompletableFuture<GetV2LoggingOptionsResponse> getV2LoggingOptions(
            GetV2LoggingOptionsRequest getV2LoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetV2LoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetV2LoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link GetV2LoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.GetV2LoggingOptions
     */
    default CompletableFuture<GetV2LoggingOptionsResponse> getV2LoggingOptions(
            Consumer<GetV2LoggingOptionsRequest.Builder> getV2LoggingOptionsRequest) {
        return getV2LoggingOptions(GetV2LoggingOptionsRequest.builder().applyMutation(getV2LoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     *
     * @param listActiveViolationsRequest
     * @return A Java Future containing the result of the ListActiveViolations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListActiveViolations
     */
    default CompletableFuture<ListActiveViolationsResponse> listActiveViolations(
            ListActiveViolationsRequest listActiveViolationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActiveViolationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListActiveViolationsRequest#builder()}
     * </p>
     *
     * @param listActiveViolationsRequest
     *        A {@link Consumer} that will call methods on {@link ListActiveViolationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListActiveViolations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListActiveViolations
     */
    default CompletableFuture<ListActiveViolationsResponse> listActiveViolations(
            Consumer<ListActiveViolationsRequest.Builder> listActiveViolationsRequest) {
        return listActiveViolations(ListActiveViolationsRequest.builder().applyMutation(listActiveViolationsRequest).build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     *
     * @return A Java Future containing the result of the ListActiveViolations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListActiveViolations
     */
    default CompletableFuture<ListActiveViolationsResponse> listActiveViolations() {
        return listActiveViolations(ListActiveViolationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     *
     * @param listAttachedPoliciesRequest
     * @return A Java Future containing the result of the ListAttachedPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAttachedPolicies
     */
    default CompletableFuture<ListAttachedPoliciesResponse> listAttachedPolicies(
            ListAttachedPoliciesRequest listAttachedPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttachedPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListAttachedPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAttachedPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAttachedPolicies
     */
    default CompletableFuture<ListAttachedPoliciesResponse> listAttachedPolicies(
            Consumer<ListAttachedPoliciesRequest.Builder> listAttachedPoliciesRequest) {
        return listAttachedPolicies(ListAttachedPoliciesRequest.builder().applyMutation(listAttachedPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 180 days.)
     * </p>
     *
     * @param listAuditFindingsRequest
     * @return A Java Future containing the result of the ListAuditFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditFindings
     */
    default CompletableFuture<ListAuditFindingsResponse> listAuditFindings(ListAuditFindingsRequest listAuditFindingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 180 days.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuditFindingsRequest#builder()}
     * </p>
     *
     * @param listAuditFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListAuditFindingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAuditFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditFindings
     */
    default CompletableFuture<ListAuditFindingsResponse> listAuditFindings(
            Consumer<ListAuditFindingsRequest.Builder> listAuditFindingsRequest) {
        return listAuditFindings(ListAuditFindingsRequest.builder().applyMutation(listAuditFindingsRequest).build());
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     * @return A Java Future containing the result of the ListAuditMitigationActionsExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsExecutions
     */
    default CompletableFuture<ListAuditMitigationActionsExecutionsResponse> listAuditMitigationActionsExecutions(
            ListAuditMitigationActionsExecutionsRequest listAuditMitigationActionsExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAuditMitigationActionsExecutionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAuditMitigationActionsExecutionsRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAuditMitigationActionsExecutionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListAuditMitigationActionsExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsExecutions
     */
    default CompletableFuture<ListAuditMitigationActionsExecutionsResponse> listAuditMitigationActionsExecutions(
            Consumer<ListAuditMitigationActionsExecutionsRequest.Builder> listAuditMitigationActionsExecutionsRequest) {
        return listAuditMitigationActionsExecutions(ListAuditMitigationActionsExecutionsRequest.builder()
                .applyMutation(listAuditMitigationActionsExecutionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     * @return A Java Future containing the result of the ListAuditMitigationActionsTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsTasks
     */
    default CompletableFuture<ListAuditMitigationActionsTasksResponse> listAuditMitigationActionsTasks(
            ListAuditMitigationActionsTasksRequest listAuditMitigationActionsTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditMitigationActionsTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAuditMitigationActionsTasksRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListAuditMitigationActionsTasksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAuditMitigationActionsTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditMitigationActionsTasks
     */
    default CompletableFuture<ListAuditMitigationActionsTasksResponse> listAuditMitigationActionsTasks(
            Consumer<ListAuditMitigationActionsTasksRequest.Builder> listAuditMitigationActionsTasksRequest) {
        return listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksRequest.builder()
                .applyMutation(listAuditMitigationActionsTasksRequest).build());
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     *
     * @param listAuditTasksRequest
     * @return A Java Future containing the result of the ListAuditTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditTasks
     */
    default CompletableFuture<ListAuditTasksResponse> listAuditTasks(ListAuditTasksRequest listAuditTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAuditTasksRequest#builder()}
     * </p>
     *
     * @param listAuditTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListAuditTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAuditTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuditTasks
     */
    default CompletableFuture<ListAuditTasksResponse> listAuditTasks(Consumer<ListAuditTasksRequest.Builder> listAuditTasksRequest) {
        return listAuditTasks(ListAuditTasksRequest.builder().applyMutation(listAuditTasksRequest).build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     *
     * @param listAuthorizersRequest
     * @return A Java Future containing the result of the ListAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuthorizers
     */
    default CompletableFuture<ListAuthorizersResponse> listAuthorizers(ListAuthorizersRequest listAuthorizersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuthorizersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuthorizersRequest#builder()}
     * </p>
     *
     * @param listAuthorizersRequest
     *        A {@link Consumer} that will call methods on {@link ListAuthorizersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuthorizers
     */
    default CompletableFuture<ListAuthorizersResponse> listAuthorizers(
            Consumer<ListAuthorizersRequest.Builder> listAuthorizersRequest) {
        return listAuthorizers(ListAuthorizersRequest.builder().applyMutation(listAuthorizersRequest).build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListAuthorizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListAuthorizers
     */
    default CompletableFuture<ListAuthorizersResponse> listAuthorizers() {
        return listAuthorizers(ListAuthorizersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListBillingGroups
     */
    default CompletableFuture<ListBillingGroupsResponse> listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListBillingGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListBillingGroups
     */
    default CompletableFuture<ListBillingGroupsResponse> listBillingGroups(
            Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest) {
        return listBillingGroups(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     *
     * @return A Java Future containing the result of the ListBillingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListBillingGroups
     */
    default CompletableFuture<ListBillingGroupsResponse> listBillingGroups() {
        return listBillingGroups(ListBillingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @param listCaCertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCACertificates
     */
    default CompletableFuture<ListCaCertificatesResponse> listCACertificates(ListCaCertificatesRequest listCaCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCaCertificatesRequest#builder()}
     * </p>
     *
     * @param listCaCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCACertificatesRequest.Builder} to create a
     *        request. Input for the ListCACertificates operation.
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCACertificates
     */
    default CompletableFuture<ListCaCertificatesResponse> listCACertificates(
            Consumer<ListCaCertificatesRequest.Builder> listCaCertificatesRequest) {
        return listCACertificates(ListCaCertificatesRequest.builder().applyMutation(listCaCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @return A Java Future containing the result of the ListCACertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCACertificates
     */
    default CompletableFuture<ListCaCertificatesResponse> listCACertificates() {
        return listCACertificates(ListCaCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificates
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificatesRequest.Builder} to create a request.
     *        The input for the ListCertificates operation.
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificates
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates(
            Consumer<ListCertificatesRequest.Builder> listCertificatesRequest) {
        return listCertificates(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the certificates registered in your AWS account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     *
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificates
     */
    default CompletableFuture<ListCertificatesResponse> listCertificates() {
        return listCertificates(ListCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        The input to the ListCertificatesByCA operation.
     * @return A Java Future containing the result of the ListCertificatesByCA operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificatesByCA
     */
    default CompletableFuture<ListCertificatesByCaResponse> listCertificatesByCA(
            ListCertificatesByCaRequest listCertificatesByCaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesByCaRequest.Builder} avoiding the
     * need to create one manually via {@link ListCertificatesByCaRequest#builder()}
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        A {@link Consumer} that will call methods on {@link ListCertificatesByCARequest.Builder} to create a
     *        request. The input to the ListCertificatesByCA operation.
     * @return A Java Future containing the result of the ListCertificatesByCA operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListCertificatesByCA
     */
    default CompletableFuture<ListCertificatesByCaResponse> listCertificatesByCA(
            Consumer<ListCertificatesByCaRequest.Builder> listCertificatesByCaRequest) {
        return listCertificatesByCA(ListCertificatesByCaRequest.builder().applyMutation(listCertificatesByCaRequest).build());
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your AWS account.
     * </p>
     *
     * @param listDimensionsRequest
     * @return A Java Future containing the result of the ListDimensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListDimensions
     */
    default CompletableFuture<ListDimensionsResponse> listDimensions(ListDimensionsRequest listDimensionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDimensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDimensionsRequest#builder()}
     * </p>
     *
     * @param listDimensionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDimensionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDimensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListDimensions
     */
    default CompletableFuture<ListDimensionsResponse> listDimensions(Consumer<ListDimensionsRequest.Builder> listDimensionsRequest) {
        return listDimensions(ListDimensionsRequest.builder().applyMutation(listDimensionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param listDomainConfigurationsRequest
     * @return A Java Future containing the result of the ListDomainConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListDomainConfigurations
     */
    default CompletableFuture<ListDomainConfigurationsResponse> listDomainConfigurations(
            ListDomainConfigurationsRequest listDomainConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDomainConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDomainConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListDomainConfigurations
     */
    default CompletableFuture<ListDomainConfigurationsResponse> listDomainConfigurations(
            Consumer<ListDomainConfigurationsRequest.Builder> listDomainConfigurationsRequest) {
        return listDomainConfigurations(ListDomainConfigurationsRequest.builder().applyMutation(listDomainConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     *
     * @param listIndicesRequest
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListIndices
     */
    default CompletableFuture<ListIndicesResponse> listIndices(ListIndicesRequest listIndicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on {@link ListIndicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListIndices
     */
    default CompletableFuture<ListIndicesResponse> listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest) {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     *
     * @return A Java Future containing the result of the ListIndices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListIndices
     */
    default CompletableFuture<ListIndicesResponse> listIndices() {
        return listIndices(ListIndicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     * @return A Java Future containing the result of the ListJobExecutionsForJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForJob
     */
    default CompletableFuture<ListJobExecutionsForJobResponse> listJobExecutionsForJob(
            ListJobExecutionsForJobRequest listJobExecutionsForJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobExecutionsForJobRequest.Builder} avoiding
     * the need to create one manually via {@link ListJobExecutionsForJobRequest#builder()}
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     *        A {@link Consumer} that will call methods on {@link ListJobExecutionsForJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListJobExecutionsForJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForJob
     */
    default CompletableFuture<ListJobExecutionsForJobResponse> listJobExecutionsForJob(
            Consumer<ListJobExecutionsForJobRequest.Builder> listJobExecutionsForJobRequest) {
        return listJobExecutionsForJob(ListJobExecutionsForJobRequest.builder().applyMutation(listJobExecutionsForJobRequest)
                .build());
    }

    /**
     * <p>
     * Lists the job executions for the specified thing.
     * </p>
     *
     * @param listJobExecutionsForThingRequest
     * @return A Java Future containing the result of the ListJobExecutionsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForThing
     */
    default CompletableFuture<ListJobExecutionsForThingResponse> listJobExecutionsForThing(
            ListJobExecutionsForThingRequest listJobExecutionsForThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the job executions for the specified thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobExecutionsForThingRequest.Builder} avoiding
     * the need to create one manually via {@link ListJobExecutionsForThingRequest#builder()}
     * </p>
     *
     * @param listJobExecutionsForThingRequest
     *        A {@link Consumer} that will call methods on {@link ListJobExecutionsForThingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListJobExecutionsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobExecutionsForThing
     */
    default CompletableFuture<ListJobExecutionsForThingResponse> listJobExecutionsForThing(
            Consumer<ListJobExecutionsForThingRequest.Builder> listJobExecutionsForThingRequest) {
        return listJobExecutionsForThing(ListJobExecutionsForThingRequest.builder()
                .applyMutation(listJobExecutionsForThingRequest).build());
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @param listJobsRequest
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobs
     */
    default CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobs
     */
    default CompletableFuture<ListJobsResponse> listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     *
     * @return A Java Future containing the result of the ListJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListJobs
     */
    default CompletableFuture<ListJobsResponse> listJobs() {
        return listJobs(ListJobsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * </p>
     *
     * @param listMitigationActionsRequest
     * @return A Java Future containing the result of the ListMitigationActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListMitigationActions
     */
    default CompletableFuture<ListMitigationActionsResponse> listMitigationActions(
            ListMitigationActionsRequest listMitigationActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMitigationActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMitigationActionsRequest#builder()}
     * </p>
     *
     * @param listMitigationActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListMitigationActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMitigationActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListMitigationActions
     */
    default CompletableFuture<ListMitigationActionsResponse> listMitigationActions(
            Consumer<ListMitigationActionsRequest.Builder> listMitigationActionsRequest) {
        return listMitigationActions(ListMitigationActionsRequest.builder().applyMutation(listMitigationActionsRequest).build());
    }

    /**
     * <p>
     * Lists OTA updates.
     * </p>
     *
     * @param listOtaUpdatesRequest
     * @return A Java Future containing the result of the ListOTAUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOTAUpdates
     */
    default CompletableFuture<ListOtaUpdatesResponse> listOTAUpdates(ListOtaUpdatesRequest listOtaUpdatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists OTA updates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOtaUpdatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListOtaUpdatesRequest#builder()}
     * </p>
     *
     * @param listOtaUpdatesRequest
     *        A {@link Consumer} that will call methods on {@link ListOTAUpdatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOTAUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOTAUpdates
     */
    default CompletableFuture<ListOtaUpdatesResponse> listOTAUpdates(Consumer<ListOtaUpdatesRequest.Builder> listOtaUpdatesRequest) {
        return listOTAUpdates(ListOtaUpdatesRequest.builder().applyMutation(listOtaUpdatesRequest).build());
    }

    /**
     * <p>
     * Lists OTA updates.
     * </p>
     *
     * @return A Java Future containing the result of the ListOTAUpdates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOTAUpdates
     */
    default CompletableFuture<ListOtaUpdatesResponse> listOTAUpdates() {
        return listOTAUpdates(ListOtaUpdatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists certificates that are being transferred but not yet accepted.
     * </p>
     *
     * @param listOutgoingCertificatesRequest
     *        The input to the ListOutgoingCertificates operation.
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOutgoingCertificates
     */
    default CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates(
            ListOutgoingCertificatesRequest listOutgoingCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists certificates that are being transferred but not yet accepted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutgoingCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOutgoingCertificatesRequest#builder()}
     * </p>
     *
     * @param listOutgoingCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ListOutgoingCertificatesRequest.Builder} to create a
     *        request. The input to the ListOutgoingCertificates operation.
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOutgoingCertificates
     */
    default CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates(
            Consumer<ListOutgoingCertificatesRequest.Builder> listOutgoingCertificatesRequest) {
        return listOutgoingCertificates(ListOutgoingCertificatesRequest.builder().applyMutation(listOutgoingCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists certificates that are being transferred but not yet accepted.
     * </p>
     *
     * @return A Java Future containing the result of the ListOutgoingCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListOutgoingCertificates
     */
    default CompletableFuture<ListOutgoingCertificatesResponse> listOutgoingCertificates() {
        return listOutgoingCertificates(ListOutgoingCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     *
     * @param listPoliciesRequest
     *        The input for the ListPolicies operation.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicies
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(ListPoliciesRequest listPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request. The
     *        input for the ListPolicies operation.
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicies
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest) {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     *
     * @return A Java Future containing the result of the ListPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicies
     */
    default CompletableFuture<ListPoliciesResponse> listPolicies() {
        return listPolicies(ListPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the versions of the specified policy and identifies the default version.
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        The input for the ListPolicyVersions operation.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicyVersions
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of the specified policy and identifies the default version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPolicyVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPolicyVersionsRequest#builder()}
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListPolicyVersionsRequest.Builder} to create a
     *        request. The input for the ListPolicyVersions operation.
     * @return A Java Future containing the result of the ListPolicyVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPolicyVersions
     */
    default CompletableFuture<ListPolicyVersionsResponse> listPolicyVersions(
            Consumer<ListPolicyVersionsRequest.Builder> listPolicyVersionsRequest) {
        return listPolicyVersions(ListPolicyVersionsRequest.builder().applyMutation(listPolicyVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param listPrincipalThingsRequest
     *        The input for the ListPrincipalThings operation.
     * @return A Java Future containing the result of the ListPrincipalThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPrincipalThings
     */
    default CompletableFuture<ListPrincipalThingsResponse> listPrincipalThings(
            ListPrincipalThingsRequest listPrincipalThingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrincipalThingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListPrincipalThingsRequest#builder()}
     * </p>
     *
     * @param listPrincipalThingsRequest
     *        A {@link Consumer} that will call methods on {@link ListPrincipalThingsRequest.Builder} to create a
     *        request. The input for the ListPrincipalThings operation.
     * @return A Java Future containing the result of the ListPrincipalThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListPrincipalThings
     */
    default CompletableFuture<ListPrincipalThingsResponse> listPrincipalThings(
            Consumer<ListPrincipalThingsRequest.Builder> listPrincipalThingsRequest) {
        return listPrincipalThings(ListPrincipalThingsRequest.builder().applyMutation(listPrincipalThingsRequest).build());
    }

    /**
     * <p>
     * A list of fleet provisioning template versions.
     * </p>
     *
     * @param listProvisioningTemplateVersionsRequest
     * @return A Java Future containing the result of the ListProvisioningTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplateVersions
     */
    default CompletableFuture<ListProvisioningTemplateVersionsResponse> listProvisioningTemplateVersions(
            ListProvisioningTemplateVersionsRequest listProvisioningTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of fleet provisioning template versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningTemplateVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisioningTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listProvisioningTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProvisioningTemplateVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProvisioningTemplateVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplateVersions
     */
    default CompletableFuture<ListProvisioningTemplateVersionsResponse> listProvisioningTemplateVersions(
            Consumer<ListProvisioningTemplateVersionsRequest.Builder> listProvisioningTemplateVersionsRequest) {
        return listProvisioningTemplateVersions(ListProvisioningTemplateVersionsRequest.builder()
                .applyMutation(listProvisioningTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Lists the fleet provisioning templates in your AWS account.
     * </p>
     *
     * @param listProvisioningTemplatesRequest
     * @return A Java Future containing the result of the ListProvisioningTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplates
     */
    default CompletableFuture<ListProvisioningTemplatesResponse> listProvisioningTemplates(
            ListProvisioningTemplatesRequest listProvisioningTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the fleet provisioning templates in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisioningTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListProvisioningTemplatesRequest#builder()}
     * </p>
     *
     * @param listProvisioningTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListProvisioningTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProvisioningTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListProvisioningTemplates
     */
    default CompletableFuture<ListProvisioningTemplatesResponse> listProvisioningTemplates(
            Consumer<ListProvisioningTemplatesRequest.Builder> listProvisioningTemplatesRequest) {
        return listProvisioningTemplates(ListProvisioningTemplatesRequest.builder()
                .applyMutation(listProvisioningTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists the role aliases registered in your account.
     * </p>
     *
     * @param listRoleAliasesRequest
     * @return A Java Future containing the result of the ListRoleAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListRoleAliases
     */
    default CompletableFuture<ListRoleAliasesResponse> listRoleAliases(ListRoleAliasesRequest listRoleAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the role aliases registered in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRoleAliasesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRoleAliasesRequest#builder()}
     * </p>
     *
     * @param listRoleAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListRoleAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRoleAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListRoleAliases
     */
    default CompletableFuture<ListRoleAliasesResponse> listRoleAliases(
            Consumer<ListRoleAliasesRequest.Builder> listRoleAliasesRequest) {
        return listRoleAliases(ListRoleAliasesRequest.builder().applyMutation(listRoleAliasesRequest).build());
    }

    /**
     * <p>
     * Lists the role aliases registered in your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListRoleAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListRoleAliases
     */
    default CompletableFuture<ListRoleAliasesResponse> listRoleAliases() {
        return listRoleAliases(ListRoleAliasesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all of your scheduled audits.
     * </p>
     *
     * @param listScheduledAuditsRequest
     * @return A Java Future containing the result of the ListScheduledAudits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListScheduledAudits
     */
    default CompletableFuture<ListScheduledAuditsResponse> listScheduledAudits(
            ListScheduledAuditsRequest listScheduledAuditsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of your scheduled audits.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScheduledAuditsRequest.Builder} avoiding the
     * need to create one manually via {@link ListScheduledAuditsRequest#builder()}
     * </p>
     *
     * @param listScheduledAuditsRequest
     *        A {@link Consumer} that will call methods on {@link ListScheduledAuditsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListScheduledAudits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListScheduledAudits
     */
    default CompletableFuture<ListScheduledAuditsResponse> listScheduledAudits(
            Consumer<ListScheduledAuditsRequest.Builder> listScheduledAuditsRequest) {
        return listScheduledAudits(ListScheduledAuditsRequest.builder().applyMutation(listScheduledAuditsRequest).build());
    }

    /**
     * <p>
     * Lists all of your scheduled audits.
     * </p>
     *
     * @return A Java Future containing the result of the ListScheduledAudits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListScheduledAudits
     */
    default CompletableFuture<ListScheduledAuditsResponse> listScheduledAudits() {
        return listScheduledAudits(ListScheduledAuditsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Device Defender security profiles you have created. You can use filters to list only those security
     * profiles associated with a thing group or only those associated with your account.
     * </p>
     *
     * @param listSecurityProfilesRequest
     * @return A Java Future containing the result of the ListSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfiles
     */
    default CompletableFuture<ListSecurityProfilesResponse> listSecurityProfiles(
            ListSecurityProfilesRequest listSecurityProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Defender security profiles you have created. You can use filters to list only those security
     * profiles associated with a thing group or only those associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityProfilesRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfiles
     */
    default CompletableFuture<ListSecurityProfilesResponse> listSecurityProfiles(
            Consumer<ListSecurityProfilesRequest.Builder> listSecurityProfilesRequest) {
        return listSecurityProfiles(ListSecurityProfilesRequest.builder().applyMutation(listSecurityProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the Device Defender security profiles you have created. You can use filters to list only those security
     * profiles associated with a thing group or only those associated with your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListSecurityProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfiles
     */
    default CompletableFuture<ListSecurityProfilesResponse> listSecurityProfiles() {
        return listSecurityProfiles(ListSecurityProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the Device Defender security profiles attached to a target (thing group).
     * </p>
     *
     * @param listSecurityProfilesForTargetRequest
     * @return A Java Future containing the result of the ListSecurityProfilesForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfilesForTarget
     */
    default CompletableFuture<ListSecurityProfilesForTargetResponse> listSecurityProfilesForTarget(
            ListSecurityProfilesForTargetRequest listSecurityProfilesForTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Defender security profiles attached to a target (thing group).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityProfilesForTargetRequest.Builder}
     * avoiding the need to create one manually via {@link ListSecurityProfilesForTargetRequest#builder()}
     * </p>
     *
     * @param listSecurityProfilesForTargetRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityProfilesForTargetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSecurityProfilesForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListSecurityProfilesForTarget
     */
    default CompletableFuture<ListSecurityProfilesForTargetResponse> listSecurityProfilesForTarget(
            Consumer<ListSecurityProfilesForTargetRequest.Builder> listSecurityProfilesForTargetRequest) {
        return listSecurityProfilesForTarget(ListSecurityProfilesForTargetRequest.builder()
                .applyMutation(listSecurityProfilesForTargetRequest).build());
    }

    /**
     * <p>
     * Lists all of the streams in your AWS account.
     * </p>
     *
     * @param listStreamsRequest
     * @return A Java Future containing the result of the ListStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListStreams
     */
    default CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the streams in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamsRequest#builder()}
     * </p>
     *
     * @param listStreamsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListStreams
     */
    default CompletableFuture<ListStreamsResponse> listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) {
        return listStreams(ListStreamsRequest.builder().applyMutation(listStreamsRequest).build());
    }

    /**
     * <p>
     * Lists all of the streams in your AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListStreams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListStreams
     */
    default CompletableFuture<ListStreamsResponse> listStreams() {
        return listStreams(ListStreamsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTagsForResource
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTagsForResource
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List targets for the specified policy.
     * </p>
     *
     * @param listTargetsForPolicyRequest
     * @return A Java Future containing the result of the ListTargetsForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForPolicy
     */
    default CompletableFuture<ListTargetsForPolicyResponse> listTargetsForPolicy(
            ListTargetsForPolicyRequest listTargetsForPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List targets for the specified policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsForPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link ListTargetsForPolicyRequest#builder()}
     * </p>
     *
     * @param listTargetsForPolicyRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetsForPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTargetsForPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForPolicy
     */
    default CompletableFuture<ListTargetsForPolicyResponse> listTargetsForPolicy(
            Consumer<ListTargetsForPolicyRequest.Builder> listTargetsForPolicyRequest) {
        return listTargetsForPolicy(ListTargetsForPolicyRequest.builder().applyMutation(listTargetsForPolicyRequest).build());
    }

    /**
     * <p>
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * </p>
     *
     * @param listTargetsForSecurityProfileRequest
     * @return A Java Future containing the result of the ListTargetsForSecurityProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForSecurityProfile
     */
    default CompletableFuture<ListTargetsForSecurityProfileResponse> listTargetsForSecurityProfile(
            ListTargetsForSecurityProfileRequest listTargetsForSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsForSecurityProfileRequest.Builder}
     * avoiding the need to create one manually via {@link ListTargetsForSecurityProfileRequest#builder()}
     * </p>
     *
     * @param listTargetsForSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link ListTargetsForSecurityProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTargetsForSecurityProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTargetsForSecurityProfile
     */
    default CompletableFuture<ListTargetsForSecurityProfileResponse> listTargetsForSecurityProfile(
            Consumer<ListTargetsForSecurityProfileRequest.Builder> listTargetsForSecurityProfileRequest) {
        return listTargetsForSecurityProfile(ListTargetsForSecurityProfileRequest.builder()
                .applyMutation(listTargetsForSecurityProfileRequest).build());
    }

    /**
     * <p>
     * List the thing groups in your account.
     * </p>
     *
     * @param listThingGroupsRequest
     * @return A Java Future containing the result of the ListThingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroups
     */
    default CompletableFuture<ListThingGroupsResponse> listThingGroups(ListThingGroupsRequest listThingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the thing groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListThingGroupsRequest#builder()}
     * </p>
     *
     * @param listThingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListThingGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListThingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroups
     */
    default CompletableFuture<ListThingGroupsResponse> listThingGroups(
            Consumer<ListThingGroupsRequest.Builder> listThingGroupsRequest) {
        return listThingGroups(ListThingGroupsRequest.builder().applyMutation(listThingGroupsRequest).build());
    }

    /**
     * <p>
     * List the thing groups in your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListThingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroups
     */
    default CompletableFuture<ListThingGroupsResponse> listThingGroups() {
        return listThingGroups(ListThingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * List the thing groups to which the specified thing belongs.
     * </p>
     *
     * @param listThingGroupsForThingRequest
     * @return A Java Future containing the result of the ListThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroupsForThing
     */
    default CompletableFuture<ListThingGroupsForThingResponse> listThingGroupsForThing(
            ListThingGroupsForThingRequest listThingGroupsForThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the thing groups to which the specified thing belongs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingGroupsForThingRequest.Builder} avoiding
     * the need to create one manually via {@link ListThingGroupsForThingRequest#builder()}
     * </p>
     *
     * @param listThingGroupsForThingRequest
     *        A {@link Consumer} that will call methods on {@link ListThingGroupsForThingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingGroupsForThing
     */
    default CompletableFuture<ListThingGroupsForThingResponse> listThingGroupsForThing(
            Consumer<ListThingGroupsForThingRequest.Builder> listThingGroupsForThingRequest) {
        return listThingGroupsForThing(ListThingGroupsForThingRequest.builder().applyMutation(listThingGroupsForThingRequest)
                .build());
    }

    /**
     * <p>
     * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     *
     * @param listThingPrincipalsRequest
     *        The input for the ListThingPrincipal operation.
     * @return A Java Future containing the result of the ListThingPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingPrincipals
     */
    default CompletableFuture<ListThingPrincipalsResponse> listThingPrincipals(
            ListThingPrincipalsRequest listThingPrincipalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingPrincipalsRequest.Builder} avoiding the
     * need to create one manually via {@link ListThingPrincipalsRequest#builder()}
     * </p>
     *
     * @param listThingPrincipalsRequest
     *        A {@link Consumer} that will call methods on {@link ListThingPrincipalsRequest.Builder} to create a
     *        request. The input for the ListThingPrincipal operation.
     * @return A Java Future containing the result of the ListThingPrincipals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingPrincipals
     */
    default CompletableFuture<ListThingPrincipalsResponse> listThingPrincipals(
            Consumer<ListThingPrincipalsRequest.Builder> listThingPrincipalsRequest) {
        return listThingPrincipals(ListThingPrincipalsRequest.builder().applyMutation(listThingPrincipalsRequest).build());
    }

    /**
     * <p>
     * Information about the thing registration tasks.
     * </p>
     *
     * @param listThingRegistrationTaskReportsRequest
     * @return A Java Future containing the result of the ListThingRegistrationTaskReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTaskReports
     */
    default CompletableFuture<ListThingRegistrationTaskReportsResponse> listThingRegistrationTaskReports(
            ListThingRegistrationTaskReportsRequest listThingRegistrationTaskReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the thing registration tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingRegistrationTaskReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListThingRegistrationTaskReportsRequest#builder()}
     * </p>
     *
     * @param listThingRegistrationTaskReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListThingRegistrationTaskReportsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListThingRegistrationTaskReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTaskReports
     */
    default CompletableFuture<ListThingRegistrationTaskReportsResponse> listThingRegistrationTaskReports(
            Consumer<ListThingRegistrationTaskReportsRequest.Builder> listThingRegistrationTaskReportsRequest) {
        return listThingRegistrationTaskReports(ListThingRegistrationTaskReportsRequest.builder()
                .applyMutation(listThingRegistrationTaskReportsRequest).build());
    }

    /**
     * <p>
     * List bulk thing provisioning tasks.
     * </p>
     *
     * @param listThingRegistrationTasksRequest
     * @return A Java Future containing the result of the ListThingRegistrationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTasks
     */
    default CompletableFuture<ListThingRegistrationTasksResponse> listThingRegistrationTasks(
            ListThingRegistrationTasksRequest listThingRegistrationTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List bulk thing provisioning tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingRegistrationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link ListThingRegistrationTasksRequest#builder()}
     * </p>
     *
     * @param listThingRegistrationTasksRequest
     *        A {@link Consumer} that will call methods on {@link ListThingRegistrationTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListThingRegistrationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTasks
     */
    default CompletableFuture<ListThingRegistrationTasksResponse> listThingRegistrationTasks(
            Consumer<ListThingRegistrationTasksRequest.Builder> listThingRegistrationTasksRequest) {
        return listThingRegistrationTasks(ListThingRegistrationTasksRequest.builder()
                .applyMutation(listThingRegistrationTasksRequest).build());
    }

    /**
     * <p>
     * List bulk thing provisioning tasks.
     * </p>
     *
     * @return A Java Future containing the result of the ListThingRegistrationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingRegistrationTasks
     */
    default CompletableFuture<ListThingRegistrationTasksResponse> listThingRegistrationTasks() {
        return listThingRegistrationTasks(ListThingRegistrationTasksRequest.builder().build());
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     *
     * @param listThingTypesRequest
     *        The input for the ListThingTypes operation.
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingTypes
     */
    default CompletableFuture<ListThingTypesResponse> listThingTypes(ListThingTypesRequest listThingTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListThingTypesRequest#builder()}
     * </p>
     *
     * @param listThingTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListThingTypesRequest.Builder} to create a request.
     *        The input for the ListThingTypes operation.
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingTypes
     */
    default CompletableFuture<ListThingTypesResponse> listThingTypes(Consumer<ListThingTypesRequest.Builder> listThingTypesRequest) {
        return listThingTypes(ListThingTypesRequest.builder().applyMutation(listThingTypesRequest).build());
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     *
     * @return A Java Future containing the result of the ListThingTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingTypes
     */
    default CompletableFuture<ListThingTypesResponse> listThingTypes() {
        return listThingTypes(ListThingTypesRequest.builder().build());
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     *
     * @param listThingsRequest
     *        The input for the ListThings operation.
     * @return A Java Future containing the result of the ListThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThings
     */
    default CompletableFuture<ListThingsResponse> listThings(ListThingsRequest listThingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListThingsRequest#builder()}
     * </p>
     *
     * @param listThingsRequest
     *        A {@link Consumer} that will call methods on {@link ListThingsRequest.Builder} to create a request. The
     *        input for the ListThings operation.
     * @return A Java Future containing the result of the ListThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThings
     */
    default CompletableFuture<ListThingsResponse> listThings(Consumer<ListThingsRequest.Builder> listThingsRequest) {
        return listThings(ListThingsRequest.builder().applyMutation(listThingsRequest).build());
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>.
     * </p>
     *
     * @return A Java Future containing the result of the ListThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThings
     */
    default CompletableFuture<ListThingsResponse> listThings() {
        return listThings(ListThingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the things you have added to the given billing group.
     * </p>
     *
     * @param listThingsInBillingGroupRequest
     * @return A Java Future containing the result of the ListThingsInBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInBillingGroup
     */
    default CompletableFuture<ListThingsInBillingGroupResponse> listThingsInBillingGroup(
            ListThingsInBillingGroupRequest listThingsInBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the things you have added to the given billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingsInBillingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ListThingsInBillingGroupRequest#builder()}
     * </p>
     *
     * @param listThingsInBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListThingsInBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListThingsInBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInBillingGroup
     */
    default CompletableFuture<ListThingsInBillingGroupResponse> listThingsInBillingGroup(
            Consumer<ListThingsInBillingGroupRequest.Builder> listThingsInBillingGroupRequest) {
        return listThingsInBillingGroup(ListThingsInBillingGroupRequest.builder().applyMutation(listThingsInBillingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Lists the things in the specified group.
     * </p>
     *
     * @param listThingsInThingGroupRequest
     * @return A Java Future containing the result of the ListThingsInThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInThingGroup
     */
    default CompletableFuture<ListThingsInThingGroupResponse> listThingsInThingGroup(
            ListThingsInThingGroupRequest listThingsInThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the things in the specified group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListThingsInThingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ListThingsInThingGroupRequest#builder()}
     * </p>
     *
     * @param listThingsInThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListThingsInThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListThingsInThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListThingsInThingGroup
     */
    default CompletableFuture<ListThingsInThingGroupResponse> listThingsInThingGroup(
            Consumer<ListThingsInThingGroupRequest.Builder> listThingsInThingGroupRequest) {
        return listThingsInThingGroup(ListThingsInThingGroupRequest.builder().applyMutation(listThingsInThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the topic rule destinations in your AWS account.
     * </p>
     *
     * @param listTopicRuleDestinationsRequest
     * @return A Java Future containing the result of the ListTopicRuleDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRuleDestinations
     */
    default CompletableFuture<ListTopicRuleDestinationsResponse> listTopicRuleDestinations(
            ListTopicRuleDestinationsRequest listTopicRuleDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the topic rule destinations in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicRuleDestinationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTopicRuleDestinationsRequest#builder()}
     * </p>
     *
     * @param listTopicRuleDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicRuleDestinationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTopicRuleDestinations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRuleDestinations
     */
    default CompletableFuture<ListTopicRuleDestinationsResponse> listTopicRuleDestinations(
            Consumer<ListTopicRuleDestinationsRequest.Builder> listTopicRuleDestinationsRequest) {
        return listTopicRuleDestinations(ListTopicRuleDestinationsRequest.builder()
                .applyMutation(listTopicRuleDestinationsRequest).build());
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     *
     * @param listTopicRulesRequest
     *        The input for the ListTopicRules operation.
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRules
     */
    default CompletableFuture<ListTopicRulesResponse> listTopicRules(ListTopicRulesRequest listTopicRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTopicRulesRequest#builder()}
     * </p>
     *
     * @param listTopicRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListTopicRulesRequest.Builder} to create a request.
     *        The input for the ListTopicRules operation.
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRules
     */
    default CompletableFuture<ListTopicRulesResponse> listTopicRules(Consumer<ListTopicRulesRequest.Builder> listTopicRulesRequest) {
        return listTopicRules(ListTopicRulesRequest.builder().applyMutation(listTopicRulesRequest).build());
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     *
     * @return A Java Future containing the result of the ListTopicRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListTopicRules
     */
    default CompletableFuture<ListTopicRulesResponse> listTopicRules() {
        return listTopicRules(ListTopicRulesRequest.builder().build());
    }

    /**
     * <p>
     * Lists logging levels.
     * </p>
     *
     * @param listV2LoggingLevelsRequest
     * @return A Java Future containing the result of the ListV2LoggingLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListV2LoggingLevels
     */
    default CompletableFuture<ListV2LoggingLevelsResponse> listV2LoggingLevels(
            ListV2LoggingLevelsRequest listV2LoggingLevelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists logging levels.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListV2LoggingLevelsRequest.Builder} avoiding the
     * need to create one manually via {@link ListV2LoggingLevelsRequest#builder()}
     * </p>
     *
     * @param listV2LoggingLevelsRequest
     *        A {@link Consumer} that will call methods on {@link ListV2LoggingLevelsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListV2LoggingLevels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListV2LoggingLevels
     */
    default CompletableFuture<ListV2LoggingLevelsResponse> listV2LoggingLevels(
            Consumer<ListV2LoggingLevelsRequest.Builder> listV2LoggingLevelsRequest) {
        return listV2LoggingLevels(ListV2LoggingLevelsRequest.builder().applyMutation(listV2LoggingLevelsRequest).build());
    }

    /**
     * <p>
     * Lists the Device Defender security profile violations discovered during the given time period. You can use
     * filters to limit the results to those alerts issued for a particular security profile, behavior, or thing
     * (device).
     * </p>
     *
     * @param listViolationEventsRequest
     * @return A Java Future containing the result of the ListViolationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListViolationEvents
     */
    default CompletableFuture<ListViolationEventsResponse> listViolationEvents(
            ListViolationEventsRequest listViolationEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Defender security profile violations discovered during the given time period. You can use
     * filters to limit the results to those alerts issued for a particular security profile, behavior, or thing
     * (device).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListViolationEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListViolationEventsRequest#builder()}
     * </p>
     *
     * @param listViolationEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListViolationEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListViolationEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ListViolationEvents
     */
    default CompletableFuture<ListViolationEventsResponse> listViolationEvents(
            Consumer<ListViolationEventsRequest.Builder> listViolationEventsRequest) {
        return listViolationEvents(ListViolationEventsRequest.builder().applyMutation(listViolationEventsRequest).build());
    }

    /**
     * <p>
     * Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which
     * can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same
     * subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you
     * have more than one CA certificate registered, make sure you pass the CA certificate when you register your device
     * certificates with the RegisterCertificate API.
     * </p>
     *
     * @param registerCaCertificateRequest
     *        The input to the RegisterCACertificate operation.
     * @return A Java Future containing the result of the RegisterCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>RegistrationCodeValidationException The registration code is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCACertificate
     */
    default CompletableFuture<RegisterCaCertificateResponse> registerCACertificate(
            RegisterCaCertificateRequest registerCaCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a CA certificate with AWS IoT. This CA certificate can then be used to sign device certificates, which
     * can be then registered with AWS IoT. You can register up to 10 CA certificates per AWS account that have the same
     * subject field. This enables you to have up to 10 certificate authorities sign your device certificates. If you
     * have more than one CA certificate registered, make sure you pass the CA certificate when you register your device
     * certificates with the RegisterCertificate API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterCaCertificateRequest#builder()}
     * </p>
     *
     * @param registerCaCertificateRequest
     *        A {@link Consumer} that will call methods on {@link RegisterCACertificateRequest.Builder} to create a
     *        request. The input to the RegisterCACertificate operation.
     * @return A Java Future containing the result of the RegisterCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>RegistrationCodeValidationException The registration code is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCACertificate
     */
    default CompletableFuture<RegisterCaCertificateResponse> registerCACertificate(
            Consumer<RegisterCaCertificateRequest.Builder> registerCaCertificateRequest) {
        return registerCACertificate(RegisterCaCertificateRequest.builder().applyMutation(registerCaCertificateRequest).build());
    }

    /**
     * <p>
     * Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject
     * field, you must specify the CA certificate that was used to sign the device certificate being registered.
     * </p>
     *
     * @param registerCertificateRequest
     *        The input to the RegisterCertificate operation.
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateConflictException Unable to verify the CA certificate used to sign the device certificate
     *         you are attempting to register. This is happens when you have registered more than one CA certificate
     *         that has the same subject field and public key.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCertificate
     */
    default CompletableFuture<RegisterCertificateResponse> registerCertificate(
            RegisterCertificateRequest registerCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a device certificate with AWS IoT. If you have more than one CA certificate that has the same subject
     * field, you must specify the CA certificate that was used to sign the device certificate being registered.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterCertificateRequest#builder()}
     * </p>
     *
     * @param registerCertificateRequest
     *        A {@link Consumer} that will call methods on {@link RegisterCertificateRequest.Builder} to create a
     *        request. The input to the RegisterCertificate operation.
     * @return A Java Future containing the result of the RegisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateConflictException Unable to verify the CA certificate used to sign the device certificate
     *         you are attempting to register. This is happens when you have registered more than one CA certificate
     *         that has the same subject field and public key.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCertificate
     */
    default CompletableFuture<RegisterCertificateResponse> registerCertificate(
            Consumer<RegisterCertificateRequest.Builder> registerCertificateRequest) {
        return registerCertificate(RegisterCertificateRequest.builder().applyMutation(registerCertificateRequest).build());
    }

    /**
     * <p>
     * Register a certificate that does not have a certificate authority (CA).
     * </p>
     *
     * @param registerCertificateWithoutCaRequest
     * @return A Java Future containing the result of the RegisterCertificateWithoutCA operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCertificateWithoutCA
     */
    default CompletableFuture<RegisterCertificateWithoutCaResponse> registerCertificateWithoutCA(
            RegisterCertificateWithoutCaRequest registerCertificateWithoutCaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Register a certificate that does not have a certificate authority (CA).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCertificateWithoutCaRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterCertificateWithoutCaRequest#builder()}
     * </p>
     *
     * @param registerCertificateWithoutCaRequest
     *        A {@link Consumer} that will call methods on {@link RegisterCertificateWithoutCARequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RegisterCertificateWithoutCA operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterCertificateWithoutCA
     */
    default CompletableFuture<RegisterCertificateWithoutCaResponse> registerCertificateWithoutCA(
            Consumer<RegisterCertificateWithoutCaRequest.Builder> registerCertificateWithoutCaRequest) {
        return registerCertificateWithoutCA(RegisterCertificateWithoutCaRequest.builder()
                .applyMutation(registerCertificateWithoutCaRequest).build());
    }

    /**
     * <p>
     * Provisions a thing in the device registry. RegisterThing calls other AWS IoT control plane APIs. These calls
     * might exceed your account level <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> AWS IoT Throttling
     * Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">AWS
     * Customer Support</a> to raise your throttling limits if necessary.
     * </p>
     *
     * @param registerThingRequest
     * @return A Java Future containing the result of the RegisterThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>ResourceRegistrationFailureException The resource registration failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterThing
     */
    default CompletableFuture<RegisterThingResponse> registerThing(RegisterThingRequest registerThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provisions a thing in the device registry. RegisterThing calls other AWS IoT control plane APIs. These calls
     * might exceed your account level <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> AWS IoT Throttling
     * Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">AWS
     * Customer Support</a> to raise your throttling limits if necessary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterThingRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterThingRequest#builder()}
     * </p>
     *
     * @param registerThingRequest
     *        A {@link Consumer} that will call methods on {@link RegisterThingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>ResourceRegistrationFailureException The resource registration failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RegisterThing
     */
    default CompletableFuture<RegisterThingResponse> registerThing(Consumer<RegisterThingRequest.Builder> registerThingRequest) {
        return registerThing(RegisterThingRequest.builder().applyMutation(registerThingRequest).build());
    }

    /**
     * <p>
     * Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status
     * changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * This operation can only be called by the transfer destination. After it is called, the certificate will be
     * returned to the source's account in the INACTIVE state.
     * </p>
     *
     * @param rejectCertificateTransferRequest
     *        The input for the RejectCertificateTransfer operation.
     * @return A Java Future containing the result of the RejectCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RejectCertificateTransfer
     */
    default CompletableFuture<RejectCertificateTransferResponse> rejectCertificateTransfer(
            RejectCertificateTransferRequest rejectCertificateTransferRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects a pending certificate transfer. After AWS IoT rejects a certificate transfer, the certificate status
     * changes from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * This operation can only be called by the transfer destination. After it is called, the certificate will be
     * returned to the source's account in the INACTIVE state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectCertificateTransferRequest.Builder} avoiding
     * the need to create one manually via {@link RejectCertificateTransferRequest#builder()}
     * </p>
     *
     * @param rejectCertificateTransferRequest
     *        A {@link Consumer} that will call methods on {@link RejectCertificateTransferRequest.Builder} to create a
     *        request. The input for the RejectCertificateTransfer operation.
     * @return A Java Future containing the result of the RejectCertificateTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>TransferAlreadyCompletedException You can't revert the certificate transfer because the transfer is
     *         already complete.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RejectCertificateTransfer
     */
    default CompletableFuture<RejectCertificateTransferResponse> rejectCertificateTransfer(
            Consumer<RejectCertificateTransferRequest.Builder> rejectCertificateTransferRequest) {
        return rejectCertificateTransfer(RejectCertificateTransferRequest.builder()
                .applyMutation(rejectCertificateTransferRequest).build());
    }

    /**
     * <p>
     * Removes the given thing from the billing group.
     * </p>
     *
     * @param removeThingFromBillingGroupRequest
     * @return A Java Future containing the result of the RemoveThingFromBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromBillingGroup
     */
    default CompletableFuture<RemoveThingFromBillingGroupResponse> removeThingFromBillingGroup(
            RemoveThingFromBillingGroupRequest removeThingFromBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given thing from the billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveThingFromBillingGroupRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveThingFromBillingGroupRequest#builder()}
     * </p>
     *
     * @param removeThingFromBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link RemoveThingFromBillingGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveThingFromBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromBillingGroup
     */
    default CompletableFuture<RemoveThingFromBillingGroupResponse> removeThingFromBillingGroup(
            Consumer<RemoveThingFromBillingGroupRequest.Builder> removeThingFromBillingGroupRequest) {
        return removeThingFromBillingGroup(RemoveThingFromBillingGroupRequest.builder()
                .applyMutation(removeThingFromBillingGroupRequest).build());
    }

    /**
     * <p>
     * Remove the specified thing from the specified group.
     * </p>
     *
     * @param removeThingFromThingGroupRequest
     * @return A Java Future containing the result of the RemoveThingFromThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromThingGroup
     */
    default CompletableFuture<RemoveThingFromThingGroupResponse> removeThingFromThingGroup(
            RemoveThingFromThingGroupRequest removeThingFromThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove the specified thing from the specified group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveThingFromThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveThingFromThingGroupRequest#builder()}
     * </p>
     *
     * @param removeThingFromThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link RemoveThingFromThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveThingFromThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.RemoveThingFromThingGroup
     */
    default CompletableFuture<RemoveThingFromThingGroupResponse> removeThingFromThingGroup(
            Consumer<RemoveThingFromThingGroupRequest.Builder> removeThingFromThingGroupRequest) {
        return removeThingFromThingGroup(RemoveThingFromThingGroupRequest.builder()
                .applyMutation(removeThingFromThingGroupRequest).build());
    }

    /**
     * <p>
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level
     * action. Any user who has permission to create rules will be able to access data processed by the rule.
     * </p>
     *
     * @param replaceTopicRuleRequest
     *        The input for the ReplaceTopicRule operation.
     * @return A Java Future containing the result of the ReplaceTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ReplaceTopicRule
     */
    default CompletableFuture<ReplaceTopicRuleResponse> replaceTopicRule(ReplaceTopicRuleRequest replaceTopicRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level
     * action. Any user who has permission to create rules will be able to access data processed by the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReplaceTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link ReplaceTopicRuleRequest#builder()}
     * </p>
     *
     * @param replaceTopicRuleRequest
     *        A {@link Consumer} that will call methods on {@link ReplaceTopicRuleRequest.Builder} to create a request.
     *        The input for the ReplaceTopicRule operation.
     * @return A Java Future containing the result of the ReplaceTopicRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SqlParseException The Rule-SQL expression can't be parsed correctly.</li>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ReplaceTopicRule
     */
    default CompletableFuture<ReplaceTopicRuleResponse> replaceTopicRule(
            Consumer<ReplaceTopicRuleRequest.Builder> replaceTopicRuleRequest) {
        return replaceTopicRule(ReplaceTopicRuleRequest.builder().applyMutation(replaceTopicRuleRequest).build());
    }

    /**
     * <p>
     * The query search index.
     * </p>
     *
     * @param searchIndexRequest
     * @return A Java Future containing the result of the SearchIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SearchIndex
     */
    default CompletableFuture<SearchIndexResponse> searchIndex(SearchIndexRequest searchIndexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The query search index.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchIndexRequest.Builder} avoiding the need to
     * create one manually via {@link SearchIndexRequest#builder()}
     * </p>
     *
     * @param searchIndexRequest
     *        A {@link Consumer} that will call methods on {@link SearchIndexRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchIndex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>IndexNotReadyException The index is not ready.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SearchIndex
     */
    default CompletableFuture<SearchIndexResponse> searchIndex(Consumer<SearchIndexRequest.Builder> searchIndexRequest) {
        return searchIndex(SearchIndexRequest.builder().applyMutation(searchIndexRequest).build());
    }

    /**
     * <p>
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an
     * authorizer.
     * </p>
     *
     * @param setDefaultAuthorizerRequest
     * @return A Java Future containing the result of the SetDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultAuthorizer
     */
    default CompletableFuture<SetDefaultAuthorizerResponse> setDefaultAuthorizer(
            SetDefaultAuthorizerRequest setDefaultAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an
     * authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link SetDefaultAuthorizerRequest#builder()}
     * </p>
     *
     * @param setDefaultAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link SetDefaultAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetDefaultAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultAuthorizer
     */
    default CompletableFuture<SetDefaultAuthorizerResponse> setDefaultAuthorizer(
            Consumer<SetDefaultAuthorizerRequest.Builder> setDefaultAuthorizerRequest) {
        return setDefaultAuthorizer(SetDefaultAuthorizerRequest.builder().applyMutation(setDefaultAuthorizerRequest).build());
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action
     * affects all certificates to which the policy is attached. To list the principals the policy is attached to, use
     * the ListPrincipalPolicy API.
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     *        The input for the SetDefaultPolicyVersion operation.
     * @return A Java Future containing the result of the SetDefaultPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultPolicyVersion
     */
    default CompletableFuture<SetDefaultPolicyVersionResponse> setDefaultPolicyVersion(
            SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action
     * affects all certificates to which the policy is attached. To list the principals the policy is attached to, use
     * the ListPrincipalPolicy API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetDefaultPolicyVersionRequest.Builder} avoiding
     * the need to create one manually via {@link SetDefaultPolicyVersionRequest#builder()}
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     *        A {@link Consumer} that will call methods on {@link SetDefaultPolicyVersionRequest.Builder} to create a
     *        request. The input for the SetDefaultPolicyVersion operation.
     * @return A Java Future containing the result of the SetDefaultPolicyVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetDefaultPolicyVersion
     */
    default CompletableFuture<SetDefaultPolicyVersionResponse> setDefaultPolicyVersion(
            Consumer<SetDefaultPolicyVersionRequest.Builder> setDefaultPolicyVersionRequest) {
        return setDefaultPolicyVersion(SetDefaultPolicyVersionRequest.builder().applyMutation(setDefaultPolicyVersionRequest)
                .build());
    }

    /**
     * <p>
     * Sets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>SetV2LoggingOptions</code> instead.
     * </p>
     *
     * @param setLoggingOptionsRequest
     *        The input for the SetLoggingOptions operation.
     * @return A Java Future containing the result of the SetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetLoggingOptions
     */
    default CompletableFuture<SetLoggingOptionsResponse> setLoggingOptions(SetLoggingOptionsRequest setLoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>SetV2LoggingOptions</code> instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link SetLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param setLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link SetLoggingOptionsRequest.Builder} to create a request.
     *        The input for the SetLoggingOptions operation.
     * @return A Java Future containing the result of the SetLoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetLoggingOptions
     */
    default CompletableFuture<SetLoggingOptionsResponse> setLoggingOptions(
            Consumer<SetLoggingOptionsRequest.Builder> setLoggingOptionsRequest) {
        return setLoggingOptions(SetLoggingOptionsRequest.builder().applyMutation(setLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Sets the logging level.
     * </p>
     *
     * @param setV2LoggingLevelRequest
     * @return A Java Future containing the result of the SetV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingLevel
     */
    default CompletableFuture<SetV2LoggingLevelResponse> setV2LoggingLevel(SetV2LoggingLevelRequest setV2LoggingLevelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetV2LoggingLevelRequest.Builder} avoiding the need
     * to create one manually via {@link SetV2LoggingLevelRequest#builder()}
     * </p>
     *
     * @param setV2LoggingLevelRequest
     *        A {@link Consumer} that will call methods on {@link SetV2LoggingLevelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SetV2LoggingLevel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>NotConfiguredException The resource is not configured.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingLevel
     */
    default CompletableFuture<SetV2LoggingLevelResponse> setV2LoggingLevel(
            Consumer<SetV2LoggingLevelRequest.Builder> setV2LoggingLevelRequest) {
        return setV2LoggingLevel(SetV2LoggingLevelRequest.builder().applyMutation(setV2LoggingLevelRequest).build());
    }

    /**
     * <p>
     * Sets the logging options for the V2 logging service.
     * </p>
     *
     * @param setV2LoggingOptionsRequest
     * @return A Java Future containing the result of the SetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingOptions
     */
    default CompletableFuture<SetV2LoggingOptionsResponse> setV2LoggingOptions(
            SetV2LoggingOptionsRequest setV2LoggingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the logging options for the V2 logging service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetV2LoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link SetV2LoggingOptionsRequest#builder()}
     * </p>
     *
     * @param setV2LoggingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link SetV2LoggingOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SetV2LoggingOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.SetV2LoggingOptions
     */
    default CompletableFuture<SetV2LoggingOptionsResponse> setV2LoggingOptions(
            Consumer<SetV2LoggingOptionsRequest.Builder> setV2LoggingOptionsRequest) {
        return setV2LoggingOptions(SetV2LoggingOptionsRequest.builder().applyMutation(setV2LoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Starts a task that applies a set of mitigation actions to the specified target.
     * </p>
     *
     * @param startAuditMitigationActionsTaskRequest
     * @return A Java Future containing the result of the StartAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TaskAlreadyExistsException This exception occurs if you attempt to start a task with the same task-id
     *         as an existing task but with a different clientRequestToken.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartAuditMitigationActionsTask
     */
    default CompletableFuture<StartAuditMitigationActionsTaskResponse> startAuditMitigationActionsTask(
            StartAuditMitigationActionsTaskRequest startAuditMitigationActionsTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a task that applies a set of mitigation actions to the specified target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAuditMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartAuditMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param startAuditMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartAuditMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartAuditMitigationActionsTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TaskAlreadyExistsException This exception occurs if you attempt to start a task with the same task-id
     *         as an existing task but with a different clientRequestToken.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartAuditMitigationActionsTask
     */
    default CompletableFuture<StartAuditMitigationActionsTaskResponse> startAuditMitigationActionsTask(
            Consumer<StartAuditMitigationActionsTaskRequest.Builder> startAuditMitigationActionsTaskRequest) {
        return startAuditMitigationActionsTask(StartAuditMitigationActionsTaskRequest.builder()
                .applyMutation(startAuditMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand Device Defender audit.
     * </p>
     *
     * @param startOnDemandAuditTaskRequest
     * @return A Java Future containing the result of the StartOnDemandAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartOnDemandAuditTask
     */
    default CompletableFuture<StartOnDemandAuditTaskResponse> startOnDemandAuditTask(
            StartOnDemandAuditTaskRequest startOnDemandAuditTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand Device Defender audit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartOnDemandAuditTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartOnDemandAuditTaskRequest#builder()}
     * </p>
     *
     * @param startOnDemandAuditTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartOnDemandAuditTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartOnDemandAuditTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartOnDemandAuditTask
     */
    default CompletableFuture<StartOnDemandAuditTaskResponse> startOnDemandAuditTask(
            Consumer<StartOnDemandAuditTaskRequest.Builder> startOnDemandAuditTaskRequest) {
        return startOnDemandAuditTask(StartOnDemandAuditTaskRequest.builder().applyMutation(startOnDemandAuditTaskRequest)
                .build());
    }

    /**
     * <p>
     * Creates a bulk thing provisioning task.
     * </p>
     *
     * @param startThingRegistrationTaskRequest
     * @return A Java Future containing the result of the StartThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartThingRegistrationTask
     */
    default CompletableFuture<StartThingRegistrationTaskResponse> startThingRegistrationTask(
            StartThingRegistrationTaskRequest startThingRegistrationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a bulk thing provisioning task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartThingRegistrationTaskRequest.Builder} avoiding
     * the need to create one manually via {@link StartThingRegistrationTaskRequest#builder()}
     * </p>
     *
     * @param startThingRegistrationTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartThingRegistrationTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StartThingRegistrationTask
     */
    default CompletableFuture<StartThingRegistrationTaskResponse> startThingRegistrationTask(
            Consumer<StartThingRegistrationTaskRequest.Builder> startThingRegistrationTaskRequest) {
        return startThingRegistrationTask(StartThingRegistrationTaskRequest.builder()
                .applyMutation(startThingRegistrationTaskRequest).build());
    }

    /**
     * <p>
     * Cancels a bulk thing provisioning task.
     * </p>
     *
     * @param stopThingRegistrationTaskRequest
     * @return A Java Future containing the result of the StopThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StopThingRegistrationTask
     */
    default CompletableFuture<StopThingRegistrationTaskResponse> stopThingRegistrationTask(
            StopThingRegistrationTaskRequest stopThingRegistrationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a bulk thing provisioning task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopThingRegistrationTaskRequest.Builder} avoiding
     * the need to create one manually via {@link StopThingRegistrationTaskRequest#builder()}
     * </p>
     *
     * @param stopThingRegistrationTaskRequest
     *        A {@link Consumer} that will call methods on {@link StopThingRegistrationTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopThingRegistrationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.StopThingRegistrationTask
     */
    default CompletableFuture<StopThingRegistrationTaskResponse> stopThingRegistrationTask(
            Consumer<StopThingRegistrationTaskRequest.Builder> stopThingRegistrationTaskRequest) {
        return stopThingRegistrationTask(StopThingRegistrationTaskRequest.builder()
                .applyMutation(stopThingRegistrationTaskRequest).build());
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TagResource
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests if a specified principal is authorized to perform an AWS IoT action on a specified resource. Use this to
     * test and debug the authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     *
     * @param testAuthorizationRequest
     * @return A Java Future containing the result of the TestAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestAuthorization
     */
    default CompletableFuture<TestAuthorizationResponse> testAuthorization(TestAuthorizationRequest testAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests if a specified principal is authorized to perform an AWS IoT action on a specified resource. Use this to
     * test and debug the authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestAuthorizationRequest.Builder} avoiding the need
     * to create one manually via {@link TestAuthorizationRequest#builder()}
     * </p>
     *
     * @param testAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link TestAuthorizationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestAuthorization
     */
    default CompletableFuture<TestAuthorizationResponse> testAuthorization(
            Consumer<TestAuthorizationRequest.Builder> testAuthorizationRequest) {
        return testAuthorization(TestAuthorizationRequest.builder().applyMutation(testAuthorizationRequest).build());
    }

    /**
     * <p>
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the
     * custom authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidResponseException The response is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestInvokeAuthorizer
     */
    default CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the
     * custom authorization behavior of devices that connect to the AWS IoT device gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestInvokeAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link TestInvokeAuthorizerRequest#builder()}
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link TestInvokeAuthorizerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TestInvokeAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidResponseException The response is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TestInvokeAuthorizer
     */
    default CompletableFuture<TestInvokeAuthorizerResponse> testInvokeAuthorizer(
            Consumer<TestInvokeAuthorizerRequest.Builder> testInvokeAuthorizerRequest) {
        return testInvokeAuthorizer(TestInvokeAuthorizerRequest.builder().applyMutation(testInvokeAuthorizerRequest).build());
    }

    /**
     * <p>
     * Transfers the specified certificate to the specified AWS account.
     * </p>
     * <p>
     * You can cancel the transfer until it is acknowledged by the recipient.
     * </p>
     * <p>
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer
     * target.
     * </p>
     * <p>
     * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to
     * deactivate it.
     * </p>
     * <p>
     * The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach
     * them.
     * </p>
     *
     * @param transferCertificateRequest
     *        The input for the TransferCertificate operation.
     * @return A Java Future containing the result of the TransferCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>TransferConflictException You can't transfer the certificate because authorization policies are still
     *         attached.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TransferCertificate
     */
    default CompletableFuture<TransferCertificateResponse> transferCertificate(
            TransferCertificateRequest transferCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Transfers the specified certificate to the specified AWS account.
     * </p>
     * <p>
     * You can cancel the transfer until it is acknowledged by the recipient.
     * </p>
     * <p>
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer
     * target.
     * </p>
     * <p>
     * The certificate being transferred must not be in the ACTIVE state. You can use the UpdateCertificate API to
     * deactivate it.
     * </p>
     * <p>
     * The certificate must not have any policies attached to it. You can use the DetachPrincipalPolicy API to detach
     * them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TransferCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link TransferCertificateRequest#builder()}
     * </p>
     *
     * @param transferCertificateRequest
     *        A {@link Consumer} that will call methods on {@link TransferCertificateRequest.Builder} to create a
     *        request. The input for the TransferCertificate operation.
     * @return A Java Future containing the result of the TransferCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>TransferConflictException You can't transfer the certificate because authorization policies are still
     *         attached.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.TransferCertificate
     */
    default CompletableFuture<TransferCertificateResponse> transferCertificate(
            Consumer<TransferCertificateRequest.Builder> transferCertificateRequest) {
        return transferCertificate(TransferCertificateRequest.builder().applyMutation(transferCertificateRequest).build());
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UntagResource
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     *
     * @param updateAccountAuditConfigurationRequest
     * @return A Java Future containing the result of the UpdateAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAccountAuditConfiguration
     */
    default CompletableFuture<UpdateAccountAuditConfigurationResponse> updateAccountAuditConfiguration(
            UpdateAccountAuditConfigurationRequest updateAccountAuditConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountAuditConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccountAuditConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAccountAuditConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAccountAuditConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccountAuditConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAccountAuditConfiguration
     */
    default CompletableFuture<UpdateAccountAuditConfigurationResponse> updateAccountAuditConfiguration(
            Consumer<UpdateAccountAuditConfigurationRequest.Builder> updateAccountAuditConfigurationRequest) {
        return updateAccountAuditConfiguration(UpdateAccountAuditConfigurationRequest.builder()
                .applyMutation(updateAccountAuditConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an authorizer.
     * </p>
     *
     * @param updateAuthorizerRequest
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an authorizer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAuthorizerRequest#builder()}
     * </p>
     *
     * @param updateAuthorizerRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAuthorizerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAuthorizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>LimitExceededException A limit has been exceeded.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateAuthorizer
     */
    default CompletableFuture<UpdateAuthorizerResponse> updateAuthorizer(
            Consumer<UpdateAuthorizerRequest.Builder> updateAuthorizerRequest) {
        return updateAuthorizer(UpdateAuthorizerRequest.builder().applyMutation(updateAuthorizerRequest).build());
    }

    /**
     * <p>
     * Updates information about the billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateBillingGroup
     */
    default CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillingGroupRequest#builder()}
     * </p>
     *
     * @param updateBillingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBillingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBillingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateBillingGroup
     */
    default CompletableFuture<UpdateBillingGroupResponse> updateBillingGroup(
            Consumer<UpdateBillingGroupRequest.Builder> updateBillingGroupRequest) {
        return updateBillingGroup(UpdateBillingGroupRequest.builder().applyMutation(updateBillingGroupRequest).build());
    }

    /**
     * <p>
     * Updates a registered CA certificate.
     * </p>
     *
     * @param updateCaCertificateRequest
     *        The input to the UpdateCACertificate operation.
     * @return A Java Future containing the result of the UpdateCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCACertificate
     */
    default CompletableFuture<UpdateCACertificateResponse> updateCACertificate(
            UpdateCaCertificateRequest updateCaCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a registered CA certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCaCertificateRequest#builder()}
     * </p>
     *
     * @param updateCaCertificateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCACertificateRequest.Builder} to create a
     *        request. The input to the UpdateCACertificate operation.
     * @return A Java Future containing the result of the UpdateCACertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCACertificate
     */
    default CompletableFuture<UpdateCACertificateResponse> updateCACertificate(
            Consumer<UpdateCaCertificateRequest.Builder> updateCaCertificateRequest) {
        return updateCACertificate(UpdateCaCertificateRequest.builder().applyMutation(updateCaCertificateRequest).build());
    }

    /**
     * <p>
     * Updates the status of the specified certificate. This operation is idempotent.
     * </p>
     * <p>
     * Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices,
     * but these devices will be unable to reconnect.
     * </p>
     * <p>
     * The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.
     * </p>
     *
     * @param updateCertificateRequest
     *        The input for the UpdateCertificate operation.
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCertificate
     */
    default CompletableFuture<UpdateCertificateResponse> updateCertificate(UpdateCertificateRequest updateCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of the specified certificate. This operation is idempotent.
     * </p>
     * <p>
     * Moving a certificate from the ACTIVE state (including REVOKED) will not disconnect currently connected devices,
     * but these devices will be unable to reconnect.
     * </p>
     * <p>
     * The ACTIVE state is required to authenticate devices connecting to AWS IoT using a certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCertificateRequest#builder()}
     * </p>
     *
     * @param updateCertificateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCertificateRequest.Builder} to create a request.
     *        The input for the UpdateCertificate operation.
     * @return A Java Future containing the result of the UpdateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateStateException The certificate operation is not allowed.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateCertificate
     */
    default CompletableFuture<UpdateCertificateResponse> updateCertificate(
            Consumer<UpdateCertificateRequest.Builder> updateCertificateRequest) {
        return updateCertificate(UpdateCertificateRequest.builder().applyMutation(updateCertificateRequest).build());
    }

    /**
     * <p>
     * Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can
     * delete it and re-create it).
     * </p>
     *
     * @param updateDimensionRequest
     * @return A Java Future containing the result of the UpdateDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDimension
     */
    default CompletableFuture<UpdateDimensionResponse> updateDimension(UpdateDimensionRequest updateDimensionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can
     * delete it and re-create it).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDimensionRequest#builder()}
     * </p>
     *
     * @param updateDimensionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDimensionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDimension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDimension
     */
    default CompletableFuture<UpdateDimensionResponse> updateDimension(
            Consumer<UpdateDimensionRequest.Builder> updateDimensionRequest) {
        return updateDimension(UpdateDimensionRequest.builder().applyMutation(updateDimensionRequest).build());
    }

    /**
     * <p>
     * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note>
     *
     * @param updateDomainConfigurationRequest
     * @return A Java Future containing the result of the UpdateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDomainConfiguration
     */
    default CompletableFuture<UpdateDomainConfigurationResponse> updateDomainConfiguration(
            UpdateDomainConfigurationRequest updateDomainConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
     * </p>
     * <note>
     * <p>
     * The domain configuration feature is in public preview and is subject to change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDomainConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>CertificateValidationException The certificate is invalid.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDomainConfiguration
     */
    default CompletableFuture<UpdateDomainConfigurationResponse> updateDomainConfiguration(
            Consumer<UpdateDomainConfigurationRequest.Builder> updateDomainConfigurationRequest) {
        return updateDomainConfiguration(UpdateDomainConfigurationRequest.builder()
                .applyMutation(updateDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a dynamic thing group.
     * </p>
     *
     * @param updateDynamicThingGroupRequest
     * @return A Java Future containing the result of the UpdateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDynamicThingGroup
     */
    default CompletableFuture<UpdateDynamicThingGroupResponse> updateDynamicThingGroup(
            UpdateDynamicThingGroupRequest updateDynamicThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a dynamic thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDynamicThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDynamicThingGroupRequest#builder()}
     * </p>
     *
     * @param updateDynamicThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDynamicThingGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDynamicThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidQueryException The query is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateDynamicThingGroup
     */
    default CompletableFuture<UpdateDynamicThingGroupResponse> updateDynamicThingGroup(
            Consumer<UpdateDynamicThingGroupRequest.Builder> updateDynamicThingGroupRequest) {
        return updateDynamicThingGroup(UpdateDynamicThingGroupRequest.builder().applyMutation(updateDynamicThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Updates the event configurations.
     * </p>
     *
     * @param updateEventConfigurationsRequest
     * @return A Java Future containing the result of the UpdateEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateEventConfigurations
     */
    default CompletableFuture<UpdateEventConfigurationsResponse> updateEventConfigurations(
            UpdateEventConfigurationsRequest updateEventConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the event configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventConfigurationsRequest#builder()}
     * </p>
     *
     * @param updateEventConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateEventConfigurations
     */
    default CompletableFuture<UpdateEventConfigurationsResponse> updateEventConfigurations(
            Consumer<UpdateEventConfigurationsRequest.Builder> updateEventConfigurationsRequest) {
        return updateEventConfigurations(UpdateEventConfigurationsRequest.builder()
                .applyMutation(updateEventConfigurationsRequest).build());
    }

    /**
     * <p>
     * Updates the search configuration.
     * </p>
     *
     * @param updateIndexingConfigurationRequest
     * @return A Java Future containing the result of the UpdateIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateIndexingConfiguration
     */
    default CompletableFuture<UpdateIndexingConfigurationResponse> updateIndexingConfiguration(
            UpdateIndexingConfigurationRequest updateIndexingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the search configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateIndexingConfigurationRequest#builder()}
     * </p>
     *
     * @param updateIndexingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIndexingConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateIndexingConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateIndexingConfiguration
     */
    default CompletableFuture<UpdateIndexingConfigurationResponse> updateIndexingConfiguration(
            Consumer<UpdateIndexingConfigurationRequest.Builder> updateIndexingConfigurationRequest) {
        return updateIndexingConfiguration(UpdateIndexingConfigurationRequest.builder()
                .applyMutation(updateIndexingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates supported fields of the specified job.
     * </p>
     *
     * @param updateJobRequest
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateJob
     */
    default CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest updateJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates supported fields of the specified job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJobRequest#builder()}
     * </p>
     *
     * @param updateJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateJob
     */
    default CompletableFuture<UpdateJobResponse> updateJob(Consumer<UpdateJobRequest.Builder> updateJobRequest) {
        return updateJob(UpdateJobRequest.builder().applyMutation(updateJobRequest).build());
    }

    /**
     * <p>
     * Updates the definition for the specified mitigation action.
     * </p>
     *
     * @param updateMitigationActionRequest
     * @return A Java Future containing the result of the UpdateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateMitigationAction
     */
    default CompletableFuture<UpdateMitigationActionResponse> updateMitigationAction(
            UpdateMitigationActionRequest updateMitigationActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the definition for the specified mitigation action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMitigationActionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMitigationActionRequest#builder()}
     * </p>
     *
     * @param updateMitigationActionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMitigationActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateMitigationAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateMitigationAction
     */
    default CompletableFuture<UpdateMitigationActionResponse> updateMitigationAction(
            Consumer<UpdateMitigationActionRequest.Builder> updateMitigationActionRequest) {
        return updateMitigationAction(UpdateMitigationActionRequest.builder().applyMutation(updateMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Updates a fleet provisioning template.
     * </p>
     *
     * @param updateProvisioningTemplateRequest
     * @return A Java Future containing the result of the UpdateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateProvisioningTemplate
     */
    default CompletableFuture<UpdateProvisioningTemplateResponse> updateProvisioningTemplate(
            UpdateProvisioningTemplateRequest updateProvisioningTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a fleet provisioning template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProvisioningTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param updateProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProvisioningTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateProvisioningTemplate
     */
    default CompletableFuture<UpdateProvisioningTemplateResponse> updateProvisioningTemplate(
            Consumer<UpdateProvisioningTemplateRequest.Builder> updateProvisioningTemplateRequest) {
        return updateProvisioningTemplate(UpdateProvisioningTemplateRequest.builder()
                .applyMutation(updateProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Updates a role alias.
     * </p>
     *
     * @param updateRoleAliasRequest
     * @return A Java Future containing the result of the UpdateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateRoleAlias
     */
    default CompletableFuture<UpdateRoleAliasResponse> updateRoleAlias(UpdateRoleAliasRequest updateRoleAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a role alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRoleAliasRequest#builder()}
     * </p>
     *
     * @param updateRoleAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoleAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRoleAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateRoleAlias
     */
    default CompletableFuture<UpdateRoleAliasResponse> updateRoleAlias(
            Consumer<UpdateRoleAliasRequest.Builder> updateRoleAliasRequest) {
        return updateRoleAlias(UpdateRoleAliasRequest.builder().applyMutation(updateRoleAliasRequest).build());
    }

    /**
     * <p>
     * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
     * </p>
     *
     * @param updateScheduledAuditRequest
     * @return A Java Future containing the result of the UpdateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateScheduledAudit
     */
    default CompletableFuture<UpdateScheduledAuditResponse> updateScheduledAudit(
            UpdateScheduledAuditRequest updateScheduledAuditRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateScheduledAuditRequest#builder()}
     * </p>
     *
     * @param updateScheduledAuditRequest
     *        A {@link Consumer} that will call methods on {@link UpdateScheduledAuditRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateScheduledAudit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateScheduledAudit
     */
    default CompletableFuture<UpdateScheduledAuditResponse> updateScheduledAudit(
            Consumer<UpdateScheduledAuditRequest.Builder> updateScheduledAuditRequest) {
        return updateScheduledAudit(UpdateScheduledAuditRequest.builder().applyMutation(updateScheduledAuditRequest).build());
    }

    /**
     * <p>
     * Updates a Device Defender security profile.
     * </p>
     *
     * @param updateSecurityProfileRequest
     * @return A Java Future containing the result of the UpdateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateSecurityProfile
     */
    default CompletableFuture<UpdateSecurityProfileResponse> updateSecurityProfile(
            UpdateSecurityProfileRequest updateSecurityProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Device Defender security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param updateSecurityProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSecurityProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateSecurityProfile
     */
    default CompletableFuture<UpdateSecurityProfileResponse> updateSecurityProfile(
            Consumer<UpdateSecurityProfileRequest.Builder> updateSecurityProfileRequest) {
        return updateSecurityProfile(UpdateSecurityProfileRequest.builder().applyMutation(updateSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Updates an existing stream. The stream version will be incremented by one.
     * </p>
     *
     * @param updateStreamRequest
     * @return A Java Future containing the result of the UpdateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateStream
     */
    default CompletableFuture<UpdateStreamResponse> updateStream(UpdateStreamRequest updateStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing stream. The stream version will be incremented by one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStreamRequest#builder()}
     * </p>
     *
     * @param updateStreamRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateStream
     */
    default CompletableFuture<UpdateStreamResponse> updateStream(Consumer<UpdateStreamRequest.Builder> updateStreamRequest) {
        return updateStream(UpdateStreamRequest.builder().applyMutation(updateStreamRequest).build());
    }

    /**
     * <p>
     * Updates the data for a thing.
     * </p>
     *
     * @param updateThingRequest
     *        The input for the UpdateThing operation.
     * @return A Java Future containing the result of the UpdateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThing
     */
    default CompletableFuture<UpdateThingResponse> updateThing(UpdateThingRequest updateThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the data for a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThingRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateThingRequest#builder()}
     * </p>
     *
     * @param updateThingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThingRequest.Builder} to create a request. The
     *        input for the UpdateThing operation.
     * @return A Java Future containing the result of the UpdateThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThing
     */
    default CompletableFuture<UpdateThingResponse> updateThing(Consumer<UpdateThingRequest.Builder> updateThingRequest) {
        return updateThing(UpdateThingRequest.builder().applyMutation(updateThingRequest).build());
    }

    /**
     * <p>
     * Update a thing group.
     * </p>
     *
     * @param updateThingGroupRequest
     * @return A Java Future containing the result of the UpdateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroup
     */
    default CompletableFuture<UpdateThingGroupResponse> updateThingGroup(UpdateThingGroupRequest updateThingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a thing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateThingGroupRequest#builder()}
     * </p>
     *
     * @param updateThingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThingGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateThingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>VersionConflictException An exception thrown when the version of an entity specified with the
     *         <code>expectedVersion</code> parameter does not match the latest version in the system.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroup
     */
    default CompletableFuture<UpdateThingGroupResponse> updateThingGroup(
            Consumer<UpdateThingGroupRequest.Builder> updateThingGroupRequest) {
        return updateThingGroup(UpdateThingGroupRequest.builder().applyMutation(updateThingGroupRequest).build());
    }

    /**
     * <p>
     * Updates the groups to which the thing belongs.
     * </p>
     *
     * @param updateThingGroupsForThingRequest
     * @return A Java Future containing the result of the UpdateThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroupsForThing
     */
    default CompletableFuture<UpdateThingGroupsForThingResponse> updateThingGroupsForThing(
            UpdateThingGroupsForThingRequest updateThingGroupsForThingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the groups to which the thing belongs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateThingGroupsForThingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateThingGroupsForThingRequest#builder()}
     * </p>
     *
     * @param updateThingGroupsForThingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateThingGroupsForThingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateThingGroupsForThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>ResourceNotFoundException The specified resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateThingGroupsForThing
     */
    default CompletableFuture<UpdateThingGroupsForThingResponse> updateThingGroupsForThing(
            Consumer<UpdateThingGroupsForThingRequest.Builder> updateThingGroupsForThingRequest) {
        return updateThingGroupsForThing(UpdateThingGroupsForThingRequest.builder()
                .applyMutation(updateThingGroupsForThingRequest).build());
    }

    /**
     * <p>
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the
     * destination.
     * </p>
     *
     * @param updateTopicRuleDestinationRequest
     * @return A Java Future containing the result of the UpdateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateTopicRuleDestination
     */
    default CompletableFuture<UpdateTopicRuleDestinationResponse> updateTopicRuleDestination(
            UpdateTopicRuleDestinationRequest updateTopicRuleDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a topic rule destination. You use this to change the status, endpoint URL, or confirmation URL of the
     * destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param updateTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTopicRuleDestination operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException An unexpected error has occurred.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ServiceUnavailableException The service is temporarily unavailable.</li>
     *         <li>UnauthorizedException You are not authorized to perform this operation.</li>
     *         <li>ConflictingResourceUpdateException A conflicting resource update exception. This exception is thrown
     *         when two pending updates cause a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.UpdateTopicRuleDestination
     */
    default CompletableFuture<UpdateTopicRuleDestinationResponse> updateTopicRuleDestination(
            Consumer<UpdateTopicRuleDestinationRequest.Builder> updateTopicRuleDestinationRequest) {
        return updateTopicRuleDestination(UpdateTopicRuleDestinationRequest.builder()
                .applyMutation(updateTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Validates a Device Defender security profile behaviors specification.
     * </p>
     *
     * @param validateSecurityProfileBehaviorsRequest
     * @return A Java Future containing the result of the ValidateSecurityProfileBehaviors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ValidateSecurityProfileBehaviors
     */
    default CompletableFuture<ValidateSecurityProfileBehaviorsResponse> validateSecurityProfileBehaviors(
            ValidateSecurityProfileBehaviorsRequest validateSecurityProfileBehaviorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates a Device Defender security profile behaviors specification.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateSecurityProfileBehaviorsRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateSecurityProfileBehaviorsRequest#builder()}
     * </p>
     *
     * @param validateSecurityProfileBehaviorsRequest
     *        A {@link Consumer} that will call methods on {@link ValidateSecurityProfileBehaviorsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ValidateSecurityProfileBehaviors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ThrottlingException The rate exceeds the limit.</li>
     *         <li>InternalFailureException An unexpected error has occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IotException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample IotAsyncClient.ValidateSecurityProfileBehaviors
     */
    default CompletableFuture<ValidateSecurityProfileBehaviorsResponse> validateSecurityProfileBehaviors(
            Consumer<ValidateSecurityProfileBehaviorsRequest.Builder> validateSecurityProfileBehaviorsRequest) {
        return validateSecurityProfileBehaviors(ValidateSecurityProfileBehaviorsRequest.builder()
                .applyMutation(validateSecurityProfileBehaviorsRequest).build());
    }
}
