/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuditCheckToActionsMappingCopier;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskTarget;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAuditMitigationActionsTaskRequest
extends IotRequest
implements ToCopyableBuilder<Builder, StartAuditMitigationActionsTaskRequest> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAuditMitigationActionsTaskRequest.getter(StartAuditMitigationActionsTaskRequest::taskId)).setter(StartAuditMitigationActionsTaskRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("taskId").build()}).build();
    private static final SdkField<AuditMitigationActionsTaskTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartAuditMitigationActionsTaskRequest.getter(StartAuditMitigationActionsTaskRequest::target)).setter(StartAuditMitigationActionsTaskRequest.setter(Builder::target)).constructor(AuditMitigationActionsTaskTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<Map<String, List<String>>> AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(StartAuditMitigationActionsTaskRequest.getter(StartAuditMitigationActionsTaskRequest::auditCheckToActionsMapping)).setter(StartAuditMitigationActionsTaskRequest.setter(Builder::auditCheckToActionsMapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditCheckToActionsMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAuditMitigationActionsTaskRequest.getter(StartAuditMitigationActionsTaskRequest::clientRequestToken)).setter(StartAuditMitigationActionsTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, TARGET_FIELD, AUDIT_CHECK_TO_ACTIONS_MAPPING_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String taskId;
    private final AuditMitigationActionsTaskTarget target;
    private final Map<String, List<String>> auditCheckToActionsMapping;
    private final String clientRequestToken;

    private StartAuditMitigationActionsTaskRequest(BuilderImpl builder) {
        super(builder);
        this.taskId = builder.taskId;
        this.target = builder.target;
        this.auditCheckToActionsMapping = builder.auditCheckToActionsMapping;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String taskId() {
        return this.taskId;
    }

    public AuditMitigationActionsTaskTarget target() {
        return this.target;
    }

    public boolean hasAuditCheckToActionsMapping() {
        return this.auditCheckToActionsMapping != null && !(this.auditCheckToActionsMapping instanceof SdkAutoConstructMap);
    }

    public Map<String, List<String>> auditCheckToActionsMapping() {
        return this.auditCheckToActionsMapping;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.auditCheckToActionsMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAuditMitigationActionsTaskRequest)) {
            return false;
        }
        StartAuditMitigationActionsTaskRequest other = (StartAuditMitigationActionsTaskRequest)((Object)obj);
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.auditCheckToActionsMapping(), other.auditCheckToActionsMapping()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"StartAuditMitigationActionsTaskRequest").add("TaskId", (Object)this.taskId()).add("Target", (Object)this.target()).add("AuditCheckToActionsMapping", this.auditCheckToActionsMapping()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "auditCheckToActionsMapping": {
                return Optional.ofNullable(clazz.cast(this.auditCheckToActionsMapping()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAuditMitigationActionsTaskRequest, T> g) {
        return obj -> g.apply((StartAuditMitigationActionsTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String taskId;
        private AuditMitigationActionsTaskTarget target;
        private Map<String, List<String>> auditCheckToActionsMapping = DefaultSdkAutoConstructMap.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAuditMitigationActionsTaskRequest model) {
            super(model);
            this.taskId(model.taskId);
            this.target(model.target);
            this.auditCheckToActionsMapping(model.auditCheckToActionsMapping);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final AuditMitigationActionsTaskTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(AuditMitigationActionsTaskTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(AuditMitigationActionsTaskTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public final Map<String, ? extends Collection<String>> getAuditCheckToActionsMapping() {
            return this.auditCheckToActionsMapping;
        }

        @Override
        public final Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
            return this;
        }

        public final void setAuditCheckToActionsMapping(Map<String, ? extends Collection<String>> auditCheckToActionsMapping) {
            this.auditCheckToActionsMapping = AuditCheckToActionsMappingCopier.copy(auditCheckToActionsMapping);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAuditMitigationActionsTaskRequest build() {
            return new StartAuditMitigationActionsTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAuditMitigationActionsTaskRequest> {
        public Builder taskId(String var1);

        public Builder target(AuditMitigationActionsTaskTarget var1);

        default public Builder target(Consumer<AuditMitigationActionsTaskTarget.Builder> target) {
            return this.target((AuditMitigationActionsTaskTarget)((AuditMitigationActionsTaskTarget.Builder)AuditMitigationActionsTaskTarget.builder().applyMutation(target)).build());
        }

        public Builder auditCheckToActionsMapping(Map<String, ? extends Collection<String>> var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

