/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateDescription.Builder, CertificateDescription> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()).build();

    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::caCertificateId)).setter(setter(Builder::caCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::certificatePem)).setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<String> OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::ownedBy)).setter(setter(Builder::ownedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()).build();

    private static final SdkField<String> PREVIOUS_OWNED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::previousOwnedBy)).setter(setter(Builder::previousOwnedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousOwnedBy").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CertificateDescription::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CertificateDescription::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Integer> CUSTOMER_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CertificateDescription::customerVersion)).setter(setter(Builder::customerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerVersion").build()).build();

    private static final SdkField<TransferData> TRANSFER_DATA_FIELD = SdkField.<TransferData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CertificateDescription::transferData)).setter(setter(Builder::transferData))
            .constructor(TransferData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferData").build()).build();

    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::generationId)).setter(setter(Builder::generationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()).build();

    private static final SdkField<CertificateValidity> VALIDITY_FIELD = SdkField
            .<CertificateValidity> builder(MarshallingType.SDK_POJO).getter(getter(CertificateDescription::validity))
            .setter(setter(Builder::validity)).constructor(CertificateValidity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validity").build()).build();

    private static final SdkField<String> CERTIFICATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CertificateDescription::certificateModeAsString)).setter(setter(Builder::certificateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD,
            CERTIFICATE_ID_FIELD, CA_CERTIFICATE_ID_FIELD, STATUS_FIELD, CERTIFICATE_PEM_FIELD, OWNED_BY_FIELD,
            PREVIOUS_OWNED_BY_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, CUSTOMER_VERSION_FIELD, TRANSFER_DATA_FIELD,
            GENERATION_ID_FIELD, VALIDITY_FIELD, CERTIFICATE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateArn;

    private final String certificateId;

    private final String caCertificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final String previousOwnedBy;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final Integer customerVersion;

    private final TransferData transferData;

    private final String generationId;

    private final CertificateValidity validity;

    private final String certificateMode;

    private CertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.caCertificateId = builder.caCertificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.previousOwnedBy = builder.previousOwnedBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.transferData = builder.transferData;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
        this.certificateMode = builder.certificateMode;
    }

    /**
     * <p>
     * The ARN of the certificate.
     * </p>
     * 
     * @return The ARN of the certificate.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The ID of the certificate.
     * </p>
     * 
     * @return The ID of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The certificate ID of the CA certificate used to sign this certificate.
     * </p>
     * 
     * @return The certificate ID of the CA certificate used to sign this certificate.
     */
    public String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.
     * @see CertificateStatus
     */
    public CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the certificate.
     * @see CertificateStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the certificate.
     * </p>
     * 
     * @return The ID of the AWS account that owns the certificate.
     */
    public String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The ID of the AWS account of the previous owner of the certificate.
     * </p>
     * 
     * @return The ID of the AWS account of the previous owner of the certificate.
     */
    public String previousOwnedBy() {
        return previousOwnedBy;
    }

    /**
     * <p>
     * The date and time the certificate was created.
     * </p>
     * 
     * @return The date and time the certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time the certificate was last modified.
     * </p>
     * 
     * @return The date and time the certificate was last modified.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The customer version of the certificate.
     * </p>
     * 
     * @return The customer version of the certificate.
     */
    public Integer customerVersion() {
        return customerVersion;
    }

    /**
     * <p>
     * The transfer data.
     * </p>
     * 
     * @return The transfer data.
     */
    public TransferData transferData() {
        return transferData;
    }

    /**
     * <p>
     * The generation ID of the certificate.
     * </p>
     * 
     * @return The generation ID of the certificate.
     */
    public String generationId() {
        return generationId;
    }

    /**
     * <p>
     * When the certificate is valid.
     * </p>
     * 
     * @return When the certificate is valid.
     */
    public CertificateValidity validity() {
        return validity;
    }

    /**
     * <p>
     * The mode of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateMode}
     * will return {@link CertificateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateModeAsString}.
     * </p>
     * 
     * @return The mode of the certificate.
     * @see CertificateMode
     */
    public CertificateMode certificateMode() {
        return CertificateMode.fromValue(certificateMode);
    }

    /**
     * <p>
     * The mode of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #certificateMode}
     * will return {@link CertificateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #certificateModeAsString}.
     * </p>
     * 
     * @return The mode of the certificate.
     * @see CertificateMode
     */
    public String certificateModeAsString() {
        return certificateMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(previousOwnedBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(transferData());
        hashCode = 31 * hashCode + Objects.hashCode(generationId());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        hashCode = 31 * hashCode + Objects.hashCode(certificateModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateDescription)) {
            return false;
        }
        CertificateDescription other = (CertificateDescription) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(caCertificateId(), other.caCertificateId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(previousOwnedBy(), other.previousOwnedBy())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(customerVersion(), other.customerVersion())
                && Objects.equals(transferData(), other.transferData()) && Objects.equals(generationId(), other.generationId())
                && Objects.equals(validity(), other.validity())
                && Objects.equals(certificateModeAsString(), other.certificateModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CertificateDescription").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("CaCertificateId", caCertificateId()).add("Status", statusAsString())
                .add("CertificatePem", certificatePem()).add("OwnedBy", ownedBy()).add("PreviousOwnedBy", previousOwnedBy())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate())
                .add("CustomerVersion", customerVersion()).add("TransferData", transferData())
                .add("GenerationId", generationId()).add("Validity", validity())
                .add("CertificateMode", certificateModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "ownedBy":
            return Optional.ofNullable(clazz.cast(ownedBy()));
        case "previousOwnedBy":
            return Optional.ofNullable(clazz.cast(previousOwnedBy()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "customerVersion":
            return Optional.ofNullable(clazz.cast(customerVersion()));
        case "transferData":
            return Optional.ofNullable(clazz.cast(transferData()));
        case "generationId":
            return Optional.ofNullable(clazz.cast(generationId()));
        case "validity":
            return Optional.ofNullable(clazz.cast(validity()));
        case "certificateMode":
            return Optional.ofNullable(clazz.cast(certificateModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateDescription, T> g) {
        return obj -> g.apply((CertificateDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateDescription> {
        /**
         * <p>
         * The ARN of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The ARN of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The ID of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The certificate ID of the CA certificate used to sign this certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The certificate ID of the CA certificate used to sign this certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the certificate.
         * </p>
         * 
         * @param status
         *        The status of the certificate.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The ID of the AWS account that owns the certificate.
         * </p>
         * 
         * @param ownedBy
         *        The ID of the AWS account that owns the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The ID of the AWS account of the previous owner of the certificate.
         * </p>
         * 
         * @param previousOwnedBy
         *        The ID of the AWS account of the previous owner of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousOwnedBy(String previousOwnedBy);

        /**
         * <p>
         * The date and time the certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time the certificate was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the certificate was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The customer version of the certificate.
         * </p>
         * 
         * @param customerVersion
         *        The customer version of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerVersion(Integer customerVersion);

        /**
         * <p>
         * The transfer data.
         * </p>
         * 
         * @param transferData
         *        The transfer data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferData(TransferData transferData);

        /**
         * <p>
         * The transfer data.
         * </p>
         * This is a convenience that creates an instance of the {@link TransferData.Builder} avoiding the need to
         * create one manually via {@link TransferData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransferData.Builder#build()} is called immediately and its
         * result is passed to {@link #transferData(TransferData)}.
         * 
         * @param transferData
         *        a consumer that will call methods on {@link TransferData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transferData(TransferData)
         */
        default Builder transferData(Consumer<TransferData.Builder> transferData) {
            return transferData(TransferData.builder().applyMutation(transferData).build());
        }

        /**
         * <p>
         * The generation ID of the certificate.
         * </p>
         * 
         * @param generationId
         *        The generation ID of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationId(String generationId);

        /**
         * <p>
         * When the certificate is valid.
         * </p>
         * 
         * @param validity
         *        When the certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(CertificateValidity validity);

        /**
         * <p>
         * When the certificate is valid.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateValidity.Builder} avoiding the need
         * to create one manually via {@link CertificateValidity#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateValidity.Builder#build()} is called immediately and
         * its result is passed to {@link #validity(CertificateValidity)}.
         * 
         * @param validity
         *        a consumer that will call methods on {@link CertificateValidity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validity(CertificateValidity)
         */
        default Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return validity(CertificateValidity.builder().applyMutation(validity).build());
        }

        /**
         * <p>
         * The mode of the certificate.
         * </p>
         * 
         * @param certificateMode
         *        The mode of the certificate.
         * @see CertificateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateMode
         */
        Builder certificateMode(String certificateMode);

        /**
         * <p>
         * The mode of the certificate.
         * </p>
         * 
         * @param certificateMode
         *        The mode of the certificate.
         * @see CertificateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateMode
         */
        Builder certificateMode(CertificateMode certificateMode);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String caCertificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private String previousOwnedBy;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private Integer customerVersion;

        private TransferData transferData;

        private String generationId;

        private CertificateValidity validity;

        private String certificateMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateDescription model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            caCertificateId(model.caCertificateId);
            status(model.status);
            certificatePem(model.certificatePem);
            ownedBy(model.ownedBy);
            previousOwnedBy(model.previousOwnedBy);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            customerVersion(model.customerVersion);
            transferData(model.transferData);
            generationId(model.generationId);
            validity(model.validity);
            certificateMode(model.certificateMode);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final String getPreviousOwnedBy() {
            return previousOwnedBy;
        }

        @Override
        public final Builder previousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
            return this;
        }

        public final void setPreviousOwnedBy(String previousOwnedBy) {
            this.previousOwnedBy = previousOwnedBy;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getCustomerVersion() {
            return customerVersion;
        }

        @Override
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        public final TransferData.Builder getTransferData() {
            return transferData != null ? transferData.toBuilder() : null;
        }

        @Override
        public final Builder transferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public final void setTransferData(TransferData.BuilderImpl transferData) {
            this.transferData = transferData != null ? transferData.build() : null;
        }

        public final String getGenerationId() {
            return generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        public final CertificateValidity.Builder getValidity() {
            return validity != null ? validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public final String getCertificateMode() {
            return certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(CertificateMode certificateMode) {
            this.certificateMode(certificateMode == null ? null : certificateMode.toString());
            return this;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        @Override
        public CertificateDescription build() {
            return new CertificateDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
