/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduledAuditResponse extends IotResponse implements
        ToCopyableBuilder<CreateScheduledAuditResponse.Builder, CreateScheduledAuditResponse> {
    private static final SdkField<String> SCHEDULED_AUDIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateScheduledAuditResponse::scheduledAuditArn)).setter(setter(Builder::scheduledAuditArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledAuditArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_AUDIT_ARN_FIELD));

    private final String scheduledAuditArn;

    private CreateScheduledAuditResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledAuditArn = builder.scheduledAuditArn;
    }

    /**
     * <p>
     * The ARN of the scheduled audit.
     * </p>
     * 
     * @return The ARN of the scheduled audit.
     */
    public String scheduledAuditArn() {
        return scheduledAuditArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledAuditArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledAuditResponse)) {
            return false;
        }
        CreateScheduledAuditResponse other = (CreateScheduledAuditResponse) obj;
        return Objects.equals(scheduledAuditArn(), other.scheduledAuditArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateScheduledAuditResponse").add("ScheduledAuditArn", scheduledAuditArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduledAuditArn":
            return Optional.ofNullable(clazz.cast(scheduledAuditArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledAuditResponse, T> g) {
        return obj -> g.apply((CreateScheduledAuditResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduledAuditResponse> {
        /**
         * <p>
         * The ARN of the scheduled audit.
         * </p>
         * 
         * @param scheduledAuditArn
         *        The ARN of the scheduled audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledAuditArn(String scheduledAuditArn);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String scheduledAuditArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledAuditResponse model) {
            super(model);
            scheduledAuditArn(model.scheduledAuditArn);
        }

        public final String getScheduledAuditArn() {
            return scheduledAuditArn;
        }

        @Override
        public final Builder scheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
            return this;
        }

        public final void setScheduledAuditArn(String scheduledAuditArn) {
            this.scheduledAuditArn = scheduledAuditArn;
        }

        @Override
        public CreateScheduledAuditResponse build() {
            return new CreateScheduledAuditResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
