/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIndexResponse extends IotResponse implements
        ToCopyableBuilder<DescribeIndexResponse.Builder, DescribeIndexResponse> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::indexStatusAsString)).setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexStatus").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeIndexResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            INDEX_STATUS_FIELD, SCHEMA_FIELD));

    private final String indexName;

    private final String indexStatus;

    private final String schema;

    private DescribeIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexName = builder.indexName;
        this.indexStatus = builder.indexStatus;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The index name.
     * </p>
     * 
     * @return The index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The index status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The index status.
     * @see IndexStatus
     */
    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * The index status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The index status.
     * @see IndexStatus
     */
    public String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * Contains a value that specifies the type of indexing performed. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains only registry data.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status data.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing
     * connectivity status data.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Contains a value that specifies the type of indexing performed. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains only registry data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status
     *         data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and
     *         thing connectivity status data.
     *         </p>
     *         </li>
     */
    public String schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIndexResponse)) {
            return false;
        }
        DescribeIndexResponse other = (DescribeIndexResponse) obj;
        return Objects.equals(indexName(), other.indexName())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeIndexResponse").add("IndexName", indexName()).add("IndexStatus", indexStatusAsString())
                .add("Schema", schema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "indexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIndexResponse, T> g) {
        return obj -> g.apply((DescribeIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIndexResponse> {
        /**
         * <p>
         * The index name.
         * </p>
         * 
         * @param indexName
         *        The index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The index status.
         * </p>
         * 
         * @param indexStatus
         *        The index status.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The index status.
         * </p>
         * 
         * @param indexStatus
         *        The index status.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * Contains a value that specifies the type of indexing performed. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains only registry data.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity status
         * data.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data, and thing
         * connectivity status data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schema
         *        Contains a value that specifies the type of indexing performed. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains only registry data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry data and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_CONNECTIVITY_STATUS - Your thing index contains registry data and thing connectivity
         *        status data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW_AND_CONNECTIVITY_STATUS - Your thing index contains registry data, shadow data,
         *        and thing connectivity status data.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String indexName;

        private String indexStatus;

        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIndexResponse model) {
            super(model);
            indexName(model.indexName);
            indexStatus(model.indexStatus);
            schema(model.schema);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final String getSchema() {
            return schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public DescribeIndexResponse build() {
            return new DescribeIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
