/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditSuppressionsResponse extends IotResponse implements
        ToCopyableBuilder<ListAuditSuppressionsResponse.Builder, ListAuditSuppressionsResponse> {
    private static final SdkField<List<AuditSuppression>> SUPPRESSIONS_FIELD = SdkField
            .<List<AuditSuppression>> builder(MarshallingType.LIST)
            .getter(getter(ListAuditSuppressionsResponse::suppressions))
            .setter(setter(Builder::suppressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditSuppression> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditSuppression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditSuppressionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuditSuppression> suppressions;

    private final String nextToken;

    private ListAuditSuppressionsResponse(BuilderImpl builder) {
        super(builder);
        this.suppressions = builder.suppressions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Suppressions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSuppressions() {
        return suppressions != null && !(suppressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of audit suppressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuppressions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of audit suppressions.
     */
    public List<AuditSuppression> suppressions() {
        return suppressions;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suppressions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditSuppressionsResponse)) {
            return false;
        }
        ListAuditSuppressionsResponse other = (ListAuditSuppressionsResponse) obj;
        return Objects.equals(suppressions(), other.suppressions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuditSuppressionsResponse").add("Suppressions", suppressions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suppressions":
            return Optional.ofNullable(clazz.cast(suppressions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditSuppressionsResponse, T> g) {
        return obj -> g.apply((ListAuditSuppressionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAuditSuppressionsResponse> {
        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * 
         * @param suppressions
         *        List of audit suppressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressions(Collection<AuditSuppression> suppressions);

        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * 
         * @param suppressions
         *        List of audit suppressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressions(AuditSuppression... suppressions);

        /**
         * <p>
         * List of audit suppressions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuditSuppression>.Builder} avoiding the
         * need to create one manually via {@link List<AuditSuppression>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuditSuppression>.Builder#build()} is called immediately and
         * its result is passed to {@link #suppressions(List<AuditSuppression>)}.
         * 
         * @param suppressions
         *        a consumer that will call methods on {@link List<AuditSuppression>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressions(List<AuditSuppression>)
         */
        Builder suppressions(Consumer<AuditSuppression.Builder>... suppressions);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuditSuppression> suppressions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditSuppressionsResponse model) {
            super(model);
            suppressions(model.suppressions);
            nextToken(model.nextToken);
        }

        public final Collection<AuditSuppression.Builder> getSuppressions() {
            return suppressions != null ? suppressions.stream().map(AuditSuppression::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder suppressions(Collection<AuditSuppression> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copy(suppressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressions(AuditSuppression... suppressions) {
            suppressions(Arrays.asList(suppressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressions(Consumer<AuditSuppression.Builder>... suppressions) {
            suppressions(Stream.of(suppressions).map(c -> AuditSuppression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuppressions(Collection<AuditSuppression.BuilderImpl> suppressions) {
            this.suppressions = AuditSuppressionListCopier.copyFromBuilder(suppressions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAuditSuppressionsResponse build() {
            return new ListAuditSuppressionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
