/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOtaUpdateRequest extends IotRequest implements
        ToCopyableBuilder<CreateOtaUpdateRequest.Builder, CreateOtaUpdateRequest> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateOtaUpdateRequest::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("otaUpdateId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateOtaUpdateRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateOtaUpdateRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateOtaUpdateRequest::protocolsAsStrings))
            .setter(setter(Builder::protocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateOtaUpdateRequest::targetSelectionAsString)).setter(setter(Builder::targetSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()).build();

    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<AwsJobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateOtaUpdateRequest::awsJobExecutionsRolloutConfig))
            .setter(setter(Builder::awsJobExecutionsRolloutConfig))
            .constructor(AwsJobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig")
                    .build()).build();

    private static final SdkField<AwsJobPresignedUrlConfig> AWS_JOB_PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<AwsJobPresignedUrlConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateOtaUpdateRequest::awsJobPresignedUrlConfig)).setter(setter(Builder::awsJobPresignedUrlConfig))
            .constructor(AwsJobPresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobPresignedUrlConfig").build())
            .build();

    private static final SdkField<AwsJobAbortConfig> AWS_JOB_ABORT_CONFIG_FIELD = SdkField
            .<AwsJobAbortConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateOtaUpdateRequest::awsJobAbortConfig))
            .setter(setter(Builder::awsJobAbortConfig)).constructor(AwsJobAbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobAbortConfig").build()).build();

    private static final SdkField<AwsJobTimeoutConfig> AWS_JOB_TIMEOUT_CONFIG_FIELD = SdkField
            .<AwsJobTimeoutConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateOtaUpdateRequest::awsJobTimeoutConfig))
            .setter(setter(Builder::awsJobTimeoutConfig)).constructor(AwsJobTimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobTimeoutConfig").build())
            .build();

    private static final SdkField<List<OTAUpdateFile>> FILES_FIELD = SdkField
            .<List<OTAUpdateFile>> builder(MarshallingType.LIST)
            .getter(getter(CreateOtaUpdateRequest::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OTAUpdateFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(OTAUpdateFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateOtaUpdateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateOtaUpdateRequest::additionalParameters))
            .setter(setter(Builder::additionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateOtaUpdateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            DESCRIPTION_FIELD, TARGETS_FIELD, PROTOCOLS_FIELD, TARGET_SELECTION_FIELD, AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD,
            AWS_JOB_PRESIGNED_URL_CONFIG_FIELD, AWS_JOB_ABORT_CONFIG_FIELD, AWS_JOB_TIMEOUT_CONFIG_FIELD, FILES_FIELD,
            ROLE_ARN_FIELD, ADDITIONAL_PARAMETERS_FIELD, TAGS_FIELD));

    private final String otaUpdateId;

    private final String description;

    private final List<String> targets;

    private final List<String> protocols;

    private final String targetSelection;

    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

    private final AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;

    private final AwsJobAbortConfig awsJobAbortConfig;

    private final AwsJobTimeoutConfig awsJobTimeoutConfig;

    private final List<OTAUpdateFile> files;

    private final String roleArn;

    private final Map<String, String> additionalParameters;

    private final List<Tag> tags;

    private CreateOtaUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.otaUpdateId = builder.otaUpdateId;
        this.description = builder.description;
        this.targets = builder.targets;
        this.protocols = builder.protocols;
        this.targetSelection = builder.targetSelection;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.awsJobPresignedUrlConfig = builder.awsJobPresignedUrlConfig;
        this.awsJobAbortConfig = builder.awsJobAbortConfig;
        this.awsJobTimeoutConfig = builder.awsJobTimeoutConfig;
        this.files = builder.files;
        this.roleArn = builder.roleArn;
        this.additionalParameters = builder.additionalParameters;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the OTA update to be created.
     * </p>
     * 
     * @return The ID of the OTA update to be created.
     */
    public String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The description of the OTA update.
     * </p>
     * 
     * @return The description of the OTA update.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The devices targeted to receive OTA updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The devices targeted to receive OTA updates.
     */
    public List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP
     * and MQTT are specified, the target device can choose the protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When
     *         both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(protocols);
    }

    /**
     * Returns true if the Protocols property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both HTTP
     * and MQTT are specified, the target device can choose the protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When
     *         both HTTP and MQTT are specified, the target device can choose the protocol.
     */
    public List<String> protocolsAsStrings() {
        return protocols;
    }

    /**
     * <p>
     * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing
     * when a change is detected in a target. For example, an update will run on a thing when the thing is added to a
     * target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS
     * | SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     *         specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
     *         thing when a change is detected in a target. For example, an update will run on a thing when the thing is
     *         added to a target group, even after the update was completed by all things originally in the group. Valid
     *         values: CONTINUOUS | SNAPSHOT.
     * @see TargetSelection
     */
    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(targetSelection);
    }

    /**
     * <p>
     * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a thing
     * when a change is detected in a target. For example, an update will run on a thing when the thing is added to a
     * target group, even after the update was completed by all things originally in the group. Valid values: CONTINUOUS
     * | SNAPSHOT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
     *         specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
     *         thing when a change is detected in a target. For example, an update will run on a thing when the thing is
     *         added to a target group, even after the update was completed by all things originally in the group. Valid
     *         values: CONTINUOUS | SNAPSHOT.
     * @see TargetSelection
     */
    public String targetSelectionAsString() {
        return targetSelection;
    }

    /**
     * <p>
     * Configuration for the rollout of OTA updates.
     * </p>
     * 
     * @return Configuration for the rollout of OTA updates.
     */
    public AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return awsJobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * Configuration information for pre-signed URLs.
     * </p>
     * 
     * @return Configuration information for pre-signed URLs.
     */
    public AwsJobPresignedUrlConfig awsJobPresignedUrlConfig() {
        return awsJobPresignedUrlConfig;
    }

    /**
     * <p>
     * The criteria that determine when and how a job abort takes place.
     * </p>
     * 
     * @return The criteria that determine when and how a job abort takes place.
     */
    public AwsJobAbortConfig awsJobAbortConfig() {
        return awsJobAbortConfig;
    }

    /**
     * <p>
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job
     * execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal
     * state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time each device has to finish its execution of the job. A timer is started when
     *         the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
     *         another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
     */
    public AwsJobTimeoutConfig awsJobTimeoutConfig() {
        return awsJobTimeoutConfig;
    }

    /**
     * Returns true if the Files property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The files to be streamed by the OTA update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The files to be streamed by the OTA update.
     */
    public List<OTAUpdateFile> files() {
        return files;
    }

    /**
     * <p>
     * The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to create
     * an OTA update job.
     * </p>
     * 
     * @return The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to
     *         create an OTA update job.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the AdditionalParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalParameters() {
        return additionalParameters != null && !(additionalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of additional OTA update parameters which are name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of additional OTA update parameters which are name-value pairs.
     */
    public Map<String, String> additionalParameters() {
        return additionalParameters;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata which can be used to manage updates.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(protocolsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobPresignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobAbortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobTimeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(files());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(additionalParameters());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOtaUpdateRequest)) {
            return false;
        }
        CreateOtaUpdateRequest other = (CreateOtaUpdateRequest) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(description(), other.description())
                && Objects.equals(targets(), other.targets()) && Objects.equals(protocolsAsStrings(), other.protocolsAsStrings())
                && Objects.equals(targetSelectionAsString(), other.targetSelectionAsString())
                && Objects.equals(awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig())
                && Objects.equals(awsJobPresignedUrlConfig(), other.awsJobPresignedUrlConfig())
                && Objects.equals(awsJobAbortConfig(), other.awsJobAbortConfig())
                && Objects.equals(awsJobTimeoutConfig(), other.awsJobTimeoutConfig()) && Objects.equals(files(), other.files())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(additionalParameters(), other.additionalParameters()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateOtaUpdateRequest").add("OtaUpdateId", otaUpdateId()).add("Description", description())
                .add("Targets", targets()).add("Protocols", protocolsAsStrings())
                .add("TargetSelection", targetSelectionAsString())
                .add("AwsJobExecutionsRolloutConfig", awsJobExecutionsRolloutConfig())
                .add("AwsJobPresignedUrlConfig", awsJobPresignedUrlConfig()).add("AwsJobAbortConfig", awsJobAbortConfig())
                .add("AwsJobTimeoutConfig", awsJobTimeoutConfig()).add("Files", files()).add("RoleArn", roleArn())
                .add("AdditionalParameters", additionalParameters()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "protocols":
            return Optional.ofNullable(clazz.cast(protocolsAsStrings()));
        case "targetSelection":
            return Optional.ofNullable(clazz.cast(targetSelectionAsString()));
        case "awsJobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(awsJobExecutionsRolloutConfig()));
        case "awsJobPresignedUrlConfig":
            return Optional.ofNullable(clazz.cast(awsJobPresignedUrlConfig()));
        case "awsJobAbortConfig":
            return Optional.ofNullable(clazz.cast(awsJobAbortConfig()));
        case "awsJobTimeoutConfig":
            return Optional.ofNullable(clazz.cast(awsJobTimeoutConfig()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "additionalParameters":
            return Optional.ofNullable(clazz.cast(additionalParameters()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOtaUpdateRequest, T> g) {
        return obj -> g.apply((CreateOtaUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOtaUpdateRequest> {
        /**
         * <p>
         * The ID of the OTA update to be created.
         * </p>
         * 
         * @param otaUpdateId
         *        The ID of the OTA update to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The description of the OTA update.
         * </p>
         * 
         * @param description
         *        The description of the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The devices targeted to receive OTA updates.
         * </p>
         * 
         * @param targets
         *        The devices targeted to receive OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The devices targeted to receive OTA updates.
         * </p>
         * 
         * @param targets
         *        The devices targeted to receive OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(Collection<String> protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(String... protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<Protocol> protocols);

        /**
         * <p>
         * The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT]. When both
         * HTTP and MQTT are specified, the target device can choose the protocol.
         * </p>
         * 
         * @param protocols
         *        The protocol used to transfer the OTA update image. Valid values are [HTTP], [MQTT], [HTTP, MQTT].
         *        When both HTTP and MQTT are specified, the target device can choose the protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Protocol... protocols);

        /**
         * <p>
         * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
         * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
         * thing when a change is detected in a target. For example, an update will run on a thing when the thing is
         * added to a target group, even after the update was completed by all things originally in the group. Valid
         * values: CONTINUOUS | SNAPSHOT.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the
         *        things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also
         *        be run on a thing when a change is detected in a target. For example, an update will run on a thing
         *        when the thing is added to a target group, even after the update was completed by all things
         *        originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(String targetSelection);

        /**
         * <p>
         * Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the things
         * specified as targets have completed the update (SNAPSHOT). If continuous, the update may also be run on a
         * thing when a change is detected in a target. For example, an update will run on a thing when the thing is
         * added to a target group, even after the update was completed by all things originally in the group. Valid
         * values: CONTINUOUS | SNAPSHOT.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the update will continue to run (CONTINUOUS), or will be complete after all the
         *        things specified as targets have completed the update (SNAPSHOT). If continuous, the update may also
         *        be run on a thing when a change is detected in a target. For example, an update will run on a thing
         *        when the thing is added to a target group, even after the update was completed by all things
         *        originally in the group. Valid values: CONTINUOUS | SNAPSHOT.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(TargetSelection targetSelection);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * 
         * @param awsJobExecutionsRolloutConfig
         *        Configuration for the rollout of OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobExecutionsRolloutConfig.Builder} avoiding
         * the need to create one manually via {@link AwsJobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobExecutionsRolloutConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)}
         * .
         * 
         * @param awsJobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link AwsJobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)
         */
        default Builder awsJobExecutionsRolloutConfig(
                Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.builder()
                    .applyMutation(awsJobExecutionsRolloutConfig).build());
        }

        /**
         * <p>
         * Configuration information for pre-signed URLs.
         * </p>
         * 
         * @param awsJobPresignedUrlConfig
         *        Configuration information for pre-signed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig);

        /**
         * <p>
         * Configuration information for pre-signed URLs.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobPresignedUrlConfig.Builder} avoiding the
         * need to create one manually via {@link AwsJobPresignedUrlConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobPresignedUrlConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig)}.
         * 
         * @param awsJobPresignedUrlConfig
         *        a consumer that will call methods on {@link AwsJobPresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig)
         */
        default Builder awsJobPresignedUrlConfig(Consumer<AwsJobPresignedUrlConfig.Builder> awsJobPresignedUrlConfig) {
            return awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.builder().applyMutation(awsJobPresignedUrlConfig).build());
        }

        /**
         * <p>
         * The criteria that determine when and how a job abort takes place.
         * </p>
         * 
         * @param awsJobAbortConfig
         *        The criteria that determine when and how a job abort takes place.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobAbortConfig(AwsJobAbortConfig awsJobAbortConfig);

        /**
         * <p>
         * The criteria that determine when and how a job abort takes place.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobAbortConfig.Builder} avoiding the need to
         * create one manually via {@link AwsJobAbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobAbortConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #awsJobAbortConfig(AwsJobAbortConfig)}.
         * 
         * @param awsJobAbortConfig
         *        a consumer that will call methods on {@link AwsJobAbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobAbortConfig(AwsJobAbortConfig)
         */
        default Builder awsJobAbortConfig(Consumer<AwsJobAbortConfig.Builder> awsJobAbortConfig) {
            return awsJobAbortConfig(AwsJobAbortConfig.builder().applyMutation(awsJobAbortConfig).build());
        }

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the
         * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
         * terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param awsJobTimeoutConfig
         *        Specifies the amount of time each device has to finish its execution of the job. A timer is started
         *        when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not
         *        set to another terminal state before the timer expires, it will be automatically set to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobTimeoutConfig(AwsJobTimeoutConfig awsJobTimeoutConfig);

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the
         * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
         * terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobTimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link AwsJobTimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobTimeoutConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #awsJobTimeoutConfig(AwsJobTimeoutConfig)}.
         * 
         * @param awsJobTimeoutConfig
         *        a consumer that will call methods on {@link AwsJobTimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobTimeoutConfig(AwsJobTimeoutConfig)
         */
        default Builder awsJobTimeoutConfig(Consumer<AwsJobTimeoutConfig.Builder> awsJobTimeoutConfig) {
            return awsJobTimeoutConfig(AwsJobTimeoutConfig.builder().applyMutation(awsJobTimeoutConfig).build());
        }

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * 
         * @param files
         *        The files to be streamed by the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<OTAUpdateFile> files);

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * 
         * @param files
         *        The files to be streamed by the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(OTAUpdateFile... files);

        /**
         * <p>
         * The files to be streamed by the OTA update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OTAUpdateFile>.Builder} avoiding the need
         * to create one manually via {@link List<OTAUpdateFile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OTAUpdateFile>.Builder#build()} is called immediately and
         * its result is passed to {@link #files(List<OTAUpdateFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on {@link List<OTAUpdateFile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(List<OTAUpdateFile>)
         */
        Builder files(Consumer<OTAUpdateFile.Builder>... files);

        /**
         * <p>
         * The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources to
         * create an OTA update job.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants AWS IoT access to the Amazon S3, AWS IoT jobs and AWS Code Signing resources
         *        to create an OTA update job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A list of additional OTA update parameters which are name-value pairs.
         * </p>
         * 
         * @param additionalParameters
         *        A list of additional OTA update parameters which are name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParameters(Map<String, String> additionalParameters);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String otaUpdateId;

        private String description;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private String targetSelection;

        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

        private AwsJobPresignedUrlConfig awsJobPresignedUrlConfig;

        private AwsJobAbortConfig awsJobAbortConfig;

        private AwsJobTimeoutConfig awsJobTimeoutConfig;

        private List<OTAUpdateFile> files = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOtaUpdateRequest model) {
            super(model);
            otaUpdateId(model.otaUpdateId);
            description(model.description);
            targets(model.targets);
            protocolsWithStrings(model.protocols);
            targetSelection(model.targetSelection);
            awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            awsJobPresignedUrlConfig(model.awsJobPresignedUrlConfig);
            awsJobAbortConfig(model.awsJobAbortConfig);
            awsJobTimeoutConfig(model.awsJobTimeoutConfig);
            files(model.files);
            roleArn(model.roleArn);
            additionalParameters(model.additionalParameters);
            tags(model.tags);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final Collection<String> getProtocols() {
            return protocols;
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String... protocols) {
            protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        public final String getTargetSelection() {
            return targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build()
                    : null;
        }

        public final AwsJobPresignedUrlConfig.Builder getAwsJobPresignedUrlConfig() {
            return awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobPresignedUrlConfig(AwsJobPresignedUrlConfig awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig;
            return this;
        }

        public final void setAwsJobPresignedUrlConfig(AwsJobPresignedUrlConfig.BuilderImpl awsJobPresignedUrlConfig) {
            this.awsJobPresignedUrlConfig = awsJobPresignedUrlConfig != null ? awsJobPresignedUrlConfig.build() : null;
        }

        public final AwsJobAbortConfig.Builder getAwsJobAbortConfig() {
            return awsJobAbortConfig != null ? awsJobAbortConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobAbortConfig(AwsJobAbortConfig awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig;
            return this;
        }

        public final void setAwsJobAbortConfig(AwsJobAbortConfig.BuilderImpl awsJobAbortConfig) {
            this.awsJobAbortConfig = awsJobAbortConfig != null ? awsJobAbortConfig.build() : null;
        }

        public final AwsJobTimeoutConfig.Builder getAwsJobTimeoutConfig() {
            return awsJobTimeoutConfig != null ? awsJobTimeoutConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobTimeoutConfig(AwsJobTimeoutConfig awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig;
            return this;
        }

        public final void setAwsJobTimeoutConfig(AwsJobTimeoutConfig.BuilderImpl awsJobTimeoutConfig) {
            this.awsJobTimeoutConfig = awsJobTimeoutConfig != null ? awsJobTimeoutConfig.build() : null;
        }

        public final Collection<OTAUpdateFile.Builder> getFiles() {
            return files != null ? files.stream().map(OTAUpdateFile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder files(Collection<OTAUpdateFile> files) {
            this.files = OTAUpdateFilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(OTAUpdateFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<OTAUpdateFile.Builder>... files) {
            files(Stream.of(files).map(c -> OTAUpdateFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFiles(Collection<OTAUpdateFile.BuilderImpl> files) {
            this.files = OTAUpdateFilesCopier.copyFromBuilder(files);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getAdditionalParameters() {
            return additionalParameters;
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOtaUpdateRequest build() {
            return new CreateOtaUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
