/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingRegistrationTaskReportsResponse extends IotResponse implements
        ToCopyableBuilder<ListThingRegistrationTaskReportsResponse.Builder, ListThingRegistrationTaskReportsResponse> {
    private static final SdkField<List<String>> RESOURCE_LINKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceLinks")
            .getter(getter(ListThingRegistrationTaskReportsResponse::resourceLinks))
            .setter(setter(Builder::resourceLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportType").getter(getter(ListThingRegistrationTaskReportsResponse::reportTypeAsString))
            .setter(setter(Builder::reportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingRegistrationTaskReportsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_LINKS_FIELD,
            REPORT_TYPE_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> resourceLinks;

    private final String reportType;

    private final String nextToken;

    private ListThingRegistrationTaskReportsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceLinks = builder.resourceLinks;
        this.reportType = builder.reportType;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ResourceLinks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasResourceLinks() {
        return resourceLinks != null && !(resourceLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Links to the task resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResourceLinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Links to the task resources.
     */
    public List<String> resourceLinks() {
        return resourceLinks;
    }

    /**
     * <p>
     * The type of task report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return The type of task report.
     * @see ReportType
     */
    public ReportType reportType() {
        return ReportType.fromValue(reportType);
    }

    /**
     * <p>
     * The type of task report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return The type of task report.
     * @see ReportType
     */
    public String reportTypeAsString() {
        return reportType;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceLinks());
        hashCode = 31 * hashCode + Objects.hashCode(reportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTaskReportsResponse)) {
            return false;
        }
        ListThingRegistrationTaskReportsResponse other = (ListThingRegistrationTaskReportsResponse) obj;
        return Objects.equals(resourceLinks(), other.resourceLinks())
                && Objects.equals(reportTypeAsString(), other.reportTypeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListThingRegistrationTaskReportsResponse").add("ResourceLinks", resourceLinks())
                .add("ReportType", reportTypeAsString()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceLinks":
            return Optional.ofNullable(clazz.cast(resourceLinks()));
        case "reportType":
            return Optional.ofNullable(clazz.cast(reportTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingRegistrationTaskReportsResponse, T> g) {
        return obj -> g.apply((ListThingRegistrationTaskReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListThingRegistrationTaskReportsResponse> {
        /**
         * <p>
         * Links to the task resources.
         * </p>
         * 
         * @param resourceLinks
         *        Links to the task resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLinks(Collection<String> resourceLinks);

        /**
         * <p>
         * Links to the task resources.
         * </p>
         * 
         * @param resourceLinks
         *        Links to the task resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLinks(String... resourceLinks);

        /**
         * <p>
         * The type of task report.
         * </p>
         * 
         * @param reportType
         *        The type of task report.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(String reportType);

        /**
         * <p>
         * The type of task report.
         * </p>
         * 
         * @param reportType
         *        The type of task report.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(ReportType reportType);

        /**
         * <p>
         * The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> resourceLinks = DefaultSdkAutoConstructList.getInstance();

        private String reportType;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTaskReportsResponse model) {
            super(model);
            resourceLinks(model.resourceLinks);
            reportType(model.reportType);
            nextToken(model.nextToken);
        }

        public final Collection<String> getResourceLinks() {
            return resourceLinks;
        }

        @Override
        public final Builder resourceLinks(Collection<String> resourceLinks) {
            this.resourceLinks = S3FileUrlListCopier.copy(resourceLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLinks(String... resourceLinks) {
            resourceLinks(Arrays.asList(resourceLinks));
            return this;
        }

        public final void setResourceLinks(Collection<String> resourceLinks) {
            this.resourceLinks = S3FileUrlListCopier.copy(resourceLinks);
        }

        public final String getReportType() {
            return reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType == null ? null : reportType.toString());
            return this;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingRegistrationTaskReportsResponse build() {
            return new ListThingRegistrationTaskReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
