/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeviceCertificateParams implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateDeviceCertificateParams.Builder, UpdateDeviceCertificateParams> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UpdateDeviceCertificateParams::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private UpdateDeviceCertificateParams(BuilderImpl builder) {
        this.action = builder.action;
    }

    /**
     * <p>
     * The action that you want to apply to the device cerrtificate. The only supported value is <code>DEACTIVATE</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DeviceCertificateUpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that you want to apply to the device cerrtificate. The only supported value is
     *         <code>DEACTIVATE</code>.
     * @see DeviceCertificateUpdateAction
     */
    public DeviceCertificateUpdateAction action() {
        return DeviceCertificateUpdateAction.fromValue(action);
    }

    /**
     * <p>
     * The action that you want to apply to the device cerrtificate. The only supported value is <code>DEACTIVATE</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link DeviceCertificateUpdateAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The action that you want to apply to the device cerrtificate. The only supported value is
     *         <code>DEACTIVATE</code>.
     * @see DeviceCertificateUpdateAction
     */
    public String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeviceCertificateParams)) {
            return false;
        }
        UpdateDeviceCertificateParams other = (UpdateDeviceCertificateParams) obj;
        return Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDeviceCertificateParams").add("Action", actionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeviceCertificateParams, T> g) {
        return obj -> g.apply((UpdateDeviceCertificateParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateDeviceCertificateParams> {
        /**
         * <p>
         * The action that you want to apply to the device cerrtificate. The only supported value is
         * <code>DEACTIVATE</code>.
         * </p>
         * 
         * @param action
         *        The action that you want to apply to the device cerrtificate. The only supported value is
         *        <code>DEACTIVATE</code>.
         * @see DeviceCertificateUpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceCertificateUpdateAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action that you want to apply to the device cerrtificate. The only supported value is
         * <code>DEACTIVATE</code>.
         * </p>
         * 
         * @param action
         *        The action that you want to apply to the device cerrtificate. The only supported value is
         *        <code>DEACTIVATE</code>.
         * @see DeviceCertificateUpdateAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceCertificateUpdateAction
         */
        Builder action(DeviceCertificateUpdateAction action);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeviceCertificateParams model) {
            action(model.action);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DeviceCertificateUpdateAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public UpdateDeviceCertificateParams build() {
            return new UpdateDeviceCertificateParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
