/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreateThing operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThingResponse extends IotResponse implements
        ToCopyableBuilder<CreateThingResponse.Builder, CreateThingResponse> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(CreateThingResponse::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(CreateThingResponse::thingArn)).setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final SdkField<String> THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingId").getter(getter(CreateThingResponse::thingId)).setter(setter(Builder::thingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_ARN_FIELD, THING_ID_FIELD));

    private final String thingName;

    private final String thingArn;

    private final String thingId;

    private CreateThingResponse(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
        this.thingId = builder.thingId;
    }

    /**
     * <p>
     * The name of the new thing.
     * </p>
     * 
     * @return The name of the new thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the new thing.
     * </p>
     * 
     * @return The ARN of the new thing.
     */
    public String thingArn() {
        return thingArn;
    }

    /**
     * <p>
     * The thing ID.
     * </p>
     * 
     * @return The thing ID.
     */
    public String thingId() {
        return thingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingResponse)) {
            return false;
        }
        CreateThingResponse other = (CreateThingResponse) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingArn(), other.thingArn())
                && Objects.equals(thingId(), other.thingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateThingResponse").add("ThingName", thingName()).add("ThingArn", thingArn())
                .add("ThingId", thingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        case "thingId":
            return Optional.ofNullable(clazz.cast(thingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThingResponse, T> g) {
        return obj -> g.apply((CreateThingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThingResponse> {
        /**
         * <p>
         * The name of the new thing.
         * </p>
         * 
         * @param thingName
         *        The name of the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the new thing.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the new thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        /**
         * <p>
         * The thing ID.
         * </p>
         * 
         * @param thingId
         *        The thing ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingId(String thingId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String thingName;

        private String thingArn;

        private String thingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingResponse model) {
            super(model);
            thingName(model.thingName);
            thingArn(model.thingArn);
            thingId(model.thingId);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingArn() {
            return thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final String getThingId() {
            return thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        @Override
        public CreateThingResponse build() {
            return new CreateThingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
