/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write to a DynamoDB table.
 * </p>
 * <p>
 * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamoDBv2Action implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamoDBv2Action.Builder, DynamoDBv2Action> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DynamoDBv2Action::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<PutItemInput> PUT_ITEM_FIELD = SdkField.<PutItemInput> builder(MarshallingType.SDK_POJO)
            .memberName("putItem").getter(getter(DynamoDBv2Action::putItem)).setter(setter(Builder::putItem))
            .constructor(PutItemInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("putItem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ROLE_ARN_FIELD, PUT_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final PutItemInput putItem;

    private DynamoDBv2Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.putItem = builder.putItem;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access to the DynamoDB table.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access to the DynamoDB table.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies the DynamoDB table to which the message data will be written. For example:
     * </p>
     * <p>
     * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     * </p>
     * <p>
     * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     * </p>
     * 
     * @return Specifies the DynamoDB table to which the message data will be written. For example:</p>
     *         <p>
     *         <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
     *         </p>
     *         <p>
     *         Each attribute in the message payload will be written to a separate column in the DynamoDB database.
     */
    public PutItemInput putItem() {
        return putItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(putItem());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBv2Action)) {
            return false;
        }
        DynamoDBv2Action other = (DynamoDBv2Action) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(putItem(), other.putItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DynamoDBv2Action").add("RoleArn", roleArn()).add("PutItem", putItem()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "putItem":
            return Optional.ofNullable(clazz.cast(putItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBv2Action, T> g) {
        return obj -> g.apply((DynamoDBv2Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamoDBv2Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access to the DynamoDB table.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access to the DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies the DynamoDB table to which the message data will be written. For example:
         * </p>
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * </p>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * </p>
         * 
         * @param putItem
         *        Specifies the DynamoDB table to which the message data will be written. For example:</p>
         *        <p>
         *        <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         *        </p>
         *        <p>
         *        Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putItem(PutItemInput putItem);

        /**
         * <p>
         * Specifies the DynamoDB table to which the message data will be written. For example:
         * </p>
         * <p>
         * <code>{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }</code>
         * </p>
         * <p>
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         * </p>
         * This is a convenience that creates an instance of the {@link PutItemInput.Builder} avoiding the need to
         * create one manually via {@link PutItemInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link PutItemInput.Builder#build()} is called immediately and its
         * result is passed to {@link #putItem(PutItemInput)}.
         * 
         * @param putItem
         *        a consumer that will call methods on {@link PutItemInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #putItem(PutItemInput)
         */
        default Builder putItem(Consumer<PutItemInput.Builder> putItem) {
            return putItem(PutItemInput.builder().applyMutation(putItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private PutItemInput putItem;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBv2Action model) {
            roleArn(model.roleArn);
            putItem(model.putItem);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final PutItemInput.Builder getPutItem() {
            return putItem != null ? putItem.toBuilder() : null;
        }

        @Override
        public final Builder putItem(PutItemInput putItem) {
            this.putItem = putItem;
            return this;
        }

        public final void setPutItem(PutItemInput.BuilderImpl putItem) {
            this.putItem = putItem != null ? putItem.build() : null;
        }

        @Override
        public DynamoDBv2Action build() {
            return new DynamoDBv2Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
